/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.python;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.razorvine.pickle.Pickler;
import net.razorvine.pickle.Unpickler;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.Scalar;
import numpy.core.ScalarUtil;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.python.PickleUtil;

public class PythonUtil {
    private PythonUtil() {
    }

    public static byte[] evaluateAll(Evaluator evaluator, byte[] listOfDictsBytes) throws IOException {
        List batchedArguments = (List)PythonUtil.unpickle(listOfDictsBytes);
        List<Map<String, ?>> batchedResults = PythonUtil.evaluateAll(evaluator, batchedArguments);
        return PythonUtil.pickle(batchedResults);
    }

    public static List<Map<String, ?>> evaluateAll(Evaluator evaluator, List<Map<String, ?>> batchedArguments) {
        ArrayList batchedResults = new ArrayList();
        for (Map<String, ?> arguments : batchedArguments) {
            Map<String, ?> results = PythonUtil.evaluate(evaluator, arguments);
            batchedResults.add(results);
        }
        return batchedResults;
    }

    public static byte[] evaluate(Evaluator evaluator, byte[] dictBytes) throws IOException {
        Map arguments = (Map)PythonUtil.unpickle(dictBytes);
        Map<String, ?> results = PythonUtil.evaluate(evaluator, arguments);
        return PythonUtil.pickle(results);
    }

    public static Map<String, ?> evaluate(Evaluator evaluator, final Map<String, ?> arguments) {
        AbstractMap<String, Object> pmmlArguments = new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                Object value = arguments.get(key);
                return PythonUtil.toJavaPrimitive(value);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                throw new UnsupportedOperationException();
            }
        };
        Map pmmlResults = evaluator.evaluate((Map)pmmlArguments);
        return EvaluatorUtil.decodeAll((Map)pmmlResults);
    }

    public static byte[] argumentsToResults(byte[] dictBytes) throws IOException {
        Map arguments = (Map)PythonUtil.unpickle(dictBytes);
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        Set entries = arguments.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            results.put(key, PythonUtil.toJavaPrimitive(value));
        }
        return PythonUtil.pickle(results);
    }

    public static Object toJavaPrimitive(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof Scalar) {
            Scalar scalar = (Scalar)value;
            return ScalarUtil.decode((Object)scalar);
        }
        if (value instanceof ClassDict) {
            ClassDict classDict = (ClassDict)value;
            throw new IllegalArgumentException("Python type " + classDict.getClassName() + " is not supported");
        }
        throw new IllegalArgumentException("Java type " + value.getClass().getName() + " is not supported");
    }

    private static Object unpickle(byte[] bytes) throws IOException {
        Unpickler unpickler = new Unpickler();
        return unpickler.loads(bytes);
    }

    private static byte[] pickle(Object object) throws IOException {
        Pickler pickler = new Pickler();
        return pickler.dumps(object);
    }

    static {
        ClassLoader clazzLoader = PythonUtil.class.getClassLoader();
        PickleUtil.init((ClassLoader)clazzLoader, (String)"python2pmml.properties");
    }
}

