/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.math.DoubleMath;
import java.util.Collection;
import org.dmg.pmml.ComplexValue;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.MathUtil;
import org.jpmml.evaluator.NotImplementedException;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.model.temporals.ComplexPeriod;
import org.jpmml.model.temporals.Date;
import org.jpmml.model.temporals.DateTime;
import org.jpmml.model.temporals.DateTimeUtil;
import org.jpmml.model.temporals.DaysSinceDate;
import org.jpmml.model.temporals.Epochs;
import org.jpmml.model.temporals.Instant;
import org.jpmml.model.temporals.Period;
import org.jpmml.model.temporals.SecondsSinceDate;
import org.jpmml.model.temporals.SecondsSinceMidnight;
import org.jpmml.model.temporals.Time;

public class TypeUtil {
    private TypeUtil() {
    }

    public static String format(Object value) {
        if (value instanceof ComplexValue) {
            ComplexValue complexValue = (ComplexValue)value;
            value = complexValue.toSimpleValue();
        }
        return TypeUtil.toString(value);
    }

    public static Object parseOrCast(DataType dataType, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return TypeUtil.parse(dataType, string);
        }
        return TypeUtil.cast(dataType, value);
    }

    public static Object parse(DataType dataType, String value) {
        switch (dataType) {
            case STRING: {
                return value;
            }
            case INTEGER: {
                return TypeUtil.parseInteger(value);
            }
            case FLOAT: {
                return TypeUtil.parseFloat(value);
            }
            case DOUBLE: {
                return TypeUtil.parseDouble(value);
            }
            case BOOLEAN: {
                return TypeUtil.parseBoolean(value);
            }
            case DATE: {
                return DateTimeUtil.parseDate((String)value);
            }
            case TIME: {
                return DateTimeUtil.parseTime((String)value);
            }
            case DATE_TIME: {
                return DateTimeUtil.parseDateTime((String)value);
            }
            case DATE_DAYS_SINCE_0: {
                throw new NotImplementedException();
            }
            case DATE_DAYS_SINCE_1960: {
                return DateTimeUtil.parseDaysSinceDate((Date)Epochs.YEAR_1960, (String)value);
            }
            case DATE_DAYS_SINCE_1970: {
                return DateTimeUtil.parseDaysSinceDate((Date)Epochs.YEAR_1970, (String)value);
            }
            case DATE_DAYS_SINCE_1980: {
                return DateTimeUtil.parseDaysSinceDate((Date)Epochs.YEAR_1980, (String)value);
            }
            case DATE_DAYS_SINCE_1990: {
                return DateTimeUtil.parseDaysSinceDate((Date)Epochs.YEAR_1990, (String)value);
            }
            case DATE_DAYS_SINCE_2000: {
                return DateTimeUtil.parseDaysSinceDate((Date)Epochs.YEAR_2000, (String)value);
            }
            case DATE_DAYS_SINCE_2010: {
                return DateTimeUtil.parseDaysSinceDate((Date)Epochs.YEAR_2010, (String)value);
            }
            case DATE_DAYS_SINCE_2020: {
                return DateTimeUtil.parseDaysSinceDate((Date)Epochs.YEAR_2020, (String)value);
            }
            case TIME_SECONDS: {
                return DateTimeUtil.parseSecondsSinceMidnight((String)value);
            }
            case DATE_TIME_SECONDS_SINCE_0: {
                throw new NotImplementedException();
            }
            case DATE_TIME_SECONDS_SINCE_1960: {
                return DateTimeUtil.parseSecondsSinceDate((Date)Epochs.YEAR_1960, (String)value);
            }
            case DATE_TIME_SECONDS_SINCE_1970: {
                return DateTimeUtil.parseSecondsSinceDate((Date)Epochs.YEAR_1970, (String)value);
            }
            case DATE_TIME_SECONDS_SINCE_1980: {
                return DateTimeUtil.parseSecondsSinceDate((Date)Epochs.YEAR_1980, (String)value);
            }
            case DATE_TIME_SECONDS_SINCE_1990: {
                return DateTimeUtil.parseSecondsSinceDate((Date)Epochs.YEAR_1990, (String)value);
            }
            case DATE_TIME_SECONDS_SINCE_2000: {
                return DateTimeUtil.parseSecondsSinceDate((Date)Epochs.YEAR_2000, (String)value);
            }
            case DATE_TIME_SECONDS_SINCE_2010: {
                return DateTimeUtil.parseSecondsSinceDate((Date)Epochs.YEAR_2010, (String)value);
            }
            case DATE_TIME_SECONDS_SINCE_2020: {
                return DateTimeUtil.parseSecondsSinceDate((Date)Epochs.YEAR_2020, (String)value);
            }
        }
        throw new IllegalArgumentException();
    }

    private static Integer parseInteger(String value) {
        try {
            long result = Long.parseLong(value);
            return TypeUtil.parseInteger(value, result);
        }
        catch (NumberFormatException nfeInteger) {
            try {
                double result = Double.parseDouble(value);
                if (DoubleMath.isMathematicalInteger((double)result)) {
                    return TypeUtil.parseInteger(value, (long)result);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                return TypeUtil.toInteger(TypeUtil.parseFlag(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw nfeInteger;
            }
        }
    }

    private static Integer parseInteger(String value, long parsedValue) {
        try {
            return MathUtil.toIntExact(parsedValue);
        }
        catch (ArithmeticException ae) {
            throw new IllegalArgumentException(value, ae);
        }
    }

    private static Float parseFloat(String value) {
        if (value.length() <= 4) {
            switch (value) {
                case "-1": 
                case "-1.0": {
                    return Numbers.FLOAT_MINUS_ONE;
                }
                case "0": 
                case "0.0": {
                    return Numbers.FLOAT_ZERO;
                }
                case "1": 
                case "1.0": {
                    return Numbers.FLOAT_ONE;
                }
            }
            if ("NaN".equalsIgnoreCase(value)) {
                return Float.valueOf(Float.NaN);
            }
            if ("-INF".equalsIgnoreCase(value)) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            if ("INF".equalsIgnoreCase(value)) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
        }
        try {
            return Float.valueOf(Float.parseFloat(value) + 0.0f);
        }
        catch (NumberFormatException nfe) {
            try {
                return TypeUtil.toFloat(TypeUtil.parseFlag(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw nfe;
            }
        }
    }

    private static Double parseDouble(String value) {
        if (value.length() <= 4) {
            switch (value) {
                case "-1": 
                case "-1.0": {
                    return Numbers.DOUBLE_MINUS_ONE;
                }
                case "0": 
                case "0.0": {
                    return Numbers.DOUBLE_ZERO;
                }
                case "0.5": {
                    return Numbers.DOUBLE_ONE_HALF;
                }
                case "1": 
                case "1.0": {
                    return Numbers.DOUBLE_ONE;
                }
                case "2": 
                case "2.0": {
                    return Numbers.DOUBLE_TWO;
                }
            }
            if ("NaN".equalsIgnoreCase(value)) {
                return Double.NaN;
            }
            if ("-INF".equalsIgnoreCase(value)) {
                return Double.NEGATIVE_INFINITY;
            }
            if ("INF".equalsIgnoreCase(value)) {
                return Double.POSITIVE_INFINITY;
            }
        }
        try {
            return Double.parseDouble(value) + 0.0;
        }
        catch (NumberFormatException nfe) {
            try {
                return TypeUtil.toDouble(TypeUtil.parseFlag(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw nfe;
            }
        }
    }

    private static Boolean parseBoolean(String value) {
        try {
            return TypeUtil.parseFlag(value);
        }
        catch (IllegalArgumentException iae) {
            try {
                return TypeUtil.toBoolean(TypeUtil.parseDouble(value));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (TypeCheckException typeCheckException) {
                // empty catch block
            }
            throw iae;
        }
    }

    private static boolean parseFlag(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException(value);
    }

    public static boolean equals(DataType dataType, Object value, Object referenceValue) {
        try {
            return TypeUtil.parseOrCast(dataType, value).equals(TypeUtil.parseOrCast(dataType, referenceValue));
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            try {
                return TypeUtil.format(value).equals(TypeUtil.format(referenceValue));
            }
            catch (TypeCheckException typeCheckException) {
                throw e;
            }
        }
    }

    public static DataType getDataType(Object value) {
        if (value instanceof String) {
            return DataType.STRING;
        }
        if (value instanceof Integer) {
            return DataType.INTEGER;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            return instant.getDataType();
        }
        if (value instanceof Period) {
            Period period = (Period)value;
            DataType dataType = period.getDataType();
            if (dataType == null) {
                ComplexPeriod complexPeriod = (ComplexPeriod)period;
                throw new EvaluationException("Non-standard epoch " + complexPeriod.getEpoch());
            }
            return dataType;
        }
        throw new EvaluationException("No PMML data type for Java data type " + (value != null ? value.getClass().getName() : null));
    }

    public static DataType getDataType(Collection<?> values) {
        DataType result = null;
        for (Object value : values) {
            if (value == null) continue;
            DataType dataType = TypeUtil.getDataType(value);
            if (result == null) {
                result = dataType;
                continue;
            }
            if (result == dataType) continue;
            throw new TypeCheckException(result, value);
        }
        if (result == null) {
            result = DataType.STRING;
        }
        return result;
    }

    public static DataType getCommonDataType(DataType left, DataType right) {
        if (left == right) {
            switch (left) {
                case INTEGER: 
                case FLOAT: 
                case DOUBLE: {
                    return left;
                }
            }
        } else if (left == DataType.DOUBLE) {
            if (right == DataType.FLOAT || right == DataType.INTEGER) {
                return left;
            }
        } else if (left == DataType.FLOAT) {
            if (right == DataType.DOUBLE) {
                return right;
            }
            if (right == DataType.INTEGER) {
                return left;
            }
        } else if (left == DataType.INTEGER && (right == DataType.DOUBLE || right == DataType.FLOAT)) {
            return right;
        }
        throw new EvaluationException("No PMML data type for the intersection of PMML data types " + left.value() + " and " + right.value());
    }

    public static OpType getOpType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return OpType.CATEGORICAL;
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                return OpType.CONTINUOUS;
            }
            case BOOLEAN: {
                return OpType.CATEGORICAL;
            }
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                return OpType.ORDINAL;
            }
            case DATE_DAYS_SINCE_0: 
            case DATE_DAYS_SINCE_1960: 
            case DATE_DAYS_SINCE_1970: 
            case DATE_DAYS_SINCE_1980: 
            case DATE_DAYS_SINCE_1990: 
            case DATE_DAYS_SINCE_2000: 
            case DATE_DAYS_SINCE_2010: 
            case DATE_DAYS_SINCE_2020: 
            case TIME_SECONDS: 
            case DATE_TIME_SECONDS_SINCE_0: 
            case DATE_TIME_SECONDS_SINCE_1960: 
            case DATE_TIME_SECONDS_SINCE_1970: 
            case DATE_TIME_SECONDS_SINCE_1980: 
            case DATE_TIME_SECONDS_SINCE_1990: 
            case DATE_TIME_SECONDS_SINCE_2000: 
            case DATE_TIME_SECONDS_SINCE_2010: 
            case DATE_TIME_SECONDS_SINCE_2020: {
                return OpType.CONTINUOUS;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Object cast(DataType dataType, Object value) {
        switch (dataType) {
            case STRING: {
                return TypeUtil.toString(value);
            }
            case INTEGER: {
                return TypeUtil.toInteger(value);
            }
            case FLOAT: {
                return TypeUtil.toFloat(value);
            }
            case DOUBLE: {
                return TypeUtil.toDouble(value);
            }
            case BOOLEAN: {
                return TypeUtil.toBoolean(value);
            }
            case DATE: {
                return TypeUtil.toDate(value);
            }
            case TIME: {
                return TypeUtil.toTime(value);
            }
            case DATE_TIME: {
                return TypeUtil.toDateTime(value);
            }
            case DATE_DAYS_SINCE_0: {
                throw new NotImplementedException();
            }
            case DATE_DAYS_SINCE_1960: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_1960, value);
            }
            case DATE_DAYS_SINCE_1970: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_1970, value);
            }
            case DATE_DAYS_SINCE_1980: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_1980, value);
            }
            case DATE_DAYS_SINCE_1990: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_1990, value);
            }
            case DATE_DAYS_SINCE_2000: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_2000, value);
            }
            case DATE_DAYS_SINCE_2010: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_2010, value);
            }
            case DATE_DAYS_SINCE_2020: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_2020, value);
            }
            case TIME_SECONDS: {
                return TypeUtil.toSecondsSinceMidnight(value);
            }
            case DATE_TIME_SECONDS_SINCE_0: {
                throw new NotImplementedException();
            }
            case DATE_TIME_SECONDS_SINCE_1960: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_1960, value);
            }
            case DATE_TIME_SECONDS_SINCE_1970: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_1970, value);
            }
            case DATE_TIME_SECONDS_SINCE_1980: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_1980, value);
            }
            case DATE_TIME_SECONDS_SINCE_1990: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_1990, value);
            }
            case DATE_TIME_SECONDS_SINCE_2000: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_2000, value);
            }
            case DATE_TIME_SECONDS_SINCE_2010: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_2010, value);
            }
            case DATE_TIME_SECONDS_SINCE_2020: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_2020, value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static <V> V cast(Class<? extends V> clazz, Object value) {
        if (!clazz.isInstance(value)) {
            throw new TypeCheckException(clazz, value);
        }
        return clazz.cast(value);
    }

    private static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            return number.toString();
        }
        if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            return flag != false ? "true" : "false";
        }
        throw new TypeCheckException(DataType.STRING, value);
    }

    private static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Double || value instanceof Float) {
            Number number = (Number)value;
            if (DoubleMath.isMathematicalInteger((double)number.doubleValue())) {
                return TypeUtil.toInteger(number);
            }
        } else {
            if (value instanceof Long) {
                Long number = (Long)value;
                return TypeUtil.toInteger(number);
            }
            if (value instanceof Short || value instanceof Byte) {
                Number number = (Number)value;
                return number.intValue();
            }
            if (value instanceof Boolean) {
                Boolean flag = (Boolean)value;
                return flag != false ? Numbers.INTEGER_ONE : Numbers.INTEGER_ZERO;
            }
            if (value instanceof Period) {
                Period period = (Period)value;
                return TypeUtil.toInteger((Number)period);
            }
        }
        throw new TypeCheckException(DataType.INTEGER, value);
    }

    private static Integer toInteger(Number value) {
        try {
            return MathUtil.toIntExact(value.longValue());
        }
        catch (ArithmeticException ae) {
            throw new TypeCheckException(DataType.INTEGER, (Object)value).initCause(ae);
        }
    }

    private static Float toFloat(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Double) {
            Number number = (Number)value;
            return TypeUtil.toFloat(number.floatValue());
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            return TypeUtil.toFloat(number.floatValue());
        }
        if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            return flag != false ? Numbers.FLOAT_ONE : Numbers.FLOAT_ZERO;
        }
        if (value instanceof Period) {
            Period period = (Period)value;
            return TypeUtil.toFloat(period.floatValue());
        }
        throw new TypeCheckException(DataType.FLOAT, value);
    }

    private static Float toFloat(float value) {
        if (value == -1.0f) {
            return Numbers.FLOAT_MINUS_ONE;
        }
        if (value == 0.0f) {
            return Numbers.FLOAT_ZERO;
        }
        if (value == 1.0f) {
            return Numbers.FLOAT_ONE;
        }
        return Float.valueOf(value);
    }

    private static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            return TypeUtil.toDouble(number.doubleValue());
        }
        if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            return flag != false ? Numbers.DOUBLE_ONE : Numbers.DOUBLE_ZERO;
        }
        if (value instanceof Period) {
            Period period = (Period)value;
            return TypeUtil.toDouble(period.doubleValue());
        }
        throw new TypeCheckException(DataType.DOUBLE, value);
    }

    private static Double toDouble(double value) {
        if (value == -1.0) {
            return Numbers.DOUBLE_MINUS_ONE;
        }
        if (value == 0.0) {
            return Numbers.DOUBLE_ZERO;
        }
        if (value == 0.5) {
            return Numbers.DOUBLE_ONE_HALF;
        }
        if (value == 1.0) {
            return Numbers.DOUBLE_ONE;
        }
        if (value == 2.0) {
            return Numbers.DOUBLE_TWO;
        }
        return value;
    }

    private static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            if (number.doubleValue() == 0.0) {
                return Boolean.FALSE;
            }
            if (number.doubleValue() == 1.0) {
                return Boolean.TRUE;
            }
        }
        throw new TypeCheckException(DataType.BOOLEAN, value);
    }

    private static Date toDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof DateTime) {
            DateTime dateTime = (DateTime)value;
            return dateTime.toDate();
        }
        try {
            return Date.valueOf((Object)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TypeCheckException(DataType.DATE, value);
        }
    }

    private static Time toTime(Object value) {
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof DateTime) {
            DateTime dateTime = (DateTime)value;
            return dateTime.toTime();
        }
        try {
            return Time.valueOf((Object)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TypeCheckException(DataType.TIME, value);
        }
    }

    private static DateTime toDateTime(Object value) {
        if (value instanceof DateTime) {
            return (DateTime)value;
        }
        try {
            return DateTime.valueOf((Object)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TypeCheckException(DataType.DATE_TIME, value);
        }
    }

    private static DaysSinceDate toDaysSinceDate(Date epoch, Object value) {
        if (value instanceof DaysSinceDate) {
            DaysSinceDate period = (DaysSinceDate)value;
            return period.forEpoch(epoch);
        }
        throw new TypeCheckException(DaysSinceDate.class, value);
    }

    private static SecondsSinceMidnight toSecondsSinceMidnight(Object value) {
        if (value instanceof SecondsSinceMidnight) {
            return (SecondsSinceMidnight)value;
        }
        throw new TypeCheckException(SecondsSinceMidnight.class, value);
    }

    private static SecondsSinceDate toSecondsSinceDate(Date epoch, Object value) {
        if (value instanceof SecondsSinceDate) {
            SecondsSinceDate period = (SecondsSinceDate)value;
            return period.forEpoch(epoch);
        }
        throw new TypeCheckException(SecondsSinceDate.class, value);
    }

    public static DataType getConstantDataType(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return TypeUtil.getConstantDataType(string);
        }
        return TypeUtil.getDataType(value);
    }

    public static DataType getConstantDataType(String value) {
        if ("".equals(value)) {
            return DataType.STRING;
        }
        if ("NaN".equalsIgnoreCase(value) || "INF".equalsIgnoreCase(value) || "-INF".equalsIgnoreCase(value)) {
            return DataType.DOUBLE;
        }
        try {
            if (value.indexOf(46) > -1) {
                Double.parseDouble(value);
                return DataType.DOUBLE;
            }
            Long.parseLong(value);
            return DataType.INTEGER;
        }
        catch (NumberFormatException nfe) {
            return DataType.STRING;
        }
    }
}

