# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rrm']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['rrm = rrm.__main__:main']}

setup_kwargs = {
    'name': 'rrm',
    'version': '0.1.1',
    'description': 'Really, relentlessly and repeatedly remove files and all of their copies.',
    'long_description': '.. image:: https://img.shields.io/pypi/v/rrm?style=flat-square\n   :target: https://pypi.org/project/rrm/\n   :alt: PyPI\n\n.. image:: https://img.shields.io/pypi/l/rrm?style=flat-square\n   :target: https://gitlab.com/szs/rrm/-/raw/master/LICENSE\n   :alt: PyPI - License\n\n.. image:: https://img.shields.io/pypi/pyversions/rrm?style=flat-square\n   :target: https://python.org\n   :alt: PyPI - Python Version\n\nrrm\n===\n\nReally, relentlessly and repeatedly remove files and all of their copies.\n\nInstallation\n============\n\nThe installation is straight forward. You can install the package via ``pip``, ``pipenv``, ``poetry``\nand alike or by downloading the source from the gitlab repository.\n\nFrom pypi.org (recommended)\n---------------------------\n\nInstall by typing\n\n.. code-block:: shell\n\n                pip install rrm\n\nor\n\n.. code-block:: shell\n\n                pip install --user rrm\n\nif you do not have root access.\n\nFrom gitlab.com\n---------------\n\nTo get the latest features or contribute to the development, you can clone the whole project using\n`git <https://git-scm.com/>`_:\n\n.. code-block:: shell\n\n                git clone https://gitlab.com/szs/rrm.git\n\nUsage\n=====\n\nDelete files\n------------\n\nTo delete files and add information about them to a local database, type\n\n.. code-block:: shell\n\n                rrm a_file.txt "another file.log"\n\nFind exact copies of deleted files and delete them (not implemented yet)\n------------------------------------------------------------------------\n\nTo search a directory for files which have been deleted (and appended to the database)\nby to command above, type\n\n.. code-block:: shell\n\n                rrm some_directory_with_obsolete_copies\n\nDocumentation\n=============\n\nPlease (for now) refer to `rrm --help` for documentation::\n\n  usage: rrm [-h] [-m [DIR]] [-d DB] [-r] [-i] [-I] [-n] [-H HASH] [-l] [-V] [-q] [-v] [-D]\n           PATH [PATH ...]\n\n  Really, relentlessly and repeatedly remove files and all of their copies.\n\n  positional arguments:\n    PATH                  each PATH is checked whether it is a regular file or a directory. If it is\n                          a regular file it will be deleted or moved to DIR (see -m option), unless\n                          -n is used, and added the the database. If it is a directory, the\n                          directory is scanned for matches to the files in the database (not\n                          implemented yet). Note that there is a huge difference between\n                          \'some_directory/\' and \'some_directory/*\'!!\n\n  optional arguments:\n    -h, --help            show this help message and exit\n    -m [DIR], --move [DIR]\n                          move to a directory instead of deleting the files permanently. If DIR is\n                          not set (but the option is used), $HOME/.config/rrm/deleted_files/ is\n                          used. The directory will be created if\n    -d DB, --db-file DB   the name of the database file. If DB does not exist, it will be created,\n                          otherwise rrm will append to the file. If DB is a directory, rrm will look\n                          for \'DB/.rrmdb.csv\' and create the file if it does not exist. If this\n                          option is omitted, rrm will use (and create if inexistent)\n                          $HOME/.config/rrm/rrmdb.csv (default: $HOME/.config/rrm/rrmdb.csv)\n    -r, --recursive       check for files to be deleted recursively. (not implemented yet) (default:\n                          False)\n    -i, --interactive     gather the files to be deleted, display them and ask once to delete all of\n                          them.The files are only added to the database if the deletion is confirmed\n                          (default: False)\n    -I, --very-interactive\n                          gather the files to be deleted, display them and ask for every file before\n                          deleting it.The files are only added to the database if the deletion is\n                          confirmed (default: False)\n    -n, --no-action       gather the files to be processed, and only add them to the database\n                          without actually deleting or moving them. (default: False)\n    -H HASH, --hash-algorithm HASH\n                          which hash algorithm to use. Currently supported are: sha1, sha224,\n                          sha256, sha384, sha512, blake2b, blake2s, md5, sha3_224, sha3_256,\n                          sha3_384, sha3_512, shake_128, shake_256 (default: sha1)\n    -l, --follow-symlinks\n                          whether to follow symlinks (default: False)\n    -V, --version         show the version of this software\n    -q, --quiet           switch off text output except for error messages. This will overwrite -v.\n                          (default: False)\n    -v, --verbose         more verbose text output (default: False)\n    -D, --debug           switch on debug mode. This will show a lot of debugging information.\n                          (default: False)\n\n\n\nTODOs\n=====\n\nProject\n-------\n\n* proper documentation\n* automated tests and CI\n\nBasic features\n--------------\n\n* process directories (i.e., look for file that match previously deleted files\n* process files in subdirectories (option `-r`)\n\nEnhancements\n------------\n\n* add timestamps (UNIX epoch time) to the database entries,\n  option to delete older than `x` or deleted before `y`\n* add check for user id\n* use sqlite instead of csv files for the databases, save hashes as integers\n* maintenance of database files: Listing, splitting, merging\n\nHow to Contribute\n=================\n\nIf you find a bug, want to propose a feature or need help getting this package to work,\nplease don\'t hesitate to file an `issue <https://gitlab.com/szs/rrm/-/issues>`_ or write\nan email.\n\nMerge requests are also much appreciated!\n\nProject links\n=============\n\n* `Repository <https://gitlab.com/szs/rrm>`_\n* `Documentation <https://rrm.readthedocs.io/en/latest/>`_ (not done yet)\n* `pypi page <https://pypi.org/project/rrm/>`_\n',
    'author': 'Steffen Brinkmann',
    'author_email': 's-b@mailbox.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/szs/rrm/',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
