/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.pykomoran;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kr.co.shineware.nlp.komoran.constant.DEFAULT_MODEL;
import kr.co.shineware.nlp.komoran.core.Komoran;
import kr.co.shineware.nlp.komoran.model.KomoranResult;
import kr.co.shineware.nlp.komoran.model.Token;
import kr.co.shineware.util.common.model.Pair;
import py4j.GatewayServer;

public class KomoranEntryPoint {
    private Komoran komoran = null;
    private KomoranResult result = null;

    public void KomoranEntryPoint() {
    }

    public void init(String modelPath) {
        if ("STABLE".equals(modelPath) || "EXP".equals(modelPath)) {
            this.initByModelName(modelPath);
            return;
        }
        if (!new File(modelPath).exists()) {
            return;
        }
        try {
            this.komoran = new Komoran(modelPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInitialized() {
        return this.komoran instanceof Komoran;
    }

    public void initByModel(DEFAULT_MODEL modelType) {
        this.komoran = new Komoran(modelType);
    }

    public void initByModelName(String modelTypeName) {
        switch (modelTypeName) {
            case "STABLE": {
                this.komoran = new Komoran(DEFAULT_MODEL.LIGHT);
                break;
            }
            case "EXP": {
                this.komoran = new Komoran(DEFAULT_MODEL.FULL);
                break;
            }
        }
    }

    public void setUserDic(String userDicPath) {
        this.komoran.setUserDic(userDicPath);
    }

    public void setFWDic(String fwDicPath) {
        this.komoran.setFWDic(fwDicPath);
    }

    public void analyze(String sentence) {
        this.result = this.komoran.analyze(sentence);
    }

    public List<String> getNouns() {
        return this.result.getNouns();
    }

    public List<String> getMorphesByTags(List<String> targetPosCollection) {
        return this.result.getMorphesByTags(targetPosCollection);
    }

    public String getPlainText() {
        return this.result.getPlainText();
    }

    public List<Map<String, Object>> getTokenList() {
        return this.result.getTokenList().stream().map(this::convertTokenToMap).collect(Collectors.toList());
    }

    public List<Map<String, String>> getList() {
        return this.result.getList().stream().map(this::convertPairToMap).collect(Collectors.toList());
    }

    private Map<String, Object> convertTokenToMap(final Token token) {
        return new HashMap<String, Object>(){
            {
                this.put("morph", token.getMorph());
                this.put("pos", token.getPos());
                this.put("beginIndex", token.getBeginIndex());
                this.put("endIndex", token.getEndIndex());
            }
        };
    }

    private Map<String, String> convertPairToMap(final Pair pair) {
        return new HashMap<String, String>(){
            {
                this.put("first", pair.getFirst().toString());
                this.put("second", pair.getSecond().toString());
            }
        };
    }

    public static void main(String[] args) {
        KomoranEntryPoint komoranEntryPoint = new KomoranEntryPoint();
        komoranEntryPoint.initByModel(DEFAULT_MODEL.LIGHT);
        komoranEntryPoint.analyze("\u2460 \ub300\ud55c\ubbfc\uad6d\uc740 \ubbfc\uc8fc\uacf5\ud654\uad6d\uc774\ub2e4. \u2461 \ub300\ud55c\ubbfc\uad6d\uc758 \uc8fc\uad8c\uc740 \uad6d\ubbfc\uc5d0\uac8c \uc788\uace0, \ubaa8\ub4e0 \uad8c\ub825\uc740 \uad6d\ubbfc\uc73c\ub85c\ubd80\ud130 \ub098\uc628\ub2e4.");
        System.out.println(komoranEntryPoint.getTokenList());
        GatewayServer gatewayServer = new GatewayServer((Object)new KomoranEntryPoint(), 25335);
        gatewayServer.start();
    }
}

