/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.run;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import kr.co.shineware.nlp.komoran.core.Komoran;
import kr.co.shineware.nlp.komoran.modeler.builder.ModelBuilder;

public class KomoranConsoleRunner {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            KomoranConsoleRunner.printUsage();
            return;
        }
        Map<String, String> argMap = KomoranConsoleRunner.parseArgs(args);
        if (argMap == null) {
            KomoranConsoleRunner.printUsage();
            return;
        }
        if (argMap.containsKey("-train") && argMap.containsKey("-model")) {
            long begin = System.currentTimeMillis();
            KomoranConsoleRunner.printTrainingInfo(argMap);
            KomoranConsoleRunner.training(argMap);
            long end = System.currentTimeMillis();
            System.out.println("Training elapsed time : " + (end - begin) + "ms");
        } else if (argMap.containsKey("-in") && argMap.containsKey("-out") && argMap.containsKey("-model")) {
            long begin = System.currentTimeMillis();
            KomoranConsoleRunner.printAnalyzeInfo(argMap);
            KomoranConsoleRunner.analyzing(argMap);
            long end = System.currentTimeMillis();
            System.out.println("Analyze elapsed time : " + (end - begin) + "ms");
        } else {
            KomoranConsoleRunner.printUsage();
            return;
        }
    }

    private static void training(Map<String, String> argMap) {
        ModelBuilder modelBuilder = new ModelBuilder();
        if (argMap.containsKey("-externalDic")) {
            modelBuilder.setExternalDic(argMap.get("-externalDic"));
        }
        modelBuilder.buildPath(argMap.get("-train"));
        modelBuilder.save(argMap.get("-model"));
    }

    private static void printTrainingInfo(Map<String, String> argMap) {
        System.out.println("training data : " + argMap.get("-train"));
        if (argMap.containsKey("-externalDic")) {
            System.out.println("externalDic : " + argMap.get("-externalDic"));
        }
        System.out.println("model path(output dir) : " + argMap.get("-model"));
    }

    private static void analyzing(Map<String, String> argMap) throws Exception {
        Komoran komoran = new Komoran(argMap.get("-model"));
        if (argMap.containsKey("-userDic")) {
            komoran.setUserDic(argMap.get("-userDic"));
        }
        if (argMap.containsKey("-fwd")) {
            komoran.setFWDic(argMap.get("-fwd"));
        }
        BufferedReader br = new BufferedReader(new FileReader(argMap.get("-in")));
        BufferedWriter bw = new BufferedWriter(new FileWriter(argMap.get("-out")));
        String line = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            bw.write(komoran.analyze(line).getPlainText());
            bw.newLine();
        }
        bw.close();
        br.close();
    }

    private static void printAnalyzeInfo(Map<String, String> argMap) {
        System.out.println("input file : " + argMap.get("-in"));
        System.out.println("output file : " + argMap.get("-out"));
        System.out.println("model path : " + argMap.get("-model"));
        if (argMap.containsKey("-userDic")) {
            System.out.println("user dic : " + argMap.get("-userDic"));
        }
        if (argMap.containsKey("-fwd")) {
            System.out.println("fwd : " + argMap.get("-fwd"));
        }
    }

    private static Map<String, String> parseArgs(String[] args) {
        try {
            HashMap<String, String> argMap = new HashMap<String, String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-train")) {
                    argMap.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-externalDic")) {
                    argMap.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-model")) {
                    argMap.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-userDic")) {
                    argMap.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-fwd")) {
                    argMap.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-in")) {
                    argMap.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-out")) {
                    argMap.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                return null;
            }
            return argMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void printUsage() {
        System.out.println("[\ucf54\ubaa8\ub780 \ud2b8\ub808\uc774\ub2dd \ubc29\ubc95]");
        System.out.println("\tjava -jar KOMORAN.jar -train '\ud559\uc2b5 \ub370\uc774\ud130\uac00 \ud3ec\ud568\ub41c \ud3f4\ub354\uba85' [-externalDic '\ud559\uc2b5 \uc2dc \ucd94\uac00\ub420 \uc0ac\uc804'] -model '\ud559\uc2b5 \ubaa8\ub378\uc774 \uc800\uc7a5\ub420 \ud3f4\ub354\uba85'");
        System.out.println("[\ucf54\ubaa8\ub780 \ud30c\uc77c \ubd84\uc11d \ubc29\ubc95]");
        System.out.println("\tjava -jar KOMORAN.jar -model '\ud559\uc2b5\ub41c \ubaa8\ub378\uc774 \ud3ec\ud568\ub41c \ud3f4\ub354\uba85' [-userDic '\uc0ac\uc6a9\uc0ac \uc0ac\uc804 \ud30c\uc77c'] [-fwd '\uae30\ubd84\uc11d \uc0ac\uc804 \ud30c\uc77c'] -in '\ubd84\uc11d \ub300\uc0c1 \ud30c\uc77c' -out '\ubd84\uc11d \uacb0\uacfc \ud30c\uc77c'");
    }
}

