/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.modeler.model;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kr.co.shineware.ds.aho_corasick.AhoCorasickDictionary;
import kr.co.shineware.nlp.komoran.interfaces.FileAccessible;
import kr.co.shineware.nlp.komoran.modeler.model.IrregularNode;

public class IrregularTrie
implements FileAccessible {
    private AhoCorasickDictionary<List<IrregularNode>> dic;

    public IrregularTrie() {
        this.init();
    }

    public void init() {
        this.dic = null;
        this.dic = new AhoCorasickDictionary();
    }

    public void put(String irr, IrregularNode irrNode) {
        List<IrregularNode> irrNodeList = this.dic.getValue(irr);
        if (irrNodeList == null) {
            irrNodeList = new ArrayList<IrregularNode>();
            irrNodeList.add(irrNode);
        } else {
            boolean hasSameNode = false;
            for (IrregularNode irregularNode : irrNodeList) {
                if (!irrNode.equals(irregularNode)) continue;
                hasSameNode = true;
                break;
            }
            if (!hasSameNode) {
                irrNodeList.add(irrNode);
            }
        }
        this.dic.put(irr, irrNodeList);
    }

    public AhoCorasickDictionary<List<IrregularNode>> getTrieDictionary() {
        return this.dic;
    }

    @Override
    public void save(String filename) {
        this.dic.save(filename);
    }

    @Override
    public void load(String filename) {
        this.dic.load(filename);
    }

    public void load(File file) {
        this.dic.load(file);
    }

    public void load(InputStream inputStream) {
        this.dic.load(inputStream);
    }
}

