/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.corpus.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.co.shineware.nlp.komoran.interfaces.FileAccessible;
import kr.co.shineware.util.common.collection.MapUtil;

public class Dictionary
implements FileAccessible {
    private Map<String, Map<String, Integer>> dictionary;

    public Dictionary() {
        this.init();
    }

    public Dictionary(String filename) {
        this.load(filename);
    }

    protected void init() {
        this.dictionary = new HashMap<String, Map<String, Integer>>();
    }

    public Map<String, Map<String, Integer>> getDictionary() {
        return this.dictionary;
    }

    @Override
    public void save(String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            Set<Map.Entry<String, Map<String, Integer>>> entrySet = this.dictionary.entrySet();
            for (Map.Entry<String, Map<String, Integer>> entry : entrySet) {
                bw.write(entry.getKey());
                bw.write("\t");
                Set<String> posSet = entry.getValue().keySet();
                int posSize = posSet.size();
                int count = 0;
                for (String pos : posSet) {
                    bw.write(pos);
                    bw.write(":");
                    Integer tf = entry.getValue().get(pos);
                    bw.write("" + tf);
                    if (++count == posSize) continue;
                    bw.write("\t");
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load(String filename) {
        this.init();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));
            String line = null;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                String[] tokens = line.split("\t");
                String word = tokens[0];
                HashMap<String, Integer> posTfMap = new HashMap<String, Integer>();
                for (int i = 1; i < tokens.length; ++i) {
                    String token = tokens[i];
                    int separatorIdx = token.lastIndexOf(58);
                    String pos = token.substring(0, separatorIdx);
                    int tf = Integer.parseInt(token.substring(separatorIdx + 1));
                    posTfMap.put(pos, tf);
                }
                this.dictionary.put(word, posTfMap);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected List<String> get(String word) {
        Map<String, Integer> keyMap = this.dictionary.get(word);
        if (keyMap == null) {
            return null;
        }
        return MapUtil.getKeyList(keyMap);
    }

    public void append(String word, String pos) {
        Integer tf;
        Map<String, Integer> posMap = this.dictionary.get(word);
        if (posMap == null) {
            posMap = new HashMap<String, Integer>();
        }
        if ((tf = posMap.get(pos)) == null) {
            tf = 0;
        }
        Integer n = tf;
        Integer n2 = tf = Integer.valueOf(tf + 1);
        posMap.put(pos, tf);
        this.dictionary.put(word, posMap);
    }

    public void append(String word, String pos, int inc) {
        Integer tf;
        Map<String, Integer> posMap = this.dictionary.get(word);
        if (posMap == null) {
            posMap = new HashMap<String, Integer>();
        }
        if ((tf = posMap.get(pos)) == null) {
            tf = 0;
        }
        tf = tf + inc;
        posMap.put(pos, tf);
        this.dictionary.put(word, posMap);
    }

    public List<String> getPosList(String word) {
        return this.get(word);
    }
}

