/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.core.model;

import kr.co.shineware.nlp.komoran.model.MorphTag;

public class LatticeNode {
    private int beginIdx;
    private int endIdx;
    private MorphTag morphTag;
    private double score;
    private int prevNodeIdx = -1;
    private String morph;

    public String toString() {
        return "LatticeNode [beginIdx=" + this.beginIdx + ", endIdx=" + this.endIdx + ", morphTag=" + this.morphTag + ", score=" + this.score + ", prevNodeIdx=" + this.prevNodeIdx + ", morph=" + this.morph + "]";
    }

    public LatticeNode() {
    }

    public LatticeNode(int beginIdx, int endIdx, MorphTag morphTag, double score) {
        this.beginIdx = beginIdx;
        this.endIdx = endIdx;
        this.morphTag = morphTag;
        this.score = score;
    }

    public LatticeNode(LatticeNode latticeNode) {
        this.beginIdx = latticeNode.getBeginIdx();
        this.endIdx = latticeNode.getEndIdx();
        this.morphTag = latticeNode.getMorphTag();
        this.score = latticeNode.getScore();
    }

    public int getBeginIdx() {
        return this.beginIdx;
    }

    public void setBeginIdx(int beginIdx) {
        this.beginIdx = beginIdx;
    }

    public int getEndIdx() {
        return this.endIdx;
    }

    public void setEndIdx(int endIdx) {
        this.endIdx = endIdx;
    }

    public MorphTag getMorphTag() {
        return this.morphTag;
    }

    public void setMorphTag(MorphTag morphTag) {
        this.morphTag = morphTag;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public int getPrevNodeIdx() {
        return this.prevNodeIdx;
    }

    public void setPrevNodeIdx(int prevNodeIdx) {
        this.prevNodeIdx = prevNodeIdx;
    }

    public String getTag() {
        return this.morphTag.getTag();
    }
}

