/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import kr.co.shineware.nlp.komoran.constant.DEFAULT_MODEL;
import kr.co.shineware.nlp.komoran.core.model.ContinuousSymbolBuffer;
import kr.co.shineware.nlp.komoran.core.model.Lattice;
import kr.co.shineware.nlp.komoran.core.model.LatticeNode;
import kr.co.shineware.nlp.komoran.core.model.Resources;
import kr.co.shineware.nlp.komoran.corpus.parser.CorpusParser;
import kr.co.shineware.nlp.komoran.corpus.parser.model.ProblemAnswerPair;
import kr.co.shineware.nlp.komoran.model.KomoranResult;
import kr.co.shineware.nlp.komoran.model.MorphTag;
import kr.co.shineware.nlp.komoran.model.ScoredTag;
import kr.co.shineware.nlp.komoran.modeler.model.IrregularNode;
import kr.co.shineware.nlp.komoran.modeler.model.Observation;
import kr.co.shineware.nlp.komoran.parser.KoreanUnitParser;
import kr.co.shineware.nlp.komoran.util.KomoranCallable;
import kr.co.shineware.util.common.file.FileUtil;
import kr.co.shineware.util.common.model.Pair;
import kr.co.shineware.util.common.string.StringUtil;

public class Komoran
implements Cloneable {
    private Resources resources = new Resources();
    private Observation userDic;
    private KoreanUnitParser unitParser;
    private HashMap<String, List<Pair<String, String>>> fwd;

    public Komoran(String modelPath) {
        this.load(modelPath);
        this.unitParser = new KoreanUnitParser();
    }

    public Komoran(DEFAULT_MODEL modelType) {
        this.resources.init();
        String modelPath = modelType == DEFAULT_MODEL.FULL ? "models_full" : (modelType == DEFAULT_MODEL.LIGHT ? "models_light" : "models_full");
        String delimiter = "/";
        InputStream posTableFile = this.getResourceStream(modelPath + delimiter + "pos.table");
        InputStream irrModelFile = this.getResourceStream(modelPath + delimiter + "irregular.model");
        InputStream observationFile = this.getResourceStream(modelPath + delimiter + "observation.model");
        InputStream transitionFile = this.getResourceStream(modelPath + delimiter + "transition.model");
        this.resources.loadPosTable(posTableFile);
        this.resources.loadIrregular(irrModelFile);
        this.resources.loadObservation(observationFile);
        this.resources.loadTransition(transitionFile);
        this.unitParser = new KoreanUnitParser();
    }

    private InputStream getResourceStream(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    public void analyzeTextFile(String inputFilename, String outputFilename, int thread) {
        try {
            List<String> lines = FileUtil.load2List(inputFilename);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), StandardCharsets.UTF_8));
            ArrayList<Future<KomoranResult>> komoranResultList = new ArrayList<Future<KomoranResult>>();
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(thread);
            for (String string : lines) {
                KomoranCallable komoranCallable = new KomoranCallable(this, string);
                komoranResultList.add(executor.submit(komoranCallable));
            }
            for (Future future : komoranResultList) {
                KomoranResult komoranResult = (KomoranResult)future.get();
                bw.write(komoranResult.getPlainText());
                bw.newLine();
            }
            bw.close();
            executor.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<KomoranResult> analyze(List<String> sentences, int thread) {
        ArrayList<KomoranResult> komoranResultList = new ArrayList<KomoranResult>();
        try {
            ArrayList<Future<KomoranResult>> komoranResultFutureList = new ArrayList<Future<KomoranResult>>();
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(thread);
            for (String string : sentences) {
                KomoranCallable komoranCallable = new KomoranCallable(this, string);
                komoranResultFutureList.add(executor.submit(komoranCallable));
            }
            for (Future future : komoranResultFutureList) {
                komoranResultList.add((KomoranResult)future.get());
            }
            executor.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return komoranResultList;
    }

    public KomoranResult analyze(String sentence) {
        return this.analyze(sentence, 1).get(0);
    }

    public List<KomoranResult> analyze(String sentence, int nbest) {
        Lattice lattice = new Lattice(this.resources, this.userDic, nbest);
        ContinuousSymbolBuffer continuousSymbolBuffer = new ContinuousSymbolBuffer();
        String jasoUnits = this.unitParser.parse(sentence);
        List<Pair<Character, KoreanUnitParser.UnitType>> jasoUnitsWithType = this.unitParser.parseWithType(sentence);
        int length = jasoUnits.length();
        int whitespaceIndex = 0;
        for (int curJasoIndex = 0; curJasoIndex < length; ++curJasoIndex) {
            int skipIdx = this.lookupFwd(lattice, jasoUnits, curJasoIndex);
            if (skipIdx != -1) {
                curJasoIndex = skipIdx - 1;
                continue;
            }
            if (jasoUnits.charAt(curJasoIndex) == ' ') {
                this.consumeContiniousSymbolParserBuffer(lattice, curJasoIndex, continuousSymbolBuffer);
                this.bridgeToken(lattice, curJasoIndex, jasoUnits, whitespaceIndex, jasoUnitsWithType);
                whitespaceIndex = curJasoIndex + 1;
            }
            this.continuousSymbolParsing(lattice, jasoUnits.charAt(curJasoIndex), curJasoIndex, continuousSymbolBuffer);
            this.symbolParsing(lattice, jasoUnits.charAt(curJasoIndex), curJasoIndex);
            this.userDicParsing(lattice, jasoUnits.charAt(curJasoIndex), curJasoIndex);
            this.regularParsing(lattice, jasoUnits.charAt(curJasoIndex), curJasoIndex);
            this.irregularParsing(lattice, jasoUnits.charAt(curJasoIndex), curJasoIndex);
            this.irregularExtends(lattice, jasoUnits.charAt(curJasoIndex), curJasoIndex);
        }
        this.consumeContiniousSymbolParserBuffer(lattice, jasoUnits, continuousSymbolBuffer);
        lattice.setLastIdx(jasoUnits.length());
        boolean inserted = lattice.appendEndNode();
        if (!inserted) {
            double NAPenaltyScore = -10000.0;
            if (whitespaceIndex != 0) {
                NAPenaltyScore += lattice.getNodeList(whitespaceIndex).get(0).getScore();
            }
            String combinedWord = this.unitParser.combineWithType(jasoUnitsWithType.subList(whitespaceIndex, jasoUnits.length()));
            LatticeNode latticeNode = new LatticeNode(whitespaceIndex, jasoUnits.length(), new MorphTag(combinedWord, "NA", this.resources.getTable().getId("NA")), NAPenaltyScore);
            latticeNode.setPrevNodeIdx(0);
            lattice.appendNode(latticeNode);
            lattice.appendEndNode();
        }
        List<List<LatticeNode>> nBestPath = lattice.findNBestPath();
        ArrayList<KomoranResult> nbestResultList = new ArrayList<KomoranResult>();
        if (nBestPath == null) {
            ArrayList<LatticeNode> resultList = new ArrayList<LatticeNode>();
            resultList.add(new LatticeNode(0, jasoUnits.length(), new MorphTag(sentence, "NA", -1), -10000.0));
            nbestResultList.add(new KomoranResult(resultList, jasoUnits));
        } else {
            for (List<LatticeNode> shortestPath : nBestPath) {
                Collections.reverse(shortestPath);
                ArrayList<LatticeNode> resultList = new ArrayList<LatticeNode>(shortestPath);
                nbestResultList.add(new KomoranResult(resultList, jasoUnits));
            }
        }
        return nbestResultList;
    }

    private void bridgeToken(Lattice lattice, int curIdx, String jasoUnits, int prevBeginSymbolIdx, List<Pair<Character, KoreanUnitParser.UnitType>> jasoUnitsWithType) {
        if (lattice.put(curIdx, curIdx + 1, "EOE", "EOE", this.resources.getTable().getId("EOE"), 0.0)) {
            return;
        }
        LatticeNode naLatticeNode = lattice.makeNode(prevBeginSymbolIdx, curIdx, this.unitParser.combineWithType(jasoUnitsWithType.subList(prevBeginSymbolIdx, curIdx)), "NA", this.resources.getTable().getId("NA"), -10000.0, 0);
        int naNodeIndex = lattice.appendNode(naLatticeNode);
        LatticeNode endLatticeNode = lattice.makeNode(curIdx, curIdx + 1, "EOE", "EOE", this.resources.getTable().getId("EOE"), 0.0, naNodeIndex);
        lattice.appendNode(endLatticeNode);
    }

    private void symbolParsing(Lattice lattice, char jaso, int idx) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(jaso);
        if (!StringUtil.isNumeric(jaso)) {
            if (unicodeBlock == Character.UnicodeBlock.BASIC_LATIN) {
                if (!(this.isEnglishCharacter(jaso) || this.isWhitespaceCharacter(jaso) || this.isDictionaryEntryCharacter(jaso))) {
                    lattice.put(idx, idx + 1, "" + jaso, "SW", this.resources.getTable().getId("SW"), -10000.0);
                }
            } else if (!(StringUtil.isKorean(jaso) || StringUtil.isJapanese(jaso) || StringUtil.isChinese(jaso))) {
                lattice.put(idx, idx + 1, "" + jaso, "SW", this.resources.getTable().getId("SW"), -10000.0);
            }
        }
    }

    private boolean isDictionaryEntryCharacter(char jaso) {
        return this.resources.getObservation().getTrieDictionary().getValue("" + jaso) != null;
    }

    private boolean isWhitespaceCharacter(char jaso) {
        return jaso == ' ';
    }

    private boolean isEnglishCharacter(char jaso) {
        return jaso >= 'A' && jaso <= 'Z' || jaso >= 'a' && jaso <= 'z';
    }

    private void userDicParsing(Lattice lattice, char jaso, int curIndex) {
        Map<String, List<ScoredTag>> morphScoredTagsMap = lattice.retrievalUserDicObservation(jaso);
        if (morphScoredTagsMap == null || morphScoredTagsMap.size() == 0) {
            return;
        }
        Set<String> morphes = morphScoredTagsMap.keySet();
        for (String morph : morphes) {
            int beginIdx = curIndex - morph.length() + 1;
            int endIdx = curIndex + 1;
            List<ScoredTag> scoredTags = morphScoredTagsMap.get(morph);
            for (ScoredTag scoredTag : scoredTags) {
                lattice.put(beginIdx, endIdx, morph, scoredTag.getTag(), scoredTag.getTagId(), scoredTag.getScore());
            }
        }
    }

    private int lookupFwd(Lattice lattice, String token, int curJasoIndex) {
        int wordEndIdx;
        String targetWord;
        List<Pair<String, String>> fwdResultList;
        if (this.fwd == null) {
            return -1;
        }
        if ((curJasoIndex == 0 || token.charAt(curJasoIndex - 1) == ' ') && (fwdResultList = this.fwd.get(targetWord = token.substring(curJasoIndex, wordEndIdx = (wordEndIdx = token.indexOf(32, curJasoIndex)) == -1 ? token.length() : wordEndIdx))) != null) {
            this.insertLatticeForFwd(lattice, curJasoIndex, wordEndIdx, fwdResultList, targetWord);
            return wordEndIdx;
        }
        return -1;
    }

    private void insertLatticeForFwd(Lattice lattice, int beginIdx, int endIdx, List<Pair<String, String>> fwdResultList, String targetWord) {
        lattice.put(beginIdx, endIdx, fwdResultList);
    }

    private boolean hasRegularFWDValues(List<Pair<String, String>> fwdResultList, String targetWord) {
        StringBuilder fwdMorphs = new StringBuilder();
        for (Pair<String, String> morphPosPair : fwdResultList) {
            fwdMorphs.append(this.unitParser.parse(morphPosPair.getFirst()));
        }
        return fwdMorphs.toString().equals(targetWord);
    }

    private void continuousSymbolParsing(Lattice lattice, char charAt, int i, ContinuousSymbolBuffer continuousSymbolBuffer) {
        String curPos = "";
        if (StringUtil.isEnglish(charAt)) {
            curPos = "SL";
        } else if (StringUtil.isNumeric(charAt)) {
            curPos = "SN";
        } else if (StringUtil.isChinese(charAt)) {
            curPos = "SH";
        } else if (StringUtil.isForeign(charAt)) {
            curPos = "SL";
        }
        if (curPos.equals(continuousSymbolBuffer.getPrevPos())) {
            continuousSymbolBuffer.setPrevMorph(continuousSymbolBuffer.getPrevMorph() + charAt);
        } else {
            switch (continuousSymbolBuffer.getPrevPos()) {
                case "SL": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), i, continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                    break;
                }
                case "SN": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), i, continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                    break;
                }
                case "SH": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), i, continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                }
            }
            continuousSymbolBuffer.setPrevBeginIdx(i);
            continuousSymbolBuffer.setPrevMorph("" + charAt);
            continuousSymbolBuffer.setPrevPos(curPos);
        }
    }

    private void consumeContiniousSymbolParserBuffer(Lattice lattice, String in, ContinuousSymbolBuffer continuousSymbolBuffer) {
        if (continuousSymbolBuffer.getPrevPos().trim().length() != 0) {
            switch (continuousSymbolBuffer.getPrevPos()) {
                case "SL": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), in.length(), continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                    break;
                }
                case "SH": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), in.length(), continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                    break;
                }
                case "SN": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), in.length(), continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                }
            }
        }
    }

    private void consumeContiniousSymbolParserBuffer(Lattice lattice, int endIdx, ContinuousSymbolBuffer continuousSymbolBuffer) {
        if (continuousSymbolBuffer.getPrevPos().trim().length() != 0) {
            switch (continuousSymbolBuffer.getPrevPos()) {
                case "SL": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), endIdx, continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                    break;
                }
                case "SH": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), endIdx, continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                    break;
                }
                case "SN": {
                    lattice.put(continuousSymbolBuffer.getPrevBeginIdx(), endIdx, continuousSymbolBuffer.getPrevMorph(), continuousSymbolBuffer.getPrevPos(), this.resources.getTable().getId(continuousSymbolBuffer.getPrevPos()), -1.0);
                }
            }
        }
    }

    private void irregularExtends(Lattice lattice, char jaso, int curIndex) {
        List<LatticeNode> prevLatticeNodes = lattice.getNodeList(curIndex);
        if (prevLatticeNodes != null) {
            HashSet<LatticeNode> extendedIrrNodeList = new HashSet<LatticeNode>();
            for (LatticeNode prevLatticeNode : prevLatticeNodes) {
                List<ScoredTag> lastScoredTags;
                if (prevLatticeNode.getMorphTag().getTagId() != -1) continue;
                String lastMorph = prevLatticeNode.getMorphTag().getMorph();
                if (this.resources.getObservation().getTrieDictionary().hasChild((lastMorph + jaso).toCharArray())) {
                    LatticeNode extendedIrregularNode = new LatticeNode();
                    extendedIrregularNode.setBeginIdx(prevLatticeNode.getBeginIdx());
                    extendedIrregularNode.setEndIdx(curIndex + 1);
                    extendedIrregularNode.setMorphTag(new MorphTag(prevLatticeNode.getMorphTag().getMorph() + jaso, "IRR", -1));
                    extendedIrregularNode.setPrevNodeIdx(prevLatticeNode.getPrevNodeIdx());
                    extendedIrregularNode.setScore(prevLatticeNode.getScore());
                    extendedIrrNodeList.add(extendedIrregularNode);
                }
                if ((lastScoredTags = this.resources.getObservation().getTrieDictionary().getValue(lastMorph + jaso)) == null) continue;
                for (ScoredTag scoredTag : lastScoredTags) {
                    lattice.put(prevLatticeNode.getBeginIdx(), curIndex + 1, prevLatticeNode.getMorphTag().getMorph() + jaso, scoredTag.getTag(), scoredTag.getTagId(), scoredTag.getScore());
                }
            }
            for (LatticeNode extendedIrrNode : extendedIrrNodeList) {
                lattice.appendNode(extendedIrrNode);
            }
        }
    }

    private void irregularParsing(Lattice lattice, char jaso, int curIndex) {
        Map<String, List<IrregularNode>> morphIrrNodesMap = lattice.retrievalIrregularNodes(jaso);
        if (morphIrrNodesMap == null || morphIrrNodesMap.size() == 0) {
            return;
        }
        Set<String> morphs = morphIrrNodesMap.keySet();
        for (String morph : morphs) {
            int beginIdx = curIndex - morph.length() + 1;
            int endIdx = curIndex + 1;
            List<IrregularNode> irrNodes = morphIrrNodesMap.get(morph);
            for (IrregularNode irregularNode : irrNodes) {
                this.insertLattice(lattice, beginIdx, endIdx, irregularNode);
            }
        }
    }

    private void insertLattice(Lattice lattice, int beginIdx, int endIdx, IrregularNode irregularNode) {
        lattice.put(beginIdx, endIdx, irregularNode);
    }

    private void regularParsing(Lattice lattice, char jaso, int curIndex) {
        Map<String, List<ScoredTag>> morphScoredTagsMap = lattice.retrievalObservation(jaso);
        if (morphScoredTagsMap == null || morphScoredTagsMap.size() == 0) {
            return;
        }
        Set<String> morphes = morphScoredTagsMap.keySet();
        for (String morph : morphes) {
            int beginIdx = curIndex - morph.length() + 1;
            int endIdx = curIndex + 1;
            List<ScoredTag> scoredTags = morphScoredTagsMap.get(morph);
            for (ScoredTag scoredTag : scoredTags) {
                lattice.put(beginIdx, endIdx, morph, scoredTag.getTag(), scoredTag.getTagId(), scoredTag.getScore());
                if (!scoredTag.getTag().equals("EC")) continue;
                lattice.put(beginIdx, endIdx, morph, "EF", this.resources.getTable().getId("EF"), scoredTag.getScore());
            }
        }
    }

    private void load(String modelPath) {
        this.resources.load(modelPath);
    }

    public void setFWDic(String filename) {
        try {
            String line;
            CorpusParser corpusParser = new CorpusParser();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));
            this.fwd = new HashMap();
            while ((line = br.readLine()) != null) {
                String[] tmp = line.split("\t");
                if (tmp.length != 2 || tmp[0].charAt(0) == '#') continue;
                ProblemAnswerPair problemAnswerPair = corpusParser.parse(line);
                ArrayList<Pair<String, String>> convertAnswerList = new ArrayList<Pair<String, String>>();
                for (Pair<String, String> pair : problemAnswerPair.getAnswerList()) {
                    convertAnswerList.add(new Pair<String, String>(pair.getFirst(), pair.getSecond()));
                }
                this.fwd.put(this.unitParser.parse(problemAnswerPair.getProblem()), convertAnswerList);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUserDic(String userDic) {
        try {
            String line;
            this.userDic = new Observation();
            BufferedReader br = new BufferedReader(new FileReader(userDic));
            while ((line = br.readLine()) != null) {
                String pos;
                String morph;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int lastIdx = line.lastIndexOf("\t");
                if (lastIdx == -1) {
                    morph = line.trim();
                    pos = "NNP";
                } else {
                    morph = line.substring(0, lastIdx);
                    pos = line.substring(lastIdx + 1);
                }
                this.userDic.put(morph, pos, this.resources.getTable().getId(pos), 0.0);
            }
            br.close();
            this.userDic.getTrieDictionary().buildFailLink();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

