"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
class Runtime {
    constructor(name, family, props = {}) {
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        Runtime.ALL.push(this);
    }
    toString() {
        return this.name;
    }
    runtimeEquals(other) {
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
exports.Runtime = Runtime;
/** A list of all known `Runtime`'s. */
Runtime.ALL = new Array();
/** @deprecated Use {@link NODEJS_10_X} */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/** @deprecated Use {@link NODEJS_10_X} */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/** @deprecated Use {@link NODEJS_10_X} */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/** @deprecated Use {@link NODEJS_10_X} */
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
Runtime.NODEJS_12_X = new Runtime('nodejs12.x', RuntimeFamily.NODEJS);
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, { supportsInlineCode: true });
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
Runtime.PYTHON_3_8 = new Runtime('python3.8', RuntimeFamily.PYTHON);
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA);
Runtime.JAVA_11 = new Runtime('java11', RuntimeFamily.JAVA);
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/** @deprecated Use {@link DotNetCore21} */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE);
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO);
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY, { supportsInlineCode: true });
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
//# sourceMappingURL=data:application/json;base64,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