"use strict";
// Copyright 2012-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const function_base_1 = require("./function-base");
function_base_1.FunctionBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric(Object.assign({ namespace: 'AWS/Lambda', metricName, dimensions: { FunctionName: this.functionName } }, props));
};
function_base_1.FunctionBase.prototype.metricThrottles = function (props) {
    return this.metric('Throttles', Object.assign({ statistic: 'Sum' }, props));
};
function_base_1.FunctionBase.prototype.metricInvocations = function (props) {
    return this.metric('Invocations', Object.assign({ statistic: 'Sum' }, props));
};
function_base_1.FunctionBase.prototype.metricErrors = function (props) {
    return this.metric('Errors', Object.assign({ statistic: 'Sum' }, props));
};
function_base_1.FunctionBase.prototype.metricDuration = function (props) {
    return this.metric('Duration', Object.assign({ statistic: 'Average' }, props));
};
//# sourceMappingURL=data:application/json;base64,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