/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.DoubleArray;
import ints.IntList;
import vcf.MarkerMap;

public class Steps {
    private final MarkerMap map;
    private final int[] stepEnds;

    public Steps(MarkerMap markerMap, float f) {
        if (f <= 0.0f || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        this.map = markerMap;
        this.stepEnds = Steps.stepEnds(markerMap, f);
    }

    private static int[] stepEnds(MarkerMap markerMap, double d) {
        DoubleArray doubleArray = markerMap.genPos();
        int n = doubleArray.size();
        IntList intList = new IntList(n >> 1);
        int n2 = 0;
        while (n2 < n) {
            double d2 = doubleArray.get(n2) + d;
            ++n2;
            while (n2 < doubleArray.size() && doubleArray.get(n2) < d2) {
                ++n2;
            }
            intList.add(n2);
        }
        return intList.toArray();
    }

    public int size() {
        return this.stepEnds.length;
    }

    public int start(int n) {
        return n == 0 ? 0 : this.stepEnds[n - 1];
    }

    public int end(int n) {
        return this.stepEnds[n];
    }

    public MarkerMap map() {
        return this.map;
    }
}

