/*
 * Decompiled with CFR 0.152.
 */
package ints;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class IntIntMap {
    private static final int NIL = -1;
    private static final float LOAD_FACTOR = 0.75f;
    private int size;
    private int nBuckets;
    private int[] next;
    private int[] data;
    private int[] keys;
    private int[] values;
    private int firstFreeIndex;

    public IntIntMap(int n) {
        if (n < 1 || n > 0x40000000) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n2 = (int)Math.ceil((float)n / 0.75f) + 1;
        this.allocateArrays(n, n2);
        this.initializeFields(n2);
    }

    private void allocateArrays(int n, int n2) {
        this.next = new int[n2 + n];
        this.data = new int[n2 + n];
        this.keys = new int[n];
        this.values = new int[n];
    }

    private void initializeFields(int n) {
        this.size = 0;
        this.firstFreeIndex = this.nBuckets = n;
        Arrays.fill(this.next, 0, this.nBuckets, -1);
        for (int i = this.nBuckets; i < this.next.length; ++i) {
            this.next[i] = i + 1;
        }
    }

    private void rehash(int n) {
        if (n > this.size) {
            int n2 = this.size;
            int[] nArray = (int[])this.keys.clone();
            int[] nArray2 = (int[])this.values.clone();
            int n3 = (int)Math.ceil((float)n / 0.75f);
            this.allocateArrays(n, n3);
            this.initializeFields(n3);
            for (int i = 0; i < n2; ++i) {
                this.put(nArray[i], nArray2[i]);
            }
        }
    }

    public void clear() {
        this.initializeFields(this.nBuckets);
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    private int indexOf(int n) {
        int n2 = this.next[this.bucket(n)];
        while (n2 != -1 && this.keys[this.data[n2]] < n) {
            n2 = this.next[n2];
        }
        return n2 != -1 && this.keys[this.data[n2]] == n ? n2 : -1;
    }

    public boolean put(int n, int n2) {
        int n3 = this.prevIndex(n);
        int n4 = this.next[n3];
        if (n4 == -1 || this.keys[this.data[n4]] != n) {
            int n5 = this.firstFreeIndex;
            this.firstFreeIndex = this.next[this.firstFreeIndex];
            this.next[n3] = n5;
            this.data[n5] = this.size;
            this.next[n5] = n4;
            this.keys[this.size] = n;
            this.values[this.size++] = n2;
            if (this.size == this.keys.length) {
                int n6 = 3 * this.keys.length / 2 + 1;
                this.rehash(n6);
            }
            return true;
        }
        if (this.values[this.data[n4]] != n2) {
            this.values[this.data[n4]] = n2;
            return true;
        }
        return false;
    }

    public boolean remove(int n) {
        int n2 = this.prevIndex(n);
        int n3 = this.next[n2];
        if (n3 == -1 || this.keys[this.data[n3]] != n) {
            return false;
        }
        int n4 = this.data[n3];
        this.next[n2] = this.next[n3];
        this.next[n3] = this.firstFreeIndex;
        this.firstFreeIndex = n3;
        --this.size;
        if (n4 != this.size) {
            n3 = this.indexOf(this.keys[this.size]);
            this.data[n3] = n4;
            this.keys[n4] = this.keys[this.size];
            this.values[n4] = this.values[this.size];
        }
        return true;
    }

    private int bucket(int n) {
        return Math.abs(71 * n % this.nBuckets);
    }

    private int prevIndex(int n) {
        int n2 = this.bucket(n);
        int n3 = this.next[n2];
        while (n3 != -1 && this.keys[this.data[n3]] < n) {
            n2 = n3;
            n3 = this.next[n3];
        }
        return n2;
    }

    public int key(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.keys[n];
    }

    public int get(int n, int n2) {
        int n3 = this.indexOf(n);
        if (n3 == -1) {
            return n2;
        }
        return this.values[this.data[n3]];
    }

    public int size() {
        return this.size;
    }

    public int[] keys() {
        return Arrays.copyOf(this.keys, this.size);
    }

    public int[] values() {
        return Arrays.copyOf(this.values, this.size);
    }

    public String toString() {
        return Arrays.toString(this.keys());
    }

    private static void main(String[] stringArray) {
        IntIntMap intIntMap = new IntIntMap(4);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(100);
        Random random = new Random(0L);
        int n = 5000;
        int n2 = 100;
        for (int i = 0; i < n; ++i) {
            Integer n3;
            int n4;
            int n5 = i % n2;
            int n6 = random.nextInt();
            double d = random.nextDouble();
            if (d < 0.005) {
                intIntMap.clear();
                hashMap.clear();
            } else if (d < 0.4) {
                n4 = intIntMap.get(n5, -1);
                n3 = (Integer)hashMap.get(n5);
                assert (n4 == -1 && n3 == null || n4 == n3);
            } else if (d < 0.7) {
                n4 = intIntMap.get(n5, -1);
                intIntMap.put(n5, n6);
                n3 = hashMap.put(n5, n6);
                assert (n4 == -1 && n3 == null || n4 == n3);
            } else {
                n4 = intIntMap.get(n5, -1);
                intIntMap.remove(n5);
                n3 = (Integer)hashMap.remove(n5);
                assert (n4 == -1 && n3 == null || n4 == n3);
            }
            assert (intIntMap.size() == hashMap.size());
        }
    }
}

