/*
 * Decompiled with CFR 0.152.
 */
package ints;

import ints.IntArray;

public class IndexArray
implements IntArray {
    private final IntArray intArray;
    private final int valueSize;

    public IndexArray(int[] nArray, int n) {
        if (nArray == null) {
            throw new NullPointerException(IntArray.class.toString());
        }
        this.intArray = IntArray.create(nArray, n);
        this.valueSize = n;
    }

    public IndexArray(IntArray intArray, int n) {
        if (intArray == null) {
            throw new NullPointerException(IntArray.class.toString());
        }
        this.intArray = intArray;
        this.valueSize = n;
    }

    @Override
    public int get(int n) {
        return this.intArray.get(n);
    }

    @Override
    public int size() {
        return this.intArray.size();
    }

    public int valueSize() {
        return this.valueSize;
    }

    public IntArray intArray() {
        return this.intArray;
    }

    public static int valueSize(int[] nArray) {
        int n = -1;
        for (int n2 : nArray) {
            if (n2 < 0) {
                throw new IllegalArgumentException(String.valueOf(n2));
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    public static int valueSize(IntArray intArray) {
        int n = -1;
        int n2 = intArray.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = intArray.get(i);
            if (n3 < 0) {
                throw new IllegalArgumentException(String.valueOf(n3));
            }
            if (n3 <= n) continue;
            n = n3;
        }
        return n + 1;
    }
}

