# Generated by Django 3.2.12 on 2022-05-14 10:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import notification_system.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='EmailTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created time')),
                ('updated_time', models.DateTimeField(auto_now=True, verbose_name='updated time')),
                ('title', models.CharField(max_length=255, verbose_name='template title')),
                ('subject', models.CharField(max_length=255, verbose_name='subject')),
                ('content', models.TextField(blank=True, verbose_name='content')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active?')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='email_templates', to=settings.AUTH_USER_MODEL, verbose_name='owner')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NotificationEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created time')),
                ('updated_time', models.DateTimeField(auto_now=True, verbose_name='updated time')),
                ('title', models.CharField(max_length=255, verbose_name='notification events title')),
                ('subject', models.CharField(blank=True, max_length=255, verbose_name='subject')),
                ('content', models.TextField(blank=True, verbose_name='content')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active?')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SmtpProvider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created time')),
                ('updated_time', models.DateTimeField(auto_now=True, verbose_name='updated time')),
                ('provider_name', models.CharField(max_length=255, verbose_name='provider name')),
                ('email_host', models.CharField(max_length=255, verbose_name='email host')),
                ('email_host_user', models.CharField(max_length=255, verbose_name='email host user')),
                ('email_host_password', models.CharField(max_length=1024, verbose_name='email host password')),
                ('email_port', models.CharField(default=587, max_length=255, verbose_name='email port')),
                ('email_from', models.CharField(blank=True, help_text="Mail from <'mail@mail.com'>", max_length=255, verbose_name='email from')),
                ('email_timeout', models.PositiveSmallIntegerField(blank=True, null=True, verbose_name='email timeout')),
                ('email_use_tls', models.BooleanField(default=False, verbose_name='email use tls')),
                ('email_use_ssl', models.BooleanField(default=False, verbose_name='email use ssl')),
                ('email_ssl_keyfile', models.TextField(blank=True, verbose_name='email ssl keyfile')),
                ('email_ssl_certfile', models.TextField(blank=True, verbose_name='email ssl certfile')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active?')),
                ('users', models.ManyToManyField(blank=True, related_name='users', to=settings.AUTH_USER_MODEL, verbose_name='user access')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OutgoingMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created time')),
                ('updated_time', models.DateTimeField(auto_now=True, verbose_name='updated time')),
                ('recipient', models.CharField(blank=True, db_index=True, max_length=255, verbose_name='recipient')),
                ('subject', models.CharField(blank=True, max_length=255, verbose_name='subject')),
                ('content', models.TextField(blank=True, verbose_name='message content')),
                ('context', models.TextField(blank=True, verbose_name='message context')),
                ('error_message', models.TextField(blank=True, verbose_name='error message')),
                ('status', models.PositiveSmallIntegerField(choices=[(3, 'Failed'), (2, 'Pending'), (1, 'Sent'), (4, 'Bounce'), (5, 'Complaint'), (6, 'Delivery'), (7, 'Send'), (8, 'Reject'), (9, 'Open'), (10, 'Click'), (11, 'Rendering Failure'), (12, 'Delivery Delay'), (13, 'Subscription')], default=2, verbose_name='status')),
                ('outgoing_message_type', models.PositiveSmallIntegerField(choices=[(1, 'Email')], default=1, verbose_name='type')),
                ('notification_event', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='outgoing_messages', to='notification_system.notificationevent', verbose_name='notification event')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='outgoing_messages', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NotificationGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created time')),
                ('updated_time', models.DateTimeField(auto_now=True, verbose_name='updated time')),
                ('name', models.CharField(max_length=255, verbose_name='name')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active?')),
                ('members', models.ManyToManyField(blank=True, related_name='members', to=settings.AUTH_USER_MODEL, verbose_name='members')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='notification_groups', to=settings.AUTH_USER_MODEL, verbose_name='owner')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='notificationevent',
            name='notification_group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='notification_events', to='notification_system.notificationgroup', verbose_name='notification group'),
        ),
        migrations.AddField(
            model_name='notificationevent',
            name='owner',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='notification_events', to=settings.AUTH_USER_MODEL, verbose_name='owner'),
        ),
        migrations.AddField(
            model_name='notificationevent',
            name='smtp_provider',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='notification_events', to='notification_system.smtpprovider', verbose_name='smtp provider'),
        ),
        migrations.AddField(
            model_name='notificationevent',
            name='template',
            field=models.ForeignKey(blank=True, help_text='If template is selected, HTML message and subject fields will not be used- they will be populated from template', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='notification_events', to='notification_system.emailtemplate'),
        ),
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created time')),
                ('updated_time', models.DateTimeField(auto_now=True, verbose_name='updated time')),
                ('file', models.FileField(upload_to='notification_system/attachment/file/', validators=[notification_system.validators.validate_file_extension, notification_system.validators.validate_file_size], verbose_name='file')),
                ('notification_event', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='attachments', to='notification_system.notificationevent', verbose_name='notification event')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
