# AUTOGENERATED! DO NOT EDIT! File to edit: 01_PreProcessor.ipynb (unless otherwise specified).

__all__ = ['PreProcessor']

# Cell
from .DataFrameLoader import *
from .Logger import *

# Cell
# hide
import pandas as pd
from sklearn.compose import ColumnTransformer
from sklearn.pipeline import Pipeline
from sklearn.impute import SimpleImputer
from sklearn.preprocessing import OneHotEncoder, OrdinalEncoder, StandardScaler, MinMaxScaler
from sklearn.ensemble import RandomForestRegressor
from sklearn.metrics import mean_absolute_error

# Cell

class PreProcessor:
    """
    Represent PreProcessor class

    Attributes:
    numerical_transformer: Numerical Columns Tranformer
    categorical_transformer: Categorical Columns Transformer
    preprocessor: Preprocessor for Columns Tranformer
    """

    def __init__(self):
        self.numerical_transformer = None
        self.categorical_transformer = None
        self.columns_transfomer = None
        self.transformer_type = None
        self.categorical_transformer = None

    def __str__(self):
        """Returns human readable string reprsentation"""
        attr_str = "numerical_transformer, categorical_transformer,columns_transfomer"
        return "PreProcessor object with attributes:" + attr_str

    def __repr__(self):
        return self.__str__()

    # PreProcessor core methods

    # Preprocessing for numerical data
    def preprocess_numerical_data(self, num_cols__imputer, num_cols__scaler):
        self.numerical_transformer = Pipeline(steps=[
            ('imputer', num_cols__imputer),
            ('scaler',  num_cols__scaler)
        ])
        return self.numerical_transformer

    # Preprocessing for categorical data
    def preprocess_categorical_data(self, cat_cols__imputer, cat_cols__encoder):
        self.categorical_transformer = Pipeline(steps=[
        ('imputer', cat_cols__imputer),
        ('encoder', cat_cols__encoder)
        ])
        return self.categorical_transformer

    # Bundle preprocessing pipelines based upon types of columns
    def preprocess_all_cols(self, dataframeloader,
                            num_cols__imputer=SimpleImputer(strategy='median'),
                            num_cols__scaler=StandardScaler(),
                            cat_cols__imputer=SimpleImputer(strategy='constant'),
                            cat_cols__encoder=OneHotEncoder(handle_unknown='ignore')):

        # change preprocessor according to type of column found

        if len(dataframeloader.categorical_cols) < 1:
            #print("categorical cols are None")
            # create scikit-learn pipelines instances
            self.numerical_transformer = self.preprocess_numerical_data(num_cols__imputer, num_cols__scaler)

            # scaled and impute all numerical columns
            self.columns_transfomer = ColumnTransformer(
                transformers=[
                    ('num_cols', self.numerical_transformer,
                     dataframeloader.numerical_cols)
                ])

            self.transformer_type = self.columns_transfomer

        elif len(dataframeloader.numerical_cols) < 1:
            #print("numeric cols are None")
            # create scikit-learn pipelines instances
            self.categorical_transformer = self.preprocess_categorical_data(cat_cols__imputer, cat_cols__encoder)

            # convert all categorical columns to OneHotEncoder with Scikit-learn ColumnTranfomer
            self.columns_transfomer = ColumnTransformer(
                transformers=[
                    ('cat_cols', self.categorical_transformer,
                     dataframeloader.categorical_cols)
                ])

            self.transformer_type = self.columns_transfomer

        else:
            # create scikit-learn pipelines instances
            #print("No cols types are None, So ALL preprocessors called!")
            self.numerical_transformer = self.preprocess_numerical_data(num_cols__imputer, num_cols__scaler)
            self.categorical_transformer = self.preprocess_categorical_data(cat_cols__imputer, cat_cols__encoder)

            # convert to Scikit-learn ColumnTranfomer
            self.columns_transfomer = ColumnTransformer(
                transformers=[
                    ('num_cols', self.numerical_transformer,
                     dataframeloader.numerical_cols),
                    ('cat_cols', self.categorical_transformer,
                     dataframeloader.categorical_cols)
                ])

            self.transformer_type = self.columns_transfomer

        return self