"""
This module contains procedures for reading and writing various ARM datasets.

"""

from .armfiles import WriteDataset, check_arm_standards, create_obj_from_arm_dod, read_netcdf
from .csvfiles import read_csv
from .mpl import proc_sigma_mplv5_read, read_sigma_mplv5
from .noaagml import (
    read_gml,
    read_gml_co2,
    read_gml_halo,
    read_gml_met,
    read_gml_ozone,
    read_gml_radiation,
)
from .noaapsl import (
    read_psl_wind_profiler,
    read_psl_wind_profiler_temperature,
    read_psl_parsivel,
    read_psl_radar_fmcw_moment
)
from .pysp2 import read_hk_file, read_sp2, read_sp2_dat
