from setuptools import setup
from os import path

# get __version__
execfile("pong/__init__.py")


setup(
	name = 'pong',
	version = __version__,
	description = 'Fast visualization and analysis of population structure',
	author = 'Aaron A. Behr, Katherine Z. Liu, Tyler D. Devlin, Gracie Liu-Fang, Priyanka Nakka, and Sohini Ramachandran',
	author_email = 'aaron_behr@alumni.brown.edu',
	url = 'https://github.com/abehr/pong',
	# download_url = 'https://github.com/abehr/pkg/tarball/0.1',
	keywords = ['population','genetics','clustering'],
	classifiers = [
		"Development Status :: 4 - Beta",
		"Intended Audience :: Science/Research",
		"License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
		"Natural Language :: English",
		"Operating System :: MacOS :: MacOS X",
		"Operating System :: POSIX :: Linux",
		"Programming Language :: Python :: 2",
		"Programming Language :: Python :: 2.7",
		"Topic :: Scientific/Engineering :: Bio-Informatics"],
	provides = ["pong"],
	# Enforce min versions tested & max versions supportive of Python 2.7
	install_requires = [
		"numpy>=1.9.2,<1.17",
		"tornado<6",
		"munkres>=1.0.7,<1.1",
		"networkx>=1.10,<=2.2"
	],
	# dependency_links=['https://pypi.python.org/pypi'],
	packages = ["pong"],
	package_data = {"pong": [
		"templates/pong.html", 
		"static/android-icon-144x144.png", 
		"static/android-icon-192x192.png", 
		"static/android-icon-36x36.png", 
		"static/android-icon-48x48.png", 
		"static/android-icon-72x72.png", 
		"static/android-icon-96x96.png", 
		"static/apple-icon-114x114.png", 
		"static/apple-icon-120x120.png", 
		"static/apple-icon-144x144.png", 
		"static/apple-icon-152x152.png", 
		"static/apple-icon-180x180.png", 
		"static/apple-icon-57x57.png", 
		"static/apple-icon-60x60.png", 
		"static/apple-icon-72x72.png", 
		"static/apple-icon-76x76.png", 
		"static/apple-icon-precomposed.png", 
		"static/apple-icon.png", 
		"static/browserconfig.xml", 
		"static/favicon-16x16.png", 
		"static/favicon-32x32.png", 
		"static/favicon-96x96.png", 
		"static/favicon.ico", 
		"static/manifest.json", 
		"static/ms-icon-144x144.png", 
		"static/ms-icon-150x150.png", 
		"static/ms-icon-310x310.png", 
		"static/ms-icon-70x70.png", 
		"static/pong.min.css", 
		"static/pong.min.js", 
		"static/dependencies/colorbrewer.v1.min.js", 
		"static/dependencies/d3.tip.v0.6.3.js", 
		"static/dependencies/d3.v3.min.js", 
		"static/dependencies/jquery-2.1.4.min.js", 
		"static/dependencies/modernizr-custom.js", 
		"static/dependencies/jquery-ui.min.js", 
		"static/dependencies/jquery-ui.min.css", 
		"static/dependencies/d3-path.v0.2.min.js", 
		"static/dependencies/d3-shape.v0.7.min.js", 
		"static/dependencies/bootstrap-3.3.5-dist/css/bootstrap.min.css", 
		"static/dependencies/bootstrap-3.3.5-dist/fonts/glyphicons-halflings-regular.eot", 
		"static/dependencies/bootstrap-3.3.5-dist/fonts/glyphicons-halflings-regular.svg", 
		"static/dependencies/bootstrap-3.3.5-dist/fonts/glyphicons-halflings-regular.ttf", 
		"static/dependencies/bootstrap-3.3.5-dist/fonts/glyphicons-halflings-regular.woff", 
		"static/dependencies/bootstrap-3.3.5-dist/fonts/glyphicons-halflings-regular.woff2", 
		"static/dependencies/bootstrap-3.3.5-dist/js/bootstrap.min.js",
                "static/dependencies/bootstrap-tour.min.css",
                "static/dependencies/bootstrap-tour.min.js",
		"static/dependencies/font-awesome-4.4.0/css/font-awesome.min.css", 
		"static/dependencies/font-awesome-4.4.0/fonts/FontAwesome.otf", 
		"static/dependencies/font-awesome-4.4.0/fonts/fontawesome-webfont.eot", 
		"static/dependencies/font-awesome-4.4.0/fonts/fontawesome-webfont.svg", 
		"static/dependencies/font-awesome-4.4.0/fonts/fontawesome-webfont.ttf", 
		"static/dependencies/font-awesome-4.4.0/fonts/fontawesome-webfont.woff", 
		"static/dependencies/font-awesome-4.4.0/fonts/fontawesome-webfont.woff2", 
		"static/favicon/android-icon-144x144.png", 
		"static/favicon/android-icon-192x192.png", 
		"static/favicon/android-icon-36x36.png", 
		"static/favicon/android-icon-48x48.png", 
		"static/favicon/android-icon-72x72.png", 
		"static/favicon/android-icon-96x96.png", 
		"static/favicon/apple-icon-114x114.png", 
		"static/favicon/apple-icon-120x120.png", 
		"static/favicon/apple-icon-144x144.png", 
		"static/favicon/apple-icon-152x152.png", 
		"static/favicon/apple-icon-180x180.png", 
		"static/favicon/apple-icon-57x57.png", 
		"static/favicon/apple-icon-60x60.png", 
		"static/favicon/apple-icon-72x72.png", 
		"static/favicon/apple-icon-76x76.png", 
		"static/favicon/apple-icon-precomposed.png", 
		"static/favicon/apple-icon.png", 
		"static/favicon/browserconfig.xml", 
		"static/favicon/favicon-16x16.png", 
		"static/favicon/favicon-32x32.png", 
		"static/favicon/favicon-96x96.png", 
		"static/favicon/favicon.ico", 
		"static/favicon/manifest.json", 
		"static/favicon/ms-icon-144x144.png", 
		"static/favicon/ms-icon-150x150.png", 
		"static/favicon/ms-icon-310x310.png", 
		"static/favicon/ms-icon-70x70.png",
		"LICENSE",
		"LICENSE.bootstrap.txt",
                "LICENSE.bootstraptour.txt",
		"LICENSE.ColorBrewer.txt",
		"LICENSE.d3-tip.txt",
		"LICENSE.d3js.txt",
		"LICENSE.jQuery.txt",
		"LICENSE.SIL_OFL.txt"
	]},
	scripts = [ 'run_script/pong' ]
)
