import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()


setuptools.setup(
    name="safe_cli",
    version="0.3.0",
    author="Uxío Fuentefría",
    author_email="uxio@gnosis.io",
    description="Command Line Interface for Gnosis Safe",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/gnosis/safe-cli",
    download_url="https://github.com/gnosis/safe-cli/releases",
    license="MIT",
    test_suite="tests",
    install_requires=[
        "cached-property==1.5.2; python_version < '3.8'",
        "colorama>=0.4",
        "gnosis-py>=3",
        "prompt_toolkit>=3",
        "pyfiglet>=0.8",
        "pygments>=2",
        "requests>=2",
        "tabulate>=0.8",
        "typing_extensions>=4; python_version < '3.8'",
    ],
    packages=setuptools.find_packages(),
    entry_points={
        "console_scripts": [
            "safe-cli=safe_cli.main:main",
            "safe-creator=safe_cli.safe_creator:main",
        ],
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.6",
)
