_HAN_ZEN = {
  '!':'！',
  '"':'＂',
  '#':'＃',
  '$':'＄',
  '%':'％',
  '&':'＆',
  '\'':'＇',
  '(':'（',
  ')':'）',
  '*':'＊',
  '+':'＋',
  ',':'、', # ユーザ設定
  '-':'ー',
  '.':'。', # ユーザ設定
  '/':'／',
  '0':'０',
  '1':'１',
  '2':'２',
  '3':'３',
  '4':'４',
  '5':'５',
  '6':'６',
  '7':'７',
  '8':'８',
  '9':'９',
  ':':'：',
  ';':'；',
  '<':'＜',
  '=':'＝',
  '>':'＞',
  '?':'？',
  '@':'＠',
  'A':'Ａ',
  'B':'Ｂ',
  'C':'Ｃ',
  'D':'Ｄ',
  'E':'Ｅ',
  'F':'Ｆ',
  'G':'Ｇ',
  'H':'Ｈ',
  'I':'Ｉ',
  'J':'Ｊ',
  'K':'Ｋ',
  'L':'Ｌ',
  'M':'Ｍ',
  'N':'Ｎ',
  'O':'Ｏ',
  'P':'Ｐ',
  'Q':'Ｑ',
  'R':'Ｒ',
  'S':'Ｓ',
  'T':'Ｔ',
  'U':'Ｕ',
  'V':'Ｖ',
  'W':'Ｗ',
  'X':'Ｘ',
  'Y':'Ｙ',
  'Z':'Ｚ',
  '[':'［',
  '\\':'＼',
  ']':'］',
  '^':'＾',
  '_':'＿',
  '`':'｀',
  'a':'ａ',
  'b':'ｂ',
  'c':'ｃ',
  'd':'ｄ',
  'e':'ｅ',
  'f':'ｆ',
  'g':'ｇ',
  'h':'ｈ',
  'i':'ｉ',
  'j':'ｊ',
  'k':'ｋ',
  'l':'ｌ',
  'm':'ｍ',
  'n':'ｎ',
  'o':'ｏ',
  'p':'ｐ',
  'q':'ｑ',
  'r':'ｒ',
  's':'ｓ',
  't':'ｔ',
  'u':'ｕ',
  'v':'ｖ',
  'w':'ｗ',
  'x':'ｘ',
  'y':'ｙ',
  'z':'ｚ',
  '{':'「', # ユーザ設定
  '|':'｜',
  '}':'」', # ユーザ設定
  '~':'～',
}

_ROMAJI = {
              'a':'あ','i':'い','u':'う','e':'え','o':'お',
              'ka':'か','ki':'き','ku':'く','ke':'け','ko':'こ',
              'ga':'が','gi':'ぎ','gu':'ぐ','ge':'げ','go':'ご',			  
              'sa':'さ','si':'し','su':'す','se':'せ','so':'そ',
              'za':'ざ','zi':'じ','zu':'ず','ze':'ぜ','zo':'ぞ',			  
              'ta':'た','ti':'ち','tu':'つ','te':'て','to':'と',
              'da':'だ','di':'ぢ','du':'づ','de':'で','do':'ど',			  
              'na':'な','ni':'に','nu':'ぬ','ne':'ね','no':'の',
              'ha':'は','hi':'ひ','hu':'ふ','he':'へ','ho':'ほ',
              'ba':'ば','bi':'び','bu':'ぶ','be':'べ','bo':'ぼ',
              'pa':'ぱ','pi':'ぴ','pu':'ぷ','pe':'ぺ','po':'ぽ',			  
              'ma':'ま','mi':'み','mu':'む','me':'め','mo':'も',
              'ya':'や','yi':'い','yu':'ゆ','ye':'いぇ','yo':'よ',
              'ra':'ら','ri':'り','ru':'る','re':'れ','ro':'ろ',
              'wa':'わ','wi':'うぃ','wu':'う','we':'うぇ','wo':'を',

              'fa':'ふぁ','fi':'ふぃ','fu':'ふ','fe':'ふぇ','fo':'ふぉ',
              'ja':'じゃ','ji':'じ','ju':'じゅ','je':'じぇ','jo':'じょ',
              'va':'う゛ぁ','vi':'う゛ぃ','vu':'う゛','ve':'う゛ぇ','vo':'う゛ぉ',
			  
              'kya':'きゃ','kyi':'きぃ','kyu':'きゅ','kye':'きぇ','kyo':'きょ',
              'gya':'ぎゃ','gyi':'ぎぃ','gyu':'ぎゅ','gye':'ぎぇ','gyo':'ぎょ',			  
              'sya':'しゃ','syi':'しぃ','syu':'しゅ','sye':'しぇ','syo':'しょ',
              'sha':'しゃ','shi':'し','shu':'しゅ','she':'しぇ','sho':'しょ',
              'zya':'じゃ','zyi':'じぃ','zyu':'じゅ','zye':'じぇ','zyo':'じょ',			  
              'tya':'ちゃ','tyi':'ちぃ','tyu':'ちゅ','tye':'ちぇ','tyo':'ちょ',
              'cha':'ちゃ','chi':'ち','chu':'ちゅ','che':'ちぇ','cho':'ちょ',
              'dya':'ぢゃ','dyi':'ぢぃ','dyu':'ぢゅ','dye':'ぢぇ','dyo':'ぢょ',
              'tsa':'つぁ','tsi':'つぃ','tsu':'つ','tse':'つぇ','tso':'つぉ',
              'nya':'にゃ','nyi':'にぃ','nyu':'にゅ','nye':'にぇ','nyo':'にょ',
              'hya':'ひゃ','hyi':'ひぃ','hyu':'ひゅ','hye':'ひぇ','hyo':'ひょ',
              'bya':'びゃ','byi':'びぃ','byu':'びゅ','bye':'びぇ','byo':'びょ',
              'pya':'ぴゃ','pyi':'ぴぃ','pyu':'ぴゅ','pye':'ぴぇ','pyo':'ぴょ',			  
              'mya':'みゃ','myi':'みぃ','myu':'みゅ','mye':'みぇ','myo':'みょ',
              'rya':'りゃ','ryi':'りぃ','ryu':'りゅ','rye':'りぇ','ryo':'りょ',
			  
              'tha':'てゃ','thi':'てぃ','thu':'てゅ','the':'てぇ','tho':'てょ',
              'dha':'でゃ','dhi':'でぃ','dhu':'でゅ','dhe':'でぇ','dho':'でょ',
              'fya':'ふゃ','fyi':'ふぃ','fyu':'ふゅ','fye':'ふぇ','fyo':'ふょ',
              'jya':'じゃ','jyi':'じぃ','jyu':'じゅ','jye':'じぇ','jyo':'じょ',
              'cya':'ちゃ','cyi':'ちぃ','cyu':'ちゅ','cye':'ちぇ','cyo':'ちょ',
              'lya':'ゃ','lyi':'ぃ','lyu':'ゅ','lye':'ぇ','lyo':'ょ',
              'xya':'ゃ','xyi':'ぃ','xyu':'ゅ','xye':'ぇ','xyo':'ょ',
              'xa':'ぁ','xi':'ぃ','xu':'ぅ','xe':'ぇ','xo':'ぉ',
              'la':'ぁ','li':'ぃ','lu':'ぅ','le':'ぇ','lo':'ぉ',
              'xka':'ヵ','lka':'ヵ','xke':'ヶ','lke':'ヶ',
              'kwa':'くぁ','gwa':'ぐぁ',
              'twu':'とぅ','dwu':'どぅ',
              'xtu':'っ','ltu':'っ',
              'xwa':'ゎ','lwa':'ゎ',
              'wyi':'ゐ','wye':'ゑ',
}

_VOWEL = {
    'a', 'i', 'u', 'e', 'o'
}

_ASCII_LOWER = dict.fromkeys(string.ascii_lowercase)

def conv(text, strict=False):
  #DEBUG = False
  #DEBUG = True
  text_len = len(text) # テキスト長
  text_pos = 0 # 現在位置
  state = 0 # 状態
  hiragana_txt = [] # 変換済みテキスト
  hira_append = hiragana_txt.append

  while text_len > text_pos:
    c = text[text_pos]

    #if DEBUG: print(f'state == {state}: {c}')

    # 1文字目の処理
    if state == 0:
      if c in _VOWEL:
        hira_append(_ROMAJI[c])
      else:
        state = 1
    # 2文字目の処理
    elif state == 1:
      prev_c = text[text_pos-1]
      if c in _VOWEL:
        text_tmp = text[text_pos-1:text_pos+1]
        if text_tmp in _ROMAJI:
          hira_append(_ROMAJI[text_tmp])
          state = 0
        else:
          # 変換失敗
          #if DEBUG: print(f'FAIL: state == {state}: {c}')
          hira_append(_HAN_ZEN[prev_c])
          state = 0
          continue
      elif prev_c == 'n' and c == 'n':
        hira_append('ん')
        state = 0
      elif prev_c == c:
        # `っ`の特殊処理
        if c != 'q' and c in _ASCII_LOWER:
          hira_append('っ')
          state = 0
          continue
        else:
          state = 2
      else:
        state = 2
    # 3文字目の処理
    elif state == 2:
      if c in _VOWEL:
        text_tmp = text[text_pos-2:text_pos+1]
        if text_tmp in _ROMAJI:
          hira_append(_ROMAJI[text_tmp])
          state = 0
        else:
          pprev_c = text[text_pos - 2]
          text_tmp2 = text_tmp[1:]
          # `ん`の特殊処理
          if pprev_c == 'n':
            hira_append('ん')
            if text_tmp in _ROMAJI:
              hira_append(_ROMAJI[text_tmp])
              state = 0
            else:
              # 変換失敗
              #if DEBUG: print(f'FAIL1: state == {state}')
              text_pos -= 1
              state = 0
              continue
          else:
            # 変換失敗
            #if DEBUG: print(f'FAIL2: state == {state}')
            hira_append(_HAN_ZEN[pprev_c])
            text_pos -= 1
            state = 0
            continue
      else:
        # 変換失敗
        #if DEBUG: print(f'FAIL3: state == {state}')
        text_tmp = text[text_pos-2]
        hira_append('ん' if text_tmp == 'n' else _HAN_ZEN[text_tmp])
        state = 0
        text_pos -= 1
        continue

    text_pos += 1
    #if DEBUG: print(f'Hira: {hiragana_txt}')

  # 残りを処理
  if state != 0:
    #if DEBUG: print(f'REM: state == {state}')
    c = text[text_pos-1]
    if state == 1:
      hira_append('ん' if c == 'n' and not strict else _HAN_ZEN[c])
    elif state == 2:
      prev_c = text[text_pos-2]
      hira_append('ん' if prev_c == 'n' and c != 'y' else _HAN_ZEN[prev_c])
      hira_append(_HAN_ZEN[c])

  return ''.join(hiragana_txt)