"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.TableProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ots_generated_1 = require("./ots.generated");
Object.defineProperty(exports, "TableProperty", { enumerable: true, get: function () { return ots_generated_1.RosTable; } });
/**
 * A ROS resource type:  `ALIYUN::OTS::Table`
 */
class Table extends ros.Resource {
    /**
     * Create a new `ALIYUN::OTS::Table`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTable = new ots_generated_1.RosTable(this, id, {
            instanceName: props.instanceName,
            tableName: props.tableName,
            timeToLive: props.timeToLive ? props.timeToLive : -1,
            maxVersions: props.maxVersions ? props.maxVersions : 1,
            secondaryIndices: props.secondaryIndices,
            deviationCellVersionInSec: props.deviationCellVersionInSec ? props.deviationCellVersionInSec : 86400,
            primaryKey: props.primaryKey,
            columns: props.columns,
            reservedThroughput: props.reservedThroughput,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTable;
        this.attrTableName = rosTable.attrTableName;
    }
}
exports.Table = Table;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGFibGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0YWJsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQTJDO0FBRXRCLDhGQUZaLHdCQUFRLE9BRWlCO0FBcURsQzs7R0FFRztBQUNILE1BQWEsS0FBTSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBWW5DOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBaUIsRUFBRSxtQ0FBMkMsSUFBSTtRQUM1RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLElBQUksd0JBQVEsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQ3JDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNwRCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUN0RCxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3hDLHlCQUF5QixFQUFFLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLHlCQUF5QixDQUFDLENBQUMsQ0FBQyxLQUFLO1lBQ3BHLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtTQUMvQyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztRQUN6QixJQUFJLENBQUMsYUFBYSxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUM7SUFDaEQsQ0FBQztDQUNKO0FBcENELHNCQW9DQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc1RhYmxlIH0gZnJvbSAnLi9vdHMuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zVGFibGUgYXMgVGFibGVQcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6T1RTOjpUYWJsZWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBUYWJsZVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGluc3RhbmNlTmFtZTogVGhlIG5hbWUgb2YgdGhlIE9UUyBpbnN0YW5jZSBpbiB3aGljaCB0YWJsZSB3aWxsIGxvY2F0ZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZU5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHByaW1hcnlLZXk6IEl0IGRlc2NyaWJlcyB0aGUgYXR0cmlidXRlIHZhbHVlIG9mIHByaW1hcnkga2V5LiBUaGUgbnVtYmVyIG9mIHByaW1hcnlfa2V5IHNob3VsZCBub3QgYmUgbGVzcyB0aGFuIG9uZSBhbmQgbm90IGJlIG1vcmUgdGhhbiBmb3VyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByaW1hcnlLZXk6IEFycmF5PFJvc1RhYmxlLlByaW1hcnlLZXlQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB0YWJsZU5hbWU6IFRoZSB0YWJsZSBuYW1lIG9mIHRoZSBPVFMgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFibGVOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb2x1bW5zOiBBdHRyaWJ1dGUgY29sdW1uIGZvciB0YWJsZSBzdG9yZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBjb2x1bW5zPzogQXJyYXk8Um9zVGFibGUuQ29sdW1uc1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRldmlhdGlvbkNlbGxWZXJzaW9uSW5TZWM6IE1heGltdW0gdmVyc2lvbiBkZXZpYXRpb24uIFRoZSBwdXJwb3NlIGlzIG1haW5seSB0byBwcm9oaWJpdCB3cml0aW5nIGFuZCBleHBlY3RlZCBsYXJnZSBkYXRhLCBzdWNoIGFzIHNldHRpbmcgdGhlIGRldmlhdGlvbl9jZWxsX3ZlcnNpb25faW5fc2VjIHRvIDEwMDAsIGFuZCBpZiB0aGUgY3VycmVudCB0aW1lc3RhbXAgaXMgMTAwMDAsIHRoZSB0aW1lc3RhbXAgcmFuZ2UgYWxsb3dlZCB0byBiZSB3cml0dGVuIGlzIFsxMDAwMCAtIDEwMDAsIDEwMDAwICsgMTAwMF0uIFRoZSB2YWxpZCB2YWx1ZSBpcyAxLTkyMjMzNzIwMzY4NTQ3NzU4MDcuIERlZmF1bHRzIHRvIDg2NDAwLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRldmlhdGlvbkNlbGxWZXJzaW9uSW5TZWM/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBtYXhWZXJzaW9uczogVGhlIG1heGltdW0gbnVtYmVyIG9mIHZlcnNpb25zIHN0b3JlZCBpbiB0aGlzIHRhYmxlLiBUaGUgdmFsaWQgdmFsdWUgaXMgMS0yMTQ3NDgzNjQ3LiBEZWZhdWx0IHRvIDEuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWF4VmVyc2lvbnM/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSByZXNlcnZlZFRocm91Z2hwdXQ6IFRoZSBpbml0aWFsIHJlc2VydmVkIHJlYWQvd3JpdGUgdGhyb3VnaHB1dCBzZXR0aW5nIG9mIHRoZSB0YWJsZSB0byBiZSBjcmVhdGVkLCB0aGUgcmVzZXJ2ZWQgcmVhZCB0aHJvdWdocHV0IGFuZCByZXNlcnZlZCB3cml0ZSB0aHJvdWdocHV0IG9mIGFueSB0YWJsZSBjYW5ub3QgZXhjZWVkIDUwMDAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzZXJ2ZWRUaHJvdWdocHV0PzogUm9zVGFibGUuUmVzZXJ2ZWRUaHJvdWdocHV0UHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzZWNvbmRhcnlJbmRpY2VzOiBUaGUgc2Vjb25kYXJ5IGluZGljZXMgb2YgdGhlIHRhYmxlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY29uZGFyeUluZGljZXM/OiBBcnJheTxSb3NUYWJsZS5TZWNvbmRhcnlJbmRpY2VzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGltZVRvTGl2ZTogVGhlIHJldGVudGlvbiB0aW1lIG9mIGRhdGEgc3RvcmVkIGluIHRoaXMgdGFibGUgKHVuaXQ6IHNlY29uZCkuIFRoZSB2YWx1ZSBtYXhpbXVtIGlzIDIxNDc0ODM2NDcgYW5kIC0xIG1lYW5zIG5ldmVyIGV4cGlyZWQuIERlZmF1bHQgdG8gLTEuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGltZVRvTGl2ZT86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6T1RTOjpUYWJsZWBcbiAqL1xuZXhwb3J0IGNsYXNzIFRhYmxlIGV4dGVuZHMgcm9zLlJlc291cmNlIHtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cbiAgICAgKi9cblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBUYWJsZU5hbWU6IFRhYmxlIG5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clRhYmxlTmFtZTogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBTElZVU46Ok9UUzo6VGFibGVgLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFRhYmxlUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAgICAgY29uc3Qgcm9zVGFibGUgPSBuZXcgUm9zVGFibGUodGhpcywgaWQsICB7XG4gICAgICAgICAgICBpbnN0YW5jZU5hbWU6IHByb3BzLmluc3RhbmNlTmFtZSxcbiAgICAgICAgICAgIHRhYmxlTmFtZTogcHJvcHMudGFibGVOYW1lLFxuICAgICAgICAgICAgdGltZVRvTGl2ZTogcHJvcHMudGltZVRvTGl2ZSA/IHByb3BzLnRpbWVUb0xpdmUgOiAtMSxcbiAgICAgICAgICAgIG1heFZlcnNpb25zOiBwcm9wcy5tYXhWZXJzaW9ucyA/IHByb3BzLm1heFZlcnNpb25zIDogMSxcbiAgICAgICAgICAgIHNlY29uZGFyeUluZGljZXM6IHByb3BzLnNlY29uZGFyeUluZGljZXMsXG4gICAgICAgICAgICBkZXZpYXRpb25DZWxsVmVyc2lvbkluU2VjOiBwcm9wcy5kZXZpYXRpb25DZWxsVmVyc2lvbkluU2VjID8gcHJvcHMuZGV2aWF0aW9uQ2VsbFZlcnNpb25JblNlYyA6IDg2NDAwLFxuICAgICAgICAgICAgcHJpbWFyeUtleTogcHJvcHMucHJpbWFyeUtleSxcbiAgICAgICAgICAgIGNvbHVtbnM6IHByb3BzLmNvbHVtbnMsXG4gICAgICAgICAgICByZXNlcnZlZFRocm91Z2hwdXQ6IHByb3BzLnJlc2VydmVkVGhyb3VnaHB1dCxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NUYWJsZTtcbiAgICAgICAgdGhpcy5hdHRyVGFibGVOYW1lID0gcm9zVGFibGUuYXR0clRhYmxlTmFtZTtcbiAgICB9XG59XG4iXX0=