# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-11-09 17:01
from __future__ import unicode_literals

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    replaces = [('birds', '0001_initial'), ('birds', '0002_auto_20150626_1219'), ('birds', '0003_datacollection_datatype_recording'), ('birds', '0004_auto_20161102_1742'), ('birds', '0005_auto_20161107_1452'), ('birds', '0006_auto_20161108_1548'), ('birds', '0007_auto_20161108_1623'), ('birds', '0008_auto_20161108_1637'), ('birds', '0009_auto_20161108_1647')]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Age',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=16)),
                ('min_days', models.PositiveIntegerField()),
                ('max_days', models.PositiveIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Animal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sex', models.CharField(choices=[('M', 'male'), ('F', 'female'), ('U', 'unknown')], max_length=2)),
                ('band_number', models.IntegerField(blank=True, null=True)),
                ('uuid', models.UUIDField(blank=True, editable=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ['band_color', 'band_number'],
            },
        ),
        migrations.CreateModel(
            name='Color',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=12, unique=True)),
                ('abbrv', models.CharField(max_length=3, unique=True, verbose_name='Abbreviation')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(default=datetime.date.today)),
                ('description', models.TextField(blank=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('animal', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='birds.Animal')),
                ('entered_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=45, unique=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Species',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('common_name', models.CharField(max_length=45)),
                ('genus', models.CharField(max_length=45)),
                ('species', models.CharField(max_length=45)),
                ('code', models.CharField(max_length=4, unique=True)),
            ],
            options={
                'ordering': ['common_name'],
                'verbose_name_plural': 'species',
            },
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=16, unique=True)),
                ('count', models.SmallIntegerField(choices=[(0, '0'), (-1, '-1'), (1, '+1')], default=0, help_text='1: animal acquired; -1: animal lost; 0: no change')),
                ('category', models.CharField(blank=True, choices=[('B', 'B'), ('C', 'C'), ('D', 'D'), ('E', 'E')], max_length=2, null=True)),
                ('description', models.TextField()),
            ],
            options={
                'ordering': ['name'],
                'verbose_name_plural': 'status codes',
            },
        ),
        migrations.AddField(
            model_name='event',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='birds.Location'),
        ),
        migrations.AddField(
            model_name='event',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='birds.Status'),
        ),
        migrations.AddField(
            model_name='animal',
            name='band_color',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='birds.Color'),
        ),
        migrations.AddField(
            model_name='animal',
            name='parents',
            field=models.ManyToManyField(related_name='children',
                                         through='birds.Parent', to='birds.Animal'),
        ),
        migrations.AddField(
            model_name='animal',
            name='reserved_by',
            field=models.ForeignKey(blank=True, help_text='mark a bird as reserved for a specific user', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='animal',
            name='species',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='birds.Species'),
        ),
        migrations.AddField(
            model_name='age',
            name='species',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='birds.Species'),
        ),
        migrations.AlterField(
            model_name='animal',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4),
        ),
        migrations.CreateModel(
            name='DataCollection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=16)),
                ('uri', models.CharField(max_length=512)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='DataType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=16)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Recording',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(help_text='canonical identifier for this recording', max_length=128)),
                ('timestamp', models.DateTimeField(blank=True, null=True)),
                ('animal', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='birds.Animal')),
                ('collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='birds.DataCollection')),
                ('datatype', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='birds.DataType')),
            ],
            options={
                'ordering': ['animal', 'collection', 'identifier'],
            },
        ),
        migrations.AlterField(
            model_name='datacollection',
            name='name',
            field=models.CharField(help_text='a short name for the collection', max_length=16),
        ),
        migrations.AlterField(
            model_name='datacollection',
            name='uri',
            field=models.CharField(help_text='canonical URL for retrieving a recording in this collection', max_length=512),
        ),
        migrations.AlterField(
            model_name='animal',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, unique=True),
        ),
        migrations.AlterUniqueTogether(
            name='age',
            unique_together=set([('name', 'species')]),
        ),
        migrations.AlterField(
            model_name='datacollection',
            name='name',
            field=models.CharField(help_text='a short name for the collection', max_length=16, unique=True),
        ),
        migrations.AlterField(
            model_name='datatype',
            name='name',
            field=models.CharField(max_length=16, unique=True),
        ),
        migrations.AlterUniqueTogether(
            name='recording',
            unique_together=set([('collection', 'identifier')]),
        ),
        migrations.AlterUniqueTogether(
            name='species',
            unique_together=set([('genus', 'species')]),
        ),
        migrations.CreateModel(
            name='Parent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='a', to='birds.Animal')),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='b', to='birds.Animal')),
            ],
        ),
    ]
