# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from opera.api.openapi.models.base_model_ import Model
from opera.api.openapi.models.invocation_state import InvocationState
from opera.api.openapi import util

from opera.api.openapi.models.invocation_state import InvocationState  # noqa: E501

class Invocation(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, id=None, state=None, operation=None, timestamp=None, inputs=None, instance_state=None, exception=None, console_output=None):  # noqa: E501
        """Invocation - a model defined in OpenAPI

        :param id: The id of this Invocation.  # noqa: E501
        :type id: str
        :param state: The state of this Invocation.  # noqa: E501
        :type state: InvocationState
        :param operation: The operation of this Invocation.  # noqa: E501
        :type operation: str
        :param timestamp: The timestamp of this Invocation.  # noqa: E501
        :type timestamp: str
        :param inputs: The inputs of this Invocation.  # noqa: E501
        :type inputs: object
        :param instance_state: The instance_state of this Invocation.  # noqa: E501
        :type instance_state: Dict[str, str]
        :param exception: The exception of this Invocation.  # noqa: E501
        :type exception: str
        :param console_output: The console_output of this Invocation.  # noqa: E501
        :type console_output: str
        """
        self.openapi_types = {
            'id': str,
            'state': InvocationState,
            'operation': str,
            'timestamp': str,
            'inputs': object,
            'instance_state': Dict[str, str],
            'exception': str,
            'console_output': str
        }

        self.attribute_map = {
            'id': 'id',
            'state': 'state',
            'operation': 'operation',
            'timestamp': 'timestamp',
            'inputs': 'inputs',
            'instance_state': 'instance_state',
            'exception': 'exception',
            'console_output': 'console_output'
        }

        self._id = id
        self._state = state
        self._operation = operation
        self._timestamp = timestamp
        self._inputs = inputs
        self._instance_state = instance_state
        self._exception = exception
        self._console_output = console_output

    @classmethod
    def from_dict(cls, dikt) -> 'Invocation':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Invocation of this Invocation.  # noqa: E501
        :rtype: Invocation
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self):
        """Gets the id of this Invocation.


        :return: The id of this Invocation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Invocation.


        :param id: The id of this Invocation.
        :type id: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def state(self):
        """Gets the state of this Invocation.


        :return: The state of this Invocation.
        :rtype: InvocationState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Invocation.


        :param state: The state of this Invocation.
        :type state: InvocationState
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def operation(self):
        """Gets the operation of this Invocation.


        :return: The operation of this Invocation.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """Sets the operation of this Invocation.


        :param operation: The operation of this Invocation.
        :type operation: str
        """
        allowed_values = ["deploy", "undeploy"]  # noqa: E501
        if operation not in allowed_values:
            raise ValueError(
                "Invalid value for `operation` ({0}), must be one of {1}"
                .format(operation, allowed_values)
            )

        self._operation = operation

    @property
    def timestamp(self):
        """Gets the timestamp of this Invocation.

        An ISO8601 timestamp of the invocation.  # noqa: E501

        :return: The timestamp of this Invocation.
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this Invocation.

        An ISO8601 timestamp of the invocation.  # noqa: E501

        :param timestamp: The timestamp of this Invocation.
        :type timestamp: str
        """
        if timestamp is None:
            raise ValueError("Invalid value for `timestamp`, must not be `None`")  # noqa: E501

        self._timestamp = timestamp

    @property
    def inputs(self):
        """Gets the inputs of this Invocation.

        Inputs provided for invocation  # noqa: E501

        :return: The inputs of this Invocation.
        :rtype: object
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """Sets the inputs of this Invocation.

        Inputs provided for invocation  # noqa: E501

        :param inputs: The inputs of this Invocation.
        :type inputs: object
        """

        self._inputs = inputs

    @property
    def instance_state(self):
        """Gets the instance_state of this Invocation.

        State of the instances defined in service template  # noqa: E501

        :return: The instance_state of this Invocation.
        :rtype: Dict[str, str]
        """
        return self._instance_state

    @instance_state.setter
    def instance_state(self, instance_state):
        """Sets the instance_state of this Invocation.

        State of the instances defined in service template  # noqa: E501

        :param instance_state: The instance_state of this Invocation.
        :type instance_state: Dict[str, str]
        """

        self._instance_state = instance_state

    @property
    def exception(self):
        """Gets the exception of this Invocation.

        An internal xOpera error that occurred starting operation  # noqa: E501

        :return: The exception of this Invocation.
        :rtype: str
        """
        return self._exception

    @exception.setter
    def exception(self, exception):
        """Sets the exception of this Invocation.

        An internal xOpera error that occurred starting operation  # noqa: E501

        :param exception: The exception of this Invocation.
        :type exception: str
        """

        self._exception = exception

    @property
    def console_output(self):
        """Gets the console_output of this Invocation.

        xOpera console output for operation  # noqa: E501

        :return: The console_output of this Invocation.
        :rtype: str
        """
        return self._console_output

    @console_output.setter
    def console_output(self, console_output):
        """Sets the console_output of this Invocation.

        xOpera console output for operation  # noqa: E501

        :param console_output: The console_output of this Invocation.
        :type console_output: str
        """
        if console_output is None:
            raise ValueError("Invalid value for `console_output`, must not be `None`")  # noqa: E501

        self._console_output = console_output
