# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from typing import MutableMapping, MutableSequence

import proto  # type: ignore

import google.apps.script.type.types  # type: ignore

__protobuf__ = proto.module(
    package="google.apps.script.type.gmail",
    manifest={
        "GmailAddOnManifest",
        "UniversalAction",
        "ComposeTrigger",
        "ContextualTrigger",
        "UnconditionalTrigger",
    },
)


class GmailAddOnManifest(proto.Message):
    r"""Properties customizing the appearance and execution of a
    Gmail add-on.

    Attributes:
        homepage_trigger (google.apps.script.type.types.HomepageExtensionPoint):
            Defines an endpoint that will be executed in contexts that
            don't match a declared contextual trigger. Any cards
            generated by this function will always be available to the
            user, but may be eclipsed by contextual content when this
            add-on declares more targeted triggers.

            If present, this overrides the configuration from
            ``addOns.common.homepageTrigger``.
        contextual_triggers (MutableSequence[google.apps.script.type.gmail.types.ContextualTrigger]):
            Defines the set of conditions that trigger
            the add-on.
        universal_actions (MutableSequence[google.apps.script.type.gmail.types.UniversalAction]):
            Defines set of `universal
            actions </gmail/add-ons/how-tos/universal-actions>`__ for
            the add-on. The user triggers universal actions from the
            add-on toolbar menu.
        compose_trigger (google.apps.script.type.gmail.types.ComposeTrigger):
            Defines the compose time trigger for a
            compose time add-on. This is the trigger that
            causes an add-on to take action when the user is
            composing an email.
            All compose time addons are required to have the
            gmail.addons.current.action.compose scope even
            though it might not edit the draft.
        authorization_check_function (str):
            The name of an endpoint that verifies that
            the add-on has all the required third-party
            authorizations, by probing the third-party APIs.
            If the probe fails, the function should throw an
            exception to initiate the authorization flow.
            This function is called before each invocation
            of the add-on, in order to ensure a smooth user
            experience.
    """

    homepage_trigger: google.apps.script.type.types.HomepageExtensionPoint = (
        proto.Field(
            proto.MESSAGE,
            number=14,
            message=google.apps.script.type.types.HomepageExtensionPoint,
        )
    )
    contextual_triggers: MutableSequence["ContextualTrigger"] = proto.RepeatedField(
        proto.MESSAGE,
        number=3,
        message="ContextualTrigger",
    )
    universal_actions: MutableSequence["UniversalAction"] = proto.RepeatedField(
        proto.MESSAGE,
        number=4,
        message="UniversalAction",
    )
    compose_trigger: "ComposeTrigger" = proto.Field(
        proto.MESSAGE,
        number=12,
        message="ComposeTrigger",
    )
    authorization_check_function: str = proto.Field(
        proto.STRING,
        number=7,
    )


class UniversalAction(proto.Message):
    r"""An action that is always available in the add-on toolbar menu
    regardless of message context.

    This message has `oneof`_ fields (mutually exclusive fields).
    For each oneof, at most one member field can be set at the same time.
    Setting any member of the oneof automatically clears all other
    members.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        text (str):
            Required. User-visible text describing the
            action, for example, "Add a new contact.".
        open_link (str):
            A link that is opened by Gmail when the user
            triggers the action.

            This field is a member of `oneof`_ ``action_type``.
        run_function (str):
            An endpoint that is called when the user triggers the
            action. See the `universal actions
            guide </gmail/add-ons/how-tos/universal-actions>`__ for
            details.

            This field is a member of `oneof`_ ``action_type``.
    """

    text: str = proto.Field(
        proto.STRING,
        number=1,
    )
    open_link: str = proto.Field(
        proto.STRING,
        number=2,
        oneof="action_type",
    )
    run_function: str = proto.Field(
        proto.STRING,
        number=3,
        oneof="action_type",
    )


class ComposeTrigger(proto.Message):
    r"""A trigger that activates when user is composing an email.

    Attributes:
        actions (MutableSequence[google.apps.script.type.types.MenuItemExtensionPoint]):
            Defines the set of actions for compose time
            add-on. These are actions that user can trigger
            on a compose time addon.
        draft_access (google.apps.script.type.gmail.types.ComposeTrigger.DraftAccess):
            Define the level of data access when a
            compose time addon is triggered.
    """

    class DraftAccess(proto.Enum):
        r"""An enum defining the level of data access this compose
        trigger requires.

        Values:
            UNSPECIFIED (0):
                Default value when nothing is set for
                DraftAccess.
            NONE (1):
                NONE means compose trigger won't be able to
                access any data of the draft when a compose
                addon is triggered.
            METADATA (2):
                METADATA gives compose trigger the permission
                to access the metadata of the draft when a
                compose addon is triggered. This includes the
                audience list (To/cc list) of a draft message.
        """
        UNSPECIFIED = 0
        NONE = 1
        METADATA = 2

    actions: MutableSequence[
        google.apps.script.type.types.MenuItemExtensionPoint
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=5,
        message=google.apps.script.type.types.MenuItemExtensionPoint,
    )
    draft_access: DraftAccess = proto.Field(
        proto.ENUM,
        number=4,
        enum=DraftAccess,
    )


class ContextualTrigger(proto.Message):
    r"""Defines a trigger that fires when the open email meets a
    specific criteria. When the trigger fires, it executes a
    specific endpoint, usually in order to create new cards and
    update the UI.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        unconditional (google.apps.script.type.gmail.types.UnconditionalTrigger):
            UnconditionalTriggers are executed when any
            mail message is opened.

            This field is a member of `oneof`_ ``trigger``.
        on_trigger_function (str):
            Required. The name of the endpoint to call
            when a message matches the trigger.
    """

    unconditional: "UnconditionalTrigger" = proto.Field(
        proto.MESSAGE,
        number=1,
        oneof="trigger",
        message="UnconditionalTrigger",
    )
    on_trigger_function: str = proto.Field(
        proto.STRING,
        number=4,
    )


class UnconditionalTrigger(proto.Message):
    r"""A trigger that fires when any email message is opened."""


__all__ = tuple(sorted(__protobuf__.manifest))
