# coding: utf-8

"""
    EOD STOCK API

     <h2>Intelligent EOD Stocks API</h2>     <p>     End of day stock world wide STOCK API, this api is intended for use by web application developers,      and service providers looking for up-to-date always available.     <ul>         <li>Exchange Information</li>         <li>Stock Tickers Data</li>         <li>End of Day (EOD) Stock Data</li>         <li>Fundamental Data</li>         <li>Stock Options And Splits Data</li>         <li>Financial News API</li>         <li>Social Media Trend Data For Stocks</li>         <li>Sentiment Analysis for News & Social Media</li>     </ul>                The information provided covers more than 150 000 tickers, stocks, mutual funds and more around the world.         we provide information for any period, including daily, weekly.     </p>    # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@eod-stock-api.site
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from src.IntelligentStockMarketAPI.api_client import ApiClient
from src.IntelligentStockMarketAPI.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FundamentalsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v1_fundamental_company_stock_code_get(self, stock_code, **kwargs):  # noqa: E501
        """v1_fundamental_company_stock_code_get  # noqa: E501

        for each stock code return the fundamental data for the company  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamental_company_stock_code_get(stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PublicFundamentalsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamental_company_stock_code_get_with_http_info(stock_code, **kwargs)  # noqa: E501

    def v1_fundamental_company_stock_code_get_with_http_info(self, stock_code, **kwargs):  # noqa: E501
        """v1_fundamental_company_stock_code_get  # noqa: E501

        for each stock code return the fundamental data for the company  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamental_company_stock_code_get_with_http_info(stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PublicFundamentalsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamental_company_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamental_company_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamental/company/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublicFundamentalsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamental_general_get(self, **kwargs):  # noqa: E501
        """v1_fundamental_general_get  # noqa: E501

        return general fundamental data for all companies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamental_general_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamental_general_get_with_http_info(**kwargs)  # noqa: E501

    def v1_fundamental_general_get_with_http_info(self, **kwargs):  # noqa: E501
        """v1_fundamental_general_get  # noqa: E501

        return general fundamental data for all companies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamental_general_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamental_general_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamental/general', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get(self, stock_code, filing_date, **kwargs):  # noqa: E501
        """v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get  # noqa: E501

        given the filing date & balance_sheet_id return annual balance sheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get(stock_code, filing_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str filing_date: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AnnualBalanceSheetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get_with_http_info(stock_code, filing_date, **kwargs)  # noqa: E501

    def v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get_with_http_info(self, stock_code, filing_date, **kwargs):  # noqa: E501
        """v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get  # noqa: E501

        given the filing date & balance_sheet_id return annual balance sheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get_with_http_info(stock_code, filing_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str filing_date: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AnnualBalanceSheetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'filing_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get`")  # noqa: E501
        # verify the required parameter 'filing_date' is set
        if self.api_client.client_side_validation and ('filing_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['filing_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `filing_date` when calling `v1_fundamentals_annual_balance_sheet_filing_date_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'filing_date' in local_var_params:
            path_params['filing_date'] = local_var_params['filing_date']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/annual-balance-sheet/{filing_date}/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnnualBalanceSheetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_company_address_id_fundamental_id_get(self, fundamental_id, **kwargs):  # noqa: E501
        """v1_fundamentals_company_address_id_fundamental_id_get  # noqa: E501

        returns company address data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_address_id_fundamental_id_get(fundamental_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str fundamental_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_company_address_id_fundamental_id_get_with_http_info(fundamental_id, **kwargs)  # noqa: E501

    def v1_fundamentals_company_address_id_fundamental_id_get_with_http_info(self, fundamental_id, **kwargs):  # noqa: E501
        """v1_fundamentals_company_address_id_fundamental_id_get  # noqa: E501

        returns company address data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_address_id_fundamental_id_get_with_http_info(fundamental_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str fundamental_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AddressResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'fundamental_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_company_address_id_fundamental_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'fundamental_id' is set
        if self.api_client.client_side_validation and ('fundamental_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['fundamental_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `fundamental_id` when calling `v1_fundamentals_company_address_id_fundamental_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fundamental_id' in local_var_params:
            path_params['fundamental_id'] = local_var_params['fundamental_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/company-address/id/{fundamental_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_company_address_stock_stock_code_get(self, stock_code, **kwargs):  # noqa: E501
        """v1_fundamentals_company_address_stock_stock_code_get  # noqa: E501

        returns company address data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_address_stock_stock_code_get(stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_company_address_stock_stock_code_get_with_http_info(stock_code, **kwargs)  # noqa: E501

    def v1_fundamentals_company_address_stock_stock_code_get_with_http_info(self, stock_code, **kwargs):  # noqa: E501
        """v1_fundamentals_company_address_stock_stock_code_get  # noqa: E501

        returns company address data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_address_stock_stock_code_get_with_http_info(stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AddressResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_company_address_stock_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_company_address_stock_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/company-address/stock/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_company_details_id_fundamental_id_get(self, fundamental_id, **kwargs):  # noqa: E501
        """v1_fundamentals_company_details_id_fundamental_id_get  # noqa: E501

        returns company details from company fundamental data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_details_id_fundamental_id_get(fundamental_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str fundamental_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_company_details_id_fundamental_id_get_with_http_info(fundamental_id, **kwargs)  # noqa: E501

    def v1_fundamentals_company_details_id_fundamental_id_get_with_http_info(self, fundamental_id, **kwargs):  # noqa: E501
        """v1_fundamentals_company_details_id_fundamental_id_get  # noqa: E501

        returns company details from company fundamental data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_details_id_fundamental_id_get_with_http_info(fundamental_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str fundamental_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'fundamental_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_company_details_id_fundamental_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'fundamental_id' is set
        if self.api_client.client_side_validation and ('fundamental_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['fundamental_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `fundamental_id` when calling `v1_fundamentals_company_details_id_fundamental_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fundamental_id' in local_var_params:
            path_params['fundamental_id'] = local_var_params['fundamental_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/company-details/id/{fundamental_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_company_details_stock_stock_code_get(self, stock_code, **kwargs):  # noqa: E501
        """v1_fundamentals_company_details_stock_stock_code_get  # noqa: E501

        returns company details from company fundamental data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_details_stock_stock_code_get(stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_company_details_stock_stock_code_get_with_http_info(stock_code, **kwargs)  # noqa: E501

    def v1_fundamentals_company_details_stock_stock_code_get_with_http_info(self, stock_code, **kwargs):  # noqa: E501
        """v1_fundamentals_company_details_stock_stock_code_get  # noqa: E501

        returns company details from company fundamental data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_details_stock_stock_code_get_with_http_info(stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_company_details_stock_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_company_details_stock_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/company-details/stock/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get(self, stock_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get  # noqa: E501

        Given companies stock_code, and year return a list of insider transactions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get(stock_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str year: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get_with_http_info(stock_code, year, **kwargs)  # noqa: E501

    def v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get_with_http_info(self, stock_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get  # noqa: E501

        Given companies stock_code, and year return a list of insider transactions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get_with_http_info(stock_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str year: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'year'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get`")  # noqa: E501
        # verify the required parameter 'year' is set
        if self.api_client.client_side_validation and ('year' not in local_var_params or  # noqa: E501
                                                        local_var_params['year'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `year` when calling `v1_fundamentals_company_insider_transactions_stock_code_stock_code_year_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'year' in local_var_params:
            path_params['year'] = local_var_params['year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/company-insider-transactions/stock-code/{stock_code}/{year}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_company_valuations_stock_code_stock_code_year_get(self, stock_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_company_valuations_stock_code_stock_code_year_get  # noqa: E501

        Get Company Valuations Data for the year  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_valuations_stock_code_stock_code_year_get(stock_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str year: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_company_valuations_stock_code_stock_code_year_get_with_http_info(stock_code, year, **kwargs)  # noqa: E501

    def v1_fundamentals_company_valuations_stock_code_stock_code_year_get_with_http_info(self, stock_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_company_valuations_stock_code_stock_code_year_get  # noqa: E501

        Get Company Valuations Data for the year  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_company_valuations_stock_code_stock_code_year_get_with_http_info(stock_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str year: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'year'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_company_valuations_stock_code_stock_code_year_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_company_valuations_stock_code_stock_code_year_get`")  # noqa: E501
        # verify the required parameter 'year' is set
        if self.api_client.client_side_validation and ('year' not in local_var_params or  # noqa: E501
                                                        local_var_params['year'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `year` when calling `v1_fundamentals_company_valuations_stock_code_stock_code_year_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'year' in local_var_params:
            path_params['year'] = local_var_params['year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/company-valuations/stock-code/{stock_code}/{year}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get(self, exchange_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get  # noqa: E501

        Get Analyst rankings for all companies listed under a specific exchange  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get(exchange_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str year: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get_with_http_info(exchange_code, year, **kwargs)  # noqa: E501

    def v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get_with_http_info(self, exchange_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get  # noqa: E501

        Get Analyst rankings for all companies listed under a specific exchange  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get_with_http_info(exchange_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str year: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'exchange_code',
            'year'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_code' is set
        if self.api_client.client_side_validation and ('exchange_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_code` when calling `v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get`")  # noqa: E501
        # verify the required parameter 'year' is set
        if self.api_client.client_side_validation and ('year' not in local_var_params or  # noqa: E501
                                                        local_var_params['year'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `year` when calling `v1_fundamentals_exchange_analyst_rankings_exchange_code_exchange_code_year_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_code' in local_var_params:
            path_params['exchange_code'] = local_var_params['exchange_code']  # noqa: E501
        if 'year' in local_var_params:
            path_params['year'] = local_var_params['year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/exchange-analyst-rankings/exchange-code/{exchange_code}/{year}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get(self, exchange_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get  # noqa: E501

        Given an exchange_code and a year return all outstanding shares for all companies for that year  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get(exchange_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str year: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get_with_http_info(exchange_code, year, **kwargs)  # noqa: E501

    def v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get_with_http_info(self, exchange_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get  # noqa: E501

        Given an exchange_code and a year return all outstanding shares for all companies for that year  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get_with_http_info(exchange_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str year: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'exchange_code',
            'year'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_code' is set
        if self.api_client.client_side_validation and ('exchange_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_code` when calling `v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get`")  # noqa: E501
        # verify the required parameter 'year' is set
        if self.api_client.client_side_validation and ('year' not in local_var_params or  # noqa: E501
                                                        local_var_params['year'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `year` when calling `v1_fundamentals_exchange_outstanding_shares_exchange_code_exchange_code_year_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_code' in local_var_params:
            path_params['exchange_code'] = local_var_params['exchange_code']  # noqa: E501
        if 'year' in local_var_params:
            path_params['year'] = local_var_params['year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/exchange-outstanding-shares/exchange-code/{exchange_code}/{year}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get(self, stock_code, to, _from, term, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get  # noqa: E501

        Return Annual or Quarterly Statements based on Term, Stock Code, and dates _from and _to  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get(stock_code, to, _from, term, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str to: (required)
        :param str _from: (required)
        :param str term: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get_with_http_info(stock_code, to, _from, term, **kwargs)  # noqa: E501

    def v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get_with_http_info(self, stock_code, to, _from, term, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get  # noqa: E501

        Return Annual or Quarterly Statements based on Term, Stock Code, and dates _from and _to  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get_with_http_info(stock_code, to, _from, term, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str to: (required)
        :param str _from: (required)
        :param str term: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'to',
            '_from',
            'term'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get`")  # noqa: E501
        # verify the required parameter 'term' is set
        if self.api_client.client_side_validation and ('term' not in local_var_params or  # noqa: E501
                                                        local_var_params['term'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `term` when calling `v1_fundamentals_financial_statements_by_term_from_to_stock_code_term_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'to' in local_var_params:
            path_params['_to'] = local_var_params['to']  # noqa: E501
        if '_from' in local_var_params:
            path_params['_from'] = local_var_params['_from']  # noqa: E501
        if 'term' in local_var_params:
            path_params['term'] = local_var_params['term']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/financial-statements/by-term/{_from}.{_to}/{stock_code}/{term}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_financial_statements_company_statement_stock_code_year_get(self, stock_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_company_statement_stock_code_year_get  # noqa: E501

        given an a stock_code and a year return a complete financial statements for the year  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_company_statement_stock_code_year_get(stock_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str year: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_financial_statements_company_statement_stock_code_year_get_with_http_info(stock_code, year, **kwargs)  # noqa: E501

    def v1_fundamentals_financial_statements_company_statement_stock_code_year_get_with_http_info(self, stock_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_company_statement_stock_code_year_get  # noqa: E501

        given an a stock_code and a year return a complete financial statements for the year  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_company_statement_stock_code_year_get_with_http_info(stock_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str year: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'year'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_financial_statements_company_statement_stock_code_year_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_financial_statements_company_statement_stock_code_year_get`")  # noqa: E501
        # verify the required parameter 'year' is set
        if self.api_client.client_side_validation and ('year' not in local_var_params or  # noqa: E501
                                                        local_var_params['year'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `year` when calling `v1_fundamentals_financial_statements_company_statement_stock_code_year_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'year' in local_var_params:
            path_params['year'] = local_var_params['year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/financial-statements/company-statement/{stock_code}/{year}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get(self, exchange_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get  # noqa: E501

        Given an exchange_code and a year return a complete list of financial statements for all companies in exchange  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get(exchange_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str year: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get_with_http_info(exchange_code, year, **kwargs)  # noqa: E501

    def v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get_with_http_info(self, exchange_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get  # noqa: E501

        Given an exchange_code and a year return a complete list of financial statements for all companies in exchange  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get_with_http_info(exchange_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str year: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'exchange_code',
            'year'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_code' is set
        if self.api_client.client_side_validation and ('exchange_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_code` when calling `v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get`")  # noqa: E501
        # verify the required parameter 'year' is set
        if self.api_client.client_side_validation and ('year' not in local_var_params or  # noqa: E501
                                                        local_var_params['year'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `year` when calling `v1_fundamentals_financial_statements_exchange_year_exchange_code_year_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_code' in local_var_params:
            path_params['exchange_code'] = local_var_params['exchange_code']  # noqa: E501
        if 'year' in local_var_params:
            path_params['year'] = local_var_params['year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/financial-statements/exchange-year/{exchange_code}/{year}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get(self, stock_code, filing_date, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get  # noqa: E501

        Returns Income Statements by Filing Date and Company Stock Code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get(stock_code, filing_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str filing_date: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get_with_http_info(stock_code, filing_date, **kwargs)  # noqa: E501

    def v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get_with_http_info(self, stock_code, filing_date, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get  # noqa: E501

        Returns Income Statements by Filing Date and Company Stock Code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get_with_http_info(stock_code, filing_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str filing_date: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'filing_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get`")  # noqa: E501
        # verify the required parameter 'filing_date' is set
        if self.api_client.client_side_validation and ('filing_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['filing_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `filing_date` when calling `v1_fundamentals_financial_statements_filing_date_ticker_filing_date_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'filing_date' in local_var_params:
            path_params['filing_date'] = local_var_params['filing_date']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/financial-statements/filing-date-ticker/{filing_date}/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get(self, stock_code, to, _from, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get  # noqa: E501

        Given two dates and a stock date return all financial statements, _from & _to should be date-strings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get(stock_code, to, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str to: (required)
        :param str _from: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get_with_http_info(stock_code, to, _from, **kwargs)  # noqa: E501

    def v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get_with_http_info(self, stock_code, to, _from, **kwargs):  # noqa: E501
        """v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get  # noqa: E501

        Given two dates and a stock date return all financial statements, _from & _to should be date-strings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get_with_http_info(stock_code, to, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str to: (required)
        :param str _from: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'to',
            '_from'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `v1_fundamentals_financial_statements_ticker_date_range_from_to_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'to' in local_var_params:
            path_params['_to'] = local_var_params['to']  # noqa: E501
        if '_from' in local_var_params:
            path_params['_from'] = local_var_params['_from']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/financial-statements/ticker-date-range/{_from}.{_to}/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_financials_income_statements_statement_id_get(self, statement_id, **kwargs):  # noqa: E501
        """v1_fundamentals_financials_income_statements_statement_id_get  # noqa: E501

        Will return Company Income Statement By Statement ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financials_income_statements_statement_id_get(statement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str statement_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_financials_income_statements_statement_id_get_with_http_info(statement_id, **kwargs)  # noqa: E501

    def v1_fundamentals_financials_income_statements_statement_id_get_with_http_info(self, statement_id, **kwargs):  # noqa: E501
        """v1_fundamentals_financials_income_statements_statement_id_get  # noqa: E501

        Will return Company Income Statement By Statement ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_financials_income_statements_statement_id_get_with_http_info(statement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str statement_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'statement_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_financials_income_statements_statement_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'statement_id' is set
        if self.api_client.client_side_validation and ('statement_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['statement_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `statement_id` when calling `v1_fundamentals_financials_income_statements_statement_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'statement_id' in local_var_params:
            path_params['statement_id'] = local_var_params['statement_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/financials/income-statements/{statement_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_highlights_id_fundamental_id_get(self, fundamental_id, **kwargs):  # noqa: E501
        """v1_fundamentals_highlights_id_fundamental_id_get  # noqa: E501

        get fundamental highlights data from either fundamental_id or stock_codes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_highlights_id_fundamental_id_get(fundamental_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str fundamental_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HighlightsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_highlights_id_fundamental_id_get_with_http_info(fundamental_id, **kwargs)  # noqa: E501

    def v1_fundamentals_highlights_id_fundamental_id_get_with_http_info(self, fundamental_id, **kwargs):  # noqa: E501
        """v1_fundamentals_highlights_id_fundamental_id_get  # noqa: E501

        get fundamental highlights data from either fundamental_id or stock_codes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_highlights_id_fundamental_id_get_with_http_info(fundamental_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str fundamental_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HighlightsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'fundamental_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_highlights_id_fundamental_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'fundamental_id' is set
        if self.api_client.client_side_validation and ('fundamental_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['fundamental_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `fundamental_id` when calling `v1_fundamentals_highlights_id_fundamental_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fundamental_id' in local_var_params:
            path_params['fundamental_id'] = local_var_params['fundamental_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/highlights/id/{fundamental_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HighlightsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_highlights_stock_stock_code_get(self, stock_code, **kwargs):  # noqa: E501
        """v1_fundamentals_highlights_stock_stock_code_get  # noqa: E501

        get fundamental highlights data from either fundamental_id or stock_codes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_highlights_stock_stock_code_get(stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HighlightsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_highlights_stock_stock_code_get_with_http_info(stock_code, **kwargs)  # noqa: E501

    def v1_fundamentals_highlights_stock_stock_code_get_with_http_info(self, stock_code, **kwargs):  # noqa: E501
        """v1_fundamentals_highlights_stock_stock_code_get  # noqa: E501

        get fundamental highlights data from either fundamental_id or stock_codes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_highlights_stock_stock_code_get_with_http_info(stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HighlightsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_highlights_stock_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_highlights_stock_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/highlights/stock/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HighlightsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get(self, stock_code, filing_date, **kwargs):  # noqa: E501
        """v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get  # noqa: E501

        given filing_date and balance_sheet_id return Quarterly Balance Sheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get(stock_code, filing_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str filing_date: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QuarterlyBalanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get_with_http_info(stock_code, filing_date, **kwargs)  # noqa: E501

    def v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get_with_http_info(self, stock_code, filing_date, **kwargs):  # noqa: E501
        """v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get  # noqa: E501

        given filing_date and balance_sheet_id return Quarterly Balance Sheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get_with_http_info(stock_code, filing_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str filing_date: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QuarterlyBalanceResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'filing_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get`")  # noqa: E501
        # verify the required parameter 'filing_date' is set
        if self.api_client.client_side_validation and ('filing_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['filing_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `filing_date` when calling `v1_fundamentals_quarterly_balance_sheet_filing_date_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'filing_date' in local_var_params:
            path_params['filing_date'] = local_var_params['filing_date']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/quarterly-balance-sheet/{filing_date}/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuarterlyBalanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get(self, stock_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get  # noqa: E501

        Given a company stock_code and a year return technical indicators for that year  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get(stock_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str year: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get_with_http_info(stock_code, year, **kwargs)  # noqa: E501

    def v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get_with_http_info(self, stock_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get  # noqa: E501

        Given a company stock_code and a year return technical indicators for that year  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get_with_http_info(stock_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str year: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'year'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get`")  # noqa: E501
        # verify the required parameter 'year' is set
        if self.api_client.client_side_validation and ('year' not in local_var_params or  # noqa: E501
                                                        local_var_params['year'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `year` when calling `v1_fundamentals_tech_indicators_by_company_stock_code_stock_code_year_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'year' in local_var_params:
            path_params['year'] = local_var_params['year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/tech-indicators-by-company/stock-code/{stock_code}/{year}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get(self, exchange_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get  # noqa: E501

        Given an exchange_code and a year return all technical indicators released for companies listed on the exchange for the year mentioned  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get(exchange_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str year: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get_with_http_info(exchange_code, year, **kwargs)  # noqa: E501

    def v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get_with_http_info(self, exchange_code, year, **kwargs):  # noqa: E501
        """v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get  # noqa: E501

        Given an exchange_code and a year return all technical indicators released for companies listed on the exchange for the year mentioned  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get_with_http_info(exchange_code, year, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str year: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OptionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'exchange_code',
            'year'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_code' is set
        if self.api_client.client_side_validation and ('exchange_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_code` when calling `v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get`")  # noqa: E501
        # verify the required parameter 'year' is set
        if self.api_client.client_side_validation and ('year' not in local_var_params or  # noqa: E501
                                                        local_var_params['year'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `year` when calling `v1_fundamentals_tech_indicators_by_exchange_exchange_code_exchange_code_year_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_code' in local_var_params:
            path_params['exchange_code'] = local_var_params['exchange_code']  # noqa: E501
        if 'year' in local_var_params:
            path_params['year'] = local_var_params['year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/fundamentals/tech-indicators-by-exchange/exchange-code/{exchange_code}/{year}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
