# Generated by Django 2.2.8 on 2019-12-13 16:29

import jsonfield.fields
import picklefield.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="WebSession",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("app", models.CharField(max_length=30, unique=True)),
                (
                    "requests_cookies",
                    picklefield.fields.PickledObjectField(editable=False),
                ),
                ("last_modified", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="TorrentFile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("app", models.CharField(max_length=30)),
                ("url", models.CharField(max_length=5000)),
                ("url_hash", models.CharField(max_length=50)),
                ("torrent_data", models.BinaryField()),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={"unique_together": {("app", "url_hash")},},
        ),
        migrations.CreateModel(
            name="ListingCache",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("app", models.CharField(max_length=30)),
                ("search_token", models.CharField(max_length=50)),
                ("path", models.CharField(default="", max_length=500)),
                ("listing", jsonfield.fields.JSONField()),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={"unique_together": {("app", "search_token", "path")},},
        ),
        migrations.CreateModel(
            name="AvailableMedia",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("app", models.CharField(max_length=30)),
                ("identifier", models.CharField(max_length=500)),
                ("created", models.DateTimeField(auto_now_add=True, db_index=True)),
            ],
            options={"unique_together": {("app", "identifier")},},
        ),
    ]
