# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zipapp_utils', 'zipapp_utils.templates']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=3.1.2,<4.0.0']

entry_points = \
{'console_scripts': ['zau = zipapp_utils.cli:main',
                     'zipapp-utils = zipapp_utils.cli:main']}

setup_kwargs = {
    'name': 'zipapp-utils',
    'version': '0.2.2',
    'description': 'zipapp utilities',
    'long_description': '# zipapp-utils\n\nzipapp utilities\n\n- [zipapp-utils](#zipapp-utils)\n  - [Features](#features)\n  - [Demo](#demo)\n  - [Install, Upgrade and Uninstall](#install-upgrade-and-uninstall)\n    - [pipx (recommended)](#pipx-recommended)\n    - [pip](#pip)\n  - [Usage](#usage)\n    - [zipapp-utils](#zipapp-utils-1)\n    - [zipapp-utils py2pyz](#zipapp-utils-py2pyz)\n    - [zipapp-utils create-archive](#zipapp-utils-create-archive)\n    - [zipapp-utils create-shell-script](#zipapp-utils-create-shell-script)\n    - [Examples](#examples)\n      - [Generate a shell script that bundles and runs a python script](#generate-a-shell-script-that-bundles-and-runs-a-python-script)\n  - [Why did you make this?](#why-did-you-make-this)\n  - [Changelog](#changelog)\n\n## Features\n- Creating application archive (`.pyz` files) like `python -m zipapp` does, but with convenient features.\n- Create shell scripts that bundle a python scripts with all of its dependencies, and can be executable on any system that has `python3 >= 3.5` installed.\n\n## Demo\n\nSee [Generate a shell script that bundles and runs a python script](#generate-a-shell-script-that-bundles-and-runs-a-python-script)\n\n<a href="https://asciinema.org/a/502539"><img src="https://asciinema.org/a/502539.svg" alt="Asciicast" width="650"/></a>\n\n## Install, Upgrade and Uninstall\n\n### pipx (recommended)\n```bash\npipx install zipapp-utils\n```\n\nAbout [`pipx`](https://pypa.github.io/pipx)\n\n\n### [pip](https://pypi.org/project/zipapp-utils)\n```bash\npip install zipapp-utils\n```\n\n\n## Usage\n\n### zipapp-utils\n\nzipapp-utils is the base command.\n\nzau is an installed alias for zipapp-utils, you can use them interchangeably.\n\n\n```\n$ zipapp-utils --help # or zau --help\n\nusage: zipapp-utils [-h] [-V] {py2pyz,p,create-archive,ca,zipapp,create-shell-script,sh} ...\n\nzipapp utilities\n\npositional arguments:\n  {py2pyz,p,create-archive,ca,zipapp,create-shell-script,sh}\n    py2pyz (p)          Create archive from a python script\n    create-archive (ca, zipapp)\n                        Create a zipapp archive\n    create-shell-script (sh)\n                        Create an ASCII shellscript that runs a zipapp archive\n\noptions:\n  -h, --help            show this help message and exit\n  -V, --version         show program\'s version number and exit\n```\n\n### zipapp-utils py2pyz\n\nCreate archive from a python script\n\n```\n$ zau p --help\n\nusage: zipapp-utils py2pyz [-h] [-d DEP] [-r [REQUIREMENT]] [--output OUTPUT] [--python PYTHON] [--main MAIN] [--compress] SCRIPT\n\nCreate archive from a python script\n\npositional arguments:\n  SCRIPT                Python script file\n\noptions:\n  -h, --help            show this help message and exit\n  -d DEP, --dep DEP     Add dependency\n  -r [REQUIREMENT], --requirement [REQUIREMENT]\n                        Install dependencies from the given requirements file. Defaults to "requirements.txt"\n  --output OUTPUT, -o OUTPUT\n                        The name of the output archive. Required if SOURCE is an archive.\n  --python PYTHON, -p PYTHON\n                        The name of the Python interpreter to use (default: no shebang line).\n  --main MAIN, -m MAIN  The main function of the application (default: use an existing __main__.py).\n  --compress, -c        Compress files with the deflate method. Files are stored uncompressed by default.\n```\n\n### zipapp-utils create-archive\n\nCreate a zipapp archive (.pyz file)\n\n```\n$ zau ca --help\n\nusage: zipapp-utils create-archive [-h] [--output OUTPUT] [--python PYTHON] [--main MAIN] [--compress] [--info] source\n\nCreate a zipapp archive\n\npositional arguments:\n  source                Source directory (or existing archive).\n\noptions:\n  -h, --help            show this help message and exit\n  --output OUTPUT, -o OUTPUT\n                        The name of the output archive. Required if SOURCE is an archive.\n  --python PYTHON, -p PYTHON\n                        The name of the Python interpreter to use (default: no shebang line).\n  --main MAIN, -m MAIN  The main function of the application (default: use an existing __main__.py).\n  --compress, -c        Compress files with the deflate method. Files are stored uncompressed by default.\n  --info                Display the interpreter from the archive.\n```\n\n### zipapp-utils create-shell-script\n\nCreate an ASCII shellscript that runs a zipapp archive\n\n```\n$ zau sh --help\n\nusage: zipapp-utils create-shell-script [-h] [-o OUTPUT] PYTHON_APPLICATION_ARCHIVE\n\nCreate an ASCII shellscript that runs a zipapp archive\n\npositional arguments:\n  PYTHON_APPLICATION_ARCHIVE\n                        Path to the pyz file\n\noptions:\n  -h, --help            show this help message and exit\n  -o OUTPUT, --output OUTPUT\n                        Path to the output file, or stdout if not set\n```\n\n### Examples\n\n#### Generate a shell script that bundles and runs a python script\n\nAs described in the [Why did you make this?](#why-did-you-make-this) section.\n\nSee [Demo](#demo) for a recording of the process.\n\n```bash\n# make an executable, compressed .pyz file from the script post_status.py, with dependencies pysnc and requests-oauthlib, outputs to test.pyz\nzau p post_status.py -d pysnc -d requests-oauthlib -o test.pyz -c\n\n# run test.pyz to verify it works\n./test.pyz\n\n# create a shell script that runs test.pyz\nzau sh test.pyz -o test.sh\n\n# run test.sh to verify it works\n./test.sh\n\n# if it works, just copy the content of test.sh and paste it into a jenkins textbox that runs the script.\n# make sure python3 >= 3.5 is installed on the jenkins executor node.\n```\n\n\n## Why did you make this?\n\nThis project was created because I needed to run a python script with some dependencies in on a managed Jenkins environment,\n\nand I wasn\'t able to install any software (including pypi packages) on the node.\n\nI tried to bundle the pypi dependency in my script. \n\nThe closest I\'ve tried was to use `pyinstaller`, which allows you to compile a single executable from a python script. It compiled and ran on my Linux box, but not on the Jenkins node because of incompatible glibc version used by python in the binary.\n\nThen I remembered the `zipapp` module, which allowed me to use this script on Jenkins:\n\n```bash\n#!/usr/bin/env bash\n\nENCODED_PYZ_FILE=\'{{ encoded_pyz_file }}\'\n\necho -n "${ENCODED_PYZ_FILE}" | base64 -d > /tmp/pyz.pyz\npython3 /tmp/pyz.pyz\n\n```\n\nAnd voila, it worked!\n\nSo I decided to create this project to ease the process of creating such shell scripts for use on Jenkins.\n\n\n\n## [Changelog](CHANGELOG.md)',
    'author': 'Xinyuan Chen',
    'author_email': '45612704+tddschn@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/tddschn/zipapp-utils',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
