import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { GatewayRoute, GatewayRouteBaseProps } from './gateway-route';
import { IMesh } from './mesh';
import { AccessLog } from './shared-interfaces';
import { VirtualGatewayListener, VirtualGatewayListenerConfig } from './virtual-gateway-listener';
/**
 * (experimental) Interface which all Virtual Gateway based classes must implement.
 *
 * @experimental
 */
export interface IVirtualGateway extends cdk.IResource {
    /**
     * (experimental) Name of the VirtualGateway.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualGatewayName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the VirtualGateway.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualGatewayArn: string;
    /**
     * (experimental) The Mesh which the VirtualGateway belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * (experimental) Utility method to add a new GatewayRoute to the VirtualGateway.
     *
     * @experimental
     */
    addGatewayRoute(id: string, route: GatewayRouteBaseProps): GatewayRoute;
}
/**
 * (experimental) Basic configuration properties for a VirtualGateway.
 *
 * @experimental
 */
export interface VirtualGatewayBaseProps {
    /**
     * (experimental) Name of the VirtualGateway.
     *
     * @default - A name is automatically determined
     * @experimental
     */
    readonly virtualGatewayName?: string;
    /**
     * (experimental) Listeners for the VirtualGateway.
     *
     * Only one is supported.
     *
     * @default - Single HTTP listener on port 8080
     * @experimental
     */
    readonly listeners?: VirtualGatewayListener[];
    /**
     * (experimental) Access Logging Configuration for the VirtualGateway.
     *
     * @default - no access logging
     * @experimental
     */
    readonly accessLog?: AccessLog;
}
/**
 * (experimental) Properties used when creating a new VirtualGateway.
 *
 * @experimental
 */
export interface VirtualGatewayProps extends VirtualGatewayBaseProps {
    /**
     * (experimental) The Mesh which the VirtualGateway belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
declare abstract class VirtualGatewayBase extends cdk.Resource implements IVirtualGateway {
    /**
     * Name of the VirtualGateway
     */
    abstract readonly virtualGatewayName: string;
    /**
     * The Amazon Resource Name (ARN) for the VirtualGateway
     */
    abstract readonly virtualGatewayArn: string;
    /**
     * The Mesh which the VirtualGateway belongs to
     */
    abstract readonly mesh: IMesh;
    /**
     * (experimental) Utility method to add a new GatewayRoute to the VirtualGateway.
     *
     * @experimental
     */
    addGatewayRoute(id: string, props: GatewayRouteBaseProps): GatewayRoute;
}
/**
 * (experimental) VirtualGateway represents a newly defined App Mesh Virtual Gateway.
 *
 * A virtual gateway allows resources that are outside of your mesh to communicate to resources that
 * are inside of your mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html
 * @experimental
 */
export declare class VirtualGateway extends VirtualGatewayBase {
    /**
     * (experimental) Import an existing VirtualGateway given an ARN.
     *
     * @experimental
     */
    static fromVirtualGatewayArn(scope: Construct, id: string, virtualGatewayArn: string): IVirtualGateway;
    /**
     * (experimental) Import an existing VirtualGateway given its attributes.
     *
     * @experimental
     */
    static fromVirtualGatewayAttributes(scope: Construct, id: string, attrs: VirtualGatewayAttributes): IVirtualGateway;
    /**
     * (experimental) The name of the VirtualGateway.
     *
     * @experimental
     */
    readonly virtualGatewayName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the VirtualGateway.
     *
     * @experimental
     */
    readonly virtualGatewayArn: string;
    /**
     * (experimental) The Mesh that the VirtualGateway belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * @experimental
     */
    protected readonly listeners: VirtualGatewayListenerConfig[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VirtualGatewayProps);
}
/**
 * (experimental) Unterface with properties necessary to import a reusable VirtualGateway.
 *
 * @experimental
 */
export interface VirtualGatewayAttributes {
    /**
     * (experimental) The name of the VirtualGateway.
     *
     * @experimental
     */
    readonly virtualGatewayName: string;
    /**
     * (experimental) The Mesh that the VirtualGateway belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
export {};
