"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SleepSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implemenation for aws:sleep
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-sleep.html
 */
class SleepSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:sleep';
        this.sleepStep = step;
        this.props = props;
    }
    executeStep(_inputs) {
        this.props.sleepHook.sleep(1000 * this.sleepStep.sleepSeconds);
        return {};
    }
}
exports.SleepSimulation = SleepSimulation;
_a = JSII_RTTI_SYMBOL_1;
SleepSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.SleepSimulation", version: "0.0.35" };
//# sourceMappingURL=data:application/json;base64,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