import { IRunCommandHook } from '../../interface/run-command-hook';
import { RunCommandStep } from '../../parent-steps/automation/run-command-step';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * Properties for RunCommandStep
 */
export interface RunCommandSimulationProps {
    /**
     * Hook for simulating aws:runCommand.
     * @default - Uses AWS API to execute the document remotely.
     */
    readonly runCommandHook: IRunCommandHook;
}
/**
 * AutomationStep implementation of [aws:runCommand](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runcommand.html)
 */
export declare class RunCommandSimulation extends AutomationSimulationBase {
    readonly action = "aws:runCommand";
    private runCommandStep;
    private props;
    constructor(step: RunCommandStep, props: RunCommandSimulationProps);
    /**
       * May perform a real approval ask based on the params used during instance creation.
       */
    executeStep(inputs: Record<string, any>): Record<string, any>;
}
