"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateSSMAgentStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const string_variable_1 = require("../../interface/variables/string-variable");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:UpdateSsmAgent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-updatessmagent
 */
class UpdateSSMAgentStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX, platform_1.Platform.MAC_OS];
        this.action = 'aws:updateSsmAgent';
        this.agentName = props.agentName ?? new string_variable_1.HardCodedString('amazon-ssm-agent');
        this.allowDowngrade = props.allowDowngrade;
        if ((props.source == undefined) == (props.sourceRegion == undefined)) {
            throw new Error('One and only one of source and sourceRegion must be provided.');
        }
        this.source = props.source ?? new string_variable_1.HardCodedString(`https://s3.${props.sourceRegion}.amazonaws.com/aws-ssm-${props.sourceRegion}/manifest.json`);
        this.targetVersion = props.targetVersion;
    }
    /**
       * Inputs required for this command include agentName allowDowngrade source and targetVersion if version other than latest is desired
       */
    listInputs() {
        const inputs = [
            this.agentName,
            this.allowDowngrade,
            this.source,
            this.targetVersion,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = { agentName: this.agentName };
        inputs.source = this.source;
        inputs.allowDowngrade = this.allowDowngrade;
        if (this.targetVersion != undefined) {
            inputs.targetVersion = this.targetVersion;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.UpdateSSMAgentStep = UpdateSSMAgentStep;
_a = JSII_RTTI_SYMBOL_1;
UpdateSSMAgentStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.UpdateSSMAgentStep", version: "0.0.35" };
//# sourceMappingURL=data:application/json;base64,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