"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainJoinStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implemenation for aws:softwareInventory
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-domainJoin
 */
class DomainJoinStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:domainJoin';
        this.directoryId = props.directoryId;
        this.directoryName = props.directoryName;
        this.directoryOU = props.directoryOU;
        this.dnsIpAddresses = props.dnsIpAddresses;
    }
    /**
     * All Inputs for this command are optional.
     */
    listInputs() {
        const inputs = [
            this.directoryId,
            this.directoryName,
            this.directoryOU,
            this.dnsIpAddresses,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = {
            directoryId: this.directoryId,
            directoryName: this.directoryName,
            dnsIpAddresses: this.dnsIpAddresses,
        };
        if (this.directoryOU != undefined) {
            inputs.directoryOU = this.directoryOU;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.DomainJoinStep = DomainJoinStep;
_a = JSII_RTTI_SYMBOL_1;
DomainJoinStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.DomainJoinStep", version: "0.0.35" };
//# sourceMappingURL=data:application/json;base64,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