webpackJsonp([1],{

/***/ 704:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (immutable) */ __webpack_exports__["setupMode"] = setupMode;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__workerManager_js__ = __webpack_require__(797);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__ = __webpack_require__(798);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



function setupMode(defaults) {
    var disposables = [];
    var providers = [];
    var client = new __WEBPACK_IMPORTED_MODULE_0__workerManager_js__["a" /* WorkerManager */](defaults);
    disposables.push(client);
    var worker = function () {
        var uris = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            uris[_i] = arguments[_i];
        }
        return client.getLanguageServiceWorker.apply(client, uris);
    };
    function registerProviders() {
        var languageId = defaults.languageId, modeConfiguration = defaults.modeConfiguration;
        disposeAll(providers);
        if (modeConfiguration.completionItems) {
            providers.push(monaco.languages.registerCompletionItemProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["a" /* CompletionAdapter */](worker)));
        }
        if (modeConfiguration.hovers) {
            providers.push(monaco.languages.registerHoverProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["h" /* HoverAdapter */](worker)));
        }
        if (modeConfiguration.documentHighlights) {
            providers.push(monaco.languages.registerDocumentHighlightProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["e" /* DocumentHighlightAdapter */](worker)));
        }
        if (modeConfiguration.definitions) {
            providers.push(monaco.languages.registerDefinitionProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["b" /* DefinitionAdapter */](worker)));
        }
        if (modeConfiguration.references) {
            providers.push(monaco.languages.registerReferenceProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["i" /* ReferenceAdapter */](worker)));
        }
        if (modeConfiguration.documentSymbols) {
            providers.push(monaco.languages.registerDocumentSymbolProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["f" /* DocumentSymbolAdapter */](worker)));
        }
        if (modeConfiguration.rename) {
            providers.push(monaco.languages.registerRenameProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["j" /* RenameAdapter */](worker)));
        }
        if (modeConfiguration.colors) {
            providers.push(monaco.languages.registerColorProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["d" /* DocumentColorAdapter */](worker)));
        }
        if (modeConfiguration.foldingRanges) {
            providers.push(monaco.languages.registerFoldingRangeProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["g" /* FoldingRangeAdapter */](worker)));
        }
        if (modeConfiguration.diagnostics) {
            providers.push(new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["c" /* DiagnosticsAdapter */](languageId, worker, defaults));
        }
        if (modeConfiguration.selectionRanges) {
            providers.push(monaco.languages.registerSelectionRangeProvider(languageId, new __WEBPACK_IMPORTED_MODULE_1__languageFeatures_js__["k" /* SelectionRangeAdapter */](worker)));
        }
    }
    registerProviders();
    disposables.push(asDisposable(providers));
    return asDisposable(disposables);
}
function asDisposable(disposables) {
    return { dispose: function () { return disposeAll(disposables); } };
}
function disposeAll(disposables) {
    while (disposables.length) {
        disposables.pop().dispose();
    }
}


/***/ }),

/***/ 756:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "S", function() { return NodeType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Z", function() { return ReferenceType; });
/* harmony export (immutable) */ __webpack_exports__["_13"] = getNodeAtOffset;
/* harmony export (immutable) */ __webpack_exports__["_14"] = getNodePath;
/* harmony export (immutable) */ __webpack_exports__["_15"] = getParentDeclaration;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "R", function() { return Node; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "T", function() { return Nodelist; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "y", function() { return Identifier; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_3", function() { return Stylesheet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return Declarations; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return BodyDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_0", function() { return RuleSet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_1", function() { return Selector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_2", function() { return SimpleSelector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AtApplyRule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return CustomPropertyDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return CustomPropertySet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return Declaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Y", function() { return Property; });
/* unused harmony export Invocation */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "s", function() { return Function; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "v", function() { return FunctionParameter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "t", function() { return FunctionArgument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "z", function() { return IfStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return ForStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return EachStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_12", function() { return WhileStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return ElseStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "u", function() { return FunctionDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_11", function() { return ViewPort; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return FontFace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Q", function() { return NestedProperties; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "C", function() { return Keyframe; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "D", function() { return KeyframeSelector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "A", function() { return Import; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_8", function() { return Use; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "O", function() { return ModuleConfiguration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return Forward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "r", function() { return ForwardVisibility; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "P", function() { return Namespace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "I", function() { return Media; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_4", function() { return Supports; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return Document; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "K", function() { return Medialist; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "J", function() { return MediaQuery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_5", function() { return SupportsCondition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "V", function() { return Page; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "W", function() { return PageBoxMarginBox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return Expression; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return BinaryExpression; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_6", function() { return Term; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return AttributeSelector; });
/* unused harmony export Operator */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "x", function() { return HexColorValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "U", function() { return NumericValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_10", function() { return VariableDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "B", function() { return Interpolation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_9", function() { return Variable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return ExtendsReference; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "M", function() { return MixinReference; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "L", function() { return MixinDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_7", function() { return UnknownAtRule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "G", function() { return ListEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "E", function() { return LessGuard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "w", function() { return GuardCondition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "N", function() { return Module; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "F", function() { return Level; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "H", function() { return Marker; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "X", function() { return ParseErrorCollector; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/// <summary>
/// Nodes for the css 2.1 specification. See for reference:
/// http://www.w3.org/TR/CSS21/grammar.html#grammar
/// </summary>
var NodeType;
(function (NodeType) {
    NodeType[NodeType["Undefined"] = 0] = "Undefined";
    NodeType[NodeType["Identifier"] = 1] = "Identifier";
    NodeType[NodeType["Stylesheet"] = 2] = "Stylesheet";
    NodeType[NodeType["Ruleset"] = 3] = "Ruleset";
    NodeType[NodeType["Selector"] = 4] = "Selector";
    NodeType[NodeType["SimpleSelector"] = 5] = "SimpleSelector";
    NodeType[NodeType["SelectorInterpolation"] = 6] = "SelectorInterpolation";
    NodeType[NodeType["SelectorCombinator"] = 7] = "SelectorCombinator";
    NodeType[NodeType["SelectorCombinatorParent"] = 8] = "SelectorCombinatorParent";
    NodeType[NodeType["SelectorCombinatorSibling"] = 9] = "SelectorCombinatorSibling";
    NodeType[NodeType["SelectorCombinatorAllSiblings"] = 10] = "SelectorCombinatorAllSiblings";
    NodeType[NodeType["SelectorCombinatorShadowPiercingDescendant"] = 11] = "SelectorCombinatorShadowPiercingDescendant";
    NodeType[NodeType["Page"] = 12] = "Page";
    NodeType[NodeType["PageBoxMarginBox"] = 13] = "PageBoxMarginBox";
    NodeType[NodeType["ClassSelector"] = 14] = "ClassSelector";
    NodeType[NodeType["IdentifierSelector"] = 15] = "IdentifierSelector";
    NodeType[NodeType["ElementNameSelector"] = 16] = "ElementNameSelector";
    NodeType[NodeType["PseudoSelector"] = 17] = "PseudoSelector";
    NodeType[NodeType["AttributeSelector"] = 18] = "AttributeSelector";
    NodeType[NodeType["Declaration"] = 19] = "Declaration";
    NodeType[NodeType["Declarations"] = 20] = "Declarations";
    NodeType[NodeType["Property"] = 21] = "Property";
    NodeType[NodeType["Expression"] = 22] = "Expression";
    NodeType[NodeType["BinaryExpression"] = 23] = "BinaryExpression";
    NodeType[NodeType["Term"] = 24] = "Term";
    NodeType[NodeType["Operator"] = 25] = "Operator";
    NodeType[NodeType["Value"] = 26] = "Value";
    NodeType[NodeType["StringLiteral"] = 27] = "StringLiteral";
    NodeType[NodeType["URILiteral"] = 28] = "URILiteral";
    NodeType[NodeType["EscapedValue"] = 29] = "EscapedValue";
    NodeType[NodeType["Function"] = 30] = "Function";
    NodeType[NodeType["NumericValue"] = 31] = "NumericValue";
    NodeType[NodeType["HexColorValue"] = 32] = "HexColorValue";
    NodeType[NodeType["MixinDeclaration"] = 33] = "MixinDeclaration";
    NodeType[NodeType["MixinReference"] = 34] = "MixinReference";
    NodeType[NodeType["VariableName"] = 35] = "VariableName";
    NodeType[NodeType["VariableDeclaration"] = 36] = "VariableDeclaration";
    NodeType[NodeType["Prio"] = 37] = "Prio";
    NodeType[NodeType["Interpolation"] = 38] = "Interpolation";
    NodeType[NodeType["NestedProperties"] = 39] = "NestedProperties";
    NodeType[NodeType["ExtendsReference"] = 40] = "ExtendsReference";
    NodeType[NodeType["SelectorPlaceholder"] = 41] = "SelectorPlaceholder";
    NodeType[NodeType["Debug"] = 42] = "Debug";
    NodeType[NodeType["If"] = 43] = "If";
    NodeType[NodeType["Else"] = 44] = "Else";
    NodeType[NodeType["For"] = 45] = "For";
    NodeType[NodeType["Each"] = 46] = "Each";
    NodeType[NodeType["While"] = 47] = "While";
    NodeType[NodeType["MixinContent"] = 48] = "MixinContent";
    NodeType[NodeType["Media"] = 49] = "Media";
    NodeType[NodeType["Keyframe"] = 50] = "Keyframe";
    NodeType[NodeType["FontFace"] = 51] = "FontFace";
    NodeType[NodeType["Import"] = 52] = "Import";
    NodeType[NodeType["Namespace"] = 53] = "Namespace";
    NodeType[NodeType["Invocation"] = 54] = "Invocation";
    NodeType[NodeType["FunctionDeclaration"] = 55] = "FunctionDeclaration";
    NodeType[NodeType["ReturnStatement"] = 56] = "ReturnStatement";
    NodeType[NodeType["MediaQuery"] = 57] = "MediaQuery";
    NodeType[NodeType["FunctionParameter"] = 58] = "FunctionParameter";
    NodeType[NodeType["FunctionArgument"] = 59] = "FunctionArgument";
    NodeType[NodeType["KeyframeSelector"] = 60] = "KeyframeSelector";
    NodeType[NodeType["ViewPort"] = 61] = "ViewPort";
    NodeType[NodeType["Document"] = 62] = "Document";
    NodeType[NodeType["AtApplyRule"] = 63] = "AtApplyRule";
    NodeType[NodeType["CustomPropertyDeclaration"] = 64] = "CustomPropertyDeclaration";
    NodeType[NodeType["CustomPropertySet"] = 65] = "CustomPropertySet";
    NodeType[NodeType["ListEntry"] = 66] = "ListEntry";
    NodeType[NodeType["Supports"] = 67] = "Supports";
    NodeType[NodeType["SupportsCondition"] = 68] = "SupportsCondition";
    NodeType[NodeType["NamespacePrefix"] = 69] = "NamespacePrefix";
    NodeType[NodeType["GridLine"] = 70] = "GridLine";
    NodeType[NodeType["Plugin"] = 71] = "Plugin";
    NodeType[NodeType["UnknownAtRule"] = 72] = "UnknownAtRule";
    NodeType[NodeType["Use"] = 73] = "Use";
    NodeType[NodeType["ModuleConfiguration"] = 74] = "ModuleConfiguration";
    NodeType[NodeType["Forward"] = 75] = "Forward";
    NodeType[NodeType["ForwardVisibility"] = 76] = "ForwardVisibility";
    NodeType[NodeType["Module"] = 77] = "Module";
})(NodeType || (NodeType = {}));
var ReferenceType;
(function (ReferenceType) {
    ReferenceType[ReferenceType["Mixin"] = 0] = "Mixin";
    ReferenceType[ReferenceType["Rule"] = 1] = "Rule";
    ReferenceType[ReferenceType["Variable"] = 2] = "Variable";
    ReferenceType[ReferenceType["Function"] = 3] = "Function";
    ReferenceType[ReferenceType["Keyframe"] = 4] = "Keyframe";
    ReferenceType[ReferenceType["Unknown"] = 5] = "Unknown";
    ReferenceType[ReferenceType["Module"] = 6] = "Module";
    ReferenceType[ReferenceType["Forward"] = 7] = "Forward";
    ReferenceType[ReferenceType["ForwardVisibility"] = 8] = "ForwardVisibility";
})(ReferenceType || (ReferenceType = {}));
function getNodeAtOffset(node, offset) {
    var candidate = null;
    if (!node || offset < node.offset || offset > node.end) {
        return null;
    }
    // Find the shortest node at the position
    node.accept(function (node) {
        if (node.offset === -1 && node.length === -1) {
            return true;
        }
        if (node.offset <= offset && node.end >= offset) {
            if (!candidate) {
                candidate = node;
            }
            else if (node.length <= candidate.length) {
                candidate = node;
            }
            return true;
        }
        return false;
    });
    return candidate;
}
function getNodePath(node, offset) {
    var candidate = getNodeAtOffset(node, offset);
    var path = [];
    while (candidate) {
        path.unshift(candidate);
        candidate = candidate.parent;
    }
    return path;
}
function getParentDeclaration(node) {
    var decl = node.findParent(NodeType.Declaration);
    var value = decl && decl.getValue();
    if (value && value.encloses(node)) {
        return decl;
    }
    return null;
}
var Node = /** @class */ (function () {
    function Node(offset, len, nodeType) {
        if (offset === void 0) { offset = -1; }
        if (len === void 0) { len = -1; }
        this.parent = null;
        this.offset = offset;
        this.length = len;
        if (nodeType) {
            this.nodeType = nodeType;
        }
    }
    Object.defineProperty(Node.prototype, "end", {
        get: function () { return this.offset + this.length; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Node.prototype, "type", {
        get: function () {
            return this.nodeType || NodeType.Undefined;
        },
        set: function (type) {
            this.nodeType = type;
        },
        enumerable: true,
        configurable: true
    });
    Node.prototype.getTextProvider = function () {
        var node = this;
        while (node && !node.textProvider) {
            node = node.parent;
        }
        if (node) {
            return node.textProvider;
        }
        return function () { return 'unknown'; };
    };
    Node.prototype.getText = function () {
        return this.getTextProvider()(this.offset, this.length);
    };
    Node.prototype.matches = function (str) {
        return this.length === str.length && this.getTextProvider()(this.offset, this.length) === str;
    };
    Node.prototype.startsWith = function (str) {
        return this.length >= str.length && this.getTextProvider()(this.offset, str.length) === str;
    };
    Node.prototype.endsWith = function (str) {
        return this.length >= str.length && this.getTextProvider()(this.end - str.length, str.length) === str;
    };
    Node.prototype.accept = function (visitor) {
        if (visitor(this) && this.children) {
            for (var _i = 0, _a = this.children; _i < _a.length; _i++) {
                var child = _a[_i];
                child.accept(visitor);
            }
        }
    };
    Node.prototype.acceptVisitor = function (visitor) {
        this.accept(visitor.visitNode.bind(visitor));
    };
    Node.prototype.adoptChild = function (node, index) {
        if (index === void 0) { index = -1; }
        if (node.parent && node.parent.children) {
            var idx = node.parent.children.indexOf(node);
            if (idx >= 0) {
                node.parent.children.splice(idx, 1);
            }
        }
        node.parent = this;
        var children = this.children;
        if (!children) {
            children = this.children = [];
        }
        if (index !== -1) {
            children.splice(index, 0, node);
        }
        else {
            children.push(node);
        }
        return node;
    };
    Node.prototype.attachTo = function (parent, index) {
        if (index === void 0) { index = -1; }
        if (parent) {
            parent.adoptChild(this, index);
        }
        return this;
    };
    Node.prototype.collectIssues = function (results) {
        if (this.issues) {
            results.push.apply(results, this.issues);
        }
    };
    Node.prototype.addIssue = function (issue) {
        if (!this.issues) {
            this.issues = [];
        }
        this.issues.push(issue);
    };
    Node.prototype.hasIssue = function (rule) {
        return Array.isArray(this.issues) && this.issues.some(function (i) { return i.getRule() === rule; });
    };
    Node.prototype.isErroneous = function (recursive) {
        if (recursive === void 0) { recursive = false; }
        if (this.issues && this.issues.length > 0) {
            return true;
        }
        return recursive && Array.isArray(this.children) && this.children.some(function (c) { return c.isErroneous(true); });
    };
    Node.prototype.setNode = function (field, node, index) {
        if (index === void 0) { index = -1; }
        if (node) {
            node.attachTo(this, index);
            this[field] = node;
            return true;
        }
        return false;
    };
    Node.prototype.addChild = function (node) {
        if (node) {
            if (!this.children) {
                this.children = [];
            }
            node.attachTo(this);
            this.updateOffsetAndLength(node);
            return true;
        }
        return false;
    };
    Node.prototype.updateOffsetAndLength = function (node) {
        if (node.offset < this.offset || this.offset === -1) {
            this.offset = node.offset;
        }
        var nodeEnd = node.end;
        if ((nodeEnd > this.end) || this.length === -1) {
            this.length = nodeEnd - this.offset;
        }
    };
    Node.prototype.hasChildren = function () {
        return !!this.children && this.children.length > 0;
    };
    Node.prototype.getChildren = function () {
        return this.children ? this.children.slice(0) : [];
    };
    Node.prototype.getChild = function (index) {
        if (this.children && index < this.children.length) {
            return this.children[index];
        }
        return null;
    };
    Node.prototype.addChildren = function (nodes) {
        for (var _i = 0, nodes_1 = nodes; _i < nodes_1.length; _i++) {
            var node = nodes_1[_i];
            this.addChild(node);
        }
    };
    Node.prototype.findFirstChildBeforeOffset = function (offset) {
        if (this.children) {
            var current = null;
            for (var i = this.children.length - 1; i >= 0; i--) {
                // iterate until we find a child that has a start offset smaller than the input offset
                current = this.children[i];
                if (current.offset <= offset) {
                    return current;
                }
            }
        }
        return null;
    };
    Node.prototype.findChildAtOffset = function (offset, goDeep) {
        var current = this.findFirstChildBeforeOffset(offset);
        if (current && current.end >= offset) {
            if (goDeep) {
                return current.findChildAtOffset(offset, true) || current;
            }
            return current;
        }
        return null;
    };
    Node.prototype.encloses = function (candidate) {
        return this.offset <= candidate.offset && this.offset + this.length >= candidate.offset + candidate.length;
    };
    Node.prototype.getParent = function () {
        var result = this.parent;
        while (result instanceof Nodelist) {
            result = result.parent;
        }
        return result;
    };
    Node.prototype.findParent = function (type) {
        var result = this;
        while (result && result.type !== type) {
            result = result.parent;
        }
        return result;
    };
    Node.prototype.findAParent = function () {
        var types = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            types[_i] = arguments[_i];
        }
        var result = this;
        while (result && !types.some(function (t) { return result.type === t; })) {
            result = result.parent;
        }
        return result;
    };
    Node.prototype.setData = function (key, value) {
        if (!this.options) {
            this.options = {};
        }
        this.options[key] = value;
    };
    Node.prototype.getData = function (key) {
        if (!this.options || !this.options.hasOwnProperty(key)) {
            return null;
        }
        return this.options[key];
    };
    return Node;
}());

var Nodelist = /** @class */ (function (_super) {
    __extends(Nodelist, _super);
    function Nodelist(parent, index) {
        if (index === void 0) { index = -1; }
        var _this = _super.call(this, -1, -1) || this;
        _this.attachTo(parent, index);
        _this.offset = -1;
        _this.length = -1;
        return _this;
    }
    return Nodelist;
}(Node));

var Identifier = /** @class */ (function (_super) {
    __extends(Identifier, _super);
    function Identifier(offset, length) {
        var _this = _super.call(this, offset, length) || this;
        _this.isCustomProperty = false;
        return _this;
    }
    Object.defineProperty(Identifier.prototype, "type", {
        get: function () {
            return NodeType.Identifier;
        },
        enumerable: true,
        configurable: true
    });
    Identifier.prototype.containsInterpolation = function () {
        return this.hasChildren();
    };
    return Identifier;
}(Node));

var Stylesheet = /** @class */ (function (_super) {
    __extends(Stylesheet, _super);
    function Stylesheet(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Stylesheet.prototype, "type", {
        get: function () {
            return NodeType.Stylesheet;
        },
        enumerable: true,
        configurable: true
    });
    return Stylesheet;
}(Node));

var Declarations = /** @class */ (function (_super) {
    __extends(Declarations, _super);
    function Declarations(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Declarations.prototype, "type", {
        get: function () {
            return NodeType.Declarations;
        },
        enumerable: true,
        configurable: true
    });
    return Declarations;
}(Node));

var BodyDeclaration = /** @class */ (function (_super) {
    __extends(BodyDeclaration, _super);
    function BodyDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    BodyDeclaration.prototype.getDeclarations = function () {
        return this.declarations;
    };
    BodyDeclaration.prototype.setDeclarations = function (decls) {
        return this.setNode('declarations', decls);
    };
    return BodyDeclaration;
}(Node));

var RuleSet = /** @class */ (function (_super) {
    __extends(RuleSet, _super);
    function RuleSet(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(RuleSet.prototype, "type", {
        get: function () {
            return NodeType.Ruleset;
        },
        enumerable: true,
        configurable: true
    });
    RuleSet.prototype.getSelectors = function () {
        if (!this.selectors) {
            this.selectors = new Nodelist(this);
        }
        return this.selectors;
    };
    RuleSet.prototype.isNested = function () {
        return !!this.parent && this.parent.findParent(NodeType.Declarations) !== null;
    };
    return RuleSet;
}(BodyDeclaration));

var Selector = /** @class */ (function (_super) {
    __extends(Selector, _super);
    function Selector(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Selector.prototype, "type", {
        get: function () {
            return NodeType.Selector;
        },
        enumerable: true,
        configurable: true
    });
    return Selector;
}(Node));

var SimpleSelector = /** @class */ (function (_super) {
    __extends(SimpleSelector, _super);
    function SimpleSelector(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(SimpleSelector.prototype, "type", {
        get: function () {
            return NodeType.SimpleSelector;
        },
        enumerable: true,
        configurable: true
    });
    return SimpleSelector;
}(Node));

var AtApplyRule = /** @class */ (function (_super) {
    __extends(AtApplyRule, _super);
    function AtApplyRule(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(AtApplyRule.prototype, "type", {
        get: function () {
            return NodeType.AtApplyRule;
        },
        enumerable: true,
        configurable: true
    });
    AtApplyRule.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    AtApplyRule.prototype.getIdentifier = function () {
        return this.identifier;
    };
    AtApplyRule.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    return AtApplyRule;
}(Node));

var AbstractDeclaration = /** @class */ (function (_super) {
    __extends(AbstractDeclaration, _super);
    function AbstractDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    return AbstractDeclaration;
}(Node));

var CustomPropertyDeclaration = /** @class */ (function (_super) {
    __extends(CustomPropertyDeclaration, _super);
    function CustomPropertyDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(CustomPropertyDeclaration.prototype, "type", {
        get: function () {
            return NodeType.CustomPropertyDeclaration;
        },
        enumerable: true,
        configurable: true
    });
    CustomPropertyDeclaration.prototype.setProperty = function (node) {
        return this.setNode('property', node);
    };
    CustomPropertyDeclaration.prototype.getProperty = function () {
        return this.property;
    };
    CustomPropertyDeclaration.prototype.setValue = function (value) {
        return this.setNode('value', value);
    };
    CustomPropertyDeclaration.prototype.getValue = function () {
        return this.value;
    };
    CustomPropertyDeclaration.prototype.setPropertySet = function (value) {
        return this.setNode('propertySet', value);
    };
    CustomPropertyDeclaration.prototype.getPropertySet = function () {
        return this.propertySet;
    };
    return CustomPropertyDeclaration;
}(AbstractDeclaration));

var CustomPropertySet = /** @class */ (function (_super) {
    __extends(CustomPropertySet, _super);
    function CustomPropertySet(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(CustomPropertySet.prototype, "type", {
        get: function () {
            return NodeType.CustomPropertySet;
        },
        enumerable: true,
        configurable: true
    });
    return CustomPropertySet;
}(BodyDeclaration));

var Declaration = /** @class */ (function (_super) {
    __extends(Declaration, _super);
    function Declaration(offset, length) {
        var _this = _super.call(this, offset, length) || this;
        _this.property = null;
        return _this;
    }
    Object.defineProperty(Declaration.prototype, "type", {
        get: function () {
            return NodeType.Declaration;
        },
        enumerable: true,
        configurable: true
    });
    Declaration.prototype.setProperty = function (node) {
        return this.setNode('property', node);
    };
    Declaration.prototype.getProperty = function () {
        return this.property;
    };
    Declaration.prototype.getFullPropertyName = function () {
        var propertyName = this.property ? this.property.getName() : 'unknown';
        if (this.parent instanceof Declarations && this.parent.getParent() instanceof NestedProperties) {
            var parentDecl = this.parent.getParent().getParent();
            if (parentDecl instanceof Declaration) {
                return parentDecl.getFullPropertyName() + propertyName;
            }
        }
        return propertyName;
    };
    Declaration.prototype.getNonPrefixedPropertyName = function () {
        var propertyName = this.getFullPropertyName();
        if (propertyName && propertyName.charAt(0) === '-') {
            var vendorPrefixEnd = propertyName.indexOf('-', 1);
            if (vendorPrefixEnd !== -1) {
                return propertyName.substring(vendorPrefixEnd + 1);
            }
        }
        return propertyName;
    };
    Declaration.prototype.setValue = function (value) {
        return this.setNode('value', value);
    };
    Declaration.prototype.getValue = function () {
        return this.value;
    };
    Declaration.prototype.setNestedProperties = function (value) {
        return this.setNode('nestedProperties', value);
    };
    Declaration.prototype.getNestedProperties = function () {
        return this.nestedProperties;
    };
    return Declaration;
}(AbstractDeclaration));

var Property = /** @class */ (function (_super) {
    __extends(Property, _super);
    function Property(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Property.prototype, "type", {
        get: function () {
            return NodeType.Property;
        },
        enumerable: true,
        configurable: true
    });
    Property.prototype.setIdentifier = function (value) {
        return this.setNode('identifier', value);
    };
    Property.prototype.getIdentifier = function () {
        return this.identifier;
    };
    Property.prototype.getName = function () {
        return this.getText();
    };
    Property.prototype.isCustomProperty = function () {
        return !!this.identifier && this.identifier.isCustomProperty;
    };
    return Property;
}(Node));

var Invocation = /** @class */ (function (_super) {
    __extends(Invocation, _super);
    function Invocation(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Invocation.prototype, "type", {
        get: function () {
            return NodeType.Invocation;
        },
        enumerable: true,
        configurable: true
    });
    Invocation.prototype.getArguments = function () {
        if (!this.arguments) {
            this.arguments = new Nodelist(this);
        }
        return this.arguments;
    };
    return Invocation;
}(Node));

var Function = /** @class */ (function (_super) {
    __extends(Function, _super);
    function Function(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Function.prototype, "type", {
        get: function () {
            return NodeType.Function;
        },
        enumerable: true,
        configurable: true
    });
    Function.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Function.prototype.getIdentifier = function () {
        return this.identifier;
    };
    Function.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    return Function;
}(Invocation));

var FunctionParameter = /** @class */ (function (_super) {
    __extends(FunctionParameter, _super);
    function FunctionParameter(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(FunctionParameter.prototype, "type", {
        get: function () {
            return NodeType.FunctionParameter;
        },
        enumerable: true,
        configurable: true
    });
    FunctionParameter.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    FunctionParameter.prototype.getIdentifier = function () {
        return this.identifier;
    };
    FunctionParameter.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    FunctionParameter.prototype.setDefaultValue = function (node) {
        return this.setNode('defaultValue', node, 0);
    };
    FunctionParameter.prototype.getDefaultValue = function () {
        return this.defaultValue;
    };
    return FunctionParameter;
}(Node));

var FunctionArgument = /** @class */ (function (_super) {
    __extends(FunctionArgument, _super);
    function FunctionArgument(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(FunctionArgument.prototype, "type", {
        get: function () {
            return NodeType.FunctionArgument;
        },
        enumerable: true,
        configurable: true
    });
    FunctionArgument.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    FunctionArgument.prototype.getIdentifier = function () {
        return this.identifier;
    };
    FunctionArgument.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    FunctionArgument.prototype.setValue = function (node) {
        return this.setNode('value', node, 0);
    };
    FunctionArgument.prototype.getValue = function () {
        return this.value;
    };
    return FunctionArgument;
}(Node));

var IfStatement = /** @class */ (function (_super) {
    __extends(IfStatement, _super);
    function IfStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(IfStatement.prototype, "type", {
        get: function () {
            return NodeType.If;
        },
        enumerable: true,
        configurable: true
    });
    IfStatement.prototype.setExpression = function (node) {
        return this.setNode('expression', node, 0);
    };
    IfStatement.prototype.setElseClause = function (elseClause) {
        return this.setNode('elseClause', elseClause);
    };
    return IfStatement;
}(BodyDeclaration));

var ForStatement = /** @class */ (function (_super) {
    __extends(ForStatement, _super);
    function ForStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(ForStatement.prototype, "type", {
        get: function () {
            return NodeType.For;
        },
        enumerable: true,
        configurable: true
    });
    ForStatement.prototype.setVariable = function (node) {
        return this.setNode('variable', node, 0);
    };
    return ForStatement;
}(BodyDeclaration));

var EachStatement = /** @class */ (function (_super) {
    __extends(EachStatement, _super);
    function EachStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(EachStatement.prototype, "type", {
        get: function () {
            return NodeType.Each;
        },
        enumerable: true,
        configurable: true
    });
    EachStatement.prototype.getVariables = function () {
        if (!this.variables) {
            this.variables = new Nodelist(this);
        }
        return this.variables;
    };
    return EachStatement;
}(BodyDeclaration));

var WhileStatement = /** @class */ (function (_super) {
    __extends(WhileStatement, _super);
    function WhileStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(WhileStatement.prototype, "type", {
        get: function () {
            return NodeType.While;
        },
        enumerable: true,
        configurable: true
    });
    return WhileStatement;
}(BodyDeclaration));

var ElseStatement = /** @class */ (function (_super) {
    __extends(ElseStatement, _super);
    function ElseStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(ElseStatement.prototype, "type", {
        get: function () {
            return NodeType.Else;
        },
        enumerable: true,
        configurable: true
    });
    return ElseStatement;
}(BodyDeclaration));

var FunctionDeclaration = /** @class */ (function (_super) {
    __extends(FunctionDeclaration, _super);
    function FunctionDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(FunctionDeclaration.prototype, "type", {
        get: function () {
            return NodeType.FunctionDeclaration;
        },
        enumerable: true,
        configurable: true
    });
    FunctionDeclaration.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    FunctionDeclaration.prototype.getIdentifier = function () {
        return this.identifier;
    };
    FunctionDeclaration.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    FunctionDeclaration.prototype.getParameters = function () {
        if (!this.parameters) {
            this.parameters = new Nodelist(this);
        }
        return this.parameters;
    };
    return FunctionDeclaration;
}(BodyDeclaration));

var ViewPort = /** @class */ (function (_super) {
    __extends(ViewPort, _super);
    function ViewPort(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(ViewPort.prototype, "type", {
        get: function () {
            return NodeType.ViewPort;
        },
        enumerable: true,
        configurable: true
    });
    return ViewPort;
}(BodyDeclaration));

var FontFace = /** @class */ (function (_super) {
    __extends(FontFace, _super);
    function FontFace(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(FontFace.prototype, "type", {
        get: function () {
            return NodeType.FontFace;
        },
        enumerable: true,
        configurable: true
    });
    return FontFace;
}(BodyDeclaration));

var NestedProperties = /** @class */ (function (_super) {
    __extends(NestedProperties, _super);
    function NestedProperties(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(NestedProperties.prototype, "type", {
        get: function () {
            return NodeType.NestedProperties;
        },
        enumerable: true,
        configurable: true
    });
    return NestedProperties;
}(BodyDeclaration));

var Keyframe = /** @class */ (function (_super) {
    __extends(Keyframe, _super);
    function Keyframe(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Keyframe.prototype, "type", {
        get: function () {
            return NodeType.Keyframe;
        },
        enumerable: true,
        configurable: true
    });
    Keyframe.prototype.setKeyword = function (keyword) {
        return this.setNode('keyword', keyword, 0);
    };
    Keyframe.prototype.getKeyword = function () {
        return this.keyword;
    };
    Keyframe.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Keyframe.prototype.getIdentifier = function () {
        return this.identifier;
    };
    Keyframe.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    return Keyframe;
}(BodyDeclaration));

var KeyframeSelector = /** @class */ (function (_super) {
    __extends(KeyframeSelector, _super);
    function KeyframeSelector(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(KeyframeSelector.prototype, "type", {
        get: function () {
            return NodeType.KeyframeSelector;
        },
        enumerable: true,
        configurable: true
    });
    return KeyframeSelector;
}(BodyDeclaration));

var Import = /** @class */ (function (_super) {
    __extends(Import, _super);
    function Import(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Import.prototype, "type", {
        get: function () {
            return NodeType.Import;
        },
        enumerable: true,
        configurable: true
    });
    Import.prototype.setMedialist = function (node) {
        if (node) {
            node.attachTo(this);
            return true;
        }
        return false;
    };
    return Import;
}(Node));

var Use = /** @class */ (function (_super) {
    __extends(Use, _super);
    function Use() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Use.prototype, "type", {
        get: function () {
            return NodeType.Use;
        },
        enumerable: true,
        configurable: true
    });
    Use.prototype.getParameters = function () {
        if (!this.parameters) {
            this.parameters = new Nodelist(this);
        }
        return this.parameters;
    };
    Use.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Use.prototype.getIdentifier = function () {
        return this.identifier;
    };
    return Use;
}(Node));

var ModuleConfiguration = /** @class */ (function (_super) {
    __extends(ModuleConfiguration, _super);
    function ModuleConfiguration() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ModuleConfiguration.prototype, "type", {
        get: function () {
            return NodeType.ModuleConfiguration;
        },
        enumerable: true,
        configurable: true
    });
    ModuleConfiguration.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    ModuleConfiguration.prototype.getIdentifier = function () {
        return this.identifier;
    };
    ModuleConfiguration.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    ModuleConfiguration.prototype.setValue = function (node) {
        return this.setNode('value', node, 0);
    };
    ModuleConfiguration.prototype.getValue = function () {
        return this.value;
    };
    return ModuleConfiguration;
}(Node));

var Forward = /** @class */ (function (_super) {
    __extends(Forward, _super);
    function Forward() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Forward.prototype, "type", {
        get: function () {
            return NodeType.Forward;
        },
        enumerable: true,
        configurable: true
    });
    Forward.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Forward.prototype.getIdentifier = function () {
        return this.identifier;
    };
    return Forward;
}(Node));

var ForwardVisibility = /** @class */ (function (_super) {
    __extends(ForwardVisibility, _super);
    function ForwardVisibility() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ForwardVisibility.prototype, "type", {
        get: function () {
            return NodeType.ForwardVisibility;
        },
        enumerable: true,
        configurable: true
    });
    ForwardVisibility.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    ForwardVisibility.prototype.getIdentifier = function () {
        return this.identifier;
    };
    return ForwardVisibility;
}(Node));

var Namespace = /** @class */ (function (_super) {
    __extends(Namespace, _super);
    function Namespace(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Namespace.prototype, "type", {
        get: function () {
            return NodeType.Namespace;
        },
        enumerable: true,
        configurable: true
    });
    return Namespace;
}(Node));

var Media = /** @class */ (function (_super) {
    __extends(Media, _super);
    function Media(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Media.prototype, "type", {
        get: function () {
            return NodeType.Media;
        },
        enumerable: true,
        configurable: true
    });
    return Media;
}(BodyDeclaration));

var Supports = /** @class */ (function (_super) {
    __extends(Supports, _super);
    function Supports(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Supports.prototype, "type", {
        get: function () {
            return NodeType.Supports;
        },
        enumerable: true,
        configurable: true
    });
    return Supports;
}(BodyDeclaration));

var Document = /** @class */ (function (_super) {
    __extends(Document, _super);
    function Document(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Document.prototype, "type", {
        get: function () {
            return NodeType.Document;
        },
        enumerable: true,
        configurable: true
    });
    return Document;
}(BodyDeclaration));

var Medialist = /** @class */ (function (_super) {
    __extends(Medialist, _super);
    function Medialist(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Medialist.prototype.getMediums = function () {
        if (!this.mediums) {
            this.mediums = new Nodelist(this);
        }
        return this.mediums;
    };
    return Medialist;
}(Node));

var MediaQuery = /** @class */ (function (_super) {
    __extends(MediaQuery, _super);
    function MediaQuery(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(MediaQuery.prototype, "type", {
        get: function () {
            return NodeType.MediaQuery;
        },
        enumerable: true,
        configurable: true
    });
    return MediaQuery;
}(Node));

var SupportsCondition = /** @class */ (function (_super) {
    __extends(SupportsCondition, _super);
    function SupportsCondition(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(SupportsCondition.prototype, "type", {
        get: function () {
            return NodeType.SupportsCondition;
        },
        enumerable: true,
        configurable: true
    });
    return SupportsCondition;
}(Node));

var Page = /** @class */ (function (_super) {
    __extends(Page, _super);
    function Page(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Page.prototype, "type", {
        get: function () {
            return NodeType.Page;
        },
        enumerable: true,
        configurable: true
    });
    return Page;
}(BodyDeclaration));

var PageBoxMarginBox = /** @class */ (function (_super) {
    __extends(PageBoxMarginBox, _super);
    function PageBoxMarginBox(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(PageBoxMarginBox.prototype, "type", {
        get: function () {
            return NodeType.PageBoxMarginBox;
        },
        enumerable: true,
        configurable: true
    });
    return PageBoxMarginBox;
}(BodyDeclaration));

var Expression = /** @class */ (function (_super) {
    __extends(Expression, _super);
    function Expression(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Expression.prototype, "type", {
        get: function () {
            return NodeType.Expression;
        },
        enumerable: true,
        configurable: true
    });
    return Expression;
}(Node));

var BinaryExpression = /** @class */ (function (_super) {
    __extends(BinaryExpression, _super);
    function BinaryExpression(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(BinaryExpression.prototype, "type", {
        get: function () {
            return NodeType.BinaryExpression;
        },
        enumerable: true,
        configurable: true
    });
    BinaryExpression.prototype.setLeft = function (left) {
        return this.setNode('left', left);
    };
    BinaryExpression.prototype.getLeft = function () {
        return this.left;
    };
    BinaryExpression.prototype.setRight = function (right) {
        return this.setNode('right', right);
    };
    BinaryExpression.prototype.getRight = function () {
        return this.right;
    };
    BinaryExpression.prototype.setOperator = function (value) {
        return this.setNode('operator', value);
    };
    BinaryExpression.prototype.getOperator = function () {
        return this.operator;
    };
    return BinaryExpression;
}(Node));

var Term = /** @class */ (function (_super) {
    __extends(Term, _super);
    function Term(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Term.prototype, "type", {
        get: function () {
            return NodeType.Term;
        },
        enumerable: true,
        configurable: true
    });
    Term.prototype.setOperator = function (value) {
        return this.setNode('operator', value);
    };
    Term.prototype.getOperator = function () {
        return this.operator;
    };
    Term.prototype.setExpression = function (value) {
        return this.setNode('expression', value);
    };
    Term.prototype.getExpression = function () {
        return this.expression;
    };
    return Term;
}(Node));

var AttributeSelector = /** @class */ (function (_super) {
    __extends(AttributeSelector, _super);
    function AttributeSelector(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(AttributeSelector.prototype, "type", {
        get: function () {
            return NodeType.AttributeSelector;
        },
        enumerable: true,
        configurable: true
    });
    AttributeSelector.prototype.setNamespacePrefix = function (value) {
        return this.setNode('namespacePrefix', value);
    };
    AttributeSelector.prototype.getNamespacePrefix = function () {
        return this.namespacePrefix;
    };
    AttributeSelector.prototype.setIdentifier = function (value) {
        return this.setNode('identifier', value);
    };
    AttributeSelector.prototype.getIdentifier = function () {
        return this.identifier;
    };
    AttributeSelector.prototype.setOperator = function (operator) {
        return this.setNode('operator', operator);
    };
    AttributeSelector.prototype.getOperator = function () {
        return this.operator;
    };
    AttributeSelector.prototype.setValue = function (value) {
        return this.setNode('value', value);
    };
    AttributeSelector.prototype.getValue = function () {
        return this.value;
    };
    return AttributeSelector;
}(Node));

var Operator = /** @class */ (function (_super) {
    __extends(Operator, _super);
    function Operator(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Operator.prototype, "type", {
        get: function () {
            return NodeType.Operator;
        },
        enumerable: true,
        configurable: true
    });
    return Operator;
}(Node));

var HexColorValue = /** @class */ (function (_super) {
    __extends(HexColorValue, _super);
    function HexColorValue(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(HexColorValue.prototype, "type", {
        get: function () {
            return NodeType.HexColorValue;
        },
        enumerable: true,
        configurable: true
    });
    return HexColorValue;
}(Node));

var _dot = '.'.charCodeAt(0), _0 = '0'.charCodeAt(0), _9 = '9'.charCodeAt(0);
var NumericValue = /** @class */ (function (_super) {
    __extends(NumericValue, _super);
    function NumericValue(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(NumericValue.prototype, "type", {
        get: function () {
            return NodeType.NumericValue;
        },
        enumerable: true,
        configurable: true
    });
    NumericValue.prototype.getValue = function () {
        var raw = this.getText();
        var unitIdx = 0;
        var code;
        for (var i = 0, len = raw.length; i < len; i++) {
            code = raw.charCodeAt(i);
            if (!(_0 <= code && code <= _9 || code === _dot)) {
                break;
            }
            unitIdx += 1;
        }
        return {
            value: raw.substring(0, unitIdx),
            unit: unitIdx < raw.length ? raw.substring(unitIdx) : undefined
        };
    };
    return NumericValue;
}(Node));

var VariableDeclaration = /** @class */ (function (_super) {
    __extends(VariableDeclaration, _super);
    function VariableDeclaration(offset, length) {
        var _this = _super.call(this, offset, length) || this;
        _this.variable = null;
        _this.value = null;
        _this.needsSemicolon = true;
        return _this;
    }
    Object.defineProperty(VariableDeclaration.prototype, "type", {
        get: function () {
            return NodeType.VariableDeclaration;
        },
        enumerable: true,
        configurable: true
    });
    VariableDeclaration.prototype.setVariable = function (node) {
        if (node) {
            node.attachTo(this);
            this.variable = node;
            return true;
        }
        return false;
    };
    VariableDeclaration.prototype.getVariable = function () {
        return this.variable;
    };
    VariableDeclaration.prototype.getName = function () {
        return this.variable ? this.variable.getName() : '';
    };
    VariableDeclaration.prototype.setValue = function (node) {
        if (node) {
            node.attachTo(this);
            this.value = node;
            return true;
        }
        return false;
    };
    VariableDeclaration.prototype.getValue = function () {
        return this.value;
    };
    return VariableDeclaration;
}(AbstractDeclaration));

var Interpolation = /** @class */ (function (_super) {
    __extends(Interpolation, _super);
    // private _interpolations: void; // workaround for https://github.com/Microsoft/TypeScript/issues/18276
    function Interpolation(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Interpolation.prototype, "type", {
        get: function () {
            return NodeType.Interpolation;
        },
        enumerable: true,
        configurable: true
    });
    return Interpolation;
}(Node));

var Variable = /** @class */ (function (_super) {
    __extends(Variable, _super);
    function Variable(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Variable.prototype, "type", {
        get: function () {
            return NodeType.VariableName;
        },
        enumerable: true,
        configurable: true
    });
    Variable.prototype.getName = function () {
        return this.getText();
    };
    return Variable;
}(Node));

var ExtendsReference = /** @class */ (function (_super) {
    __extends(ExtendsReference, _super);
    function ExtendsReference(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(ExtendsReference.prototype, "type", {
        get: function () {
            return NodeType.ExtendsReference;
        },
        enumerable: true,
        configurable: true
    });
    ExtendsReference.prototype.getSelectors = function () {
        if (!this.selectors) {
            this.selectors = new Nodelist(this);
        }
        return this.selectors;
    };
    return ExtendsReference;
}(Node));

var MixinReference = /** @class */ (function (_super) {
    __extends(MixinReference, _super);
    function MixinReference(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(MixinReference.prototype, "type", {
        get: function () {
            return NodeType.MixinReference;
        },
        enumerable: true,
        configurable: true
    });
    MixinReference.prototype.getNamespaces = function () {
        if (!this.namespaces) {
            this.namespaces = new Nodelist(this);
        }
        return this.namespaces;
    };
    MixinReference.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    MixinReference.prototype.getIdentifier = function () {
        return this.identifier;
    };
    MixinReference.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    MixinReference.prototype.getArguments = function () {
        if (!this.arguments) {
            this.arguments = new Nodelist(this);
        }
        return this.arguments;
    };
    MixinReference.prototype.setContent = function (node) {
        return this.setNode('content', node);
    };
    MixinReference.prototype.getContent = function () {
        return this.content;
    };
    return MixinReference;
}(Node));

var MixinDeclaration = /** @class */ (function (_super) {
    __extends(MixinDeclaration, _super);
    function MixinDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(MixinDeclaration.prototype, "type", {
        get: function () {
            return NodeType.MixinDeclaration;
        },
        enumerable: true,
        configurable: true
    });
    MixinDeclaration.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    MixinDeclaration.prototype.getIdentifier = function () {
        return this.identifier;
    };
    MixinDeclaration.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    MixinDeclaration.prototype.getParameters = function () {
        if (!this.parameters) {
            this.parameters = new Nodelist(this);
        }
        return this.parameters;
    };
    MixinDeclaration.prototype.setGuard = function (node) {
        if (node) {
            node.attachTo(this);
            this.guard = node;
        }
        return false;
    };
    return MixinDeclaration;
}(BodyDeclaration));

var UnknownAtRule = /** @class */ (function (_super) {
    __extends(UnknownAtRule, _super);
    function UnknownAtRule(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(UnknownAtRule.prototype, "type", {
        get: function () {
            return NodeType.UnknownAtRule;
        },
        enumerable: true,
        configurable: true
    });
    UnknownAtRule.prototype.setAtRuleName = function (atRuleName) {
        this.atRuleName = atRuleName;
    };
    UnknownAtRule.prototype.getAtRuleName = function () {
        return this.atRuleName;
    };
    return UnknownAtRule;
}(BodyDeclaration));

var ListEntry = /** @class */ (function (_super) {
    __extends(ListEntry, _super);
    function ListEntry() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ListEntry.prototype, "type", {
        get: function () {
            return NodeType.ListEntry;
        },
        enumerable: true,
        configurable: true
    });
    ListEntry.prototype.setKey = function (node) {
        return this.setNode('key', node, 0);
    };
    ListEntry.prototype.setValue = function (node) {
        return this.setNode('value', node, 1);
    };
    return ListEntry;
}(Node));

var LessGuard = /** @class */ (function (_super) {
    __extends(LessGuard, _super);
    function LessGuard() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    LessGuard.prototype.getConditions = function () {
        if (!this.conditions) {
            this.conditions = new Nodelist(this);
        }
        return this.conditions;
    };
    return LessGuard;
}(Node));

var GuardCondition = /** @class */ (function (_super) {
    __extends(GuardCondition, _super);
    function GuardCondition() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GuardCondition.prototype.setVariable = function (node) {
        return this.setNode('variable', node);
    };
    return GuardCondition;
}(Node));

var Module = /** @class */ (function (_super) {
    __extends(Module, _super);
    function Module() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Module.prototype, "type", {
        get: function () {
            return NodeType.Module;
        },
        enumerable: true,
        configurable: true
    });
    Module.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Module.prototype.getIdentifier = function () {
        return this.identifier;
    };
    return Module;
}(Node));

var Level;
(function (Level) {
    Level[Level["Ignore"] = 1] = "Ignore";
    Level[Level["Warning"] = 2] = "Warning";
    Level[Level["Error"] = 4] = "Error";
})(Level || (Level = {}));
var Marker = /** @class */ (function () {
    function Marker(node, rule, level, message, offset, length) {
        if (offset === void 0) { offset = node.offset; }
        if (length === void 0) { length = node.length; }
        this.node = node;
        this.rule = rule;
        this.level = level;
        this.message = message || rule.message;
        this.offset = offset;
        this.length = length;
    }
    Marker.prototype.getRule = function () {
        return this.rule;
    };
    Marker.prototype.getLevel = function () {
        return this.level;
    };
    Marker.prototype.getOffset = function () {
        return this.offset;
    };
    Marker.prototype.getLength = function () {
        return this.length;
    };
    Marker.prototype.getNode = function () {
        return this.node;
    };
    Marker.prototype.getMessage = function () {
        return this.message;
    };
    return Marker;
}());

/*
export class DefaultVisitor implements IVisitor {

    public visitNode(node:Node):boolean {
        switch (node.type) {
            case NodeType.Stylesheet:
                return this.visitStylesheet(<Stylesheet> node);
            case NodeType.FontFace:
                return this.visitFontFace(<FontFace> node);
            case NodeType.Ruleset:
                return this.visitRuleSet(<RuleSet> node);
            case NodeType.Selector:
                return this.visitSelector(<Selector> node);
            case NodeType.SimpleSelector:
                return this.visitSimpleSelector(<SimpleSelector> node);
            case NodeType.Declaration:
                return this.visitDeclaration(<Declaration> node);
            case NodeType.Function:
                return this.visitFunction(<Function> node);
            case NodeType.FunctionDeclaration:
                return this.visitFunctionDeclaration(<FunctionDeclaration> node);
            case NodeType.FunctionParameter:
                return this.visitFunctionParameter(<FunctionParameter> node);
            case NodeType.FunctionArgument:
                return this.visitFunctionArgument(<FunctionArgument> node);
            case NodeType.Term:
                return this.visitTerm(<Term> node);
            case NodeType.Declaration:
                return this.visitExpression(<Expression> node);
            case NodeType.NumericValue:
                return this.visitNumericValue(<NumericValue> node);
            case NodeType.Page:
                return this.visitPage(<Page> node);
            case NodeType.PageBoxMarginBox:
                return this.visitPageBoxMarginBox(<PageBoxMarginBox> node);
            case NodeType.Property:
                return this.visitProperty(<Property> node);
            case NodeType.NumericValue:
                return this.visitNodelist(<Nodelist> node);
            case NodeType.Import:
                return this.visitImport(<Import> node);
            case NodeType.Namespace:
                return this.visitNamespace(<Namespace> node);
            case NodeType.Keyframe:
                return this.visitKeyframe(<Keyframe> node);
            case NodeType.KeyframeSelector:
                return this.visitKeyframeSelector(<KeyframeSelector> node);
            case NodeType.MixinDeclaration:
                return this.visitMixinDeclaration(<MixinDeclaration> node);
            case NodeType.MixinReference:
                return this.visitMixinReference(<MixinReference> node);
            case NodeType.Variable:
                return this.visitVariable(<Variable> node);
            case NodeType.VariableDeclaration:
                return this.visitVariableDeclaration(<VariableDeclaration> node);
        }
        return this.visitUnknownNode(node);
    }

    public visitFontFace(node:FontFace):boolean {
        return true;
    }

    public visitKeyframe(node:Keyframe):boolean {
        return true;
    }

    public visitKeyframeSelector(node:KeyframeSelector):boolean {
        return true;
    }

    public visitStylesheet(node:Stylesheet):boolean {
        return true;
    }

    public visitProperty(Node:Property):boolean {
        return true;
    }

    public visitRuleSet(node:RuleSet):boolean {
        return true;
    }

    public visitSelector(node:Selector):boolean {
        return true;
    }

    public visitSimpleSelector(node:SimpleSelector):boolean {
        return true;
    }

    public visitDeclaration(node:Declaration):boolean {
        return true;
    }

    public visitFunction(node:Function):boolean {
        return true;
    }

    public visitFunctionDeclaration(node:FunctionDeclaration):boolean {
        return true;
    }

    public visitInvocation(node:Invocation):boolean {
        return true;
    }

    public visitTerm(node:Term):boolean {
        return true;
    }

    public visitImport(node:Import):boolean {
        return true;
    }

    public visitNamespace(node:Namespace):boolean {
        return true;
    }

    public visitExpression(node:Expression):boolean {
        return true;
    }

    public visitNumericValue(node:NumericValue):boolean {
        return true;
    }

    public visitPage(node:Page):boolean {
        return true;
    }

    public visitPageBoxMarginBox(node:PageBoxMarginBox):boolean {
        return true;
    }

    public visitNodelist(node:Nodelist):boolean {
        return true;
    }

    public visitVariableDeclaration(node:VariableDeclaration):boolean {
        return true;
    }

    public visitVariable(node:Variable):boolean {
        return true;
    }

    public visitMixinDeclaration(node:MixinDeclaration):boolean {
        return true;
    }

    public visitMixinReference(node:MixinReference):boolean {
        return true;
    }

    public visitUnknownNode(node:Node):boolean {
        return true;
    }
}
*/
var ParseErrorCollector = /** @class */ (function () {
    function ParseErrorCollector() {
        this.entries = [];
    }
    ParseErrorCollector.entries = function (node) {
        var visitor = new ParseErrorCollector();
        node.acceptVisitor(visitor);
        return visitor.entries;
    };
    ParseErrorCollector.prototype.visitNode = function (node) {
        if (node.isErroneous()) {
            node.collectIssues(this.entries);
        }
        return true;
    };
    return ParseErrorCollector;
}());



/***/ }),

/***/ 757:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = loadMessageBundle;
/* unused harmony export config */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
function format(message, args) {
    var result;
    if (args.length === 0) {
        result = message;
    }
    else {
        result = message.replace(/\{(\d+)\}/g, function (match, rest) {
            var index = rest[0];
            return typeof args[index] !== 'undefined' ? args[index] : match;
        });
    }
    return result;
}
function localize(key, message) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    return format(message, args);
}
function loadMessageBundle(file) {
    return localize;
}
function config(opt) {
    return loadMessageBundle;
}


/***/ }),

/***/ 758:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export ClientCapabilities */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return FileType; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__ = __webpack_require__(785);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__deps_vscode_languageserver_textdocument_lib_esm_main_js__ = __webpack_require__(804);
/* unused harmony reexport TextDocument */
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["a"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["b"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "c", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["c"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "d", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["d"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "e", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["e"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "f", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["f"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "g", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["g"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "i", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["h"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "j", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["i"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "k", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["j"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "l", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "m", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["l"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "n", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["m"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "o", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["n"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "p", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["o"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "q", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["p"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "r", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["q"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "s", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["r"]; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/




var ClientCapabilities;
(function (ClientCapabilities) {
    ClientCapabilities.LATEST = {
        textDocument: {
            completion: {
                completionItem: {
                    documentationFormat: [__WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k" /* MarkupKind */].Markdown, __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k" /* MarkupKind */].PlainText]
                }
            },
            hover: {
                contentFormat: [__WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k" /* MarkupKind */].Markdown, __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k" /* MarkupKind */].PlainText]
            }
        }
    };
})(ClientCapabilities || (ClientCapabilities = {}));
var FileType;
(function (FileType) {
    /**
     * The file type is unknown.
     */
    FileType[FileType["Unknown"] = 0] = "Unknown";
    /**
     * A regular file.
     */
    FileType[FileType["File"] = 1] = "File";
    /**
     * A directory.
     */
    FileType[FileType["Directory"] = 2] = "Directory";
    /**
     * A symbolic link to a file.
     */
    FileType[FileType["SymbolicLink"] = 64] = "SymbolicLink";
})(FileType || (FileType = {}));


/***/ }),

/***/ 762:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return cssDataManager; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__data_webCustomData_js__ = __webpack_require__(800);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__dataManager_js__ = __webpack_require__(782);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__dataProvider_js__ = __webpack_require__(783);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__entry_js__ = __webpack_require__(801);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "j", function() { return __WEBPACK_IMPORTED_MODULE_3__entry_js__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__colors_js__ = __webpack_require__(802);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "c", function() { return __WEBPACK_IMPORTED_MODULE_4__colors_js__["a"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "d", function() { return __WEBPACK_IMPORTED_MODULE_4__colors_js__["b"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "e", function() { return __WEBPACK_IMPORTED_MODULE_4__colors_js__["c"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "i", function() { return __WEBPACK_IMPORTED_MODULE_4__colors_js__["d"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "k", function() { return __WEBPACK_IMPORTED_MODULE_4__colors_js__["e"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "n", function() { return __WEBPACK_IMPORTED_MODULE_4__colors_js__["f"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__builtinData_js__ = __webpack_require__(803);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["a"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["b"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "g", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["c"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "h", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["d"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "l", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["e"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "m", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["f"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "o", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["g"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "p", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["h"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "q", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["i"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "r", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["j"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "s", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["k"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "t", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["l"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "u", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["m"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "v", function() { return __WEBPACK_IMPORTED_MODULE_5__builtinData_js__["n"]; });
/* unused harmony namespace reexport */
/* unused harmony namespace reexport */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/









var cssDataManager = new __WEBPACK_IMPORTED_MODULE_1__dataManager_js__["a" /* CSSDataManager */]([
    new __WEBPACK_IMPORTED_MODULE_2__dataProvider_js__["a" /* CSSDataProvider */](__WEBPACK_IMPORTED_MODULE_0__data_webCustomData_js__["a" /* cssData */])
]);


/***/ }),

/***/ 764:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return TokenType; });
/* unused harmony export MultiLineStream */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Scanner; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var TokenType;
(function (TokenType) {
    TokenType[TokenType["Ident"] = 0] = "Ident";
    TokenType[TokenType["AtKeyword"] = 1] = "AtKeyword";
    TokenType[TokenType["String"] = 2] = "String";
    TokenType[TokenType["BadString"] = 3] = "BadString";
    TokenType[TokenType["UnquotedString"] = 4] = "UnquotedString";
    TokenType[TokenType["Hash"] = 5] = "Hash";
    TokenType[TokenType["Num"] = 6] = "Num";
    TokenType[TokenType["Percentage"] = 7] = "Percentage";
    TokenType[TokenType["Dimension"] = 8] = "Dimension";
    TokenType[TokenType["UnicodeRange"] = 9] = "UnicodeRange";
    TokenType[TokenType["CDO"] = 10] = "CDO";
    TokenType[TokenType["CDC"] = 11] = "CDC";
    TokenType[TokenType["Colon"] = 12] = "Colon";
    TokenType[TokenType["SemiColon"] = 13] = "SemiColon";
    TokenType[TokenType["CurlyL"] = 14] = "CurlyL";
    TokenType[TokenType["CurlyR"] = 15] = "CurlyR";
    TokenType[TokenType["ParenthesisL"] = 16] = "ParenthesisL";
    TokenType[TokenType["ParenthesisR"] = 17] = "ParenthesisR";
    TokenType[TokenType["BracketL"] = 18] = "BracketL";
    TokenType[TokenType["BracketR"] = 19] = "BracketR";
    TokenType[TokenType["Whitespace"] = 20] = "Whitespace";
    TokenType[TokenType["Includes"] = 21] = "Includes";
    TokenType[TokenType["Dashmatch"] = 22] = "Dashmatch";
    TokenType[TokenType["SubstringOperator"] = 23] = "SubstringOperator";
    TokenType[TokenType["PrefixOperator"] = 24] = "PrefixOperator";
    TokenType[TokenType["SuffixOperator"] = 25] = "SuffixOperator";
    TokenType[TokenType["Delim"] = 26] = "Delim";
    TokenType[TokenType["EMS"] = 27] = "EMS";
    TokenType[TokenType["EXS"] = 28] = "EXS";
    TokenType[TokenType["Length"] = 29] = "Length";
    TokenType[TokenType["Angle"] = 30] = "Angle";
    TokenType[TokenType["Time"] = 31] = "Time";
    TokenType[TokenType["Freq"] = 32] = "Freq";
    TokenType[TokenType["Exclamation"] = 33] = "Exclamation";
    TokenType[TokenType["Resolution"] = 34] = "Resolution";
    TokenType[TokenType["Comma"] = 35] = "Comma";
    TokenType[TokenType["Charset"] = 36] = "Charset";
    TokenType[TokenType["EscapedJavaScript"] = 37] = "EscapedJavaScript";
    TokenType[TokenType["BadEscapedJavaScript"] = 38] = "BadEscapedJavaScript";
    TokenType[TokenType["Comment"] = 39] = "Comment";
    TokenType[TokenType["SingleLineComment"] = 40] = "SingleLineComment";
    TokenType[TokenType["EOF"] = 41] = "EOF";
    TokenType[TokenType["CustomToken"] = 42] = "CustomToken";
})(TokenType || (TokenType = {}));
var MultiLineStream = /** @class */ (function () {
    function MultiLineStream(source) {
        this.source = source;
        this.len = source.length;
        this.position = 0;
    }
    MultiLineStream.prototype.substring = function (from, to) {
        if (to === void 0) { to = this.position; }
        return this.source.substring(from, to);
    };
    MultiLineStream.prototype.eos = function () {
        return this.len <= this.position;
    };
    MultiLineStream.prototype.pos = function () {
        return this.position;
    };
    MultiLineStream.prototype.goBackTo = function (pos) {
        this.position = pos;
    };
    MultiLineStream.prototype.goBack = function (n) {
        this.position -= n;
    };
    MultiLineStream.prototype.advance = function (n) {
        this.position += n;
    };
    MultiLineStream.prototype.nextChar = function () {
        return this.source.charCodeAt(this.position++) || 0;
    };
    MultiLineStream.prototype.peekChar = function (n) {
        if (n === void 0) { n = 0; }
        return this.source.charCodeAt(this.position + n) || 0;
    };
    MultiLineStream.prototype.lookbackChar = function (n) {
        if (n === void 0) { n = 0; }
        return this.source.charCodeAt(this.position - n) || 0;
    };
    MultiLineStream.prototype.advanceIfChar = function (ch) {
        if (ch === this.source.charCodeAt(this.position)) {
            this.position++;
            return true;
        }
        return false;
    };
    MultiLineStream.prototype.advanceIfChars = function (ch) {
        if (this.position + ch.length > this.source.length) {
            return false;
        }
        var i = 0;
        for (; i < ch.length; i++) {
            if (this.source.charCodeAt(this.position + i) !== ch[i]) {
                return false;
            }
        }
        this.advance(i);
        return true;
    };
    MultiLineStream.prototype.advanceWhileChar = function (condition) {
        var posNow = this.position;
        while (this.position < this.len && condition(this.source.charCodeAt(this.position))) {
            this.position++;
        }
        return this.position - posNow;
    };
    return MultiLineStream;
}());

var _a = 'a'.charCodeAt(0);
var _f = 'f'.charCodeAt(0);
var _z = 'z'.charCodeAt(0);
var _A = 'A'.charCodeAt(0);
var _F = 'F'.charCodeAt(0);
var _Z = 'Z'.charCodeAt(0);
var _0 = '0'.charCodeAt(0);
var _9 = '9'.charCodeAt(0);
var _TLD = '~'.charCodeAt(0);
var _HAT = '^'.charCodeAt(0);
var _EQS = '='.charCodeAt(0);
var _PIP = '|'.charCodeAt(0);
var _MIN = '-'.charCodeAt(0);
var _USC = '_'.charCodeAt(0);
var _PRC = '%'.charCodeAt(0);
var _MUL = '*'.charCodeAt(0);
var _LPA = '('.charCodeAt(0);
var _RPA = ')'.charCodeAt(0);
var _LAN = '<'.charCodeAt(0);
var _RAN = '>'.charCodeAt(0);
var _ATS = '@'.charCodeAt(0);
var _HSH = '#'.charCodeAt(0);
var _DLR = '$'.charCodeAt(0);
var _BSL = '\\'.charCodeAt(0);
var _FSL = '/'.charCodeAt(0);
var _NWL = '\n'.charCodeAt(0);
var _CAR = '\r'.charCodeAt(0);
var _LFD = '\f'.charCodeAt(0);
var _DQO = '"'.charCodeAt(0);
var _SQO = '\''.charCodeAt(0);
var _WSP = ' '.charCodeAt(0);
var _TAB = '\t'.charCodeAt(0);
var _SEM = ';'.charCodeAt(0);
var _COL = ':'.charCodeAt(0);
var _CUL = '{'.charCodeAt(0);
var _CUR = '}'.charCodeAt(0);
var _BRL = '['.charCodeAt(0);
var _BRR = ']'.charCodeAt(0);
var _CMA = ','.charCodeAt(0);
var _DOT = '.'.charCodeAt(0);
var _BNG = '!'.charCodeAt(0);
var staticTokenTable = {};
staticTokenTable[_SEM] = TokenType.SemiColon;
staticTokenTable[_COL] = TokenType.Colon;
staticTokenTable[_CUL] = TokenType.CurlyL;
staticTokenTable[_CUR] = TokenType.CurlyR;
staticTokenTable[_BRR] = TokenType.BracketR;
staticTokenTable[_BRL] = TokenType.BracketL;
staticTokenTable[_LPA] = TokenType.ParenthesisL;
staticTokenTable[_RPA] = TokenType.ParenthesisR;
staticTokenTable[_CMA] = TokenType.Comma;
var staticUnitTable = {};
staticUnitTable['em'] = TokenType.EMS;
staticUnitTable['ex'] = TokenType.EXS;
staticUnitTable['px'] = TokenType.Length;
staticUnitTable['cm'] = TokenType.Length;
staticUnitTable['mm'] = TokenType.Length;
staticUnitTable['in'] = TokenType.Length;
staticUnitTable['pt'] = TokenType.Length;
staticUnitTable['pc'] = TokenType.Length;
staticUnitTable['deg'] = TokenType.Angle;
staticUnitTable['rad'] = TokenType.Angle;
staticUnitTable['grad'] = TokenType.Angle;
staticUnitTable['ms'] = TokenType.Time;
staticUnitTable['s'] = TokenType.Time;
staticUnitTable['hz'] = TokenType.Freq;
staticUnitTable['khz'] = TokenType.Freq;
staticUnitTable['%'] = TokenType.Percentage;
staticUnitTable['fr'] = TokenType.Percentage;
staticUnitTable['dpi'] = TokenType.Resolution;
staticUnitTable['dpcm'] = TokenType.Resolution;
var Scanner = /** @class */ (function () {
    function Scanner() {
        this.stream = new MultiLineStream('');
        this.ignoreComment = true;
        this.ignoreWhitespace = true;
        this.inURL = false;
    }
    Scanner.prototype.setSource = function (input) {
        this.stream = new MultiLineStream(input);
    };
    Scanner.prototype.finishToken = function (offset, type, text) {
        return {
            offset: offset,
            len: this.stream.pos() - offset,
            type: type,
            text: text || this.stream.substring(offset)
        };
    };
    Scanner.prototype.substring = function (offset, len) {
        return this.stream.substring(offset, offset + len);
    };
    Scanner.prototype.pos = function () {
        return this.stream.pos();
    };
    Scanner.prototype.goBackTo = function (pos) {
        this.stream.goBackTo(pos);
    };
    Scanner.prototype.scanUnquotedString = function () {
        var offset = this.stream.pos();
        var content = [];
        if (this._unquotedString(content)) {
            return this.finishToken(offset, TokenType.UnquotedString, content.join(''));
        }
        return null;
    };
    Scanner.prototype.scan = function () {
        // processes all whitespaces and comments
        var triviaToken = this.trivia();
        if (triviaToken !== null) {
            return triviaToken;
        }
        var offset = this.stream.pos();
        // End of file/input
        if (this.stream.eos()) {
            return this.finishToken(offset, TokenType.EOF);
        }
        return this.scanNext(offset);
    };
    Scanner.prototype.scanNext = function (offset) {
        // CDO <!--
        if (this.stream.advanceIfChars([_LAN, _BNG, _MIN, _MIN])) {
            return this.finishToken(offset, TokenType.CDO);
        }
        // CDC -->
        if (this.stream.advanceIfChars([_MIN, _MIN, _RAN])) {
            return this.finishToken(offset, TokenType.CDC);
        }
        var content = [];
        if (this.ident(content)) {
            return this.finishToken(offset, TokenType.Ident, content.join(''));
        }
        // at-keyword
        if (this.stream.advanceIfChar(_ATS)) {
            content = ['@'];
            if (this._name(content)) {
                var keywordText = content.join('');
                if (keywordText === '@charset') {
                    return this.finishToken(offset, TokenType.Charset, keywordText);
                }
                return this.finishToken(offset, TokenType.AtKeyword, keywordText);
            }
            else {
                return this.finishToken(offset, TokenType.Delim);
            }
        }
        // hash
        if (this.stream.advanceIfChar(_HSH)) {
            content = ['#'];
            if (this._name(content)) {
                return this.finishToken(offset, TokenType.Hash, content.join(''));
            }
            else {
                return this.finishToken(offset, TokenType.Delim);
            }
        }
        // Important
        if (this.stream.advanceIfChar(_BNG)) {
            return this.finishToken(offset, TokenType.Exclamation);
        }
        // Numbers
        if (this._number()) {
            var pos = this.stream.pos();
            content = [this.stream.substring(offset, pos)];
            if (this.stream.advanceIfChar(_PRC)) {
                // Percentage 43%
                return this.finishToken(offset, TokenType.Percentage);
            }
            else if (this.ident(content)) {
                var dim = this.stream.substring(pos).toLowerCase();
                var tokenType_1 = staticUnitTable[dim];
                if (typeof tokenType_1 !== 'undefined') {
                    // Known dimension 43px
                    return this.finishToken(offset, tokenType_1, content.join(''));
                }
                else {
                    // Unknown dimension 43ft
                    return this.finishToken(offset, TokenType.Dimension, content.join(''));
                }
            }
            return this.finishToken(offset, TokenType.Num);
        }
        // String, BadString
        content = [];
        var tokenType = this._string(content);
        if (tokenType !== null) {
            return this.finishToken(offset, tokenType, content.join(''));
        }
        // single character tokens
        tokenType = staticTokenTable[this.stream.peekChar()];
        if (typeof tokenType !== 'undefined') {
            this.stream.advance(1);
            return this.finishToken(offset, tokenType);
        }
        // includes ~=
        if (this.stream.peekChar(0) === _TLD && this.stream.peekChar(1) === _EQS) {
            this.stream.advance(2);
            return this.finishToken(offset, TokenType.Includes);
        }
        // DashMatch |=
        if (this.stream.peekChar(0) === _PIP && this.stream.peekChar(1) === _EQS) {
            this.stream.advance(2);
            return this.finishToken(offset, TokenType.Dashmatch);
        }
        // Substring operator *=
        if (this.stream.peekChar(0) === _MUL && this.stream.peekChar(1) === _EQS) {
            this.stream.advance(2);
            return this.finishToken(offset, TokenType.SubstringOperator);
        }
        // Substring operator ^=
        if (this.stream.peekChar(0) === _HAT && this.stream.peekChar(1) === _EQS) {
            this.stream.advance(2);
            return this.finishToken(offset, TokenType.PrefixOperator);
        }
        // Substring operator $=
        if (this.stream.peekChar(0) === _DLR && this.stream.peekChar(1) === _EQS) {
            this.stream.advance(2);
            return this.finishToken(offset, TokenType.SuffixOperator);
        }
        // Delim
        this.stream.nextChar();
        return this.finishToken(offset, TokenType.Delim);
    };
    Scanner.prototype._matchWordAnyCase = function (characters) {
        var index = 0;
        this.stream.advanceWhileChar(function (ch) {
            var result = characters[index] === ch || characters[index + 1] === ch;
            if (result) {
                index += 2;
            }
            return result;
        });
        if (index === characters.length) {
            return true;
        }
        else {
            this.stream.goBack(index / 2);
            return false;
        }
    };
    Scanner.prototype.trivia = function () {
        while (true) {
            var offset = this.stream.pos();
            if (this._whitespace()) {
                if (!this.ignoreWhitespace) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
            }
            else if (this.comment()) {
                if (!this.ignoreComment) {
                    return this.finishToken(offset, TokenType.Comment);
                }
            }
            else {
                return null;
            }
        }
    };
    Scanner.prototype.comment = function () {
        if (this.stream.advanceIfChars([_FSL, _MUL])) {
            var success_1 = false, hot_1 = false;
            this.stream.advanceWhileChar(function (ch) {
                if (hot_1 && ch === _FSL) {
                    success_1 = true;
                    return false;
                }
                hot_1 = ch === _MUL;
                return true;
            });
            if (success_1) {
                this.stream.advance(1);
            }
            return true;
        }
        return false;
    };
    Scanner.prototype._number = function () {
        var npeek = 0, ch;
        if (this.stream.peekChar() === _DOT) {
            npeek = 1;
        }
        ch = this.stream.peekChar(npeek);
        if (ch >= _0 && ch <= _9) {
            this.stream.advance(npeek + 1);
            this.stream.advanceWhileChar(function (ch) {
                return ch >= _0 && ch <= _9 || npeek === 0 && ch === _DOT;
            });
            return true;
        }
        return false;
    };
    Scanner.prototype._newline = function (result) {
        var ch = this.stream.peekChar();
        switch (ch) {
            case _CAR:
            case _LFD:
            case _NWL:
                this.stream.advance(1);
                result.push(String.fromCharCode(ch));
                if (ch === _CAR && this.stream.advanceIfChar(_NWL)) {
                    result.push('\n');
                }
                return true;
        }
        return false;
    };
    Scanner.prototype._escape = function (result, includeNewLines) {
        var ch = this.stream.peekChar();
        if (ch === _BSL) {
            this.stream.advance(1);
            ch = this.stream.peekChar();
            var hexNumCount = 0;
            while (hexNumCount < 6 && (ch >= _0 && ch <= _9 || ch >= _a && ch <= _f || ch >= _A && ch <= _F)) {
                this.stream.advance(1);
                ch = this.stream.peekChar();
                hexNumCount++;
            }
            if (hexNumCount > 0) {
                try {
                    var hexVal = parseInt(this.stream.substring(this.stream.pos() - hexNumCount), 16);
                    if (hexVal) {
                        result.push(String.fromCharCode(hexVal));
                    }
                }
                catch (e) {
                    // ignore
                }
                // optional whitespace or new line, not part of result text
                if (ch === _WSP || ch === _TAB) {
                    this.stream.advance(1);
                }
                else {
                    this._newline([]);
                }
                return true;
            }
            if (ch !== _CAR && ch !== _LFD && ch !== _NWL) {
                this.stream.advance(1);
                result.push(String.fromCharCode(ch));
                return true;
            }
            else if (includeNewLines) {
                return this._newline(result);
            }
        }
        return false;
    };
    Scanner.prototype._stringChar = function (closeQuote, result) {
        // not closeQuote, not backslash, not newline
        var ch = this.stream.peekChar();
        if (ch !== 0 && ch !== closeQuote && ch !== _BSL && ch !== _CAR && ch !== _LFD && ch !== _NWL) {
            this.stream.advance(1);
            result.push(String.fromCharCode(ch));
            return true;
        }
        return false;
    };
    Scanner.prototype._string = function (result) {
        if (this.stream.peekChar() === _SQO || this.stream.peekChar() === _DQO) {
            var closeQuote = this.stream.nextChar();
            result.push(String.fromCharCode(closeQuote));
            while (this._stringChar(closeQuote, result) || this._escape(result, true)) {
                // loop
            }
            if (this.stream.peekChar() === closeQuote) {
                this.stream.nextChar();
                result.push(String.fromCharCode(closeQuote));
                return TokenType.String;
            }
            else {
                return TokenType.BadString;
            }
        }
        return null;
    };
    Scanner.prototype._unquotedChar = function (result) {
        // not closeQuote, not backslash, not newline
        var ch = this.stream.peekChar();
        if (ch !== 0 && ch !== _BSL && ch !== _SQO && ch !== _DQO && ch !== _LPA && ch !== _RPA && ch !== _WSP && ch !== _TAB && ch !== _NWL && ch !== _LFD && ch !== _CAR) {
            this.stream.advance(1);
            result.push(String.fromCharCode(ch));
            return true;
        }
        return false;
    };
    Scanner.prototype._unquotedString = function (result) {
        var hasContent = false;
        while (this._unquotedChar(result) || this._escape(result)) {
            hasContent = true;
        }
        return hasContent;
    };
    Scanner.prototype._whitespace = function () {
        var n = this.stream.advanceWhileChar(function (ch) {
            return ch === _WSP || ch === _TAB || ch === _NWL || ch === _LFD || ch === _CAR;
        });
        return n > 0;
    };
    Scanner.prototype._name = function (result) {
        var matched = false;
        while (this._identChar(result) || this._escape(result)) {
            matched = true;
        }
        return matched;
    };
    Scanner.prototype.ident = function (result) {
        var pos = this.stream.pos();
        var hasMinus = this._minus(result);
        if (hasMinus && this._minus(result) /* -- */) {
            if (this._identFirstChar(result) || this._escape(result)) {
                while (this._identChar(result) || this._escape(result)) {
                    // loop
                }
                return true;
            }
        }
        else if (this._identFirstChar(result) || this._escape(result)) {
            while (this._identChar(result) || this._escape(result)) {
                // loop
            }
            return true;
        }
        this.stream.goBackTo(pos);
        return false;
    };
    Scanner.prototype._identFirstChar = function (result) {
        var ch = this.stream.peekChar();
        if (ch === _USC || // _
            ch >= _a && ch <= _z || // a-z
            ch >= _A && ch <= _Z || // A-Z
            ch >= 0x80 && ch <= 0xFFFF) { // nonascii
            this.stream.advance(1);
            result.push(String.fromCharCode(ch));
            return true;
        }
        return false;
    };
    Scanner.prototype._minus = function (result) {
        var ch = this.stream.peekChar();
        if (ch === _MIN) {
            this.stream.advance(1);
            result.push(String.fromCharCode(ch));
            return true;
        }
        return false;
    };
    Scanner.prototype._identChar = function (result) {
        var ch = this.stream.peekChar();
        if (ch === _USC || // _
            ch === _MIN || // -
            ch >= _a && ch <= _z || // a-z
            ch >= _A && ch <= _Z || // A-Z
            ch >= _0 && ch <= _9 || // 0/9
            ch >= 0x80 && ch <= 0xFFFF) { // nonascii
            this.stream.advance(1);
            result.push(String.fromCharCode(ch));
            return true;
        }
        return false;
    };
    return Scanner;
}());



/***/ }),

/***/ 768:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["b"] = values;
/* harmony export (immutable) */ __webpack_exports__["a"] = isDefined;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

function values(obj) {
    return Object.keys(obj).map(function (key) { return obj[key]; });
}
function isDefined(obj) {
    return typeof obj !== 'undefined';
}


/***/ }),

/***/ 769:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["d"] = startsWith;
/* harmony export (immutable) */ __webpack_exports__["b"] = endsWith;
/* harmony export (immutable) */ __webpack_exports__["a"] = difference;
/* harmony export (immutable) */ __webpack_exports__["c"] = getLimitedString;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

function startsWith(haystack, needle) {
    if (haystack.length < needle.length) {
        return false;
    }
    for (var i = 0; i < needle.length; i++) {
        if (haystack[i] !== needle[i]) {
            return false;
        }
    }
    return true;
}
/**
 * Determines if haystack ends with needle.
 */
function endsWith(haystack, needle) {
    var diff = haystack.length - needle.length;
    if (diff > 0) {
        return haystack.lastIndexOf(needle) === diff;
    }
    else if (diff === 0) {
        return haystack === needle;
    }
    else {
        return false;
    }
}
/**
 * Computes the difference score for two strings. More similar strings have a higher score.
 * We use largest common subsequence dynamic programming approach but penalize in the end for length differences.
 * Strings that have a large length difference will get a bad default score 0.
 * Complexity - both time and space O(first.length * second.length)
 * Dynamic programming LCS computation http://en.wikipedia.org/wiki/Longest_common_subsequence_problem
 *
 * @param first a string
 * @param second a string
 */
function difference(first, second, maxLenDelta) {
    if (maxLenDelta === void 0) { maxLenDelta = 4; }
    var lengthDifference = Math.abs(first.length - second.length);
    // We only compute score if length of the currentWord and length of entry.name are similar.
    if (lengthDifference > maxLenDelta) {
        return 0;
    }
    // Initialize LCS (largest common subsequence) matrix.
    var LCS = [];
    var zeroArray = [];
    var i, j;
    for (i = 0; i < second.length + 1; ++i) {
        zeroArray.push(0);
    }
    for (i = 0; i < first.length + 1; ++i) {
        LCS.push(zeroArray);
    }
    for (i = 1; i < first.length + 1; ++i) {
        for (j = 1; j < second.length + 1; ++j) {
            if (first[i - 1] === second[j - 1]) {
                LCS[i][j] = LCS[i - 1][j - 1] + 1;
            }
            else {
                LCS[i][j] = Math.max(LCS[i - 1][j], LCS[i][j - 1]);
            }
        }
    }
    return LCS[first.length][second.length] - Math.sqrt(lengthDifference);
}
/**
 * Limit of string length.
 */
function getLimitedString(str, ellipsis) {
    if (ellipsis === void 0) { ellipsis = true; }
    if (!str) {
        return '';
    }
    if (str.length < 140) {
        return str;
    }
    return str.slice(0, 140) + (ellipsis ? '\u2026' : '');
}


/***/ }),

/***/ 771:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Parser; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__ = __webpack_require__(764);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__ = __webpack_require__(756);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__ = __webpack_require__(772);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__languageFacts_facts_js__ = __webpack_require__(762);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__utils_objects_js__ = __webpack_require__(768);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};





/// <summary>
/// A parser for the css core specification. See for reference:
/// https://www.w3.org/TR/CSS21/grammar.html
/// http://www.w3.org/TR/CSS21/syndata.html#tokenization
/// </summary>
var Parser = /** @class */ (function () {
    function Parser(scnr) {
        if (scnr === void 0) { scnr = new __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["a" /* Scanner */](); }
        this.keyframeRegex = /^@(\-(webkit|ms|moz|o)\-)?keyframes$/i;
        this.scanner = scnr;
        this.token = { type: __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF, offset: -1, len: 0, text: '' };
        this.prevToken = undefined;
    }
    Parser.prototype.peekIdent = function (text) {
        return __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident === this.token.type && text.length === this.token.text.length && text === this.token.text.toLowerCase();
    };
    Parser.prototype.peekKeyword = function (text) {
        return __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].AtKeyword === this.token.type && text.length === this.token.text.length && text === this.token.text.toLowerCase();
    };
    Parser.prototype.peekDelim = function (text) {
        return __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Delim === this.token.type && text === this.token.text;
    };
    Parser.prototype.peek = function (type) {
        return type === this.token.type;
    };
    Parser.prototype.peekRegExp = function (type, regEx) {
        if (type !== this.token.type) {
            return false;
        }
        return regEx.test(this.token.text);
    };
    Parser.prototype.hasWhitespace = function () {
        return !!this.prevToken && (this.prevToken.offset + this.prevToken.len !== this.token.offset);
    };
    Parser.prototype.consumeToken = function () {
        this.prevToken = this.token;
        this.token = this.scanner.scan();
    };
    Parser.prototype.mark = function () {
        return {
            prev: this.prevToken,
            curr: this.token,
            pos: this.scanner.pos()
        };
    };
    Parser.prototype.restoreAtMark = function (mark) {
        this.prevToken = mark.prev;
        this.token = mark.curr;
        this.scanner.goBackTo(mark.pos);
    };
    Parser.prototype.try = function (func) {
        var pos = this.mark();
        var node = func();
        if (!node) {
            this.restoreAtMark(pos);
            return null;
        }
        return node;
    };
    Parser.prototype.acceptOneKeyword = function (keywords) {
        if (__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].AtKeyword === this.token.type) {
            for (var _i = 0, keywords_1 = keywords; _i < keywords_1.length; _i++) {
                var keyword = keywords_1[_i];
                if (keyword.length === this.token.text.length && keyword === this.token.text.toLowerCase()) {
                    this.consumeToken();
                    return true;
                }
            }
        }
        return false;
    };
    Parser.prototype.accept = function (type) {
        if (type === this.token.type) {
            this.consumeToken();
            return true;
        }
        return false;
    };
    Parser.prototype.acceptIdent = function (text) {
        if (this.peekIdent(text)) {
            this.consumeToken();
            return true;
        }
        return false;
    };
    Parser.prototype.acceptKeyword = function (text) {
        if (this.peekKeyword(text)) {
            this.consumeToken();
            return true;
        }
        return false;
    };
    Parser.prototype.acceptDelim = function (text) {
        if (this.peekDelim(text)) {
            this.consumeToken();
            return true;
        }
        return false;
    };
    Parser.prototype.acceptRegexp = function (regEx) {
        if (regEx.test(this.token.text)) {
            this.consumeToken();
            return true;
        }
        return false;
    };
    Parser.prototype._parseRegexp = function (regEx) {
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Identifier);
        do { } while (this.acceptRegexp(regEx));
        return this.finish(node);
    };
    Parser.prototype.acceptUnquotedString = function () {
        var pos = this.scanner.pos();
        this.scanner.goBackTo(this.token.offset);
        var unquoted = this.scanner.scanUnquotedString();
        if (unquoted) {
            this.token = unquoted;
            this.consumeToken();
            return true;
        }
        this.scanner.goBackTo(pos);
        return false;
    };
    Parser.prototype.resync = function (resyncTokens, resyncStopTokens) {
        while (true) {
            if (resyncTokens && resyncTokens.indexOf(this.token.type) !== -1) {
                this.consumeToken();
                return true;
            }
            else if (resyncStopTokens && resyncStopTokens.indexOf(this.token.type) !== -1) {
                return true;
            }
            else {
                if (this.token.type === __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF) {
                    return false;
                }
                this.token = this.scanner.scan();
            }
        }
    };
    Parser.prototype.createNode = function (nodeType) {
        return new __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */](this.token.offset, this.token.len, nodeType);
    };
    Parser.prototype.create = function (ctor) {
        return new ctor(this.token.offset, this.token.len);
    };
    Parser.prototype.finish = function (node, error, resyncTokens, resyncStopTokens) {
        // parseNumeric misuses error for boolean flagging (however the real error mustn't be a false)
        // + nodelist offsets mustn't be modified, because there is a offset hack in rulesets for smartselection
        if (!(node instanceof __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["T" /* Nodelist */])) {
            if (error) {
                this.markError(node, error, resyncTokens, resyncStopTokens);
            }
            // set the node end position
            if (this.prevToken) {
                // length with more elements belonging together
                var prevEnd = this.prevToken.offset + this.prevToken.len;
                node.length = prevEnd > node.offset ? prevEnd - node.offset : 0; // offset is taken from current token, end from previous: Use 0 for empty nodes
            }
        }
        return node;
    };
    Parser.prototype.markError = function (node, error, resyncTokens, resyncStopTokens) {
        if (this.token !== this.lastErrorToken) { // do not report twice on the same token
            node.addIssue(new __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["H" /* Marker */](node, error, __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["F" /* Level */].Error, undefined, this.token.offset, this.token.len));
            this.lastErrorToken = this.token;
        }
        if (resyncTokens || resyncStopTokens) {
            this.resync(resyncTokens, resyncStopTokens);
        }
    };
    Parser.prototype.parseStylesheet = function (textDocument) {
        var versionId = textDocument.version;
        var text = textDocument.getText();
        var textProvider = function (offset, length) {
            if (textDocument.version !== versionId) {
                throw new Error('Underlying model has changed, AST is no longer valid');
            }
            return text.substr(offset, length);
        };
        return this.internalParse(text, this._parseStylesheet, textProvider);
    };
    Parser.prototype.internalParse = function (input, parseFunc, textProvider) {
        this.scanner.setSource(input);
        this.token = this.scanner.scan();
        var node = parseFunc.bind(this)();
        if (node) {
            if (textProvider) {
                node.textProvider = textProvider;
            }
            else {
                node.textProvider = function (offset, length) { return input.substr(offset, length); };
            }
        }
        return node;
    };
    Parser.prototype._parseStylesheet = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_3" /* Stylesheet */]);
        while (node.addChild(this._parseStylesheetStart())) {
            // Parse statements only valid at the beginning of stylesheets.
        }
        var inRecovery = false;
        do {
            var hasMatch = false;
            do {
                hasMatch = false;
                var statement = this._parseStylesheetStatement();
                if (statement) {
                    node.addChild(statement);
                    hasMatch = true;
                    inRecovery = false;
                    if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF) && this._needsSemicolonAfter(statement) && !this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon)) {
                        this.markError(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].SemiColonExpected);
                    }
                }
                while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon) || this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CDO) || this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CDC)) {
                    // accept empty statements
                    hasMatch = true;
                    inRecovery = false;
                }
            } while (hasMatch);
            if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF)) {
                break;
            }
            if (!inRecovery) {
                if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].AtKeyword)) {
                    this.markError(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].UnknownAtRule);
                }
                else {
                    this.markError(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RuleOrSelectorExpected);
                }
                inRecovery = true;
            }
            this.consumeToken();
        } while (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF));
        return this.finish(node);
    };
    Parser.prototype._parseStylesheetStart = function () {
        return this._parseCharset();
    };
    Parser.prototype._parseStylesheetStatement = function (isNested) {
        if (isNested === void 0) { isNested = false; }
        if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].AtKeyword)) {
            return this._parseStylesheetAtStatement(isNested);
        }
        return this._parseRuleset(isNested);
    };
    Parser.prototype._parseStylesheetAtStatement = function (isNested) {
        if (isNested === void 0) { isNested = false; }
        return this._parseImport()
            || this._parseMedia(isNested)
            || this._parsePage()
            || this._parseFontFace()
            || this._parseKeyframe()
            || this._parseSupports(isNested)
            || this._parseViewPort()
            || this._parseNamespace()
            || this._parseDocument()
            || this._parseUnknownAtRule();
    };
    Parser.prototype._tryParseRuleset = function (isNested) {
        var mark = this.mark();
        if (this._parseSelector(isNested)) {
            while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma) && this._parseSelector(isNested)) {
                // loop
            }
            if (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL)) {
                this.restoreAtMark(mark);
                return this._parseRuleset(isNested);
            }
        }
        this.restoreAtMark(mark);
        return null;
    };
    Parser.prototype._parseRuleset = function (isNested) {
        if (isNested === void 0) { isNested = false; }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_0" /* RuleSet */]);
        var selectors = node.getSelectors();
        if (!selectors.addChild(this._parseSelector(isNested))) {
            return null;
        }
        while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma)) {
            if (!selectors.addChild(this._parseSelector(isNested))) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].SelectorExpected);
            }
        }
        return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    };
    Parser.prototype._parseRuleSetDeclaration = function () {
        // https://www.w3.org/TR/css-syntax-3/#consume-a-list-of-declarations0
        return this._parseAtApply()
            || this._tryParseCustomPropertyDeclaration()
            || this._parseDeclaration()
            || this._parseUnknownAtRule();
    };
    /**
     * Parses declarations like:
     *   @apply --my-theme;
     *
     * Follows https://tabatkins.github.io/specs/css-apply-rule/#using
     */
    Parser.prototype._parseAtApply = function () {
        if (!this.peekKeyword('@apply')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["b" /* AtApplyRule */]);
        this.consumeToken();
        if (!node.setIdentifier(this._parseIdent([__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["Z" /* ReferenceType */].Variable]))) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._needsSemicolonAfter = function (node) {
        switch (node.type) {
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Keyframe:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].ViewPort:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Media:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Ruleset:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Namespace:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].If:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].For:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Each:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].While:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].MixinDeclaration:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].FunctionDeclaration:
                return false;
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].ExtendsReference:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].MixinContent:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].ReturnStatement:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].MediaQuery:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Debug:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Import:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].AtApplyRule:
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].CustomPropertyDeclaration:
                return true;
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].VariableDeclaration:
                return node.needsSemicolon;
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].MixinReference:
                return !node.getContent();
            case __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Declaration:
                return !node.getNestedProperties();
        }
        return false;
    };
    Parser.prototype._parseDeclarations = function (parseDeclaration) {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["i" /* Declarations */]);
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL)) {
            return null;
        }
        var decl = parseDeclaration();
        while (node.addChild(decl)) {
            if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyR)) {
                break;
            }
            if (this._needsSemicolonAfter(decl) && !this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon)) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].SemiColonExpected, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon, __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyR]);
            }
            // We accepted semicolon token. Link it to declaration.
            if (decl && this.prevToken && this.prevToken.type === __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon) {
                decl.semicolonPosition = this.prevToken.offset;
            }
            while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon)) {
                // accept empty statements
            }
            decl = parseDeclaration();
        }
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyR)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightCurlyExpected, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyR, __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon]);
        }
        return this.finish(node);
    };
    Parser.prototype._parseBody = function (node, parseDeclaration) {
        if (!node.setDeclarations(this._parseDeclarations(parseDeclaration))) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftCurlyExpected, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyR, __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon]);
        }
        return this.finish(node);
    };
    Parser.prototype._parseSelector = function (isNested) {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_1" /* Selector */]);
        var hasContent = false;
        if (isNested) {
            // nested selectors can start with a combinator
            hasContent = node.addChild(this._parseCombinator());
        }
        while (node.addChild(this._parseSimpleSelector())) {
            hasContent = true;
            node.addChild(this._parseCombinator()); // optional
        }
        return hasContent ? this.finish(node) : null;
    };
    Parser.prototype._parseDeclaration = function (resyncStopTokens) {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["h" /* Declaration */]);
        if (!node.setProperty(this._parseProperty())) {
            return null;
        }
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon)) {
            var stopTokens = resyncStopTokens ? __spreadArrays(resyncStopTokens, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon]) : [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon];
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].ColonExpected, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon], stopTokens);
        }
        if (this.prevToken) {
            node.colonPosition = this.prevToken.offset;
        }
        if (!node.setValue(this._parseExpr())) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].PropertyValueExpected);
        }
        node.addChild(this._parsePrio());
        if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon)) {
            node.semicolonPosition = this.token.offset; // not part of the declaration, but useful information for code assist
        }
        return this.finish(node);
    };
    Parser.prototype._tryParseCustomPropertyDeclaration = function () {
        if (!this.peekRegExp(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident, /^--/)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["f" /* CustomPropertyDeclaration */]);
        if (!node.setProperty(this._parseProperty())) {
            return null;
        }
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].ColonExpected, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon]);
        }
        if (this.prevToken) {
            node.colonPosition = this.prevToken.offset;
        }
        var mark = this.mark();
        if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL)) {
            // try to parse it as nested declaration
            var propertySet = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["g" /* CustomPropertySet */]);
            var declarations = this._parseDeclarations(this._parseRuleSetDeclaration.bind(this));
            if (propertySet.setDeclarations(declarations) && !declarations.isErroneous(true)) {
                propertySet.addChild(this._parsePrio());
                if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon)) {
                    this.finish(propertySet);
                    node.setPropertySet(propertySet);
                    node.semicolonPosition = this.token.offset; // not part of the declaration, but useful information for code assist
                    return this.finish(node);
                }
            }
            this.restoreAtMark(mark);
        }
        // try tp parse as expression
        var expression = this._parseExpr();
        if (expression && !expression.isErroneous(true)) {
            this._parsePrio();
            if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon)) {
                node.setValue(expression);
                node.semicolonPosition = this.token.offset; // not part of the declaration, but useful information for code assist
                return this.finish(node);
            }
        }
        this.restoreAtMark(mark);
        node.addChild(this._parseCustomPropertyValue());
        node.addChild(this._parsePrio());
        if (Object(__WEBPACK_IMPORTED_MODULE_4__utils_objects_js__["a" /* isDefined */])(node.colonPosition) && this.token.offset === node.colonPosition + 1) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].PropertyValueExpected);
        }
        return this.finish(node);
    };
    /**
     * Parse custom property values.
     *
     * Based on https://www.w3.org/TR/css-variables/#syntax
     *
     * This code is somewhat unusual, as the allowed syntax is incredibly broad,
     * parsing almost any sequence of tokens, save for a small set of exceptions.
     * Unbalanced delimitors, invalid tokens, and declaration
     * terminators like semicolons and !important directives (when not inside
     * of delimitors).
     */
    Parser.prototype._parseCustomPropertyValue = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        var isTopLevel = function () { return curlyDepth === 0 && parensDepth === 0 && bracketsDepth === 0; };
        var curlyDepth = 0;
        var parensDepth = 0;
        var bracketsDepth = 0;
        done: while (true) {
            switch (this.token.type) {
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon:
                    // A semicolon only ends things if we're not inside a delimitor.
                    if (isTopLevel()) {
                        break done;
                    }
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Exclamation:
                    // An exclamation ends the value if we're not inside delims.
                    if (isTopLevel()) {
                        break done;
                    }
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL:
                    curlyDepth++;
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyR:
                    curlyDepth--;
                    if (curlyDepth < 0) {
                        // The property value has been terminated without a semicolon, and
                        // this is the last declaration in the ruleset.
                        if (parensDepth === 0 && bracketsDepth === 0) {
                            break done;
                        }
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftCurlyExpected);
                    }
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL:
                    parensDepth++;
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR:
                    parensDepth--;
                    if (parensDepth < 0) {
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftParenthesisExpected);
                    }
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BracketL:
                    bracketsDepth++;
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BracketR:
                    bracketsDepth--;
                    if (bracketsDepth < 0) {
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftSquareBracketExpected);
                    }
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BadString: // fall through
                    break done;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF:
                    // We shouldn't have reached the end of input, something is
                    // unterminated.
                    var error = __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightCurlyExpected;
                    if (bracketsDepth > 0) {
                        error = __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightSquareBracketExpected;
                    }
                    else if (parensDepth > 0) {
                        error = __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected;
                    }
                    return this.finish(node, error);
            }
            this.consumeToken();
        }
        return this.finish(node);
    };
    Parser.prototype._tryToParseDeclaration = function () {
        var mark = this.mark();
        if (this._parseProperty() && this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon)) {
            // looks like a declaration, go ahead
            this.restoreAtMark(mark);
            return this._parseDeclaration();
        }
        this.restoreAtMark(mark);
        return null;
    };
    Parser.prototype._parseProperty = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["Y" /* Property */]);
        var mark = this.mark();
        if (this.acceptDelim('*') || this.acceptDelim('_')) {
            // support for  IE 5.x, 6 and 7 star hack: see http://en.wikipedia.org/wiki/CSS_filter#Star_hack
            if (this.hasWhitespace()) {
                this.restoreAtMark(mark);
                return null;
            }
        }
        if (node.setIdentifier(this._parsePropertyIdentifier())) {
            return this.finish(node);
        }
        return null;
    };
    Parser.prototype._parsePropertyIdentifier = function () {
        return this._parseIdent();
    };
    Parser.prototype._parseCharset = function () {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Charset)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        this.consumeToken(); // charset
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].String)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
        }
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].SemiColonExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._parseImport = function () {
        if (!this.peekKeyword('@import')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["A" /* Import */]);
        this.consumeToken(); // @import
        if (!node.addChild(this._parseURILiteral()) && !node.addChild(this._parseStringLiteral())) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].URIOrStringExpected);
        }
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon) && !this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF)) {
            node.setMedialist(this._parseMediaQueryList());
        }
        return this.finish(node);
    };
    Parser.prototype._parseNamespace = function () {
        // http://www.w3.org/TR/css3-namespace/
        // namespace  : NAMESPACE_SYM S* [IDENT S*]? [STRING|URI] S* ';' S*
        if (!this.peekKeyword('@namespace')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["P" /* Namespace */]);
        this.consumeToken(); // @namespace
        if (!node.addChild(this._parseURILiteral())) { // url literal also starts with ident
            node.addChild(this._parseIdent()); // optional prefix
            if (!node.addChild(this._parseURILiteral()) && !node.addChild(this._parseStringLiteral())) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].URIExpected, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon]);
            }
        }
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].SemiColonExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._parseFontFace = function () {
        if (!this.peekKeyword('@font-face')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["o" /* FontFace */]);
        this.consumeToken(); // @font-face
        return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    };
    Parser.prototype._parseViewPort = function () {
        if (!this.peekKeyword('@-ms-viewport') &&
            !this.peekKeyword('@-o-viewport') &&
            !this.peekKeyword('@viewport')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_11" /* ViewPort */]);
        this.consumeToken(); // @-ms-viewport
        return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    };
    Parser.prototype._parseKeyframe = function () {
        if (!this.peekRegExp(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].AtKeyword, this.keyframeRegex)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["C" /* Keyframe */]);
        var atNode = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        this.consumeToken(); // atkeyword
        node.setKeyword(this.finish(atNode));
        if (atNode.matches('@-ms-keyframes')) { // -ms-keyframes never existed
            this.markError(atNode, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].UnknownKeyword);
        }
        if (!node.setIdentifier(this._parseKeyframeIdent())) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyR]);
        }
        return this._parseBody(node, this._parseKeyframeSelector.bind(this));
    };
    Parser.prototype._parseKeyframeIdent = function () {
        return this._parseIdent([__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["Z" /* ReferenceType */].Keyframe]);
    };
    Parser.prototype._parseKeyframeSelector = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["D" /* KeyframeSelector */]);
        if (!node.addChild(this._parseIdent()) && !this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Percentage)) {
            return null;
        }
        while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma)) {
            if (!node.addChild(this._parseIdent()) && !this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Percentage)) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].PercentageExpected);
            }
        }
        return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    };
    Parser.prototype._tryParseKeyframeSelector = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["D" /* KeyframeSelector */]);
        var pos = this.mark();
        if (!node.addChild(this._parseIdent()) && !this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Percentage)) {
            return null;
        }
        while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma)) {
            if (!node.addChild(this._parseIdent()) && !this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Percentage)) {
                this.restoreAtMark(pos);
                return null;
            }
        }
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL)) {
            this.restoreAtMark(pos);
            return null;
        }
        return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    };
    Parser.prototype._parseSupports = function (isNested) {
        if (isNested === void 0) { isNested = false; }
        // SUPPORTS_SYM S* supports_condition '{' S* ruleset* '}' S*
        if (!this.peekKeyword('@supports')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_4" /* Supports */]);
        this.consumeToken(); // @supports
        node.addChild(this._parseSupportsCondition());
        return this._parseBody(node, this._parseSupportsDeclaration.bind(this, isNested));
    };
    Parser.prototype._parseSupportsDeclaration = function (isNested) {
        if (isNested === void 0) { isNested = false; }
        if (isNested) {
            // if nested, the body can contain rulesets, but also declarations
            return this._tryParseRuleset(true)
                || this._tryToParseDeclaration()
                || this._parseStylesheetStatement(true);
        }
        return this._parseStylesheetStatement(false);
    };
    Parser.prototype._parseSupportsCondition = function () {
        // supports_condition : supports_negation | supports_conjunction | supports_disjunction | supports_condition_in_parens ;
        // supports_condition_in_parens: ( '(' S* supports_condition S* ')' ) | supports_declaration_condition | general_enclosed ;
        // supports_negation: NOT S+ supports_condition_in_parens ;
        // supports_conjunction: supports_condition_in_parens ( S+ AND S+ supports_condition_in_parens )+;
        // supports_disjunction: supports_condition_in_parens ( S+ OR S+ supports_condition_in_parens )+;
        // supports_declaration_condition: '(' S* declaration ')';
        // general_enclosed: ( FUNCTION | '(' ) ( any | unused )* ')' ;
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_5" /* SupportsCondition */]);
        if (this.acceptIdent('not')) {
            node.addChild(this._parseSupportsConditionInParens());
        }
        else {
            node.addChild(this._parseSupportsConditionInParens());
            if (this.peekRegExp(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident, /^(and|or)$/i)) {
                var text = this.token.text.toLowerCase();
                while (this.acceptIdent(text)) {
                    node.addChild(this._parseSupportsConditionInParens());
                }
            }
        }
        return this.finish(node);
    };
    Parser.prototype._parseSupportsConditionInParens = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_5" /* SupportsCondition */]);
        if (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL)) {
            if (this.prevToken) {
                node.lParent = this.prevToken.offset;
            }
            if (!node.addChild(this._tryToParseDeclaration())) {
                if (!this._parseSupportsCondition()) {
                    return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].ConditionExpected);
                }
            }
            if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR)) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected, [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR], []);
            }
            if (this.prevToken) {
                node.rParent = this.prevToken.offset;
            }
            return this.finish(node);
        }
        else if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident)) {
            var pos = this.mark();
            this.consumeToken();
            if (!this.hasWhitespace() && this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL)) {
                var openParentCount = 1;
                while (this.token.type !== __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF && openParentCount !== 0) {
                    if (this.token.type === __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL) {
                        openParentCount++;
                    }
                    else if (this.token.type === __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR) {
                        openParentCount--;
                    }
                    this.consumeToken();
                }
                return this.finish(node);
            }
            else {
                this.restoreAtMark(pos);
            }
        }
        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftParenthesisExpected, [], [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL]);
    };
    Parser.prototype._parseMediaDeclaration = function (isNested) {
        if (isNested === void 0) { isNested = false; }
        if (isNested) {
            // if nested, the body can contain rulesets, but also declarations
            return this._tryParseRuleset(true)
                || this._tryToParseDeclaration()
                || this._parseStylesheetStatement(true);
        }
        return this._parseStylesheetStatement(false);
    };
    Parser.prototype._parseMedia = function (isNested) {
        if (isNested === void 0) { isNested = false; }
        // MEDIA_SYM S* media_query_list '{' S* ruleset* '}' S*
        // media_query_list : S* [media_query [ ',' S* media_query ]* ]?
        if (!this.peekKeyword('@media')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["I" /* Media */]);
        this.consumeToken(); // @media
        if (!node.addChild(this._parseMediaQueryList())) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].MediaQueryExpected);
        }
        return this._parseBody(node, this._parseMediaDeclaration.bind(this, isNested));
    };
    Parser.prototype._parseMediaQueryList = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["K" /* Medialist */]);
        if (!node.addChild(this._parseMediaQuery([__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL]))) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].MediaQueryExpected);
        }
        while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma)) {
            if (!node.addChild(this._parseMediaQuery([__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL]))) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].MediaQueryExpected);
            }
        }
        return this.finish(node);
    };
    Parser.prototype._parseMediaQuery = function (resyncStopToken) {
        // http://www.w3.org/TR/css3-mediaqueries/
        // media_query : [ONLY | NOT]? S* IDENT S* [ AND S* expression ]* | expression [ AND S* expression ]*
        // expression : '(' S* IDENT S* [ ':' S* expr ]? ')' S*
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["J" /* MediaQuery */]);
        var parseExpression = true;
        var hasContent = false;
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL)) {
            if (this.acceptIdent('only') || this.acceptIdent('not')) {
                // optional
            }
            if (!node.addChild(this._parseIdent())) {
                return null;
            }
            hasContent = true;
            parseExpression = this.acceptIdent('and');
        }
        while (parseExpression) {
            // Allow short-circuting for other language constructs.
            if (node.addChild(this._parseMediaContentStart())) {
                parseExpression = this.acceptIdent('and');
                continue;
            }
            if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL)) {
                if (hasContent) {
                    return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftParenthesisExpected, [], resyncStopToken);
                }
                return null;
            }
            if (!node.addChild(this._parseMediaFeatureName())) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected, [], resyncStopToken);
            }
            if (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon)) {
                if (!node.addChild(this._parseExpr())) {
                    return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].TermExpected, [], resyncStopToken);
                }
            }
            if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR)) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected, [], resyncStopToken);
            }
            parseExpression = this.acceptIdent('and');
        }
        return this.finish(node);
    };
    Parser.prototype._parseMediaContentStart = function () {
        return null;
    };
    Parser.prototype._parseMediaFeatureName = function () {
        return this._parseIdent();
    };
    Parser.prototype._parseMedium = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        if (node.addChild(this._parseIdent())) {
            return this.finish(node);
        }
        else {
            return null;
        }
    };
    Parser.prototype._parsePageDeclaration = function () {
        return this._parsePageMarginBox() || this._parseRuleSetDeclaration();
    };
    Parser.prototype._parsePage = function () {
        // http://www.w3.org/TR/css3-page/
        // page_rule : PAGE_SYM S* page_selector_list '{' S* page_body '}' S*
        // page_body :  /* Can be empty */ declaration? [ ';' S* page_body ]? | page_margin_box page_body
        if (!this.peekKeyword('@page')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["V" /* Page */]);
        this.consumeToken();
        if (node.addChild(this._parsePageSelector())) {
            while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma)) {
                if (!node.addChild(this._parsePageSelector())) {
                    return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
                }
            }
        }
        return this._parseBody(node, this._parsePageDeclaration.bind(this));
    };
    Parser.prototype._parsePageMarginBox = function () {
        // page_margin_box :  margin_sym S* '{' S* declaration? [ ';' S* declaration? ]* '}' S*
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].AtKeyword)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["W" /* PageBoxMarginBox */]);
        if (!this.acceptOneKeyword(__WEBPACK_IMPORTED_MODULE_3__languageFacts_facts_js__["q" /* pageBoxDirectives */])) {
            this.markError(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].UnknownAtRule, [], [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL]);
        }
        return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    };
    Parser.prototype._parsePageSelector = function () {
        // page_selector : pseudo_page+ | IDENT pseudo_page*
        // pseudo_page :  ':' [ "left" | "right" | "first" | "blank" ];
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident) && !this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        node.addChild(this._parseIdent()); // optional ident
        if (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon)) {
            if (!node.addChild(this._parseIdent())) { // optional ident
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
            }
        }
        return this.finish(node);
    };
    Parser.prototype._parseDocument = function () {
        // -moz-document is experimental but has been pushed to css4
        if (!this.peekKeyword('@-moz-document')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["j" /* Document */]);
        this.consumeToken(); // @-moz-document
        this.resync([], [__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL]); // ignore all the rules
        return this._parseBody(node, this._parseStylesheetStatement.bind(this));
    };
    // https://www.w3.org/TR/css-syntax-3/#consume-an-at-rule
    Parser.prototype._parseUnknownAtRule = function () {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].AtKeyword)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_7" /* UnknownAtRule */]);
        node.addChild(this._parseUnknownAtRuleName());
        var isTopLevel = function () { return curlyDepth === 0 && parensDepth === 0 && bracketsDepth === 0; };
        var curlyLCount = 0;
        var curlyDepth = 0;
        var parensDepth = 0;
        var bracketsDepth = 0;
        done: while (true) {
            switch (this.token.type) {
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SemiColon:
                    if (isTopLevel()) {
                        break done;
                    }
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EOF:
                    if (curlyDepth > 0) {
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightCurlyExpected);
                    }
                    else if (bracketsDepth > 0) {
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightSquareBracketExpected);
                    }
                    else if (parensDepth > 0) {
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected);
                    }
                    else {
                        return this.finish(node);
                    }
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyL:
                    curlyLCount++;
                    curlyDepth++;
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CurlyR:
                    curlyDepth--;
                    // End of at-rule, consume CurlyR and return node
                    if (curlyLCount > 0 && curlyDepth === 0) {
                        this.consumeToken();
                        if (bracketsDepth > 0) {
                            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightSquareBracketExpected);
                        }
                        else if (parensDepth > 0) {
                            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected);
                        }
                        break done;
                    }
                    if (curlyDepth < 0) {
                        // The property value has been terminated without a semicolon, and
                        // this is the last declaration in the ruleset.
                        if (parensDepth === 0 && bracketsDepth === 0) {
                            break done;
                        }
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftCurlyExpected);
                    }
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL:
                    parensDepth++;
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR:
                    parensDepth--;
                    if (parensDepth < 0) {
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftParenthesisExpected);
                    }
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BracketL:
                    bracketsDepth++;
                    break;
                case __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BracketR:
                    bracketsDepth--;
                    if (bracketsDepth < 0) {
                        return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].LeftSquareBracketExpected);
                    }
                    break;
            }
            this.consumeToken();
        }
        return node;
    };
    Parser.prototype._parseUnknownAtRuleName = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        if (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].AtKeyword)) {
            return this.finish(node);
        }
        return node;
    };
    Parser.prototype._parseOperator = function () {
        // these are operators for binary expressions
        if (this.peekDelim('/') ||
            this.peekDelim('*') ||
            this.peekDelim('+') ||
            this.peekDelim('-') ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Dashmatch) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Includes) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SubstringOperator) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].PrefixOperator) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].SuffixOperator) ||
            this.peekDelim('=')) { // doesn't stick to the standard here
            var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Operator);
            this.consumeToken();
            return this.finish(node);
        }
        else {
            return null;
        }
    };
    Parser.prototype._parseUnaryOperator = function () {
        if (!this.peekDelim('+') && !this.peekDelim('-')) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        this.consumeToken();
        return this.finish(node);
    };
    Parser.prototype._parseCombinator = function () {
        if (this.peekDelim('>')) {
            var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
            this.consumeToken();
            var mark = this.mark();
            if (!this.hasWhitespace() && this.acceptDelim('>')) {
                if (!this.hasWhitespace() && this.acceptDelim('>')) {
                    node.type = __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].SelectorCombinatorShadowPiercingDescendant;
                    return this.finish(node);
                }
                this.restoreAtMark(mark);
            }
            node.type = __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].SelectorCombinatorParent;
            return this.finish(node);
        }
        else if (this.peekDelim('+')) {
            var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
            this.consumeToken();
            node.type = __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].SelectorCombinatorSibling;
            return this.finish(node);
        }
        else if (this.peekDelim('~')) {
            var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
            this.consumeToken();
            node.type = __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].SelectorCombinatorAllSiblings;
            return this.finish(node);
        }
        else if (this.peekDelim('/')) {
            var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
            this.consumeToken();
            var mark = this.mark();
            if (!this.hasWhitespace() && this.acceptIdent('deep') && !this.hasWhitespace() && this.acceptDelim('/')) {
                node.type = __WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].SelectorCombinatorShadowPiercingDescendant;
                return this.finish(node);
            }
            this.restoreAtMark(mark);
        }
        return null;
    };
    Parser.prototype._parseSimpleSelector = function () {
        // simple_selector
        //  : element_name [ HASH | class | attrib | pseudo ]* | [ HASH | class | attrib | pseudo ]+ ;
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_2" /* SimpleSelector */]);
        var c = 0;
        if (node.addChild(this._parseElementName())) {
            c++;
        }
        while ((c === 0 || !this.hasWhitespace()) && node.addChild(this._parseSimpleSelectorBody())) {
            c++;
        }
        return c > 0 ? this.finish(node) : null;
    };
    Parser.prototype._parseSimpleSelectorBody = function () {
        return this._parsePseudo() || this._parseHash() || this._parseClass() || this._parseAttrib();
    };
    Parser.prototype._parseSelectorIdent = function () {
        return this._parseIdent();
    };
    Parser.prototype._parseHash = function () {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Hash) && !this.peekDelim('#')) {
            return null;
        }
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].IdentifierSelector);
        if (this.acceptDelim('#')) {
            if (this.hasWhitespace() || !node.addChild(this._parseSelectorIdent())) {
                return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
            }
        }
        else {
            this.consumeToken(); // TokenType.Hash
        }
        return this.finish(node);
    };
    Parser.prototype._parseClass = function () {
        // class: '.' IDENT ;
        if (!this.peekDelim('.')) {
            return null;
        }
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].ClassSelector);
        this.consumeToken(); // '.'
        if (this.hasWhitespace() || !node.addChild(this._parseSelectorIdent())) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._parseElementName = function () {
        // element_name: (ns? '|')? IDENT | '*';
        var pos = this.mark();
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].ElementNameSelector);
        node.addChild(this._parseNamespacePrefix());
        if (!node.addChild(this._parseSelectorIdent()) && !this.acceptDelim('*')) {
            this.restoreAtMark(pos);
            return null;
        }
        return this.finish(node);
    };
    Parser.prototype._parseNamespacePrefix = function () {
        var pos = this.mark();
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].NamespacePrefix);
        if (!node.addChild(this._parseIdent()) && !this.acceptDelim('*')) {
            // ns is optional
        }
        if (!this.acceptDelim('|')) {
            this.restoreAtMark(pos);
            return null;
        }
        return this.finish(node);
    };
    Parser.prototype._parseAttrib = function () {
        // attrib : '[' S* IDENT S* [ [ '=' | INCLUDES | DASHMATCH ] S*   [ IDENT | STRING ] S* ]? ']'
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BracketL)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["c" /* AttributeSelector */]);
        this.consumeToken(); // BracketL
        // Optional attrib namespace
        node.setNamespacePrefix(this._parseNamespacePrefix());
        if (!node.setIdentifier(this._parseIdent())) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
        }
        if (node.setOperator(this._parseOperator())) {
            node.setValue(this._parseBinaryExpr());
            this.acceptIdent('i'); // case insensitive matching
        }
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BracketR)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightSquareBracketExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._parsePseudo = function () {
        var _this = this;
        // pseudo: ':' [ IDENT | FUNCTION S* [IDENT S*]? ')' ]
        var node = this._tryParsePseudoIdentifier();
        if (node) {
            if (!this.hasWhitespace() && this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL)) {
                var tryAsSelector = function () {
                    var selectors = _this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
                    if (!selectors.addChild(_this._parseSelector(false))) {
                        return null;
                    }
                    while (_this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma) && selectors.addChild(_this._parseSelector(false))) {
                        // loop
                    }
                    if (_this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR)) {
                        return _this.finish(selectors);
                    }
                    return null;
                };
                node.addChild(this.try(tryAsSelector) || this._parseBinaryExpr());
                if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR)) {
                    return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected);
                }
            }
            return this.finish(node);
        }
        return null;
    };
    Parser.prototype._tryParsePseudoIdentifier = function () {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon)) {
            return null;
        }
        var pos = this.mark();
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].PseudoSelector);
        this.consumeToken(); // Colon
        if (this.hasWhitespace()) {
            this.restoreAtMark(pos);
            return null;
        }
        // optional, support ::
        if (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon) && this.hasWhitespace()) {
            this.markError(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
        }
        if (!node.addChild(this._parseIdent())) {
            this.markError(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].IdentifierExpected);
        }
        return node;
    };
    Parser.prototype._tryParsePrio = function () {
        var mark = this.mark();
        var prio = this._parsePrio();
        if (prio) {
            return prio;
        }
        this.restoreAtMark(mark);
        return null;
    };
    Parser.prototype._parsePrio = function () {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Exclamation)) {
            return null;
        }
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].Prio);
        if (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Exclamation) && this.acceptIdent('important')) {
            return this.finish(node);
        }
        return null;
    };
    Parser.prototype._parseExpr = function (stopOnComma) {
        if (stopOnComma === void 0) { stopOnComma = false; }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["m" /* Expression */]);
        if (!node.addChild(this._parseBinaryExpr())) {
            return null;
        }
        while (true) {
            if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma)) { // optional
                if (stopOnComma) {
                    return this.finish(node);
                }
                this.consumeToken();
            }
            if (!node.addChild(this._parseBinaryExpr())) {
                break;
            }
        }
        return this.finish(node);
    };
    Parser.prototype._parseNamedLine = function () {
        // https://www.w3.org/TR/css-grid-1/#named-lines
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BracketL)) {
            return null;
        }
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].GridLine);
        this.consumeToken();
        while (node.addChild(this._parseIdent())) {
            // repeat
        }
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BracketR)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightSquareBracketExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._parseBinaryExpr = function (preparsedLeft, preparsedOper) {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["d" /* BinaryExpression */]);
        if (!node.setLeft((preparsedLeft || this._parseTerm()))) {
            return null;
        }
        if (!node.setOperator(preparsedOper || this._parseOperator())) {
            return this.finish(node);
        }
        if (!node.setRight(this._parseTerm())) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].TermExpected);
        }
        // things needed for multiple binary expressions
        node = this.finish(node);
        var operator = this._parseOperator();
        if (operator) {
            node = this._parseBinaryExpr(node, operator);
        }
        return this.finish(node);
    };
    Parser.prototype._parseTerm = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["_6" /* Term */]);
        node.setOperator(this._parseUnaryOperator()); // optional
        if (node.setExpression(this._parseURILiteral()) || // url before function
            node.setExpression(this._parseFunction()) || // function before ident
            node.setExpression(this._parseIdent()) ||
            node.setExpression(this._parseStringLiteral()) ||
            node.setExpression(this._parseNumeric()) ||
            node.setExpression(this._parseHexColor()) ||
            node.setExpression(this._parseOperation()) ||
            node.setExpression(this._parseNamedLine())) {
            return this.finish(node);
        }
        return null;
    };
    Parser.prototype._parseOperation = function () {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        this.consumeToken(); // ParenthesisL
        node.addChild(this._parseExpr());
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._parseNumeric = function () {
        if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Num) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Percentage) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Resolution) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Length) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EMS) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EXS) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Angle) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Time) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Dimension) ||
            this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Freq)) {
            var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["U" /* NumericValue */]);
            this.consumeToken();
            return this.finish(node);
        }
        return null;
    };
    Parser.prototype._parseStringLiteral = function () {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].String) && !this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BadString)) {
            return null;
        }
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].StringLiteral);
        this.consumeToken();
        return this.finish(node);
    };
    Parser.prototype._parseURILiteral = function () {
        if (!this.peekRegExp(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident, /^url(-prefix)?$/i)) {
            return null;
        }
        var pos = this.mark();
        var node = this.createNode(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["S" /* NodeType */].URILiteral);
        this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident);
        if (this.hasWhitespace() || !this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL)) {
            this.restoreAtMark(pos);
            return null;
        }
        this.scanner.inURL = true;
        this.consumeToken(); // consume ()
        node.addChild(this._parseURLArgument()); // argument is optional
        this.scanner.inURL = false;
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._parseURLArgument = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["R" /* Node */]);
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].String) && !this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BadString) && !this.acceptUnquotedString()) {
            return null;
        }
        return this.finish(node);
    };
    Parser.prototype._parseIdent = function (referenceTypes) {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["y" /* Identifier */]);
        if (referenceTypes) {
            node.referenceTypes = referenceTypes;
        }
        node.isCustomProperty = this.peekRegExp(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident, /^--/);
        this.consumeToken();
        return this.finish(node);
    };
    Parser.prototype._parseFunction = function () {
        var pos = this.mark();
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["s" /* Function */]);
        if (!node.setIdentifier(this._parseFunctionIdentifier())) {
            return null;
        }
        if (this.hasWhitespace() || !this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisL)) {
            this.restoreAtMark(pos);
            return null;
        }
        if (node.getArguments().addChild(this._parseFunctionArgument())) {
            while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Comma)) {
                if (this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR)) {
                    break;
                }
                if (!node.getArguments().addChild(this._parseFunctionArgument())) {
                    this.markError(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].ExpressionExpected);
                }
            }
        }
        if (!this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].ParenthesisR)) {
            return this.finish(node, __WEBPACK_IMPORTED_MODULE_2__cssErrors_js__["a" /* ParseError */].RightParenthesisExpected);
        }
        return this.finish(node);
    };
    Parser.prototype._parseFunctionIdentifier = function () {
        if (!this.peek(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident)) {
            return null;
        }
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["y" /* Identifier */]);
        node.referenceTypes = [__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["Z" /* ReferenceType */].Function];
        if (this.acceptIdent('progid')) {
            // support for IE7 specific filters: 'progid:DXImageTransform.Microsoft.MotionBlur(strength=13, direction=310)'
            if (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Colon)) {
                while (this.accept(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Ident) && this.acceptDelim('.')) {
                    // loop
                }
            }
            return this.finish(node);
        }
        this.consumeToken();
        return this.finish(node);
    };
    Parser.prototype._parseFunctionArgument = function () {
        var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["t" /* FunctionArgument */]);
        if (node.setValue(this._parseExpr(true))) {
            return this.finish(node);
        }
        return null;
    };
    Parser.prototype._parseHexColor = function () {
        if (this.peekRegExp(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Hash, /^#([A-Fa-f0-9]{3}|[A-Fa-f0-9]{4}|[A-Fa-f0-9]{6}|[A-Fa-f0-9]{8})$/g)) {
            var node = this.create(__WEBPACK_IMPORTED_MODULE_1__cssNodes_js__["x" /* HexColorValue */]);
            this.consumeToken();
            return this.finish(node);
        }
        else {
            return null;
        }
    };
    return Parser;
}());



/***/ }),

/***/ 772:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export CSSIssueType */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ParseError; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__fillers_vscode_nls_js__ = __webpack_require__(757);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var localize = __WEBPACK_IMPORTED_MODULE_0__fillers_vscode_nls_js__["a" /* loadMessageBundle */]();
var CSSIssueType = /** @class */ (function () {
    function CSSIssueType(id, message) {
        this.id = id;
        this.message = message;
    }
    return CSSIssueType;
}());

var ParseError = {
    NumberExpected: new CSSIssueType('css-numberexpected', localize('expected.number', "number expected")),
    ConditionExpected: new CSSIssueType('css-conditionexpected', localize('expected.condt', "condition expected")),
    RuleOrSelectorExpected: new CSSIssueType('css-ruleorselectorexpected', localize('expected.ruleorselector', "at-rule or selector expected")),
    DotExpected: new CSSIssueType('css-dotexpected', localize('expected.dot', "dot expected")),
    ColonExpected: new CSSIssueType('css-colonexpected', localize('expected.colon', "colon expected")),
    SemiColonExpected: new CSSIssueType('css-semicolonexpected', localize('expected.semicolon', "semi-colon expected")),
    TermExpected: new CSSIssueType('css-termexpected', localize('expected.term', "term expected")),
    ExpressionExpected: new CSSIssueType('css-expressionexpected', localize('expected.expression', "expression expected")),
    OperatorExpected: new CSSIssueType('css-operatorexpected', localize('expected.operator', "operator expected")),
    IdentifierExpected: new CSSIssueType('css-identifierexpected', localize('expected.ident', "identifier expected")),
    PercentageExpected: new CSSIssueType('css-percentageexpected', localize('expected.percentage', "percentage expected")),
    URIOrStringExpected: new CSSIssueType('css-uriorstringexpected', localize('expected.uriorstring', "uri or string expected")),
    URIExpected: new CSSIssueType('css-uriexpected', localize('expected.uri', "URI expected")),
    VariableNameExpected: new CSSIssueType('css-varnameexpected', localize('expected.varname', "variable name expected")),
    VariableValueExpected: new CSSIssueType('css-varvalueexpected', localize('expected.varvalue', "variable value expected")),
    PropertyValueExpected: new CSSIssueType('css-propertyvalueexpected', localize('expected.propvalue', "property value expected")),
    LeftCurlyExpected: new CSSIssueType('css-lcurlyexpected', localize('expected.lcurly', "{ expected")),
    RightCurlyExpected: new CSSIssueType('css-rcurlyexpected', localize('expected.rcurly', "} expected")),
    LeftSquareBracketExpected: new CSSIssueType('css-rbracketexpected', localize('expected.lsquare', "[ expected")),
    RightSquareBracketExpected: new CSSIssueType('css-lbracketexpected', localize('expected.rsquare', "] expected")),
    LeftParenthesisExpected: new CSSIssueType('css-lparentexpected', localize('expected.lparen', "( expected")),
    RightParenthesisExpected: new CSSIssueType('css-rparentexpected', localize('expected.rparent', ") expected")),
    CommaExpected: new CSSIssueType('css-commaexpected', localize('expected.comma', "comma expected")),
    PageDirectiveOrDeclarationExpected: new CSSIssueType('css-pagedirordeclexpected', localize('expected.pagedirordecl', "page directive or declaraton expected")),
    UnknownAtRule: new CSSIssueType('css-unknownatrule', localize('unknown.atrule', "at-rule unknown")),
    UnknownKeyword: new CSSIssueType('css-unknownkeyword', localize('unknown.keyword', "unknown keyword")),
    SelectorExpected: new CSSIssueType('css-selectorexpected', localize('expected.selector', "selector expected")),
    StringLiteralExpected: new CSSIssueType('css-stringliteralexpected', localize('expected.stringliteral', "string literal expected")),
    WhitespaceExpected: new CSSIssueType('css-whitespaceexpected', localize('expected.whitespace', "whitespace expected")),
    MediaQueryExpected: new CSSIssueType('css-mediaqueryexpected', localize('expected.mediaquery', "media query expected")),
    IdentifierOrWildcardExpected: new CSSIssueType('css-idorwildcardexpected', localize('expected.idorwildcard', "identifier or wildcard expected")),
    WildcardExpected: new CSSIssueType('css-wildcardexpected', localize('expected.wildcard', "wildcard expected")),
    IdentifierOrVariableExpected: new CSSIssueType('css-idorvarexpected', localize('expected.idorvar', "identifier or variable expected")),
};


/***/ }),

/***/ 773:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CSSCompletion; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__ = __webpack_require__(756);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__parser_cssSymbolScope_js__ = __webpack_require__(784);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__ = __webpack_require__(762);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__utils_strings_js__ = __webpack_require__(769);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__ = __webpack_require__(758);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__fillers_vscode_nls_js__ = __webpack_require__(757);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__utils_objects_js__ = __webpack_require__(768);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/








var localize = __WEBPACK_IMPORTED_MODULE_5__fillers_vscode_nls_js__["a" /* loadMessageBundle */]();
var SnippetFormat = __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["j" /* InsertTextFormat */].Snippet;
var SortTexts;
(function (SortTexts) {
    // char code 32, comes before everything
    SortTexts["Enums"] = " ";
    SortTexts["Normal"] = "d";
    SortTexts["VendorPrefixed"] = "x";
    SortTexts["Term"] = "y";
    SortTexts["Variable"] = "z";
})(SortTexts || (SortTexts = {}));
var CSSCompletion = /** @class */ (function () {
    function CSSCompletion(variablePrefix, clientCapabilities) {
        if (variablePrefix === void 0) { variablePrefix = null; }
        this.variablePrefix = variablePrefix;
        this.clientCapabilities = clientCapabilities;
        this.completionParticipants = [];
        this.valueTypes = [
            __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].Identifier, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].Value, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].StringLiteral, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].URILiteral, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].NumericValue,
            __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].HexColorValue, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].VariableName, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].Prio
        ];
    }
    CSSCompletion.prototype.configure = function (settings) {
        this.settings = settings;
    };
    CSSCompletion.prototype.getSymbolContext = function () {
        if (!this.symbolContext) {
            this.symbolContext = new __WEBPACK_IMPORTED_MODULE_1__parser_cssSymbolScope_js__["a" /* Symbols */](this.styleSheet);
        }
        return this.symbolContext;
    };
    CSSCompletion.prototype.setCompletionParticipants = function (registeredCompletionParticipants) {
        this.completionParticipants = registeredCompletionParticipants || [];
    };
    CSSCompletion.prototype.doComplete = function (document, position, styleSheet) {
        this.offset = document.offsetAt(position);
        this.position = position;
        this.currentWord = getCurrentWord(document, this.offset);
        this.defaultReplaceRange = __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["n" /* Range */].create(__WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["m" /* Position */].create(this.position.line, this.position.character - this.currentWord.length), this.position);
        this.textDocument = document;
        this.styleSheet = styleSheet;
        try {
            var result = { isIncomplete: false, items: [] };
            this.nodePath = __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_14" /* getNodePath */](this.styleSheet, this.offset);
            for (var i = this.nodePath.length - 1; i >= 0; i--) {
                var node = this.nodePath[i];
                if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["Y" /* Property */]) {
                    this.getCompletionsForDeclarationProperty(node.getParent(), result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["m" /* Expression */]) {
                    if (node.parent instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["B" /* Interpolation */]) {
                        this.getVariableProposals(null, result);
                    }
                    else {
                        this.getCompletionsForExpression(node, result);
                    }
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_2" /* SimpleSelector */]) {
                    var parentRef = node.findAParent(__WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].ExtendsReference, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].Ruleset);
                    if (parentRef) {
                        if (parentRef.type === __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].ExtendsReference) {
                            this.getCompletionsForExtendsReference(parentRef, node, result);
                        }
                        else {
                            var parentRuleSet = parentRef;
                            this.getCompletionsForSelector(parentRuleSet, parentRuleSet && parentRuleSet.isNested(), result);
                        }
                    }
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["t" /* FunctionArgument */]) {
                    this.getCompletionsForFunctionArgument(node, node.getParent(), result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["i" /* Declarations */]) {
                    this.getCompletionsForDeclarations(node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_10" /* VariableDeclaration */]) {
                    this.getCompletionsForVariableDeclaration(node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_0" /* RuleSet */]) {
                    this.getCompletionsForRuleSet(node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["B" /* Interpolation */]) {
                    this.getCompletionsForInterpolation(node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["u" /* FunctionDeclaration */]) {
                    this.getCompletionsForFunctionDeclaration(node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["M" /* MixinReference */]) {
                    this.getCompletionsForMixinReference(node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["s" /* Function */]) {
                    this.getCompletionsForFunctionArgument(null, node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_4" /* Supports */]) {
                    this.getCompletionsForSupports(node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_5" /* SupportsCondition */]) {
                    this.getCompletionsForSupportsCondition(node, result);
                }
                else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["n" /* ExtendsReference */]) {
                    this.getCompletionsForExtendsReference(node, null, result);
                }
                else if (node.type === __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].URILiteral) {
                    this.getCompletionForUriLiteralValue(node, result);
                }
                else if (node.parent === null) {
                    this.getCompletionForTopLevel(result);
                }
                else if (node.type === __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].StringLiteral && this.isImportPathParent(node.parent.type)) {
                    this.getCompletionForImportPath(node, result);
                    // } else if (node instanceof nodes.Variable) {
                    // this.getCompletionsForVariableDeclaration()
                }
                else {
                    continue;
                }
                if (result.items.length > 0 || this.offset > node.offset) {
                    return this.finalize(result);
                }
            }
            this.getCompletionsForStylesheet(result);
            if (result.items.length === 0) {
                if (this.variablePrefix && this.currentWord.indexOf(this.variablePrefix) === 0) {
                    this.getVariableProposals(null, result);
                }
            }
            return this.finalize(result);
        }
        finally {
            // don't hold on any state, clear symbolContext
            this.position = null;
            this.currentWord = null;
            this.textDocument = null;
            this.styleSheet = null;
            this.symbolContext = null;
            this.defaultReplaceRange = null;
            this.nodePath = null;
        }
    };
    CSSCompletion.prototype.isImportPathParent = function (type) {
        return type === __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].Import;
    };
    CSSCompletion.prototype.finalize = function (result) {
        var needsSortText = result.items.some(function (i) { return !!i.sortText || i.label[0] === '-'; });
        if (needsSortText) {
            result.items.forEach(function (item, index) {
                if (!item.sortText) {
                    if (item.label[0] === '-') {
                        item.sortText = SortTexts.VendorPrefixed + '_' + computeRankNumber(index);
                    }
                    else {
                        item.sortText = SortTexts.Normal + '_' + computeRankNumber(index);
                    }
                }
                else {
                    if (item.label[0] === '-') {
                        item.sortText += SortTexts.VendorPrefixed + '_' + computeRankNumber(index);
                    }
                    else {
                        item.sortText += SortTexts.Normal + '_' + computeRankNumber(index);
                    }
                }
            });
        }
        return result;
    };
    CSSCompletion.prototype.findInNodePath = function () {
        var types = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            types[_i] = arguments[_i];
        }
        for (var i = this.nodePath.length - 1; i >= 0; i--) {
            var node = this.nodePath[i];
            if (types.indexOf(node.type) !== -1) {
                return node;
            }
        }
        return null;
    };
    CSSCompletion.prototype.getCompletionsForDeclarationProperty = function (declaration, result) {
        return this.getPropertyProposals(declaration, result);
    };
    CSSCompletion.prototype.getPropertyProposals = function (declaration, result) {
        var _this = this;
        var triggerPropertyValueCompletion = this.isTriggerPropertyValueCompletionEnabled;
        var completePropertyWithSemicolon = this.isCompletePropertyWithSemicolonEnabled;
        var properties = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["f" /* cssDataManager */].getProperties();
        properties.forEach(function (entry) {
            var range;
            var insertText;
            var retrigger = false;
            if (declaration) {
                range = _this.getCompletionRange(declaration.getProperty());
                insertText = entry.name;
                if (!Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(declaration.colonPosition)) {
                    insertText += ': ';
                    retrigger = true;
                }
            }
            else {
                range = _this.getCompletionRange(null);
                insertText = entry.name + ': ';
                retrigger = true;
            }
            // Empty .selector { | } case
            if (!declaration && completePropertyWithSemicolon) {
                insertText += '$0;';
            }
            // Cases such as .selector { p; } or .selector { p:; }
            if (declaration && !declaration.semicolonPosition) {
                if (completePropertyWithSemicolon && _this.offset >= _this.textDocument.offsetAt(range.end)) {
                    insertText += '$0;';
                }
            }
            var item = {
                label: entry.name,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["j" /* getEntryDescription */](entry, _this.doesSupportMarkdown()),
                tags: isDeprecated(entry) ? [__WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["e" /* CompletionItemTag */].Deprecated] : [],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(range, insertText),
                insertTextFormat: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["j" /* InsertTextFormat */].Snippet,
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Property
            };
            if (!entry.restrictions) {
                retrigger = false;
            }
            if (triggerPropertyValueCompletion && retrigger) {
                item.command = {
                    title: 'Suggest',
                    command: 'editor.action.triggerSuggest'
                };
            }
            if (__WEBPACK_IMPORTED_MODULE_3__utils_strings_js__["d" /* startsWith */](entry.name, '-')) {
                item.sortText = SortTexts.VendorPrefixed;
            }
            result.items.push(item);
        });
        this.completionParticipants.forEach(function (participant) {
            if (participant.onCssProperty) {
                participant.onCssProperty({
                    propertyName: _this.currentWord,
                    range: _this.defaultReplaceRange
                });
            }
        });
        return result;
    };
    Object.defineProperty(CSSCompletion.prototype, "isTriggerPropertyValueCompletionEnabled", {
        get: function () {
            if (!this.settings ||
                !this.settings.completion ||
                this.settings.completion.triggerPropertyValueCompletion === undefined) {
                return true;
            }
            return this.settings.completion.triggerPropertyValueCompletion;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CSSCompletion.prototype, "isCompletePropertyWithSemicolonEnabled", {
        get: function () {
            if (!this.settings ||
                !this.settings.completion ||
                this.settings.completion.completePropertyWithSemicolon === undefined) {
                return true;
            }
            return this.settings.completion.completePropertyWithSemicolon;
        },
        enumerable: true,
        configurable: true
    });
    CSSCompletion.prototype.getCompletionsForDeclarationValue = function (node, result) {
        var _this = this;
        var propertyName = node.getFullPropertyName();
        var entry = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["f" /* cssDataManager */].getProperty(propertyName);
        var existingNode = node.getValue() || null;
        while (existingNode && existingNode.hasChildren()) {
            existingNode = existingNode.findChildAtOffset(this.offset, false);
        }
        this.completionParticipants.forEach(function (participant) {
            if (participant.onCssPropertyValue) {
                participant.onCssPropertyValue({
                    propertyName: propertyName,
                    propertyValue: _this.currentWord,
                    range: _this.getCompletionRange(existingNode)
                });
            }
        });
        if (entry) {
            if (entry.restrictions) {
                for (var _i = 0, _a = entry.restrictions; _i < _a.length; _i++) {
                    var restriction = _a[_i];
                    switch (restriction) {
                        case 'color':
                            this.getColorProposals(entry, existingNode, result);
                            break;
                        case 'position':
                            this.getPositionProposals(entry, existingNode, result);
                            break;
                        case 'repeat':
                            this.getRepeatStyleProposals(entry, existingNode, result);
                            break;
                        case 'line-style':
                            this.getLineStyleProposals(entry, existingNode, result);
                            break;
                        case 'line-width':
                            this.getLineWidthProposals(entry, existingNode, result);
                            break;
                        case 'geometry-box':
                            this.getGeometryBoxProposals(entry, existingNode, result);
                            break;
                        case 'box':
                            this.getBoxProposals(entry, existingNode, result);
                            break;
                        case 'image':
                            this.getImageProposals(entry, existingNode, result);
                            break;
                        case 'timing-function':
                            this.getTimingFunctionProposals(entry, existingNode, result);
                            break;
                        case 'shape':
                            this.getBasicShapeProposals(entry, existingNode, result);
                            break;
                    }
                }
            }
            this.getValueEnumProposals(entry, existingNode, result);
            this.getCSSWideKeywordProposals(entry, existingNode, result);
            this.getUnitProposals(entry, existingNode, result);
        }
        else {
            var existingValues = collectValues(this.styleSheet, node);
            for (var _b = 0, _c = existingValues.getEntries(); _b < _c.length; _b++) {
                var existingValue = _c[_b];
                result.items.push({
                    label: existingValue,
                    textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), existingValue),
                    kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
                });
            }
        }
        this.getVariableProposals(existingNode, result);
        this.getTermProposals(entry, existingNode, result);
        return result;
    };
    CSSCompletion.prototype.getValueEnumProposals = function (entry, existingNode, result) {
        if (entry.values) {
            for (var _i = 0, _a = entry.values; _i < _a.length; _i++) {
                var value = _a[_i];
                var insertString = value.name;
                var insertTextFormat = void 0;
                if (__WEBPACK_IMPORTED_MODULE_3__utils_strings_js__["b" /* endsWith */](insertString, ')')) {
                    var from = insertString.lastIndexOf('(');
                    if (from !== -1) {
                        insertString = insertString.substr(0, from) + '($1)';
                        insertTextFormat = SnippetFormat;
                    }
                }
                var item = {
                    label: value.name,
                    documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["j" /* getEntryDescription */](value, this.doesSupportMarkdown()),
                    tags: isDeprecated(entry) ? [__WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["e" /* CompletionItemTag */].Deprecated] : [],
                    textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), insertString),
                    sortText: SortTexts.Enums,
                    kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value,
                    insertTextFormat: insertTextFormat
                };
                result.items.push(item);
            }
        }
        return result;
    };
    CSSCompletion.prototype.getCSSWideKeywordProposals = function (entry, existingNode, result) {
        for (var keywords in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["g" /* cssWideKeywords */]) {
            result.items.push({
                label: keywords,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["g" /* cssWideKeywords */][keywords],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), keywords),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
            });
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForInterpolation = function (node, result) {
        if (this.offset >= node.offset + 2) {
            this.getVariableProposals(null, result);
        }
        return result;
    };
    CSSCompletion.prototype.getVariableProposals = function (existingNode, result) {
        var symbols = this.getSymbolContext().findSymbolsAtOffset(this.offset, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["Z" /* ReferenceType */].Variable);
        for (var _i = 0, symbols_1 = symbols; _i < symbols_1.length; _i++) {
            var symbol = symbols_1[_i];
            var insertText = __WEBPACK_IMPORTED_MODULE_3__utils_strings_js__["d" /* startsWith */](symbol.name, '--') ? "var(" + symbol.name + ")" : symbol.name;
            var completionItem = {
                label: symbol.name,
                documentation: symbol.value ? __WEBPACK_IMPORTED_MODULE_3__utils_strings_js__["c" /* getLimitedString */](symbol.value) : symbol.value,
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), insertText),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Variable,
                sortText: SortTexts.Variable
            };
            if (typeof completionItem.documentation === 'string' && isColorString(completionItem.documentation)) {
                completionItem.kind = __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Color;
            }
            if (symbol.node.type === __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].FunctionParameter) {
                var mixinNode = (symbol.node.getParent());
                if (mixinNode.type === __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].MixinDeclaration) {
                    completionItem.detail = localize('completion.argument', 'argument from \'{0}\'', mixinNode.getName());
                }
            }
            result.items.push(completionItem);
        }
        return result;
    };
    CSSCompletion.prototype.getVariableProposalsForCSSVarFunction = function (result) {
        var symbols = this.getSymbolContext().findSymbolsAtOffset(this.offset, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["Z" /* ReferenceType */].Variable);
        symbols = symbols.filter(function (symbol) {
            return __WEBPACK_IMPORTED_MODULE_3__utils_strings_js__["d" /* startsWith */](symbol.name, '--');
        });
        for (var _i = 0, symbols_2 = symbols; _i < symbols_2.length; _i++) {
            var symbol = symbols_2[_i];
            var completionItem = {
                label: symbol.name,
                documentation: symbol.value ? __WEBPACK_IMPORTED_MODULE_3__utils_strings_js__["c" /* getLimitedString */](symbol.value) : symbol.value,
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(null), symbol.name),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Variable
            };
            if (typeof completionItem.documentation === 'string' && isColorString(completionItem.documentation)) {
                completionItem.kind = __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Color;
            }
            result.items.push(completionItem);
        }
        return result;
    };
    CSSCompletion.prototype.getUnitProposals = function (entry, existingNode, result) {
        var currentWord = '0';
        if (this.currentWord.length > 0) {
            var numMatch = this.currentWord.match(/^-?\d[\.\d+]*/);
            if (numMatch) {
                currentWord = numMatch[0];
                result.isIncomplete = currentWord.length === this.currentWord.length;
            }
        }
        else if (this.currentWord.length === 0) {
            result.isIncomplete = true;
        }
        if (existingNode && existingNode.parent && existingNode.parent.type === __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].Term) {
            existingNode = existingNode.getParent(); // include the unary operator
        }
        if (entry.restrictions) {
            for (var _i = 0, _a = entry.restrictions; _i < _a.length; _i++) {
                var restriction = _a[_i];
                var units = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["v" /* units */][restriction];
                if (units) {
                    for (var _b = 0, units_1 = units; _b < units_1.length; _b++) {
                        var unit = units_1[_b];
                        var insertText = currentWord + unit;
                        result.items.push({
                            label: insertText,
                            textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), insertText),
                            kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Unit
                        });
                    }
                }
            }
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionRange = function (existingNode) {
        if (existingNode && existingNode.offset <= this.offset && this.offset <= existingNode.end) {
            var end = existingNode.end !== -1 ? this.textDocument.positionAt(existingNode.end) : this.position;
            var start = this.textDocument.positionAt(existingNode.offset);
            if (start.line === end.line) {
                return __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["n" /* Range */].create(start, end); // multi line edits are not allowed
            }
        }
        return this.defaultReplaceRange;
    };
    CSSCompletion.prototype.getColorProposals = function (entry, existingNode, result) {
        for (var color in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["e" /* colors */]) {
            result.items.push({
                label: color,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["e" /* colors */][color],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), color),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Color
            });
        }
        for (var color in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["d" /* colorKeywords */]) {
            result.items.push({
                label: color,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["d" /* colorKeywords */][color],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), color),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
            });
        }
        var colorValues = new Set();
        this.styleSheet.acceptVisitor(new ColorValueCollector(colorValues, this.offset));
        for (var _i = 0, _a = colorValues.getEntries(); _i < _a.length; _i++) {
            var color = _a[_i];
            result.items.push({
                label: color,
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), color),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Color
            });
        }
        var _loop_1 = function (p) {
            var tabStop = 1;
            var replaceFunction = function (_match, p1) { return '${' + tabStop++ + ':' + p1 + '}'; };
            var insertText = p.func.replace(/\[?\$(\w+)\]?/g, replaceFunction);
            result.items.push({
                label: p.func.substr(0, p.func.indexOf('(')),
                detail: p.func,
                documentation: p.desc,
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this_1.getCompletionRange(existingNode), insertText),
                insertTextFormat: SnippetFormat,
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Function
            });
        };
        var this_1 = this;
        for (var _b = 0, _c = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["c" /* colorFunctions */]; _b < _c.length; _b++) {
            var p = _c[_b];
            _loop_1(p);
        }
        return result;
    };
    CSSCompletion.prototype.getPositionProposals = function (entry, existingNode, result) {
        for (var position in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["r" /* positionKeywords */]) {
            result.items.push({
                label: position,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["r" /* positionKeywords */][position],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), position),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
            });
        }
        return result;
    };
    CSSCompletion.prototype.getRepeatStyleProposals = function (entry, existingNode, result) {
        for (var repeat in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["s" /* repeatStyleKeywords */]) {
            result.items.push({
                label: repeat,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["s" /* repeatStyleKeywords */][repeat],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), repeat),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
            });
        }
        return result;
    };
    CSSCompletion.prototype.getLineStyleProposals = function (entry, existingNode, result) {
        for (var lineStyle in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["o" /* lineStyleKeywords */]) {
            result.items.push({
                label: lineStyle,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["o" /* lineStyleKeywords */][lineStyle],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), lineStyle),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
            });
        }
        return result;
    };
    CSSCompletion.prototype.getLineWidthProposals = function (entry, existingNode, result) {
        for (var _i = 0, _a = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["p" /* lineWidthKeywords */]; _i < _a.length; _i++) {
            var lineWidth = _a[_i];
            result.items.push({
                label: lineWidth,
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), lineWidth),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
            });
        }
        return result;
    };
    CSSCompletion.prototype.getGeometryBoxProposals = function (entry, existingNode, result) {
        for (var box in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["h" /* geometryBoxKeywords */]) {
            result.items.push({
                label: box,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["h" /* geometryBoxKeywords */][box],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), box),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
            });
        }
        return result;
    };
    CSSCompletion.prototype.getBoxProposals = function (entry, existingNode, result) {
        for (var box in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["b" /* boxKeywords */]) {
            result.items.push({
                label: box,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["b" /* boxKeywords */][box],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), box),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Value
            });
        }
        return result;
    };
    CSSCompletion.prototype.getImageProposals = function (entry, existingNode, result) {
        for (var image in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["m" /* imageFunctions */]) {
            var insertText = moveCursorInsideParenthesis(image);
            result.items.push({
                label: image,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["m" /* imageFunctions */][image],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), insertText),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Function,
                insertTextFormat: image !== insertText ? SnippetFormat : void 0
            });
        }
        return result;
    };
    CSSCompletion.prototype.getTimingFunctionProposals = function (entry, existingNode, result) {
        for (var timing in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["u" /* transitionTimingFunctions */]) {
            var insertText = moveCursorInsideParenthesis(timing);
            result.items.push({
                label: timing,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["u" /* transitionTimingFunctions */][timing],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), insertText),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Function,
                insertTextFormat: timing !== insertText ? SnippetFormat : void 0
            });
        }
        return result;
    };
    CSSCompletion.prototype.getBasicShapeProposals = function (entry, existingNode, result) {
        for (var shape in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["a" /* basicShapeFunctions */]) {
            var insertText = moveCursorInsideParenthesis(shape);
            result.items.push({
                label: shape,
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["a" /* basicShapeFunctions */][shape],
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), insertText),
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Function,
                insertTextFormat: shape !== insertText ? SnippetFormat : void 0
            });
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForStylesheet = function (result) {
        var node = this.styleSheet.findFirstChildBeforeOffset(this.offset);
        if (!node) {
            return this.getCompletionForTopLevel(result);
        }
        if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_0" /* RuleSet */]) {
            return this.getCompletionsForRuleSet(node, result);
        }
        if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_4" /* Supports */]) {
            return this.getCompletionsForSupports(node, result);
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionForTopLevel = function (result) {
        var _this = this;
        __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["f" /* cssDataManager */].getAtDirectives().forEach(function (entry) {
            result.items.push({
                label: entry.name,
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(_this.getCompletionRange(null), entry.name),
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["j" /* getEntryDescription */](entry, _this.doesSupportMarkdown()),
                tags: isDeprecated(entry) ? [__WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["e" /* CompletionItemTag */].Deprecated] : [],
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Keyword
            });
        });
        this.getCompletionsForSelector(null, false, result);
        return result;
    };
    CSSCompletion.prototype.getCompletionsForRuleSet = function (ruleSet, result) {
        var declarations = ruleSet.getDeclarations();
        var isAfter = declarations && declarations.endsWith('}') && this.offset >= declarations.end;
        if (isAfter) {
            return this.getCompletionForTopLevel(result);
        }
        var isInSelectors = !declarations || this.offset <= declarations.offset;
        if (isInSelectors) {
            return this.getCompletionsForSelector(ruleSet, ruleSet.isNested(), result);
        }
        return this.getCompletionsForDeclarations(ruleSet.getDeclarations(), result);
    };
    CSSCompletion.prototype.getCompletionsForSelector = function (ruleSet, isNested, result) {
        var _this = this;
        var existingNode = this.findInNodePath(__WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].PseudoSelector, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].IdentifierSelector, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].ClassSelector, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].ElementNameSelector);
        if (!existingNode && this.offset - this.currentWord.length > 0 && this.textDocument.getText()[this.offset - this.currentWord.length - 1] === ':') {
            // after the ':' of a pseudo selector, no node generated for just ':'
            this.currentWord = ':' + this.currentWord;
            this.defaultReplaceRange = __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["n" /* Range */].create(__WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["m" /* Position */].create(this.position.line, this.position.character - this.currentWord.length), this.position);
        }
        var pseudoClasses = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["f" /* cssDataManager */].getPseudoClasses();
        pseudoClasses.forEach(function (entry) {
            var insertText = moveCursorInsideParenthesis(entry.name);
            var item = {
                label: entry.name,
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(_this.getCompletionRange(existingNode), insertText),
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["j" /* getEntryDescription */](entry, _this.doesSupportMarkdown()),
                tags: isDeprecated(entry) ? [__WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["e" /* CompletionItemTag */].Deprecated] : [],
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Function,
                insertTextFormat: entry.name !== insertText ? SnippetFormat : void 0
            };
            if (__WEBPACK_IMPORTED_MODULE_3__utils_strings_js__["d" /* startsWith */](entry.name, ':-')) {
                item.sortText = SortTexts.VendorPrefixed;
            }
            result.items.push(item);
        });
        var pseudoElements = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["f" /* cssDataManager */].getPseudoElements();
        pseudoElements.forEach(function (entry) {
            var insertText = moveCursorInsideParenthesis(entry.name);
            var item = {
                label: entry.name,
                textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(_this.getCompletionRange(existingNode), insertText),
                documentation: __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["j" /* getEntryDescription */](entry, _this.doesSupportMarkdown()),
                tags: isDeprecated(entry) ? [__WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["e" /* CompletionItemTag */].Deprecated] : [],
                kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Function,
                insertTextFormat: entry.name !== insertText ? SnippetFormat : void 0
            };
            if (__WEBPACK_IMPORTED_MODULE_3__utils_strings_js__["d" /* startsWith */](entry.name, '::-')) {
                item.sortText = SortTexts.VendorPrefixed;
            }
            result.items.push(item);
        });
        if (!isNested) { // show html tags only for top level
            for (var _i = 0, _a = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["l" /* html5Tags */]; _i < _a.length; _i++) {
                var entry = _a[_i];
                result.items.push({
                    label: entry,
                    textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), entry),
                    kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Keyword
                });
            }
            for (var _b = 0, _c = __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["t" /* svgElements */]; _b < _c.length; _b++) {
                var entry = _c[_b];
                result.items.push({
                    label: entry,
                    textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), entry),
                    kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Keyword
                });
            }
        }
        var visited = {};
        visited[this.currentWord] = true;
        var docText = this.textDocument.getText();
        this.styleSheet.accept(function (n) {
            if (n.type === __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].SimpleSelector && n.length > 0) {
                var selector = docText.substr(n.offset, n.length);
                if (selector.charAt(0) === '.' && !visited[selector]) {
                    visited[selector] = true;
                    result.items.push({
                        label: selector,
                        textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(_this.getCompletionRange(existingNode), selector),
                        kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Keyword
                    });
                }
                return false;
            }
            return true;
        });
        if (ruleSet && ruleSet.isNested()) {
            var selector = ruleSet.getSelectors().findFirstChildBeforeOffset(this.offset);
            if (selector && ruleSet.getSelectors().getChildren().indexOf(selector) === 0) {
                this.getPropertyProposals(null, result);
            }
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForDeclarations = function (declarations, result) {
        if (!declarations || this.offset === declarations.offset) { // incomplete nodes
            return result;
        }
        var node = declarations.findFirstChildBeforeOffset(this.offset);
        if (!node) {
            return this.getCompletionsForDeclarationProperty(null, result);
        }
        if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["a" /* AbstractDeclaration */]) {
            var declaration = node;
            if (!Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(declaration.colonPosition) || this.offset <= declaration.colonPosition) {
                // complete property
                return this.getCompletionsForDeclarationProperty(declaration, result);
            }
            else if ((Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(declaration.semicolonPosition) && declaration.semicolonPosition < this.offset)) {
                if (this.offset === declaration.semicolonPosition + 1) {
                    return result; // don't show new properties right after semicolon (see Bug 15421:[intellisense] [css] Be less aggressive when manually typing CSS)
                }
                // complete next property
                return this.getCompletionsForDeclarationProperty(null, result);
            }
            if (declaration instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["h" /* Declaration */]) {
                // complete value
                return this.getCompletionsForDeclarationValue(declaration, result);
            }
        }
        else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["n" /* ExtendsReference */]) {
            this.getCompletionsForExtendsReference(node, null, result);
        }
        else if (this.currentWord && this.currentWord[0] === '@') {
            this.getCompletionsForDeclarationProperty(null, result);
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForVariableDeclaration = function (declaration, result) {
        if (this.offset && Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(declaration.colonPosition) && this.offset > declaration.colonPosition) {
            this.getVariableProposals(declaration.getValue(), result);
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForExpression = function (expression, result) {
        var parent = expression.getParent();
        if (parent instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["t" /* FunctionArgument */]) {
            this.getCompletionsForFunctionArgument(parent, parent.getParent(), result);
            return result;
        }
        var declaration = expression.findParent(__WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["S" /* NodeType */].Declaration);
        if (!declaration) {
            this.getTermProposals(null, null, result);
            return result;
        }
        var node = expression.findChildAtOffset(this.offset, true);
        if (!node) {
            return this.getCompletionsForDeclarationValue(declaration, result);
        }
        if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["U" /* NumericValue */] || node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["y" /* Identifier */]) {
            return this.getCompletionsForDeclarationValue(declaration, result);
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForFunctionArgument = function (arg, func, result) {
        var identifier = func.getIdentifier();
        if (identifier && identifier.matches('var')) {
            if (!func.getArguments().hasChildren() || func.getArguments().getChild(0) === arg) {
                this.getVariableProposalsForCSSVarFunction(result);
            }
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForFunctionDeclaration = function (decl, result) {
        var declarations = decl.getDeclarations();
        if (declarations && this.offset > declarations.offset && this.offset < declarations.end) {
            this.getTermProposals(null, null, result);
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForMixinReference = function (ref, result) {
        var allMixins = this.getSymbolContext().findSymbolsAtOffset(this.offset, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["Z" /* ReferenceType */].Mixin);
        for (var _i = 0, allMixins_1 = allMixins; _i < allMixins_1.length; _i++) {
            var mixinSymbol = allMixins_1[_i];
            if (mixinSymbol.node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["L" /* MixinDeclaration */]) {
                result.items.push(this.makeTermProposal(mixinSymbol, mixinSymbol.node.getParameters(), null));
            }
        }
        return result;
    };
    CSSCompletion.prototype.getTermProposals = function (entry, existingNode, result) {
        var allFunctions = this.getSymbolContext().findSymbolsAtOffset(this.offset, __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["Z" /* ReferenceType */].Function);
        for (var _i = 0, allFunctions_1 = allFunctions; _i < allFunctions_1.length; _i++) {
            var functionSymbol = allFunctions_1[_i];
            if (functionSymbol.node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["u" /* FunctionDeclaration */]) {
                result.items.push(this.makeTermProposal(functionSymbol, functionSymbol.node.getParameters(), existingNode));
            }
        }
        return result;
    };
    CSSCompletion.prototype.makeTermProposal = function (symbol, parameters, existingNode) {
        var decl = symbol.node;
        var params = parameters.getChildren().map(function (c) {
            return (c instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["v" /* FunctionParameter */]) ? c.getName() : c.getText();
        });
        var insertText = symbol.name + '(' + params.map(function (p, index) { return '${' + (index + 1) + ':' + p + '}'; }).join(', ') + ')';
        return {
            label: symbol.name,
            detail: symbol.name + '(' + params.join(', ') + ')',
            textEdit: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["r" /* TextEdit */].replace(this.getCompletionRange(existingNode), insertText),
            insertTextFormat: SnippetFormat,
            kind: __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["d" /* CompletionItemKind */].Function,
            sortText: SortTexts.Term
        };
    };
    CSSCompletion.prototype.getCompletionsForSupportsCondition = function (supportsCondition, result) {
        var child = supportsCondition.findFirstChildBeforeOffset(this.offset);
        if (child) {
            if (child instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["h" /* Declaration */]) {
                if (!Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(child.colonPosition) || this.offset <= child.colonPosition) {
                    return this.getCompletionsForDeclarationProperty(child, result);
                }
                else {
                    return this.getCompletionsForDeclarationValue(child, result);
                }
            }
            else if (child instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_5" /* SupportsCondition */]) {
                return this.getCompletionsForSupportsCondition(child, result);
            }
        }
        if (Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(supportsCondition.lParent) && this.offset > supportsCondition.lParent && (!Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(supportsCondition.rParent) || this.offset <= supportsCondition.rParent)) {
            return this.getCompletionsForDeclarationProperty(null, result);
        }
        return result;
    };
    CSSCompletion.prototype.getCompletionsForSupports = function (supports, result) {
        var declarations = supports.getDeclarations();
        var inInCondition = !declarations || this.offset <= declarations.offset;
        if (inInCondition) {
            var child = supports.findFirstChildBeforeOffset(this.offset);
            if (child instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["_5" /* SupportsCondition */]) {
                return this.getCompletionsForSupportsCondition(child, result);
            }
            return result;
        }
        return this.getCompletionForTopLevel(result);
    };
    CSSCompletion.prototype.getCompletionsForExtendsReference = function (extendsRef, existingNode, result) {
        return result;
    };
    CSSCompletion.prototype.getCompletionForUriLiteralValue = function (uriLiteralNode, result) {
        var uriValue;
        var position;
        var range;
        // No children, empty value
        if (!uriLiteralNode.hasChildren()) {
            uriValue = '';
            position = this.position;
            var emptyURIValuePosition = this.textDocument.positionAt(uriLiteralNode.offset + 'url('.length);
            range = __WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["n" /* Range */].create(emptyURIValuePosition, emptyURIValuePosition);
        }
        else {
            var uriValueNode = uriLiteralNode.getChild(0);
            uriValue = uriValueNode.getText();
            position = this.position;
            range = this.getCompletionRange(uriValueNode);
        }
        this.completionParticipants.forEach(function (participant) {
            if (participant.onCssURILiteralValue) {
                participant.onCssURILiteralValue({
                    uriValue: uriValue,
                    position: position,
                    range: range
                });
            }
        });
        return result;
    };
    CSSCompletion.prototype.getCompletionForImportPath = function (importPathNode, result) {
        var _this = this;
        this.completionParticipants.forEach(function (participant) {
            if (participant.onCssImportPath) {
                participant.onCssImportPath({
                    pathValue: importPathNode.getText(),
                    position: _this.position,
                    range: _this.getCompletionRange(importPathNode)
                });
            }
        });
        return result;
    };
    CSSCompletion.prototype.doesSupportMarkdown = function () {
        if (!Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(this.supportsMarkdown)) {
            if (!Object(__WEBPACK_IMPORTED_MODULE_6__utils_objects_js__["a" /* isDefined */])(this.clientCapabilities)) {
                this.supportsMarkdown = true;
                return this.supportsMarkdown;
            }
            var completion = this.clientCapabilities.textDocument && this.clientCapabilities.textDocument.completion;
            this.supportsMarkdown = completion && completion.completionItem && Array.isArray(completion.completionItem.documentationFormat) && completion.completionItem.documentationFormat.indexOf(__WEBPACK_IMPORTED_MODULE_4__cssLanguageTypes_js__["l" /* MarkupKind */].Markdown) !== -1;
        }
        return this.supportsMarkdown;
    };
    return CSSCompletion;
}());

function isDeprecated(entry) {
    if (entry.status && (entry.status === 'nonstandard' || entry.status === 'obsolete')) {
        return true;
    }
    return false;
}
/**
 * Rank number should all be same length strings
 */
function computeRankNumber(n) {
    var nstr = n.toString();
    switch (nstr.length) {
        case 4:
            return nstr;
        case 3:
            return '0' + nstr;
        case 2:
            return '00' + nstr;
        case 1:
            return '000' + nstr;
        default:
            return '0000';
    }
}
var Set = /** @class */ (function () {
    function Set() {
        this.entries = {};
    }
    Set.prototype.add = function (entry) {
        this.entries[entry] = true;
    };
    Set.prototype.getEntries = function () {
        return Object.keys(this.entries);
    };
    return Set;
}());
function moveCursorInsideParenthesis(text) {
    return text.replace(/\(\)$/, "($1)");
}
function collectValues(styleSheet, declaration) {
    var fullPropertyName = declaration.getFullPropertyName();
    var entries = new Set();
    function visitValue(node) {
        if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["y" /* Identifier */] || node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["U" /* NumericValue */] || node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["x" /* HexColorValue */]) {
            entries.add(node.getText());
        }
        return true;
    }
    function matchesProperty(decl) {
        var propertyName = decl.getFullPropertyName();
        return fullPropertyName === propertyName;
    }
    function vistNode(node) {
        if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["h" /* Declaration */] && node !== declaration) {
            if (matchesProperty(node)) {
                var value = node.getValue();
                if (value) {
                    value.accept(visitValue);
                }
            }
        }
        return true;
    }
    styleSheet.accept(vistNode);
    return entries;
}
var ColorValueCollector = /** @class */ (function () {
    function ColorValueCollector(entries, currentOffset) {
        this.entries = entries;
        this.currentOffset = currentOffset;
        // nothing to do
    }
    ColorValueCollector.prototype.visitNode = function (node) {
        if (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["x" /* HexColorValue */] || (node instanceof __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["s" /* Function */] && __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["n" /* isColorConstructor */](node))) {
            if (this.currentOffset < node.offset || node.end < this.currentOffset) {
                this.entries.add(node.getText());
            }
        }
        return true;
    };
    return ColorValueCollector;
}());
function getCurrentWord(document, offset) {
    var i = offset - 1;
    var text = document.getText();
    while (i >= 0 && ' \t\n\r":{[()]},*>+'.indexOf(text.charAt(i)) === -1) {
        i--;
    }
    return text.substring(i + 1, offset);
}
function isColorString(s) {
    // From https://stackoverflow.com/questions/8027423/how-to-check-if-a-string-is-a-valid-hex-color-representation/8027444
    return (s.toLowerCase() in __WEBPACK_IMPORTED_MODULE_2__languageFacts_facts_js__["e" /* colors */]) || /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(s);
}


/***/ }),

/***/ 774:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = findFirst;
/* harmony export (immutable) */ __webpack_exports__["b"] = includes;
/* harmony export (immutable) */ __webpack_exports__["c"] = union;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

/**
 * Takes a sorted array and a function p. The array is sorted in such a way that all elements where p(x) is false
 * are located before all elements where p(x) is true.
 * @returns the least x for which p(x) is true or array.length if no element fullfills the given function.
 */
function findFirst(array, p) {
    var low = 0, high = array.length;
    if (high === 0) {
        return 0; // no children
    }
    while (low < high) {
        var mid = Math.floor((low + high) / 2);
        if (p(array[mid])) {
            high = mid;
        }
        else {
            low = mid + 1;
        }
    }
    return low;
}
function includes(array, item) {
    return array.indexOf(item) !== -1;
}
function union() {
    var arrays = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        arrays[_i] = arguments[_i];
    }
    var result = [];
    for (var _a = 0, arrays_1 = arrays; _a < arrays_1.length; _a++) {
        var array = arrays_1[_a];
        for (var _b = 0, array_1 = array; _b < array_1.length; _b++) {
            var item = array_1[_b];
            if (!includes(result, item)) {
                result.push(item);
            }
        }
    }
    return result;
}


/***/ }),

/***/ 775:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export Rule */
/* unused harmony export Setting */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return Rules; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return Settings; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LintConfigurationSettings; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__ = __webpack_require__(756);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__fillers_vscode_nls_js__ = __webpack_require__(757);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



var localize = __WEBPACK_IMPORTED_MODULE_1__fillers_vscode_nls_js__["a" /* loadMessageBundle */]();
var Warning = __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["F" /* Level */].Warning;
var Error = __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["F" /* Level */].Error;
var Ignore = __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["F" /* Level */].Ignore;
var Rule = /** @class */ (function () {
    function Rule(id, message, defaultValue) {
        this.id = id;
        this.message = message;
        this.defaultValue = defaultValue;
        // nothing to do
    }
    return Rule;
}());

var Setting = /** @class */ (function () {
    function Setting(id, message, defaultValue) {
        this.id = id;
        this.message = message;
        this.defaultValue = defaultValue;
        // nothing to do
    }
    return Setting;
}());

var Rules = {
    AllVendorPrefixes: new Rule('compatibleVendorPrefixes', localize('rule.vendorprefixes.all', "When using a vendor-specific prefix make sure to also include all other vendor-specific properties"), Ignore),
    IncludeStandardPropertyWhenUsingVendorPrefix: new Rule('vendorPrefix', localize('rule.standardvendorprefix.all', "When using a vendor-specific prefix also include the standard property"), Warning),
    DuplicateDeclarations: new Rule('duplicateProperties', localize('rule.duplicateDeclarations', "Do not use duplicate style definitions"), Ignore),
    EmptyRuleSet: new Rule('emptyRules', localize('rule.emptyRuleSets', "Do not use empty rulesets"), Warning),
    ImportStatemement: new Rule('importStatement', localize('rule.importDirective', "Import statements do not load in parallel"), Ignore),
    BewareOfBoxModelSize: new Rule('boxModel', localize('rule.bewareOfBoxModelSize', "Do not use width or height when using padding or border"), Ignore),
    UniversalSelector: new Rule('universalSelector', localize('rule.universalSelector', "The universal selector (*) is known to be slow"), Ignore),
    ZeroWithUnit: new Rule('zeroUnits', localize('rule.zeroWidthUnit', "No unit for zero needed"), Ignore),
    RequiredPropertiesForFontFace: new Rule('fontFaceProperties', localize('rule.fontFaceProperties', "@font-face rule must define 'src' and 'font-family' properties"), Warning),
    HexColorLength: new Rule('hexColorLength', localize('rule.hexColor', "Hex colors must consist of three, four, six or eight hex numbers"), Error),
    ArgsInColorFunction: new Rule('argumentsInColorFunction', localize('rule.colorFunction', "Invalid number of parameters"), Error),
    UnknownProperty: new Rule('unknownProperties', localize('rule.unknownProperty', "Unknown property."), Warning),
    UnknownAtRules: new Rule('unknownAtRules', localize('rule.unknownAtRules', "Unknown at-rule."), Warning),
    IEStarHack: new Rule('ieHack', localize('rule.ieHack', "IE hacks are only necessary when supporting IE7 and older"), Ignore),
    UnknownVendorSpecificProperty: new Rule('unknownVendorSpecificProperties', localize('rule.unknownVendorSpecificProperty', "Unknown vendor specific property."), Ignore),
    PropertyIgnoredDueToDisplay: new Rule('propertyIgnoredDueToDisplay', localize('rule.propertyIgnoredDueToDisplay', "Property is ignored due to the display."), Warning),
    AvoidImportant: new Rule('important', localize('rule.avoidImportant', "Avoid using !important. It is an indication that the specificity of the entire CSS has gotten out of control and needs to be refactored."), Ignore),
    AvoidFloat: new Rule('float', localize('rule.avoidFloat', "Avoid using 'float'. Floats lead to fragile CSS that is easy to break if one aspect of the layout changes."), Ignore),
    AvoidIdSelector: new Rule('idSelector', localize('rule.avoidIdSelector', "Selectors should not contain IDs because these rules are too tightly coupled with the HTML."), Ignore),
};
var Settings = {
    ValidProperties: new Setting('validProperties', localize('rule.validProperties', "A list of properties that are not validated against the `unknownProperties` rule."), [])
};
var LintConfigurationSettings = /** @class */ (function () {
    function LintConfigurationSettings(conf) {
        if (conf === void 0) { conf = {}; }
        this.conf = conf;
    }
    LintConfigurationSettings.prototype.getRule = function (rule) {
        if (this.conf.hasOwnProperty(rule.id)) {
            var level = toLevel(this.conf[rule.id]);
            if (level) {
                return level;
            }
        }
        return rule.defaultValue;
    };
    LintConfigurationSettings.prototype.getSetting = function (setting) {
        return this.conf[setting.id];
    };
    return LintConfigurationSettings;
}());

function toLevel(level) {
    switch (level) {
        case 'ignore': return __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["F" /* Level */].Ignore;
        case 'warning': return __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["F" /* Level */].Warning;
        case 'error': return __WEBPACK_IMPORTED_MODULE_0__parser_cssNodes_js__["F" /* Level */].Error;
    }
    return null;
}


/***/ }),

/***/ 782:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CSSDataManager; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__utils_objects_js__ = __webpack_require__(768);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var CSSDataManager = /** @class */ (function () {
    function CSSDataManager(dataProviders) {
        this.dataProviders = dataProviders;
        this._propertySet = {};
        this._atDirectiveSet = {};
        this._pseudoClassSet = {};
        this._pseudoElementSet = {};
        this._properties = [];
        this._atDirectives = [];
        this._pseudoClasses = [];
        this._pseudoElements = [];
        this.collectData();
    }
    CSSDataManager.prototype.addDataProviders = function (providers) {
        this.dataProviders = this.dataProviders.concat(providers);
        this.collectData();
    };
    /**
     * Collect all data  & handle duplicates
     */
    CSSDataManager.prototype.collectData = function () {
        var _this = this;
        this.dataProviders.forEach(function (provider) {
            provider.provideProperties().forEach(function (p) {
                if (!_this._propertySet[p.name]) {
                    _this._propertySet[p.name] = p;
                }
            });
            provider.provideAtDirectives().forEach(function (p) {
                if (!_this._atDirectiveSet[p.name]) {
                    _this._atDirectiveSet[p.name] = p;
                }
            });
            provider.providePseudoClasses().forEach(function (p) {
                if (!_this._pseudoClassSet[p.name]) {
                    _this._pseudoClassSet[p.name] = p;
                }
            });
            provider.providePseudoElements().forEach(function (p) {
                if (!_this._pseudoElementSet[p.name]) {
                    _this._pseudoElementSet[p.name] = p;
                }
            });
        });
        this._properties = __WEBPACK_IMPORTED_MODULE_0__utils_objects_js__["b" /* values */](this._propertySet);
        this._atDirectives = __WEBPACK_IMPORTED_MODULE_0__utils_objects_js__["b" /* values */](this._atDirectiveSet);
        this._pseudoClasses = __WEBPACK_IMPORTED_MODULE_0__utils_objects_js__["b" /* values */](this._pseudoClassSet);
        this._pseudoElements = __WEBPACK_IMPORTED_MODULE_0__utils_objects_js__["b" /* values */](this._pseudoElementSet);
    };
    CSSDataManager.prototype.getProperty = function (name) { return this._propertySet[name]; };
    CSSDataManager.prototype.getAtDirective = function (name) { return this._atDirectiveSet[name]; };
    CSSDataManager.prototype.getPseudoClass = function (name) { return this._pseudoClassSet[name]; };
    CSSDataManager.prototype.getPseudoElement = function (name) { return this._pseudoElementSet[name]; };
    CSSDataManager.prototype.getProperties = function () {
        return this._properties;
    };
    CSSDataManager.prototype.getAtDirectives = function () {
        return this._atDirectives;
    };
    CSSDataManager.prototype.getPseudoClasses = function () {
        return this._pseudoClasses;
    };
    CSSDataManager.prototype.getPseudoElements = function () {
        return this._pseudoElements;
    };
    CSSDataManager.prototype.isKnownProperty = function (name) {
        return name.toLowerCase() in this._propertySet;
    };
    CSSDataManager.prototype.isStandardProperty = function (name) {
        return this.isKnownProperty(name) &&
            (!this._propertySet[name.toLowerCase()].status || this._propertySet[name.toLowerCase()].status === 'standard');
    };
    return CSSDataManager;
}());



/***/ }),

/***/ 783:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CSSDataProvider; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var CSSDataProvider = /** @class */ (function () {
    /**
     * Currently, unversioned data uses the V1 implementation
     * In the future when the provider handles multiple versions of HTML custom data,
     * use the latest implementation for unversioned data
     */
    function CSSDataProvider(data) {
        this._properties = [];
        this._atDirectives = [];
        this._pseudoClasses = [];
        this._pseudoElements = [];
        this.addData(data);
    }
    CSSDataProvider.prototype.provideProperties = function () {
        return this._properties;
    };
    CSSDataProvider.prototype.provideAtDirectives = function () {
        return this._atDirectives;
    };
    CSSDataProvider.prototype.providePseudoClasses = function () {
        return this._pseudoClasses;
    };
    CSSDataProvider.prototype.providePseudoElements = function () {
        return this._pseudoElements;
    };
    CSSDataProvider.prototype.addData = function (data) {
        if (data.properties) {
            this._properties = this._properties.concat(data.properties);
        }
        if (data.atDirectives) {
            this._atDirectives = this._atDirectives.concat(data.atDirectives);
        }
        if (data.pseudoClasses) {
            this._pseudoClasses = this._pseudoClasses.concat(data.pseudoClasses);
        }
        if (data.pseudoElements) {
            this._pseudoElements = this._pseudoElements.concat(data.pseudoElements);
        }
    };
    return CSSDataProvider;
}());



/***/ }),

/***/ 784:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export Scope */
/* unused harmony export GlobalScope */
/* unused harmony export Symbol */
/* unused harmony export ScopeBuilder */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Symbols; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__ = __webpack_require__(756);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__utils_arrays_js__ = __webpack_require__(774);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var Scope = /** @class */ (function () {
    function Scope(offset, length) {
        this.offset = offset;
        this.length = length;
        this.symbols = [];
        this.parent = null;
        this.children = [];
    }
    Scope.prototype.addChild = function (scope) {
        this.children.push(scope);
        scope.setParent(this);
    };
    Scope.prototype.setParent = function (scope) {
        this.parent = scope;
    };
    Scope.prototype.findScope = function (offset, length) {
        if (length === void 0) { length = 0; }
        if (this.offset <= offset && this.offset + this.length > offset + length || this.offset === offset && this.length === length) {
            return this.findInScope(offset, length);
        }
        return null;
    };
    Scope.prototype.findInScope = function (offset, length) {
        if (length === void 0) { length = 0; }
        // find the first scope child that has an offset larger than offset + length
        var end = offset + length;
        var idx = Object(__WEBPACK_IMPORTED_MODULE_1__utils_arrays_js__["a" /* findFirst */])(this.children, function (s) { return s.offset > end; });
        if (idx === 0) {
            // all scopes have offsets larger than our end
            return this;
        }
        var res = this.children[idx - 1];
        if (res.offset <= offset && res.offset + res.length >= offset + length) {
            return res.findInScope(offset, length);
        }
        return this;
    };
    Scope.prototype.addSymbol = function (symbol) {
        this.symbols.push(symbol);
    };
    Scope.prototype.getSymbol = function (name, type) {
        for (var index = 0; index < this.symbols.length; index++) {
            var symbol = this.symbols[index];
            if (symbol.name === name && symbol.type === type) {
                return symbol;
            }
        }
        return null;
    };
    Scope.prototype.getSymbols = function () {
        return this.symbols;
    };
    return Scope;
}());

var GlobalScope = /** @class */ (function (_super) {
    __extends(GlobalScope, _super);
    function GlobalScope() {
        return _super.call(this, 0, Number.MAX_VALUE) || this;
    }
    return GlobalScope;
}(Scope));

var Symbol = /** @class */ (function () {
    function Symbol(name, value, node, type) {
        this.name = name;
        this.value = value;
        this.node = node;
        this.type = type;
    }
    return Symbol;
}());

var ScopeBuilder = /** @class */ (function () {
    function ScopeBuilder(scope) {
        this.scope = scope;
    }
    ScopeBuilder.prototype.addSymbol = function (node, name, value, type) {
        if (node.offset !== -1) {
            var current = this.scope.findScope(node.offset, node.length);
            if (current) {
                current.addSymbol(new Symbol(name, value, node, type));
            }
        }
    };
    ScopeBuilder.prototype.addScope = function (node) {
        if (node.offset !== -1) {
            var current = this.scope.findScope(node.offset, node.length);
            if (current && (current.offset !== node.offset || current.length !== node.length)) { // scope already known?
                var newScope = new Scope(node.offset, node.length);
                current.addChild(newScope);
                return newScope;
            }
            return current;
        }
        return null;
    };
    ScopeBuilder.prototype.addSymbolToChildScope = function (scopeNode, node, name, value, type) {
        if (scopeNode && scopeNode.offset !== -1) {
            var current = this.addScope(scopeNode); // create the scope or gets the existing one
            if (current) {
                current.addSymbol(new Symbol(name, value, node, type));
            }
        }
    };
    ScopeBuilder.prototype.visitNode = function (node) {
        switch (node.type) {
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].Keyframe:
                this.addSymbol(node, node.getName(), void 0, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Keyframe);
                return true;
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].CustomPropertyDeclaration:
                return this.visitCustomPropertyDeclarationNode(node);
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].VariableDeclaration:
                return this.visitVariableDeclarationNode(node);
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].Ruleset:
                return this.visitRuleSet(node);
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].MixinDeclaration:
                this.addSymbol(node, node.getName(), void 0, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Mixin);
                return true;
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].FunctionDeclaration:
                this.addSymbol(node, node.getName(), void 0, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Function);
                return true;
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].FunctionParameter: {
                return this.visitFunctionParameterNode(node);
            }
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].Declarations:
                this.addScope(node);
                return true;
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].For:
                var forNode = node;
                var scopeNode = forNode.getDeclarations();
                if (scopeNode && forNode.variable) {
                    this.addSymbolToChildScope(scopeNode, forNode.variable, forNode.variable.getName(), void 0, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Variable);
                }
                return true;
            case __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].Each: {
                var eachNode = node;
                var scopeNode_1 = eachNode.getDeclarations();
                if (scopeNode_1) {
                    var variables = eachNode.getVariables().getChildren();
                    for (var _i = 0, variables_1 = variables; _i < variables_1.length; _i++) {
                        var variable = variables_1[_i];
                        this.addSymbolToChildScope(scopeNode_1, variable, variable.getName(), void 0, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Variable);
                    }
                }
                return true;
            }
        }
        return true;
    };
    ScopeBuilder.prototype.visitRuleSet = function (node) {
        var current = this.scope.findScope(node.offset, node.length);
        if (current) {
            for (var _i = 0, _a = node.getSelectors().getChildren(); _i < _a.length; _i++) {
                var child = _a[_i];
                if (child instanceof __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["_1" /* Selector */]) {
                    if (child.getChildren().length === 1) { // only selectors with a single element can be extended
                        current.addSymbol(new Symbol(child.getChild(0).getText(), void 0, child, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Rule));
                    }
                }
            }
        }
        return true;
    };
    ScopeBuilder.prototype.visitVariableDeclarationNode = function (node) {
        var value = node.getValue() ? node.getValue().getText() : void 0;
        this.addSymbol(node, node.getName(), value, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Variable);
        return true;
    };
    ScopeBuilder.prototype.visitFunctionParameterNode = function (node) {
        // parameters are part of the body scope
        var scopeNode = node.getParent().getDeclarations();
        if (scopeNode) {
            var valueNode = node.getDefaultValue();
            var value = valueNode ? valueNode.getText() : void 0;
            this.addSymbolToChildScope(scopeNode, node, node.getName(), value, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Variable);
        }
        return true;
    };
    ScopeBuilder.prototype.visitCustomPropertyDeclarationNode = function (node) {
        var value = node.getValue() ? node.getValue().getText() : '';
        this.addCSSVariable(node.getProperty(), node.getProperty().getName(), value, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Variable);
        return true;
    };
    ScopeBuilder.prototype.addCSSVariable = function (node, name, value, type) {
        if (node.offset !== -1) {
            this.scope.addSymbol(new Symbol(name, value, node, type));
        }
    };
    return ScopeBuilder;
}());

var Symbols = /** @class */ (function () {
    function Symbols(node) {
        this.global = new GlobalScope();
        node.acceptVisitor(new ScopeBuilder(this.global));
    }
    Symbols.prototype.findSymbolsAtOffset = function (offset, referenceType) {
        var scope = this.global.findScope(offset, 0);
        var result = [];
        var names = {};
        while (scope) {
            var symbols = scope.getSymbols();
            for (var i = 0; i < symbols.length; i++) {
                var symbol = symbols[i];
                if (symbol.type === referenceType && !names[symbol.name]) {
                    result.push(symbol);
                    names[symbol.name] = true;
                }
            }
            scope = scope.parent;
        }
        return result;
    };
    Symbols.prototype.internalFindSymbol = function (node, referenceTypes) {
        var scopeNode = node;
        if (node.parent instanceof __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["v" /* FunctionParameter */] && node.parent.getParent() instanceof __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["e" /* BodyDeclaration */]) {
            scopeNode = node.parent.getParent().getDeclarations();
        }
        if (node.parent instanceof __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["t" /* FunctionArgument */] && node.parent.getParent() instanceof __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["s" /* Function */]) {
            var funcId = node.parent.getParent().getIdentifier();
            if (funcId) {
                var functionSymbol = this.internalFindSymbol(funcId, [__WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Function]);
                if (functionSymbol) {
                    scopeNode = functionSymbol.node.getDeclarations();
                }
            }
        }
        if (!scopeNode) {
            return null;
        }
        var name = node.getText();
        var scope = this.global.findScope(scopeNode.offset, scopeNode.length);
        while (scope) {
            for (var index = 0; index < referenceTypes.length; index++) {
                var type = referenceTypes[index];
                var symbol = scope.getSymbol(name, type);
                if (symbol) {
                    return symbol;
                }
            }
            scope = scope.parent;
        }
        return null;
    };
    Symbols.prototype.evaluateReferenceTypes = function (node) {
        if (node instanceof __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["y" /* Identifier */]) {
            var referenceTypes = node.referenceTypes;
            if (referenceTypes) {
                return referenceTypes;
            }
            else {
                if (node.isCustomProperty) {
                    return [__WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Variable];
                }
                // are a reference to a keyframe?
                var decl = __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["_15" /* getParentDeclaration */](node);
                if (decl) {
                    var propertyName = decl.getNonPrefixedPropertyName();
                    if ((propertyName === 'animation' || propertyName === 'animation-name')
                        && decl.getValue() && decl.getValue().offset === node.offset) {
                        return [__WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Keyframe];
                    }
                }
            }
        }
        else if (node instanceof __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["_9" /* Variable */]) {
            return [__WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Variable];
        }
        var selector = node.findAParent(__WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].Selector, __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].ExtendsReference);
        if (selector) {
            return [__WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["Z" /* ReferenceType */].Rule];
        }
        return null;
    };
    Symbols.prototype.findSymbolFromNode = function (node) {
        if (!node) {
            return null;
        }
        while (node.type === __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].Interpolation) {
            node = node.getParent();
        }
        var referenceTypes = this.evaluateReferenceTypes(node);
        if (referenceTypes) {
            return this.internalFindSymbol(node, referenceTypes);
        }
        return null;
    };
    Symbols.prototype.matchesSymbol = function (node, symbol) {
        if (!node) {
            return false;
        }
        while (node.type === __WEBPACK_IMPORTED_MODULE_0__cssNodes_js__["S" /* NodeType */].Interpolation) {
            node = node.getParent();
        }
        if (!node.matches(symbol.name)) {
            return false;
        }
        var referenceTypes = this.evaluateReferenceTypes(node);
        if (!referenceTypes || referenceTypes.indexOf(symbol.type) === -1) {
            return false;
        }
        var nodeSymbol = this.internalFindSymbol(node, referenceTypes);
        return nodeSymbol === symbol;
    };
    Symbols.prototype.findSymbol = function (name, type, offset) {
        var scope = this.global.findScope(offset);
        while (scope) {
            var symbol = scope.getSymbol(name, type);
            if (symbol) {
                return symbol;
            }
            scope = scope.parent;
        }
        return null;
    };
    return Symbols;
}());



/***/ }),

/***/ 785:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return Position; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return Range; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return Location; });
/* unused harmony export LocationLink */
/* unused harmony export Color */
/* unused harmony export ColorInformation */
/* unused harmony export ColorPresentation */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return FoldingRangeKind; });
/* unused harmony export FoldingRange */
/* unused harmony export DiagnosticRelatedInformation */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return DiagnosticSeverity; });
/* unused harmony export DiagnosticTag */
/* unused harmony export Diagnostic */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return Command; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return TextEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return TextDocumentEdit; });
/* unused harmony export CreateFile */
/* unused harmony export RenameFile */
/* unused harmony export DeleteFile */
/* unused harmony export WorkspaceEdit */
/* unused harmony export WorkspaceChange */
/* unused harmony export TextDocumentIdentifier */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "r", function() { return VersionedTextDocumentIdentifier; });
/* unused harmony export TextDocumentItem */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return MarkupKind; });
/* unused harmony export MarkupContent */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return CompletionItemKind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return InsertTextFormat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return CompletionItemTag; });
/* unused harmony export CompletionItem */
/* unused harmony export CompletionList */
/* unused harmony export MarkedString */
/* unused harmony export Hover */
/* unused harmony export ParameterInformation */
/* unused harmony export SignatureInformation */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return DocumentHighlightKind; });
/* unused harmony export DocumentHighlight */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return SymbolKind; });
/* unused harmony export SymbolTag */
/* unused harmony export SymbolInformation */
/* unused harmony export DocumentSymbol */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CodeActionKind; });
/* unused harmony export CodeActionContext */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CodeAction; });
/* unused harmony export CodeLens */
/* unused harmony export FormattingOptions */
/* unused harmony export DocumentLink */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return SelectionRange; });
/* unused harmony export EOL */
/* unused harmony export TextDocument */
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */

/**
 * The Position namespace provides helper functions to work with
 * [Position](#Position) literals.
 */
var Position;
(function (Position) {
    /**
     * Creates a new Position literal from the given line and character.
     * @param line The position's line.
     * @param character The position's character.
     */
    function create(line, character) {
        return { line: line, character: character };
    }
    Position.create = create;
    /**
     * Checks whether the given liternal conforms to the [Position](#Position) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.objectLiteral(candidate) && Is.number(candidate.line) && Is.number(candidate.character);
    }
    Position.is = is;
})(Position || (Position = {}));
/**
 * The Range namespace provides helper functions to work with
 * [Range](#Range) literals.
 */
var Range;
(function (Range) {
    function create(one, two, three, four) {
        if (Is.number(one) && Is.number(two) && Is.number(three) && Is.number(four)) {
            return { start: Position.create(one, two), end: Position.create(three, four) };
        }
        else if (Position.is(one) && Position.is(two)) {
            return { start: one, end: two };
        }
        else {
            throw new Error("Range#create called with invalid arguments[" + one + ", " + two + ", " + three + ", " + four + "]");
        }
    }
    Range.create = create;
    /**
     * Checks whether the given literal conforms to the [Range](#Range) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.objectLiteral(candidate) && Position.is(candidate.start) && Position.is(candidate.end);
    }
    Range.is = is;
})(Range || (Range = {}));
/**
 * The Location namespace provides helper functions to work with
 * [Location](#Location) literals.
 */
var Location;
(function (Location) {
    /**
     * Creates a Location literal.
     * @param uri The location's uri.
     * @param range The location's range.
     */
    function create(uri, range) {
        return { uri: uri, range: range };
    }
    Location.create = create;
    /**
     * Checks whether the given literal conforms to the [Location](#Location) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Range.is(candidate.range) && (Is.string(candidate.uri) || Is.undefined(candidate.uri));
    }
    Location.is = is;
})(Location || (Location = {}));
/**
 * The LocationLink namespace provides helper functions to work with
 * [LocationLink](#LocationLink) literals.
 */
var LocationLink;
(function (LocationLink) {
    /**
     * Creates a LocationLink literal.
     * @param targetUri The definition's uri.
     * @param targetRange The full range of the definition.
     * @param targetSelectionRange The span of the symbol definition at the target.
     * @param originSelectionRange The span of the symbol being defined in the originating source file.
     */
    function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
        return { targetUri: targetUri, targetRange: targetRange, targetSelectionRange: targetSelectionRange, originSelectionRange: originSelectionRange };
    }
    LocationLink.create = create;
    /**
     * Checks whether the given literal conforms to the [LocationLink](#LocationLink) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Range.is(candidate.targetRange) && Is.string(candidate.targetUri)
            && (Range.is(candidate.targetSelectionRange) || Is.undefined(candidate.targetSelectionRange))
            && (Range.is(candidate.originSelectionRange) || Is.undefined(candidate.originSelectionRange));
    }
    LocationLink.is = is;
})(LocationLink || (LocationLink = {}));
/**
 * The Color namespace provides helper functions to work with
 * [Color](#Color) literals.
 */
var Color;
(function (Color) {
    /**
     * Creates a new Color literal.
     */
    function create(red, green, blue, alpha) {
        return {
            red: red,
            green: green,
            blue: blue,
            alpha: alpha,
        };
    }
    Color.create = create;
    /**
     * Checks whether the given literal conforms to the [Color](#Color) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.number(candidate.red)
            && Is.number(candidate.green)
            && Is.number(candidate.blue)
            && Is.number(candidate.alpha);
    }
    Color.is = is;
})(Color || (Color = {}));
/**
 * The ColorInformation namespace provides helper functions to work with
 * [ColorInformation](#ColorInformation) literals.
 */
var ColorInformation;
(function (ColorInformation) {
    /**
     * Creates a new ColorInformation literal.
     */
    function create(range, color) {
        return {
            range: range,
            color: color,
        };
    }
    ColorInformation.create = create;
    /**
     * Checks whether the given literal conforms to the [ColorInformation](#ColorInformation) interface.
     */
    function is(value) {
        var candidate = value;
        return Range.is(candidate.range) && Color.is(candidate.color);
    }
    ColorInformation.is = is;
})(ColorInformation || (ColorInformation = {}));
/**
 * The Color namespace provides helper functions to work with
 * [ColorPresentation](#ColorPresentation) literals.
 */
var ColorPresentation;
(function (ColorPresentation) {
    /**
     * Creates a new ColorInformation literal.
     */
    function create(label, textEdit, additionalTextEdits) {
        return {
            label: label,
            textEdit: textEdit,
            additionalTextEdits: additionalTextEdits,
        };
    }
    ColorPresentation.create = create;
    /**
     * Checks whether the given literal conforms to the [ColorInformation](#ColorInformation) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.string(candidate.label)
            && (Is.undefined(candidate.textEdit) || TextEdit.is(candidate))
            && (Is.undefined(candidate.additionalTextEdits) || Is.typedArray(candidate.additionalTextEdits, TextEdit.is));
    }
    ColorPresentation.is = is;
})(ColorPresentation || (ColorPresentation = {}));
/**
 * Enum of known range kinds
 */
var FoldingRangeKind;
(function (FoldingRangeKind) {
    /**
     * Folding range for a comment
     */
    FoldingRangeKind["Comment"] = "comment";
    /**
     * Folding range for a imports or includes
     */
    FoldingRangeKind["Imports"] = "imports";
    /**
     * Folding range for a region (e.g. `#region`)
     */
    FoldingRangeKind["Region"] = "region";
})(FoldingRangeKind || (FoldingRangeKind = {}));
/**
 * The folding range namespace provides helper functions to work with
 * [FoldingRange](#FoldingRange) literals.
 */
var FoldingRange;
(function (FoldingRange) {
    /**
     * Creates a new FoldingRange literal.
     */
    function create(startLine, endLine, startCharacter, endCharacter, kind) {
        var result = {
            startLine: startLine,
            endLine: endLine
        };
        if (Is.defined(startCharacter)) {
            result.startCharacter = startCharacter;
        }
        if (Is.defined(endCharacter)) {
            result.endCharacter = endCharacter;
        }
        if (Is.defined(kind)) {
            result.kind = kind;
        }
        return result;
    }
    FoldingRange.create = create;
    /**
     * Checks whether the given literal conforms to the [FoldingRange](#FoldingRange) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.number(candidate.startLine) && Is.number(candidate.startLine)
            && (Is.undefined(candidate.startCharacter) || Is.number(candidate.startCharacter))
            && (Is.undefined(candidate.endCharacter) || Is.number(candidate.endCharacter))
            && (Is.undefined(candidate.kind) || Is.string(candidate.kind));
    }
    FoldingRange.is = is;
})(FoldingRange || (FoldingRange = {}));
/**
 * The DiagnosticRelatedInformation namespace provides helper functions to work with
 * [DiagnosticRelatedInformation](#DiagnosticRelatedInformation) literals.
 */
var DiagnosticRelatedInformation;
(function (DiagnosticRelatedInformation) {
    /**
     * Creates a new DiagnosticRelatedInformation literal.
     */
    function create(location, message) {
        return {
            location: location,
            message: message
        };
    }
    DiagnosticRelatedInformation.create = create;
    /**
     * Checks whether the given literal conforms to the [DiagnosticRelatedInformation](#DiagnosticRelatedInformation) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Location.is(candidate.location) && Is.string(candidate.message);
    }
    DiagnosticRelatedInformation.is = is;
})(DiagnosticRelatedInformation || (DiagnosticRelatedInformation = {}));
/**
 * The diagnostic's severity.
 */
var DiagnosticSeverity;
(function (DiagnosticSeverity) {
    /**
     * Reports an error.
     */
    DiagnosticSeverity.Error = 1;
    /**
     * Reports a warning.
     */
    DiagnosticSeverity.Warning = 2;
    /**
     * Reports an information.
     */
    DiagnosticSeverity.Information = 3;
    /**
     * Reports a hint.
     */
    DiagnosticSeverity.Hint = 4;
})(DiagnosticSeverity || (DiagnosticSeverity = {}));
/**
 * The diagnostic tags.
 *
 * @since 3.15.0
 */
var DiagnosticTag;
(function (DiagnosticTag) {
    /**
     * Unused or unnecessary code.
     *
     * Clients are allowed to render diagnostics with this tag faded out instead of having
     * an error squiggle.
     */
    DiagnosticTag.Unnecessary = 1;
    /**
     * Deprecated or obsolete code.
     *
     * Clients are allowed to rendered diagnostics with this tag strike through.
     */
    DiagnosticTag.Deprecated = 2;
})(DiagnosticTag || (DiagnosticTag = {}));
/**
 * The Diagnostic namespace provides helper functions to work with
 * [Diagnostic](#Diagnostic) literals.
 */
var Diagnostic;
(function (Diagnostic) {
    /**
     * Creates a new Diagnostic literal.
     */
    function create(range, message, severity, code, source, relatedInformation) {
        var result = { range: range, message: message };
        if (Is.defined(severity)) {
            result.severity = severity;
        }
        if (Is.defined(code)) {
            result.code = code;
        }
        if (Is.defined(source)) {
            result.source = source;
        }
        if (Is.defined(relatedInformation)) {
            result.relatedInformation = relatedInformation;
        }
        return result;
    }
    Diagnostic.create = create;
    /**
     * Checks whether the given literal conforms to the [Diagnostic](#Diagnostic) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate)
            && Range.is(candidate.range)
            && Is.string(candidate.message)
            && (Is.number(candidate.severity) || Is.undefined(candidate.severity))
            && (Is.number(candidate.code) || Is.string(candidate.code) || Is.undefined(candidate.code))
            && (Is.string(candidate.source) || Is.undefined(candidate.source))
            && (Is.undefined(candidate.relatedInformation) || Is.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation.is));
    }
    Diagnostic.is = is;
})(Diagnostic || (Diagnostic = {}));
/**
 * The Command namespace provides helper functions to work with
 * [Command](#Command) literals.
 */
var Command;
(function (Command) {
    /**
     * Creates a new Command literal.
     */
    function create(title, command) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var result = { title: title, command: command };
        if (Is.defined(args) && args.length > 0) {
            result.arguments = args;
        }
        return result;
    }
    Command.create = create;
    /**
     * Checks whether the given literal conforms to the [Command](#Command) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.title) && Is.string(candidate.command);
    }
    Command.is = is;
})(Command || (Command = {}));
/**
 * The TextEdit namespace provides helper function to create replace,
 * insert and delete edits more easily.
 */
var TextEdit;
(function (TextEdit) {
    /**
     * Creates a replace text edit.
     * @param range The range of text to be replaced.
     * @param newText The new text.
     */
    function replace(range, newText) {
        return { range: range, newText: newText };
    }
    TextEdit.replace = replace;
    /**
     * Creates a insert text edit.
     * @param position The position to insert the text at.
     * @param newText The text to be inserted.
     */
    function insert(position, newText) {
        return { range: { start: position, end: position }, newText: newText };
    }
    TextEdit.insert = insert;
    /**
     * Creates a delete text edit.
     * @param range The range of text to be deleted.
     */
    function del(range) {
        return { range: range, newText: '' };
    }
    TextEdit.del = del;
    function is(value) {
        var candidate = value;
        return Is.objectLiteral(candidate)
            && Is.string(candidate.newText)
            && Range.is(candidate.range);
    }
    TextEdit.is = is;
})(TextEdit || (TextEdit = {}));
/**
 * The TextDocumentEdit namespace provides helper function to create
 * an edit that manipulates a text document.
 */
var TextDocumentEdit;
(function (TextDocumentEdit) {
    /**
     * Creates a new `TextDocumentEdit`
     */
    function create(textDocument, edits) {
        return { textDocument: textDocument, edits: edits };
    }
    TextDocumentEdit.create = create;
    function is(value) {
        var candidate = value;
        return Is.defined(candidate)
            && VersionedTextDocumentIdentifier.is(candidate.textDocument)
            && Array.isArray(candidate.edits);
    }
    TextDocumentEdit.is = is;
})(TextDocumentEdit || (TextDocumentEdit = {}));
var CreateFile;
(function (CreateFile) {
    function create(uri, options) {
        var result = {
            kind: 'create',
            uri: uri
        };
        if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
        }
        return result;
    }
    CreateFile.create = create;
    function is(value) {
        var candidate = value;
        return candidate && candidate.kind === 'create' && Is.string(candidate.uri) &&
            (candidate.options === void 0 ||
                ((candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))));
    }
    CreateFile.is = is;
})(CreateFile || (CreateFile = {}));
var RenameFile;
(function (RenameFile) {
    function create(oldUri, newUri, options) {
        var result = {
            kind: 'rename',
            oldUri: oldUri,
            newUri: newUri
        };
        if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
        }
        return result;
    }
    RenameFile.create = create;
    function is(value) {
        var candidate = value;
        return candidate && candidate.kind === 'rename' && Is.string(candidate.oldUri) && Is.string(candidate.newUri) &&
            (candidate.options === void 0 ||
                ((candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))));
    }
    RenameFile.is = is;
})(RenameFile || (RenameFile = {}));
var DeleteFile;
(function (DeleteFile) {
    function create(uri, options) {
        var result = {
            kind: 'delete',
            uri: uri
        };
        if (options !== void 0 && (options.recursive !== void 0 || options.ignoreIfNotExists !== void 0)) {
            result.options = options;
        }
        return result;
    }
    DeleteFile.create = create;
    function is(value) {
        var candidate = value;
        return candidate && candidate.kind === 'delete' && Is.string(candidate.uri) &&
            (candidate.options === void 0 ||
                ((candidate.options.recursive === void 0 || Is.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === void 0 || Is.boolean(candidate.options.ignoreIfNotExists))));
    }
    DeleteFile.is = is;
})(DeleteFile || (DeleteFile = {}));
var WorkspaceEdit;
(function (WorkspaceEdit) {
    function is(value) {
        var candidate = value;
        return candidate &&
            (candidate.changes !== void 0 || candidate.documentChanges !== void 0) &&
            (candidate.documentChanges === void 0 || candidate.documentChanges.every(function (change) {
                if (Is.string(change.kind)) {
                    return CreateFile.is(change) || RenameFile.is(change) || DeleteFile.is(change);
                }
                else {
                    return TextDocumentEdit.is(change);
                }
            }));
    }
    WorkspaceEdit.is = is;
})(WorkspaceEdit || (WorkspaceEdit = {}));
var TextEditChangeImpl = /** @class */ (function () {
    function TextEditChangeImpl(edits) {
        this.edits = edits;
    }
    TextEditChangeImpl.prototype.insert = function (position, newText) {
        this.edits.push(TextEdit.insert(position, newText));
    };
    TextEditChangeImpl.prototype.replace = function (range, newText) {
        this.edits.push(TextEdit.replace(range, newText));
    };
    TextEditChangeImpl.prototype.delete = function (range) {
        this.edits.push(TextEdit.del(range));
    };
    TextEditChangeImpl.prototype.add = function (edit) {
        this.edits.push(edit);
    };
    TextEditChangeImpl.prototype.all = function () {
        return this.edits;
    };
    TextEditChangeImpl.prototype.clear = function () {
        this.edits.splice(0, this.edits.length);
    };
    return TextEditChangeImpl;
}());
/**
 * A workspace change helps constructing changes to a workspace.
 */
var WorkspaceChange = /** @class */ (function () {
    function WorkspaceChange(workspaceEdit) {
        var _this = this;
        this._textEditChanges = Object.create(null);
        if (workspaceEdit) {
            this._workspaceEdit = workspaceEdit;
            if (workspaceEdit.documentChanges) {
                workspaceEdit.documentChanges.forEach(function (change) {
                    if (TextDocumentEdit.is(change)) {
                        var textEditChange = new TextEditChangeImpl(change.edits);
                        _this._textEditChanges[change.textDocument.uri] = textEditChange;
                    }
                });
            }
            else if (workspaceEdit.changes) {
                Object.keys(workspaceEdit.changes).forEach(function (key) {
                    var textEditChange = new TextEditChangeImpl(workspaceEdit.changes[key]);
                    _this._textEditChanges[key] = textEditChange;
                });
            }
        }
    }
    Object.defineProperty(WorkspaceChange.prototype, "edit", {
        /**
         * Returns the underlying [WorkspaceEdit](#WorkspaceEdit) literal
         * use to be returned from a workspace edit operation like rename.
         */
        get: function () {
            return this._workspaceEdit;
        },
        enumerable: true,
        configurable: true
    });
    WorkspaceChange.prototype.getTextEditChange = function (key) {
        if (VersionedTextDocumentIdentifier.is(key)) {
            if (!this._workspaceEdit) {
                this._workspaceEdit = {
                    documentChanges: []
                };
            }
            if (!this._workspaceEdit.documentChanges) {
                throw new Error('Workspace edit is not configured for document changes.');
            }
            var textDocument = key;
            var result = this._textEditChanges[textDocument.uri];
            if (!result) {
                var edits = [];
                var textDocumentEdit = {
                    textDocument: textDocument,
                    edits: edits
                };
                this._workspaceEdit.documentChanges.push(textDocumentEdit);
                result = new TextEditChangeImpl(edits);
                this._textEditChanges[textDocument.uri] = result;
            }
            return result;
        }
        else {
            if (!this._workspaceEdit) {
                this._workspaceEdit = {
                    changes: Object.create(null)
                };
            }
            if (!this._workspaceEdit.changes) {
                throw new Error('Workspace edit is not configured for normal text edit changes.');
            }
            var result = this._textEditChanges[key];
            if (!result) {
                var edits = [];
                this._workspaceEdit.changes[key] = edits;
                result = new TextEditChangeImpl(edits);
                this._textEditChanges[key] = result;
            }
            return result;
        }
    };
    WorkspaceChange.prototype.createFile = function (uri, options) {
        this.checkDocumentChanges();
        this._workspaceEdit.documentChanges.push(CreateFile.create(uri, options));
    };
    WorkspaceChange.prototype.renameFile = function (oldUri, newUri, options) {
        this.checkDocumentChanges();
        this._workspaceEdit.documentChanges.push(RenameFile.create(oldUri, newUri, options));
    };
    WorkspaceChange.prototype.deleteFile = function (uri, options) {
        this.checkDocumentChanges();
        this._workspaceEdit.documentChanges.push(DeleteFile.create(uri, options));
    };
    WorkspaceChange.prototype.checkDocumentChanges = function () {
        if (!this._workspaceEdit || !this._workspaceEdit.documentChanges) {
            throw new Error('Workspace edit is not configured for document changes.');
        }
    };
    return WorkspaceChange;
}());

/**
 * The TextDocumentIdentifier namespace provides helper functions to work with
 * [TextDocumentIdentifier](#TextDocumentIdentifier) literals.
 */
var TextDocumentIdentifier;
(function (TextDocumentIdentifier) {
    /**
     * Creates a new TextDocumentIdentifier literal.
     * @param uri The document's uri.
     */
    function create(uri) {
        return { uri: uri };
    }
    TextDocumentIdentifier.create = create;
    /**
     * Checks whether the given literal conforms to the [TextDocumentIdentifier](#TextDocumentIdentifier) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.uri);
    }
    TextDocumentIdentifier.is = is;
})(TextDocumentIdentifier || (TextDocumentIdentifier = {}));
/**
 * The VersionedTextDocumentIdentifier namespace provides helper functions to work with
 * [VersionedTextDocumentIdentifier](#VersionedTextDocumentIdentifier) literals.
 */
var VersionedTextDocumentIdentifier;
(function (VersionedTextDocumentIdentifier) {
    /**
     * Creates a new VersionedTextDocumentIdentifier literal.
     * @param uri The document's uri.
     * @param uri The document's text.
     */
    function create(uri, version) {
        return { uri: uri, version: version };
    }
    VersionedTextDocumentIdentifier.create = create;
    /**
     * Checks whether the given literal conforms to the [VersionedTextDocumentIdentifier](#VersionedTextDocumentIdentifier) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.uri) && (candidate.version === null || Is.number(candidate.version));
    }
    VersionedTextDocumentIdentifier.is = is;
})(VersionedTextDocumentIdentifier || (VersionedTextDocumentIdentifier = {}));
/**
 * The TextDocumentItem namespace provides helper functions to work with
 * [TextDocumentItem](#TextDocumentItem) literals.
 */
var TextDocumentItem;
(function (TextDocumentItem) {
    /**
     * Creates a new TextDocumentItem literal.
     * @param uri The document's uri.
     * @param languageId The document's language identifier.
     * @param version The document's version number.
     * @param text The document's text.
     */
    function create(uri, languageId, version, text) {
        return { uri: uri, languageId: languageId, version: version, text: text };
    }
    TextDocumentItem.create = create;
    /**
     * Checks whether the given literal conforms to the [TextDocumentItem](#TextDocumentItem) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.uri) && Is.string(candidate.languageId) && Is.number(candidate.version) && Is.string(candidate.text);
    }
    TextDocumentItem.is = is;
})(TextDocumentItem || (TextDocumentItem = {}));
/**
 * Describes the content type that a client supports in various
 * result literals like `Hover`, `ParameterInfo` or `CompletionItem`.
 *
 * Please note that `MarkupKinds` must not start with a `$`. This kinds
 * are reserved for internal usage.
 */
var MarkupKind;
(function (MarkupKind) {
    /**
     * Plain text is supported as a content format
     */
    MarkupKind.PlainText = 'plaintext';
    /**
     * Markdown is supported as a content format
     */
    MarkupKind.Markdown = 'markdown';
})(MarkupKind || (MarkupKind = {}));
(function (MarkupKind) {
    /**
     * Checks whether the given value is a value of the [MarkupKind](#MarkupKind) type.
     */
    function is(value) {
        var candidate = value;
        return candidate === MarkupKind.PlainText || candidate === MarkupKind.Markdown;
    }
    MarkupKind.is = is;
})(MarkupKind || (MarkupKind = {}));
var MarkupContent;
(function (MarkupContent) {
    /**
     * Checks whether the given value conforms to the [MarkupContent](#MarkupContent) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.objectLiteral(value) && MarkupKind.is(candidate.kind) && Is.string(candidate.value);
    }
    MarkupContent.is = is;
})(MarkupContent || (MarkupContent = {}));
/**
 * The kind of a completion entry.
 */
var CompletionItemKind;
(function (CompletionItemKind) {
    CompletionItemKind.Text = 1;
    CompletionItemKind.Method = 2;
    CompletionItemKind.Function = 3;
    CompletionItemKind.Constructor = 4;
    CompletionItemKind.Field = 5;
    CompletionItemKind.Variable = 6;
    CompletionItemKind.Class = 7;
    CompletionItemKind.Interface = 8;
    CompletionItemKind.Module = 9;
    CompletionItemKind.Property = 10;
    CompletionItemKind.Unit = 11;
    CompletionItemKind.Value = 12;
    CompletionItemKind.Enum = 13;
    CompletionItemKind.Keyword = 14;
    CompletionItemKind.Snippet = 15;
    CompletionItemKind.Color = 16;
    CompletionItemKind.File = 17;
    CompletionItemKind.Reference = 18;
    CompletionItemKind.Folder = 19;
    CompletionItemKind.EnumMember = 20;
    CompletionItemKind.Constant = 21;
    CompletionItemKind.Struct = 22;
    CompletionItemKind.Event = 23;
    CompletionItemKind.Operator = 24;
    CompletionItemKind.TypeParameter = 25;
})(CompletionItemKind || (CompletionItemKind = {}));
/**
 * Defines whether the insert text in a completion item should be interpreted as
 * plain text or a snippet.
 */
var InsertTextFormat;
(function (InsertTextFormat) {
    /**
     * The primary text to be inserted is treated as a plain string.
     */
    InsertTextFormat.PlainText = 1;
    /**
     * The primary text to be inserted is treated as a snippet.
     *
     * A snippet can define tab stops and placeholders with `$1`, `$2`
     * and `${3:foo}`. `$0` defines the final tab stop, it defaults to
     * the end of the snippet. Placeholders with equal identifiers are linked,
     * that is typing in one will update others too.
     *
     * See also: https://github.com/Microsoft/vscode/blob/master/src/vs/editor/contrib/snippet/common/snippet.md
     */
    InsertTextFormat.Snippet = 2;
})(InsertTextFormat || (InsertTextFormat = {}));
/**
 * Completion item tags are extra annotations that tweak the rendering of a completion
 * item.
 *
 * @since 3.15.0
 */
var CompletionItemTag;
(function (CompletionItemTag) {
    /**
     * Render a completion as obsolete, usually using a strike-out.
     */
    CompletionItemTag.Deprecated = 1;
})(CompletionItemTag || (CompletionItemTag = {}));
/**
 * The CompletionItem namespace provides functions to deal with
 * completion items.
 */
var CompletionItem;
(function (CompletionItem) {
    /**
     * Create a completion item and seed it with a label.
     * @param label The completion item's label
     */
    function create(label) {
        return { label: label };
    }
    CompletionItem.create = create;
})(CompletionItem || (CompletionItem = {}));
/**
 * The CompletionList namespace provides functions to deal with
 * completion lists.
 */
var CompletionList;
(function (CompletionList) {
    /**
     * Creates a new completion list.
     *
     * @param items The completion items.
     * @param isIncomplete The list is not complete.
     */
    function create(items, isIncomplete) {
        return { items: items ? items : [], isIncomplete: !!isIncomplete };
    }
    CompletionList.create = create;
})(CompletionList || (CompletionList = {}));
var MarkedString;
(function (MarkedString) {
    /**
     * Creates a marked string from plain text.
     *
     * @param plainText The plain text.
     */
    function fromPlainText(plainText) {
        return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, '\\$&'); // escape markdown syntax tokens: http://daringfireball.net/projects/markdown/syntax#backslash
    }
    MarkedString.fromPlainText = fromPlainText;
    /**
     * Checks whether the given value conforms to the [MarkedString](#MarkedString) type.
     */
    function is(value) {
        var candidate = value;
        return Is.string(candidate) || (Is.objectLiteral(candidate) && Is.string(candidate.language) && Is.string(candidate.value));
    }
    MarkedString.is = is;
})(MarkedString || (MarkedString = {}));
var Hover;
(function (Hover) {
    /**
     * Checks whether the given value conforms to the [Hover](#Hover) interface.
     */
    function is(value) {
        var candidate = value;
        return !!candidate && Is.objectLiteral(candidate) && (MarkupContent.is(candidate.contents) ||
            MarkedString.is(candidate.contents) ||
            Is.typedArray(candidate.contents, MarkedString.is)) && (value.range === void 0 || Range.is(value.range));
    }
    Hover.is = is;
})(Hover || (Hover = {}));
/**
 * The ParameterInformation namespace provides helper functions to work with
 * [ParameterInformation](#ParameterInformation) literals.
 */
var ParameterInformation;
(function (ParameterInformation) {
    /**
     * Creates a new parameter information literal.
     *
     * @param label A label string.
     * @param documentation A doc string.
     */
    function create(label, documentation) {
        return documentation ? { label: label, documentation: documentation } : { label: label };
    }
    ParameterInformation.create = create;
})(ParameterInformation || (ParameterInformation = {}));
/**
 * The SignatureInformation namespace provides helper functions to work with
 * [SignatureInformation](#SignatureInformation) literals.
 */
var SignatureInformation;
(function (SignatureInformation) {
    function create(label, documentation) {
        var parameters = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            parameters[_i - 2] = arguments[_i];
        }
        var result = { label: label };
        if (Is.defined(documentation)) {
            result.documentation = documentation;
        }
        if (Is.defined(parameters)) {
            result.parameters = parameters;
        }
        else {
            result.parameters = [];
        }
        return result;
    }
    SignatureInformation.create = create;
})(SignatureInformation || (SignatureInformation = {}));
/**
 * A document highlight kind.
 */
var DocumentHighlightKind;
(function (DocumentHighlightKind) {
    /**
     * A textual occurrence.
     */
    DocumentHighlightKind.Text = 1;
    /**
     * Read-access of a symbol, like reading a variable.
     */
    DocumentHighlightKind.Read = 2;
    /**
     * Write-access of a symbol, like writing to a variable.
     */
    DocumentHighlightKind.Write = 3;
})(DocumentHighlightKind || (DocumentHighlightKind = {}));
/**
 * DocumentHighlight namespace to provide helper functions to work with
 * [DocumentHighlight](#DocumentHighlight) literals.
 */
var DocumentHighlight;
(function (DocumentHighlight) {
    /**
     * Create a DocumentHighlight object.
     * @param range The range the highlight applies to.
     */
    function create(range, kind) {
        var result = { range: range };
        if (Is.number(kind)) {
            result.kind = kind;
        }
        return result;
    }
    DocumentHighlight.create = create;
})(DocumentHighlight || (DocumentHighlight = {}));
/**
 * A symbol kind.
 */
var SymbolKind;
(function (SymbolKind) {
    SymbolKind.File = 1;
    SymbolKind.Module = 2;
    SymbolKind.Namespace = 3;
    SymbolKind.Package = 4;
    SymbolKind.Class = 5;
    SymbolKind.Method = 6;
    SymbolKind.Property = 7;
    SymbolKind.Field = 8;
    SymbolKind.Constructor = 9;
    SymbolKind.Enum = 10;
    SymbolKind.Interface = 11;
    SymbolKind.Function = 12;
    SymbolKind.Variable = 13;
    SymbolKind.Constant = 14;
    SymbolKind.String = 15;
    SymbolKind.Number = 16;
    SymbolKind.Boolean = 17;
    SymbolKind.Array = 18;
    SymbolKind.Object = 19;
    SymbolKind.Key = 20;
    SymbolKind.Null = 21;
    SymbolKind.EnumMember = 22;
    SymbolKind.Struct = 23;
    SymbolKind.Event = 24;
    SymbolKind.Operator = 25;
    SymbolKind.TypeParameter = 26;
})(SymbolKind || (SymbolKind = {}));
/**
 * Symbol tags are extra annotations that tweak the rendering of a symbol.
 * @since 3.15
 */
var SymbolTag;
(function (SymbolTag) {
    /**
     * Render a symbol as obsolete, usually using a strike-out.
     */
    SymbolTag.Deprecated = 1;
})(SymbolTag || (SymbolTag = {}));
var SymbolInformation;
(function (SymbolInformation) {
    /**
     * Creates a new symbol information literal.
     *
     * @param name The name of the symbol.
     * @param kind The kind of the symbol.
     * @param range The range of the location of the symbol.
     * @param uri The resource of the location of symbol, defaults to the current document.
     * @param containerName The name of the symbol containing the symbol.
     */
    function create(name, kind, range, uri, containerName) {
        var result = {
            name: name,
            kind: kind,
            location: { uri: uri, range: range }
        };
        if (containerName) {
            result.containerName = containerName;
        }
        return result;
    }
    SymbolInformation.create = create;
})(SymbolInformation || (SymbolInformation = {}));
var DocumentSymbol;
(function (DocumentSymbol) {
    /**
     * Creates a new symbol information literal.
     *
     * @param name The name of the symbol.
     * @param detail The detail of the symbol.
     * @param kind The kind of the symbol.
     * @param range The range of the symbol.
     * @param selectionRange The selectionRange of the symbol.
     * @param children Children of the symbol.
     */
    function create(name, detail, kind, range, selectionRange, children) {
        var result = {
            name: name,
            detail: detail,
            kind: kind,
            range: range,
            selectionRange: selectionRange
        };
        if (children !== void 0) {
            result.children = children;
        }
        return result;
    }
    DocumentSymbol.create = create;
    /**
     * Checks whether the given literal conforms to the [DocumentSymbol](#DocumentSymbol) interface.
     */
    function is(value) {
        var candidate = value;
        return candidate &&
            Is.string(candidate.name) && Is.number(candidate.kind) &&
            Range.is(candidate.range) && Range.is(candidate.selectionRange) &&
            (candidate.detail === void 0 || Is.string(candidate.detail)) &&
            (candidate.deprecated === void 0 || Is.boolean(candidate.deprecated)) &&
            (candidate.children === void 0 || Array.isArray(candidate.children));
    }
    DocumentSymbol.is = is;
})(DocumentSymbol || (DocumentSymbol = {}));
/**
 * A set of predefined code action kinds
 */
var CodeActionKind;
(function (CodeActionKind) {
    /**
     * Empty kind.
     */
    CodeActionKind.Empty = '';
    /**
     * Base kind for quickfix actions: 'quickfix'
     */
    CodeActionKind.QuickFix = 'quickfix';
    /**
     * Base kind for refactoring actions: 'refactor'
     */
    CodeActionKind.Refactor = 'refactor';
    /**
     * Base kind for refactoring extraction actions: 'refactor.extract'
     *
     * Example extract actions:
     *
     * - Extract method
     * - Extract function
     * - Extract variable
     * - Extract interface from class
     * - ...
     */
    CodeActionKind.RefactorExtract = 'refactor.extract';
    /**
     * Base kind for refactoring inline actions: 'refactor.inline'
     *
     * Example inline actions:
     *
     * - Inline function
     * - Inline variable
     * - Inline constant
     * - ...
     */
    CodeActionKind.RefactorInline = 'refactor.inline';
    /**
     * Base kind for refactoring rewrite actions: 'refactor.rewrite'
     *
     * Example rewrite actions:
     *
     * - Convert JavaScript function to class
     * - Add or remove parameter
     * - Encapsulate field
     * - Make method static
     * - Move method to base class
     * - ...
     */
    CodeActionKind.RefactorRewrite = 'refactor.rewrite';
    /**
     * Base kind for source actions: `source`
     *
     * Source code actions apply to the entire file.
     */
    CodeActionKind.Source = 'source';
    /**
     * Base kind for an organize imports source action: `source.organizeImports`
     */
    CodeActionKind.SourceOrganizeImports = 'source.organizeImports';
    /**
     * Base kind for auto-fix source actions: `source.fixAll`.
     *
     * Fix all actions automatically fix errors that have a clear fix that do not require user input.
     * They should not suppress errors or perform unsafe fixes such as generating new types or classes.
     *
     * @since 3.15.0
     */
    CodeActionKind.SourceFixAll = 'source.fixAll';
})(CodeActionKind || (CodeActionKind = {}));
/**
 * The CodeActionContext namespace provides helper functions to work with
 * [CodeActionContext](#CodeActionContext) literals.
 */
var CodeActionContext;
(function (CodeActionContext) {
    /**
     * Creates a new CodeActionContext literal.
     */
    function create(diagnostics, only) {
        var result = { diagnostics: diagnostics };
        if (only !== void 0 && only !== null) {
            result.only = only;
        }
        return result;
    }
    CodeActionContext.create = create;
    /**
     * Checks whether the given literal conforms to the [CodeActionContext](#CodeActionContext) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.typedArray(candidate.diagnostics, Diagnostic.is) && (candidate.only === void 0 || Is.typedArray(candidate.only, Is.string));
    }
    CodeActionContext.is = is;
})(CodeActionContext || (CodeActionContext = {}));
var CodeAction;
(function (CodeAction) {
    function create(title, commandOrEdit, kind) {
        var result = { title: title };
        if (Command.is(commandOrEdit)) {
            result.command = commandOrEdit;
        }
        else {
            result.edit = commandOrEdit;
        }
        if (kind !== void 0) {
            result.kind = kind;
        }
        return result;
    }
    CodeAction.create = create;
    function is(value) {
        var candidate = value;
        return candidate && Is.string(candidate.title) &&
            (candidate.diagnostics === void 0 || Is.typedArray(candidate.diagnostics, Diagnostic.is)) &&
            (candidate.kind === void 0 || Is.string(candidate.kind)) &&
            (candidate.edit !== void 0 || candidate.command !== void 0) &&
            (candidate.command === void 0 || Command.is(candidate.command)) &&
            (candidate.isPreferred === void 0 || Is.boolean(candidate.isPreferred)) &&
            (candidate.edit === void 0 || WorkspaceEdit.is(candidate.edit));
    }
    CodeAction.is = is;
})(CodeAction || (CodeAction = {}));
/**
 * The CodeLens namespace provides helper functions to work with
 * [CodeLens](#CodeLens) literals.
 */
var CodeLens;
(function (CodeLens) {
    /**
     * Creates a new CodeLens literal.
     */
    function create(range, data) {
        var result = { range: range };
        if (Is.defined(data)) {
            result.data = data;
        }
        return result;
    }
    CodeLens.create = create;
    /**
     * Checks whether the given literal conforms to the [CodeLens](#CodeLens) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.command) || Command.is(candidate.command));
    }
    CodeLens.is = is;
})(CodeLens || (CodeLens = {}));
/**
 * The FormattingOptions namespace provides helper functions to work with
 * [FormattingOptions](#FormattingOptions) literals.
 */
var FormattingOptions;
(function (FormattingOptions) {
    /**
     * Creates a new FormattingOptions literal.
     */
    function create(tabSize, insertSpaces) {
        return { tabSize: tabSize, insertSpaces: insertSpaces };
    }
    FormattingOptions.create = create;
    /**
     * Checks whether the given literal conforms to the [FormattingOptions](#FormattingOptions) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.number(candidate.tabSize) && Is.boolean(candidate.insertSpaces);
    }
    FormattingOptions.is = is;
})(FormattingOptions || (FormattingOptions = {}));
/**
 * The DocumentLink namespace provides helper functions to work with
 * [DocumentLink](#DocumentLink) literals.
 */
var DocumentLink;
(function (DocumentLink) {
    /**
     * Creates a new DocumentLink literal.
     */
    function create(range, target, data) {
        return { range: range, target: target, data: data };
    }
    DocumentLink.create = create;
    /**
     * Checks whether the given literal conforms to the [DocumentLink](#DocumentLink) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.target) || Is.string(candidate.target));
    }
    DocumentLink.is = is;
})(DocumentLink || (DocumentLink = {}));
/**
 * The SelectionRange namespace provides helper function to work with
 * SelectionRange literals.
 */
var SelectionRange;
(function (SelectionRange) {
    /**
     * Creates a new SelectionRange
     * @param range the range.
     * @param parent an optional parent.
     */
    function create(range, parent) {
        return { range: range, parent: parent };
    }
    SelectionRange.create = create;
    function is(value) {
        var candidate = value;
        return candidate !== undefined && Range.is(candidate.range) && (candidate.parent === undefined || SelectionRange.is(candidate.parent));
    }
    SelectionRange.is = is;
})(SelectionRange || (SelectionRange = {}));
var EOL = ['\n', '\r\n', '\r'];
/**
 * @deprecated Use the text document from the new vscode-languageserver-textdocument package.
 */
var TextDocument;
(function (TextDocument) {
    /**
     * Creates a new ITextDocument literal from the given uri and content.
     * @param uri The document's uri.
     * @param languageId  The document's language Id.
     * @param content The document's content.
     */
    function create(uri, languageId, version, content) {
        return new FullTextDocument(uri, languageId, version, content);
    }
    TextDocument.create = create;
    /**
     * Checks whether the given literal conforms to the [ITextDocument](#ITextDocument) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.uri) && (Is.undefined(candidate.languageId) || Is.string(candidate.languageId)) && Is.number(candidate.lineCount)
            && Is.func(candidate.getText) && Is.func(candidate.positionAt) && Is.func(candidate.offsetAt) ? true : false;
    }
    TextDocument.is = is;
    function applyEdits(document, edits) {
        var text = document.getText();
        var sortedEdits = mergeSort(edits, function (a, b) {
            var diff = a.range.start.line - b.range.start.line;
            if (diff === 0) {
                return a.range.start.character - b.range.start.character;
            }
            return diff;
        });
        var lastModifiedOffset = text.length;
        for (var i = sortedEdits.length - 1; i >= 0; i--) {
            var e = sortedEdits[i];
            var startOffset = document.offsetAt(e.range.start);
            var endOffset = document.offsetAt(e.range.end);
            if (endOffset <= lastModifiedOffset) {
                text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
            }
            else {
                throw new Error('Overlapping edit');
            }
            lastModifiedOffset = startOffset;
        }
        return text;
    }
    TextDocument.applyEdits = applyEdits;
    function mergeSort(data, compare) {
        if (data.length <= 1) {
            // sorted
            return data;
        }
        var p = (data.length / 2) | 0;
        var left = data.slice(0, p);
        var right = data.slice(p);
        mergeSort(left, compare);
        mergeSort(right, compare);
        var leftIdx = 0;
        var rightIdx = 0;
        var i = 0;
        while (leftIdx < left.length && rightIdx < right.length) {
            var ret = compare(left[leftIdx], right[rightIdx]);
            if (ret <= 0) {
                // smaller_equal -> take left to preserve order
                data[i++] = left[leftIdx++];
            }
            else {
                // greater -> take right
                data[i++] = right[rightIdx++];
            }
        }
        while (leftIdx < left.length) {
            data[i++] = left[leftIdx++];
        }
        while (rightIdx < right.length) {
            data[i++] = right[rightIdx++];
        }
        return data;
    }
})(TextDocument || (TextDocument = {}));
var FullTextDocument = /** @class */ (function () {
    function FullTextDocument(uri, languageId, version, content) {
        this._uri = uri;
        this._languageId = languageId;
        this._version = version;
        this._content = content;
        this._lineOffsets = undefined;
    }
    Object.defineProperty(FullTextDocument.prototype, "uri", {
        get: function () {
            return this._uri;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FullTextDocument.prototype, "languageId", {
        get: function () {
            return this._languageId;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FullTextDocument.prototype, "version", {
        get: function () {
            return this._version;
        },
        enumerable: true,
        configurable: true
    });
    FullTextDocument.prototype.getText = function (range) {
        if (range) {
            var start = this.offsetAt(range.start);
            var end = this.offsetAt(range.end);
            return this._content.substring(start, end);
        }
        return this._content;
    };
    FullTextDocument.prototype.update = function (event, version) {
        this._content = event.text;
        this._version = version;
        this._lineOffsets = undefined;
    };
    FullTextDocument.prototype.getLineOffsets = function () {
        if (this._lineOffsets === undefined) {
            var lineOffsets = [];
            var text = this._content;
            var isLineStart = true;
            for (var i = 0; i < text.length; i++) {
                if (isLineStart) {
                    lineOffsets.push(i);
                    isLineStart = false;
                }
                var ch = text.charAt(i);
                isLineStart = (ch === '\r' || ch === '\n');
                if (ch === '\r' && i + 1 < text.length && text.charAt(i + 1) === '\n') {
                    i++;
                }
            }
            if (isLineStart && text.length > 0) {
                lineOffsets.push(text.length);
            }
            this._lineOffsets = lineOffsets;
        }
        return this._lineOffsets;
    };
    FullTextDocument.prototype.positionAt = function (offset) {
        offset = Math.max(Math.min(offset, this._content.length), 0);
        var lineOffsets = this.getLineOffsets();
        var low = 0, high = lineOffsets.length;
        if (high === 0) {
            return Position.create(0, offset);
        }
        while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (lineOffsets[mid] > offset) {
                high = mid;
            }
            else {
                low = mid + 1;
            }
        }
        // low is the least x for which the line offset is larger than the current offset
        // or array.length if no line offset is larger than the current offset
        var line = low - 1;
        return Position.create(line, offset - lineOffsets[line]);
    };
    FullTextDocument.prototype.offsetAt = function (position) {
        var lineOffsets = this.getLineOffsets();
        if (position.line >= lineOffsets.length) {
            return this._content.length;
        }
        else if (position.line < 0) {
            return 0;
        }
        var lineOffset = lineOffsets[position.line];
        var nextLineOffset = (position.line + 1 < lineOffsets.length) ? lineOffsets[position.line + 1] : this._content.length;
        return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
    };
    Object.defineProperty(FullTextDocument.prototype, "lineCount", {
        get: function () {
            return this.getLineOffsets().length;
        },
        enumerable: true,
        configurable: true
    });
    return FullTextDocument;
}());
var Is;
(function (Is) {
    var toString = Object.prototype.toString;
    function defined(value) {
        return typeof value !== 'undefined';
    }
    Is.defined = defined;
    function undefined(value) {
        return typeof value === 'undefined';
    }
    Is.undefined = undefined;
    function boolean(value) {
        return value === true || value === false;
    }
    Is.boolean = boolean;
    function string(value) {
        return toString.call(value) === '[object String]';
    }
    Is.string = string;
    function number(value) {
        return toString.call(value) === '[object Number]';
    }
    Is.number = number;
    function func(value) {
        return toString.call(value) === '[object Function]';
    }
    Is.func = func;
    function objectLiteral(value) {
        // Strictly speaking class instances pass this check as well. Since the LSP
        // doesn't use classes we ignore this for now. If we do we need to add something
        // like this: `Object.getPrototypeOf(Object.getPrototypeOf(x)) === null`
        return value !== null && typeof value === 'object';
    }
    Is.objectLiteral = objectLiteral;
    function typedArray(value, check) {
        return Array.isArray(value) && value.every(check);
    }
    Is.typedArray = typedArray;
})(Is || (Is = {}));


/***/ }),

/***/ 786:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CSSNavigation; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__ = __webpack_require__(758);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__fillers_vscode_nls_js__ = __webpack_require__(757);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__ = __webpack_require__(756);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__parser_cssSymbolScope_js__ = __webpack_require__(784);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__languageFacts_facts_js__ = __webpack_require__(762);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__utils_strings_js__ = __webpack_require__(769);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};






var localize = __WEBPACK_IMPORTED_MODULE_1__fillers_vscode_nls_js__["a" /* loadMessageBundle */]();
var CSSNavigation = /** @class */ (function () {
    function CSSNavigation() {
    }
    CSSNavigation.prototype.findDefinition = function (document, position, stylesheet) {
        var symbols = new __WEBPACK_IMPORTED_MODULE_3__parser_cssSymbolScope_js__["a" /* Symbols */](stylesheet);
        var offset = document.offsetAt(position);
        var node = __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["_13" /* getNodeAtOffset */](stylesheet, offset);
        if (!node) {
            return null;
        }
        var symbol = symbols.findSymbolFromNode(node);
        if (!symbol) {
            return null;
        }
        return {
            uri: document.uri,
            range: getRange(symbol.node, document)
        };
    };
    CSSNavigation.prototype.findReferences = function (document, position, stylesheet) {
        var highlights = this.findDocumentHighlights(document, position, stylesheet);
        return highlights.map(function (h) {
            return {
                uri: document.uri,
                range: h.range
            };
        });
    };
    CSSNavigation.prototype.findDocumentHighlights = function (document, position, stylesheet) {
        var result = [];
        var offset = document.offsetAt(position);
        var node = __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["_13" /* getNodeAtOffset */](stylesheet, offset);
        if (!node || node.type === __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].Stylesheet || node.type === __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].Declarations) {
            return result;
        }
        if (node.type === __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].Identifier && node.parent && node.parent.type === __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].ClassSelector) {
            node = node.parent;
        }
        var symbols = new __WEBPACK_IMPORTED_MODULE_3__parser_cssSymbolScope_js__["a" /* Symbols */](stylesheet);
        var symbol = symbols.findSymbolFromNode(node);
        var name = node.getText();
        stylesheet.accept(function (candidate) {
            if (symbol) {
                if (symbols.matchesSymbol(candidate, symbol)) {
                    result.push({
                        kind: getHighlightKind(candidate),
                        range: getRange(candidate, document)
                    });
                    return false;
                }
            }
            else if (node && node.type === candidate.type && candidate.matches(name)) {
                // Same node type and data
                result.push({
                    kind: getHighlightKind(candidate),
                    range: getRange(candidate, document)
                });
            }
            return true;
        });
        return result;
    };
    CSSNavigation.prototype.isRawStringDocumentLinkNode = function (node) {
        return node.type === __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].Import;
    };
    CSSNavigation.prototype.findDocumentLinks = function (document, stylesheet, documentContext) {
        var _this = this;
        var result = [];
        stylesheet.accept(function (candidate) {
            if (candidate.type === __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].URILiteral) {
                var link = uriLiteralNodeToDocumentLink(document, candidate, documentContext);
                if (link) {
                    result.push(link);
                }
                return false;
            }
            /**
             * In @import, it is possible to include links that do not use `url()`
             * For example, `@import 'foo.css';`
             */
            if (candidate.parent && _this.isRawStringDocumentLinkNode(candidate.parent)) {
                var rawText = candidate.getText();
                if (Object(__WEBPACK_IMPORTED_MODULE_5__utils_strings_js__["d" /* startsWith */])(rawText, "'") || Object(__WEBPACK_IMPORTED_MODULE_5__utils_strings_js__["d" /* startsWith */])(rawText, "\"")) {
                    var link = uriStringNodeToDocumentLink(document, candidate, documentContext);
                    if (link) {
                        result.push(link);
                    }
                }
                return false;
            }
            return true;
        });
        return result;
    };
    CSSNavigation.prototype.findDocumentLinks2 = function (document, stylesheet, documentContext) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.findDocumentLinks(document, stylesheet, documentContext)];
            });
        });
    };
    CSSNavigation.prototype.findDocumentSymbols = function (document, stylesheet) {
        var result = [];
        stylesheet.accept(function (node) {
            var entry = {
                name: null,
                kind: __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["p" /* SymbolKind */].Class,
                location: null
            };
            var locationNode = node;
            if (node instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["_1" /* Selector */]) {
                entry.name = node.getText();
                locationNode = node.findAParent(__WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].Ruleset, __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].ExtendsReference);
                if (locationNode) {
                    entry.location = __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["k" /* Location */].create(document.uri, getRange(locationNode, document));
                    result.push(entry);
                }
                return false;
            }
            else if (node instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["_10" /* VariableDeclaration */]) {
                entry.name = node.getName();
                entry.kind = __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["p" /* SymbolKind */].Variable;
            }
            else if (node instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["L" /* MixinDeclaration */]) {
                entry.name = node.getName();
                entry.kind = __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["p" /* SymbolKind */].Method;
            }
            else if (node instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["u" /* FunctionDeclaration */]) {
                entry.name = node.getName();
                entry.kind = __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["p" /* SymbolKind */].Function;
            }
            else if (node instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["C" /* Keyframe */]) {
                entry.name = localize('literal.keyframes', "@keyframes {0}", node.getName());
            }
            else if (node instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["o" /* FontFace */]) {
                entry.name = localize('literal.fontface', "@font-face");
            }
            else if (node instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["I" /* Media */]) {
                var mediaList = node.getChild(0);
                if (mediaList instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["K" /* Medialist */]) {
                    entry.name = '@media ' + mediaList.getText();
                    entry.kind = __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["p" /* SymbolKind */].Module;
                }
            }
            if (entry.name) {
                entry.location = __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["k" /* Location */].create(document.uri, getRange(locationNode, document));
                result.push(entry);
            }
            return true;
        });
        return result;
    };
    CSSNavigation.prototype.findDocumentColors = function (document, stylesheet) {
        var result = [];
        stylesheet.accept(function (node) {
            var colorInfo = getColorInformation(node, document);
            if (colorInfo) {
                result.push(colorInfo);
            }
            return true;
        });
        return result;
    };
    CSSNavigation.prototype.getColorPresentations = function (document, stylesheet, color, range) {
        var result = [];
        var red256 = Math.round(color.red * 255), green256 = Math.round(color.green * 255), blue256 = Math.round(color.blue * 255);
        var label;
        if (color.alpha === 1) {
            label = "rgb(" + red256 + ", " + green256 + ", " + blue256 + ")";
        }
        else {
            label = "rgba(" + red256 + ", " + green256 + ", " + blue256 + ", " + color.alpha + ")";
        }
        result.push({ label: label, textEdit: __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["r" /* TextEdit */].replace(range, label) });
        if (color.alpha === 1) {
            label = "#" + toTwoDigitHex(red256) + toTwoDigitHex(green256) + toTwoDigitHex(blue256);
        }
        else {
            label = "#" + toTwoDigitHex(red256) + toTwoDigitHex(green256) + toTwoDigitHex(blue256) + toTwoDigitHex(Math.round(color.alpha * 255));
        }
        result.push({ label: label, textEdit: __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["r" /* TextEdit */].replace(range, label) });
        var hsl = Object(__WEBPACK_IMPORTED_MODULE_4__languageFacts_facts_js__["k" /* hslFromColor */])(color);
        if (hsl.a === 1) {
            label = "hsl(" + hsl.h + ", " + Math.round(hsl.s * 100) + "%, " + Math.round(hsl.l * 100) + "%)";
        }
        else {
            label = "hsla(" + hsl.h + ", " + Math.round(hsl.s * 100) + "%, " + Math.round(hsl.l * 100) + "%, " + hsl.a + ")";
        }
        result.push({ label: label, textEdit: __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["r" /* TextEdit */].replace(range, label) });
        return result;
    };
    CSSNavigation.prototype.doRename = function (document, position, newName, stylesheet) {
        var _a;
        var highlights = this.findDocumentHighlights(document, position, stylesheet);
        var edits = highlights.map(function (h) { return __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["r" /* TextEdit */].replace(h.range, newName); });
        return {
            changes: (_a = {}, _a[document.uri] = edits, _a)
        };
    };
    return CSSNavigation;
}());

function getColorInformation(node, document) {
    var color = Object(__WEBPACK_IMPORTED_MODULE_4__languageFacts_facts_js__["i" /* getColorValue */])(node);
    if (color) {
        var range = getRange(node, document);
        return { color: color, range: range };
    }
    return null;
}
function uriLiteralNodeToDocumentLink(document, uriLiteralNode, documentContext) {
    if (uriLiteralNode.getChildren().length === 0) {
        return null;
    }
    var uriStringNode = uriLiteralNode.getChild(0);
    return uriStringNodeToDocumentLink(document, uriStringNode, documentContext);
}
function uriStringNodeToDocumentLink(document, uriStringNode, documentContext) {
    if (!uriStringNode) {
        return null;
    }
    var rawUri = uriStringNode.getText();
    var range = getRange(uriStringNode, document);
    // Make sure the range is not empty
    if (range.start.line === range.end.line && range.start.character === range.end.character) {
        return null;
    }
    if (Object(__WEBPACK_IMPORTED_MODULE_5__utils_strings_js__["d" /* startsWith */])(rawUri, "'") || Object(__WEBPACK_IMPORTED_MODULE_5__utils_strings_js__["d" /* startsWith */])(rawUri, "\"")) {
        rawUri = rawUri.slice(1, -1);
    }
    var target;
    if (Object(__WEBPACK_IMPORTED_MODULE_5__utils_strings_js__["d" /* startsWith */])(rawUri, 'http://') || Object(__WEBPACK_IMPORTED_MODULE_5__utils_strings_js__["d" /* startsWith */])(rawUri, 'https://')) {
        target = rawUri;
    }
    else if (/^\w+:\/\//g.test(rawUri)) {
        target = rawUri;
    }
    else {
        target = documentContext.resolveReference(rawUri, document.uri);
    }
    return {
        range: range,
        target: target
    };
}
function getRange(node, document) {
    return __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["n" /* Range */].create(document.positionAt(node.offset), document.positionAt(node.end));
}
function getHighlightKind(node) {
    if (node.type === __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].Selector) {
        return __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["g" /* DocumentHighlightKind */].Write;
    }
    if (node instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["y" /* Identifier */]) {
        if (node.parent && node.parent instanceof __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["Y" /* Property */]) {
            if (node.isCustomProperty) {
                return __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["g" /* DocumentHighlightKind */].Write;
            }
        }
    }
    if (node.parent) {
        switch (node.parent.type) {
            case __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].FunctionDeclaration:
            case __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].MixinDeclaration:
            case __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].Keyframe:
            case __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].VariableDeclaration:
            case __WEBPACK_IMPORTED_MODULE_2__parser_cssNodes_js__["S" /* NodeType */].FunctionParameter:
                return __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["g" /* DocumentHighlightKind */].Write;
        }
    }
    return __WEBPACK_IMPORTED_MODULE_0__cssLanguageTypes_js__["g" /* DocumentHighlightKind */].Read;
}
function toTwoDigitHex(n) {
    var r = n.toString(16);
    return r.length !== 2 ? '0' + r : r;
}


/***/ }),

/***/ 787:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return VariableName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return InterpolationFunction; });
/* unused harmony export Default */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return EqualsOperator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return NotEqualsOperator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return GreaterEqualsOperator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return SmallerEqualsOperator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Ellipsis; });
/* unused harmony export Module */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return Forward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return Use; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return SCSSScanner; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__ = __webpack_require__(764);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var _FSL = '/'.charCodeAt(0);
var _NWL = '\n'.charCodeAt(0);
var _CAR = '\r'.charCodeAt(0);
var _LFD = '\f'.charCodeAt(0);
var _DLR = '$'.charCodeAt(0);
var _HSH = '#'.charCodeAt(0);
var _CUL = '{'.charCodeAt(0);
var _EQS = '='.charCodeAt(0);
var _BNG = '!'.charCodeAt(0);
var _LAN = '<'.charCodeAt(0);
var _RAN = '>'.charCodeAt(0);
var _DOT = '.'.charCodeAt(0);
var _ATS = '@'.charCodeAt(0);
var customTokenValue = __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CustomToken;
var VariableName = customTokenValue++;
var InterpolationFunction = customTokenValue++;
var Default = customTokenValue++;
var EqualsOperator = customTokenValue++;
var NotEqualsOperator = customTokenValue++;
var GreaterEqualsOperator = customTokenValue++;
var SmallerEqualsOperator = customTokenValue++;
var Ellipsis = customTokenValue++;
var Module = customTokenValue++;
var Forward = customTokenValue++;
var Use = customTokenValue++;
var SCSSScanner = /** @class */ (function (_super) {
    __extends(SCSSScanner, _super);
    function SCSSScanner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SCSSScanner.prototype.scanNext = function (offset) {
        // scss variable
        if (this.stream.advanceIfChar(_DLR)) {
            var content = ['$'];
            if (this.ident(content)) {
                return this.finishToken(offset, VariableName, content.join(''));
            }
            else {
                this.stream.goBackTo(offset);
            }
        }
        // scss: interpolation function #{..})
        if (this.stream.advanceIfChars([_HSH, _CUL])) {
            return this.finishToken(offset, InterpolationFunction);
        }
        // operator ==
        if (this.stream.advanceIfChars([_EQS, _EQS])) {
            return this.finishToken(offset, EqualsOperator);
        }
        // operator !=
        if (this.stream.advanceIfChars([_BNG, _EQS])) {
            return this.finishToken(offset, NotEqualsOperator);
        }
        // operators <, <=
        if (this.stream.advanceIfChar(_LAN)) {
            if (this.stream.advanceIfChar(_EQS)) {
                return this.finishToken(offset, SmallerEqualsOperator);
            }
            return this.finishToken(offset, __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Delim);
        }
        // ooperators >, >=
        if (this.stream.advanceIfChar(_RAN)) {
            if (this.stream.advanceIfChar(_EQS)) {
                return this.finishToken(offset, GreaterEqualsOperator);
            }
            return this.finishToken(offset, __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].Delim);
        }
        // ellipis
        if (this.stream.advanceIfChars([_DOT, _DOT, _DOT])) {
            return this.finishToken(offset, Ellipsis);
        }
        // module loaders, @forward and @use
        if (this.stream.advanceIfChar(_ATS)) {
            var content = ['@'];
            if (this.ident(content)) {
                var keywordText = content.join('');
                if (keywordText === '@forward') {
                    return this.finishToken(offset, Forward, keywordText);
                }
                else if (keywordText === '@use') {
                    return this.finishToken(offset, Use, keywordText);
                }
            }
            this.stream.goBackTo(offset);
        }
        return _super.prototype.scanNext.call(this, offset);
    };
    SCSSScanner.prototype.comment = function () {
        if (_super.prototype.comment.call(this)) {
            return true;
        }
        if (!this.inURL && this.stream.advanceIfChars([_FSL, _FSL])) {
            this.stream.advanceWhileChar(function (ch) {
                switch (ch) {
                    case _NWL:
                    case _CAR:
                    case _LFD:
                        return false;
                    default:
                        return true;
                }
            });
            return true;
        }
        else {
            return false;
        }
    };
    return SCSSScanner;
}(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["a" /* Scanner */]));



/***/ }),

/***/ 788:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Ellipsis; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return LESSScanner; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__ = __webpack_require__(764);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var _FSL = '/'.charCodeAt(0);
var _NWL = '\n'.charCodeAt(0);
var _CAR = '\r'.charCodeAt(0);
var _LFD = '\f'.charCodeAt(0);
var _TIC = '`'.charCodeAt(0);
var _DOT = '.'.charCodeAt(0);
var customTokenValue = __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].CustomToken;
var Ellipsis = customTokenValue++;
var LESSScanner = /** @class */ (function (_super) {
    __extends(LESSScanner, _super);
    function LESSScanner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    LESSScanner.prototype.scanNext = function (offset) {
        // LESS: escaped JavaScript code `const a = "dddd"`
        var tokenType = this.escapedJavaScript();
        if (tokenType !== null) {
            return this.finishToken(offset, tokenType);
        }
        if (this.stream.advanceIfChars([_DOT, _DOT, _DOT])) {
            return this.finishToken(offset, Ellipsis);
        }
        return _super.prototype.scanNext.call(this, offset);
    };
    LESSScanner.prototype.comment = function () {
        if (_super.prototype.comment.call(this)) {
            return true;
        }
        if (!this.inURL && this.stream.advanceIfChars([_FSL, _FSL])) {
            this.stream.advanceWhileChar(function (ch) {
                switch (ch) {
                    case _NWL:
                    case _CAR:
                    case _LFD:
                        return false;
                    default:
                        return true;
                }
            });
            return true;
        }
        else {
            return false;
        }
    };
    LESSScanner.prototype.escapedJavaScript = function () {
        var ch = this.stream.peekChar();
        if (ch === _TIC) {
            this.stream.advance(1);
            this.stream.advanceWhileChar(function (ch) { return ch !== _TIC; });
            return this.stream.advanceIfChar(_TIC) ? __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].EscapedJavaScript : __WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["b" /* TokenType */].BadEscapedJavaScript;
        }
        return null;
    };
    return LESSScanner;
}(__WEBPACK_IMPORTED_MODULE_0__cssScanner_js__["a" /* Scanner */]));



/***/ }),

/***/ 797:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return WorkerManager; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var STOP_WHEN_IDLE_FOR = 2 * 60 * 1000; // 2min
var WorkerManager = /** @class */ (function () {
    function WorkerManager(defaults) {
        var _this = this;
        this._defaults = defaults;
        this._worker = null;
        this._idleCheckInterval = window.setInterval(function () { return _this._checkIfIdle(); }, 30 * 1000);
        this._lastUsedTime = 0;
        this._configChangeListener = this._defaults.onDidChange(function () { return _this._stopWorker(); });
    }
    WorkerManager.prototype._stopWorker = function () {
        if (this._worker) {
            this._worker.dispose();
            this._worker = null;
        }
        this._client = null;
    };
    WorkerManager.prototype.dispose = function () {
        clearInterval(this._idleCheckInterval);
        this._configChangeListener.dispose();
        this._stopWorker();
    };
    WorkerManager.prototype._checkIfIdle = function () {
        if (!this._worker) {
            return;
        }
        var timePassedSinceLastUsed = Date.now() - this._lastUsedTime;
        if (timePassedSinceLastUsed > STOP_WHEN_IDLE_FOR) {
            this._stopWorker();
        }
    };
    WorkerManager.prototype._getClient = function () {
        this._lastUsedTime = Date.now();
        if (!this._client) {
            this._worker = monaco.editor.createWebWorker({
                // module that exports the create() method and returns a `CSSWorker` instance
                moduleId: 'vs/language/css/cssWorker',
                label: this._defaults.languageId,
                // passed in to the create() method
                createData: {
                    languageSettings: this._defaults.diagnosticsOptions,
                    languageId: this._defaults.languageId
                }
            });
            this._client = this._worker.getProxy();
        }
        return this._client;
    };
    WorkerManager.prototype.getLanguageServiceWorker = function () {
        var _this = this;
        var resources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            resources[_i] = arguments[_i];
        }
        var _client;
        return this._getClient().then(function (client) {
            _client = client;
        }).then(function (_) {
            return _this._worker.withSyncedResources(resources);
        }).then(function (_) { return _client; });
    };
    return WorkerManager;
}());



/***/ }),

/***/ 798:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return DiagnosticsAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CompletionAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return HoverAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return DocumentHighlightAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return DefinitionAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return ReferenceAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return RenameAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return DocumentSymbolAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return DocumentColorAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return FoldingRangeAdapter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return SelectionRangeAdapter; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__ = __webpack_require__(799);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var Uri = monaco.Uri;
var Range = monaco.Range;
// --- diagnostics --- ---
var DiagnosticsAdapter = /** @class */ (function () {
    function DiagnosticsAdapter(_languageId, _worker, defaults) {
        var _this = this;
        this._languageId = _languageId;
        this._worker = _worker;
        this._disposables = [];
        this._listener = Object.create(null);
        var onModelAdd = function (model) {
            var modeId = model.getModeId();
            if (modeId !== _this._languageId) {
                return;
            }
            var handle;
            _this._listener[model.uri.toString()] = model.onDidChangeContent(function () {
                window.clearTimeout(handle);
                handle = window.setTimeout(function () { return _this._doValidate(model.uri, modeId); }, 500);
            });
            _this._doValidate(model.uri, modeId);
        };
        var onModelRemoved = function (model) {
            monaco.editor.setModelMarkers(model, _this._languageId, []);
            var uriStr = model.uri.toString();
            var listener = _this._listener[uriStr];
            if (listener) {
                listener.dispose();
                delete _this._listener[uriStr];
            }
        };
        this._disposables.push(monaco.editor.onDidCreateModel(onModelAdd));
        this._disposables.push(monaco.editor.onWillDisposeModel(onModelRemoved));
        this._disposables.push(monaco.editor.onDidChangeModelLanguage(function (event) {
            onModelRemoved(event.model);
            onModelAdd(event.model);
        }));
        defaults.onDidChange(function (_) {
            monaco.editor.getModels().forEach(function (model) {
                if (model.getModeId() === _this._languageId) {
                    onModelRemoved(model);
                    onModelAdd(model);
                }
            });
        });
        this._disposables.push({
            dispose: function () {
                for (var key in _this._listener) {
                    _this._listener[key].dispose();
                }
            }
        });
        monaco.editor.getModels().forEach(onModelAdd);
    }
    DiagnosticsAdapter.prototype.dispose = function () {
        this._disposables.forEach(function (d) { return d && d.dispose(); });
        this._disposables = [];
    };
    DiagnosticsAdapter.prototype._doValidate = function (resource, languageId) {
        this._worker(resource).then(function (worker) {
            return worker.doValidation(resource.toString());
        }).then(function (diagnostics) {
            var markers = diagnostics.map(function (d) { return toDiagnostics(resource, d); });
            var model = monaco.editor.getModel(resource);
            if (model.getModeId() === languageId) {
                monaco.editor.setModelMarkers(model, languageId, markers);
            }
        }).then(undefined, function (err) {
            console.error(err);
        });
    };
    return DiagnosticsAdapter;
}());

function toSeverity(lsSeverity) {
    switch (lsSeverity) {
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["b" /* DiagnosticSeverity */].Error: return monaco.MarkerSeverity.Error;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["b" /* DiagnosticSeverity */].Warning: return monaco.MarkerSeverity.Warning;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["b" /* DiagnosticSeverity */].Information: return monaco.MarkerSeverity.Info;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["b" /* DiagnosticSeverity */].Hint: return monaco.MarkerSeverity.Hint;
        default:
            return monaco.MarkerSeverity.Info;
    }
}
function toDiagnostics(resource, diag) {
    var code = typeof diag.code === 'number' ? String(diag.code) : diag.code;
    return {
        severity: toSeverity(diag.severity),
        startLineNumber: diag.range.start.line + 1,
        startColumn: diag.range.start.character + 1,
        endLineNumber: diag.range.end.line + 1,
        endColumn: diag.range.end.character + 1,
        message: diag.message,
        code: code,
        source: diag.source
    };
}
// --- completion ------
function fromPosition(position) {
    if (!position) {
        return void 0;
    }
    return { character: position.column - 1, line: position.lineNumber - 1 };
}
function fromRange(range) {
    if (!range) {
        return void 0;
    }
    return { start: { line: range.startLineNumber - 1, character: range.startColumn - 1 }, end: { line: range.endLineNumber - 1, character: range.endColumn - 1 } };
}
function toRange(range) {
    if (!range) {
        return void 0;
    }
    return new monaco.Range(range.start.line + 1, range.start.character + 1, range.end.line + 1, range.end.character + 1);
}
function toCompletionItemKind(kind) {
    var mItemKind = monaco.languages.CompletionItemKind;
    switch (kind) {
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Text: return mItemKind.Text;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Method: return mItemKind.Method;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Function: return mItemKind.Function;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Constructor: return mItemKind.Constructor;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Field: return mItemKind.Field;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Variable: return mItemKind.Variable;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Class: return mItemKind.Class;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Interface: return mItemKind.Interface;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Module: return mItemKind.Module;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Property: return mItemKind.Property;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Unit: return mItemKind.Unit;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Value: return mItemKind.Value;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Enum: return mItemKind.Enum;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Keyword: return mItemKind.Keyword;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Snippet: return mItemKind.Snippet;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Color: return mItemKind.Color;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].File: return mItemKind.File;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["a" /* CompletionItemKind */].Reference: return mItemKind.Reference;
    }
    return mItemKind.Property;
}
function toTextEdit(textEdit) {
    if (!textEdit) {
        return void 0;
    }
    return {
        range: toRange(textEdit.range),
        text: textEdit.newText
    };
}
var CompletionAdapter = /** @class */ (function () {
    function CompletionAdapter(_worker) {
        this._worker = _worker;
    }
    Object.defineProperty(CompletionAdapter.prototype, "triggerCharacters", {
        get: function () {
            return [' ', ':'];
        },
        enumerable: true,
        configurable: true
    });
    CompletionAdapter.prototype.provideCompletionItems = function (model, position, context, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) {
            return worker.doComplete(resource.toString(), fromPosition(position));
        }).then(function (info) {
            if (!info) {
                return;
            }
            var wordInfo = model.getWordUntilPosition(position);
            var wordRange = new Range(position.lineNumber, wordInfo.startColumn, position.lineNumber, wordInfo.endColumn);
            var items = info.items.map(function (entry) {
                var item = {
                    label: entry.label,
                    insertText: entry.insertText || entry.label,
                    sortText: entry.sortText,
                    filterText: entry.filterText,
                    documentation: entry.documentation,
                    detail: entry.detail,
                    range: wordRange,
                    kind: toCompletionItemKind(entry.kind),
                };
                if (entry.textEdit) {
                    item.range = toRange(entry.textEdit.range);
                    item.insertText = entry.textEdit.newText;
                }
                if (entry.additionalTextEdits) {
                    item.additionalTextEdits = entry.additionalTextEdits.map(toTextEdit);
                }
                if (entry.insertTextFormat === __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["e" /* InsertTextFormat */].Snippet) {
                    item.insertTextRules = monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet;
                }
                return item;
            });
            return {
                isIncomplete: info.isIncomplete,
                suggestions: items
            };
        });
    };
    return CompletionAdapter;
}());

function isMarkupContent(thing) {
    return thing && typeof thing === 'object' && typeof thing.kind === 'string';
}
function toMarkdownString(entry) {
    if (typeof entry === 'string') {
        return {
            value: entry
        };
    }
    if (isMarkupContent(entry)) {
        if (entry.kind === 'plaintext') {
            return {
                value: entry.value.replace(/[\\`*_{}[\]()#+\-.!]/g, '\\$&')
            };
        }
        return {
            value: entry.value
        };
    }
    return { value: '```' + entry.language + '\n' + entry.value + '\n```\n' };
}
function toMarkedStringArray(contents) {
    if (!contents) {
        return void 0;
    }
    if (Array.isArray(contents)) {
        return contents.map(toMarkdownString);
    }
    return [toMarkdownString(contents)];
}
// --- hover ------
var HoverAdapter = /** @class */ (function () {
    function HoverAdapter(_worker) {
        this._worker = _worker;
    }
    HoverAdapter.prototype.provideHover = function (model, position, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) {
            return worker.doHover(resource.toString(), fromPosition(position));
        }).then(function (info) {
            if (!info) {
                return;
            }
            return {
                range: toRange(info.range),
                contents: toMarkedStringArray(info.contents)
            };
        });
    };
    return HoverAdapter;
}());

// --- document highlights ------
function toDocumentHighlightKind(kind) {
    switch (kind) {
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["c" /* DocumentHighlightKind */].Read: return monaco.languages.DocumentHighlightKind.Read;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["c" /* DocumentHighlightKind */].Write: return monaco.languages.DocumentHighlightKind.Write;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["c" /* DocumentHighlightKind */].Text: return monaco.languages.DocumentHighlightKind.Text;
    }
    return monaco.languages.DocumentHighlightKind.Text;
}
var DocumentHighlightAdapter = /** @class */ (function () {
    function DocumentHighlightAdapter(_worker) {
        this._worker = _worker;
    }
    DocumentHighlightAdapter.prototype.provideDocumentHighlights = function (model, position, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) {
            return worker.findDocumentHighlights(resource.toString(), fromPosition(position));
        }).then(function (entries) {
            if (!entries) {
                return;
            }
            return entries.map(function (entry) {
                return {
                    range: toRange(entry.range),
                    kind: toDocumentHighlightKind(entry.kind)
                };
            });
        });
    };
    return DocumentHighlightAdapter;
}());

// --- definition ------
function toLocation(location) {
    return {
        uri: Uri.parse(location.uri),
        range: toRange(location.range)
    };
}
var DefinitionAdapter = /** @class */ (function () {
    function DefinitionAdapter(_worker) {
        this._worker = _worker;
    }
    DefinitionAdapter.prototype.provideDefinition = function (model, position, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) {
            return worker.findDefinition(resource.toString(), fromPosition(position));
        }).then(function (definition) {
            if (!definition) {
                return;
            }
            return [toLocation(definition)];
        });
    };
    return DefinitionAdapter;
}());

// --- references ------
var ReferenceAdapter = /** @class */ (function () {
    function ReferenceAdapter(_worker) {
        this._worker = _worker;
    }
    ReferenceAdapter.prototype.provideReferences = function (model, position, context, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) {
            return worker.findReferences(resource.toString(), fromPosition(position));
        }).then(function (entries) {
            if (!entries) {
                return;
            }
            return entries.map(toLocation);
        });
    };
    return ReferenceAdapter;
}());

// --- rename ------
function toWorkspaceEdit(edit) {
    if (!edit || !edit.changes) {
        return void 0;
    }
    var resourceEdits = [];
    for (var uri in edit.changes) {
        var _uri = Uri.parse(uri);
        // let edits: monaco.languages.TextEdit[] = [];
        for (var _i = 0, _a = edit.changes[uri]; _i < _a.length; _i++) {
            var e = _a[_i];
            resourceEdits.push({
                resource: _uri,
                edit: {
                    range: toRange(e.range),
                    text: e.newText
                }
            });
        }
    }
    return {
        edits: resourceEdits
    };
}
var RenameAdapter = /** @class */ (function () {
    function RenameAdapter(_worker) {
        this._worker = _worker;
    }
    RenameAdapter.prototype.provideRenameEdits = function (model, position, newName, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) {
            return worker.doRename(resource.toString(), fromPosition(position), newName);
        }).then(function (edit) {
            return toWorkspaceEdit(edit);
        });
    };
    return RenameAdapter;
}());

// --- document symbols ------
function toSymbolKind(kind) {
    var mKind = monaco.languages.SymbolKind;
    switch (kind) {
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].File: return mKind.Array;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Module: return mKind.Module;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Namespace: return mKind.Namespace;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Package: return mKind.Package;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Class: return mKind.Class;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Method: return mKind.Method;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Property: return mKind.Property;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Field: return mKind.Field;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Constructor: return mKind.Constructor;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Enum: return mKind.Enum;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Interface: return mKind.Interface;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Function: return mKind.Function;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Variable: return mKind.Variable;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Constant: return mKind.Constant;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].String: return mKind.String;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Number: return mKind.Number;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Boolean: return mKind.Boolean;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["f" /* SymbolKind */].Array: return mKind.Array;
    }
    return mKind.Function;
}
var DocumentSymbolAdapter = /** @class */ (function () {
    function DocumentSymbolAdapter(_worker) {
        this._worker = _worker;
    }
    DocumentSymbolAdapter.prototype.provideDocumentSymbols = function (model, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) { return worker.findDocumentSymbols(resource.toString()); }).then(function (items) {
            if (!items) {
                return;
            }
            return items.map(function (item) { return ({
                name: item.name,
                detail: '',
                containerName: item.containerName,
                kind: toSymbolKind(item.kind),
                tags: [],
                range: toRange(item.location.range),
                selectionRange: toRange(item.location.range)
            }); });
        });
    };
    return DocumentSymbolAdapter;
}());

var DocumentColorAdapter = /** @class */ (function () {
    function DocumentColorAdapter(_worker) {
        this._worker = _worker;
    }
    DocumentColorAdapter.prototype.provideDocumentColors = function (model, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) { return worker.findDocumentColors(resource.toString()); }).then(function (infos) {
            if (!infos) {
                return;
            }
            return infos.map(function (item) { return ({
                color: item.color,
                range: toRange(item.range)
            }); });
        });
    };
    DocumentColorAdapter.prototype.provideColorPresentations = function (model, info, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) { return worker.getColorPresentations(resource.toString(), info.color, fromRange(info.range)); }).then(function (presentations) {
            if (!presentations) {
                return;
            }
            return presentations.map(function (presentation) {
                var item = {
                    label: presentation.label,
                };
                if (presentation.textEdit) {
                    item.textEdit = toTextEdit(presentation.textEdit);
                }
                if (presentation.additionalTextEdits) {
                    item.additionalTextEdits = presentation.additionalTextEdits.map(toTextEdit);
                }
                return item;
            });
        });
    };
    return DocumentColorAdapter;
}());

var FoldingRangeAdapter = /** @class */ (function () {
    function FoldingRangeAdapter(_worker) {
        this._worker = _worker;
    }
    FoldingRangeAdapter.prototype.provideFoldingRanges = function (model, context, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) { return worker.getFoldingRanges(resource.toString(), context); }).then(function (ranges) {
            if (!ranges) {
                return;
            }
            return ranges.map(function (range) {
                var result = {
                    start: range.startLine + 1,
                    end: range.endLine + 1
                };
                if (typeof range.kind !== 'undefined') {
                    result.kind = toFoldingRangeKind(range.kind);
                }
                return result;
            });
        });
    };
    return FoldingRangeAdapter;
}());

function toFoldingRangeKind(kind) {
    switch (kind) {
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["d" /* FoldingRangeKind */].Comment: return monaco.languages.FoldingRangeKind.Comment;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["d" /* FoldingRangeKind */].Imports: return monaco.languages.FoldingRangeKind.Imports;
        case __WEBPACK_IMPORTED_MODULE_0__deps_vscode_css_languageservice_cssLanguageService_js__["d" /* FoldingRangeKind */].Region: return monaco.languages.FoldingRangeKind.Region;
    }
}
var SelectionRangeAdapter = /** @class */ (function () {
    function SelectionRangeAdapter(_worker) {
        this._worker = _worker;
    }
    SelectionRangeAdapter.prototype.provideSelectionRanges = function (model, positions, token) {
        var resource = model.uri;
        return this._worker(resource).then(function (worker) { return worker.getSelectionRanges(resource.toString(), positions.map(fromPosition)); }).then(function (selectionRanges) {
            if (!selectionRanges) {
                return;
            }
            return selectionRanges.map(function (selectionRange) {
                var result = [];
                while (selectionRange) {
                    result.push({ range: toRange(selectionRange.range) });
                    selectionRange = selectionRange.parent;
                }
                return result;
            });
        });
    };
    return SelectionRangeAdapter;
}());



/***/ }),

/***/ 799:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export getCSSLanguageService */
/* unused harmony export getSCSSLanguageService */
/* unused harmony export getLESSLanguageService */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__parser_cssParser_js__ = __webpack_require__(771);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__services_cssCompletion_js__ = __webpack_require__(773);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__services_cssHover_js__ = __webpack_require__(805);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__services_cssNavigation_js__ = __webpack_require__(786);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__services_cssCodeActions_js__ = __webpack_require__(807);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__services_cssValidation_js__ = __webpack_require__(808);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__parser_scssParser_js__ = __webpack_require__(811);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__services_scssCompletion_js__ = __webpack_require__(813);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__parser_lessParser_js__ = __webpack_require__(814);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__services_lessCompletion_js__ = __webpack_require__(815);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__services_cssFolding_js__ = __webpack_require__(816);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__languageFacts_facts_js__ = __webpack_require__(762);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__services_cssSelectionRange_js__ = __webpack_require__(817);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__services_scssNavigation_js__ = __webpack_require__(818);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__cssLanguageTypes_js__ = __webpack_require__(758);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_14__cssLanguageTypes_js__["d"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_14__cssLanguageTypes_js__["f"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "c", function() { return __WEBPACK_IMPORTED_MODULE_14__cssLanguageTypes_js__["g"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "d", function() { return __WEBPACK_IMPORTED_MODULE_14__cssLanguageTypes_js__["i"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "e", function() { return __WEBPACK_IMPORTED_MODULE_14__cssLanguageTypes_js__["j"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "f", function() { return __WEBPACK_IMPORTED_MODULE_14__cssLanguageTypes_js__["p"]; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
















function createFacade(parser, completion, hover, navigation, codeActions, validation) {
    return {
        configure: function (settings) {
            validation.configure(settings);
            completion.configure(settings);
        },
        doValidation: validation.doValidation.bind(validation),
        parseStylesheet: parser.parseStylesheet.bind(parser),
        doComplete: completion.doComplete.bind(completion),
        setCompletionParticipants: completion.setCompletionParticipants.bind(completion),
        doHover: hover.doHover.bind(hover),
        findDefinition: navigation.findDefinition.bind(navigation),
        findReferences: navigation.findReferences.bind(navigation),
        findDocumentHighlights: navigation.findDocumentHighlights.bind(navigation),
        findDocumentLinks: navigation.findDocumentLinks.bind(navigation),
        findDocumentLinks2: navigation.findDocumentLinks2.bind(navigation),
        findDocumentSymbols: navigation.findDocumentSymbols.bind(navigation),
        doCodeActions: codeActions.doCodeActions.bind(codeActions),
        doCodeActions2: codeActions.doCodeActions2.bind(codeActions),
        findColorSymbols: function (d, s) { return navigation.findDocumentColors(d, s).map(function (s) { return s.range; }); },
        findDocumentColors: navigation.findDocumentColors.bind(navigation),
        getColorPresentations: navigation.getColorPresentations.bind(navigation),
        doRename: navigation.doRename.bind(navigation),
        getFoldingRanges: __WEBPACK_IMPORTED_MODULE_10__services_cssFolding_js__["a" /* getFoldingRanges */],
        getSelectionRanges: __WEBPACK_IMPORTED_MODULE_12__services_cssSelectionRange_js__["a" /* getSelectionRanges */]
    };
}
function handleCustomData(options) {
    if (options && options.customDataProviders) {
        __WEBPACK_IMPORTED_MODULE_11__languageFacts_facts_js__["f" /* cssDataManager */].addDataProviders(options.customDataProviders);
    }
}
function getCSSLanguageService(options) {
    handleCustomData(options);
    return createFacade(new __WEBPACK_IMPORTED_MODULE_0__parser_cssParser_js__["a" /* Parser */](), new __WEBPACK_IMPORTED_MODULE_1__services_cssCompletion_js__["a" /* CSSCompletion */](null, options && options.clientCapabilities), new __WEBPACK_IMPORTED_MODULE_2__services_cssHover_js__["a" /* CSSHover */](options && options.clientCapabilities), new __WEBPACK_IMPORTED_MODULE_3__services_cssNavigation_js__["a" /* CSSNavigation */](), new __WEBPACK_IMPORTED_MODULE_4__services_cssCodeActions_js__["a" /* CSSCodeActions */](), new __WEBPACK_IMPORTED_MODULE_5__services_cssValidation_js__["a" /* CSSValidation */]());
}
function getSCSSLanguageService(options) {
    handleCustomData(options);
    return createFacade(new __WEBPACK_IMPORTED_MODULE_6__parser_scssParser_js__["a" /* SCSSParser */](), new __WEBPACK_IMPORTED_MODULE_7__services_scssCompletion_js__["a" /* SCSSCompletion */](options && options.clientCapabilities), new __WEBPACK_IMPORTED_MODULE_2__services_cssHover_js__["a" /* CSSHover */](options && options.clientCapabilities), new __WEBPACK_IMPORTED_MODULE_13__services_scssNavigation_js__["a" /* SCSSNavigation */](options && options.fileSystemProvider), new __WEBPACK_IMPORTED_MODULE_4__services_cssCodeActions_js__["a" /* CSSCodeActions */](), new __WEBPACK_IMPORTED_MODULE_5__services_cssValidation_js__["a" /* CSSValidation */]());
}
function getLESSLanguageService(options) {
    handleCustomData(options);
    return createFacade(new __WEBPACK_IMPORTED_MODULE_8__parser_lessParser_js__["a" /* LESSParser */](), new __WEBPACK_IMPORTED_MODULE_9__services_lessCompletion_js__["a" /* LESSCompletion */](options && options.clientCapabilities), new __WEBPACK_IMPORTED_MODULE_2__services_cssHover_js__["a" /* CSSHover */](options && options.clientCapabilities), new __WEBPACK_IMPORTED_MODULE_3__services_cssNavigation_js__["a" /* CSSNavigation */](), new __WEBPACK_IMPORTED_MODULE_4__services_cssCodeActions_js__["a" /* CSSCodeActions */](), new __WEBPACK_IMPORTED_MODULE_5__services_cssValidation_js__["a" /* CSSValidation */]());
}


/***/ }),

/***/ 800:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return cssData; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// file generated from vscode-web-custom-data NPM package
var cssData = {
    "version": 1.1,
    "properties": [
        {
            "name": "width",
            "values": [
                {
                    "name": "auto",
                    "description": "The width depends on the values of other properties."
                },
                {
                    "name": "fit-content",
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "<viewport-length>{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/width"
                }
            ],
            "description": "Specifies the width of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "height",
            "values": [
                {
                    "name": "auto",
                    "description": "The height depends on the values of other properties."
                },
                {
                    "name": "fit-content",
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "<viewport-length>{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/height"
                }
            ],
            "description": "Specifies the height of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "display",
            "values": [
                {
                    "name": "block",
                    "description": "The element generates a block-level box"
                },
                {
                    "name": "contents",
                    "description": "The element itself does not generate any boxes, but its children and pseudo-elements still generate boxes as normal."
                },
                {
                    "name": "flex",
                    "description": "The element generates a principal flex container box and establishes a flex formatting context."
                },
                {
                    "name": "flexbox",
                    "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
                },
                {
                    "name": "flow-root",
                    "description": "The element generates a block container box, and lays out its contents using flow layout."
                },
                {
                    "name": "grid",
                    "description": "The element generates a principal grid container box, and establishes a grid formatting context."
                },
                {
                    "name": "inline",
                    "description": "The element generates an inline-level box."
                },
                {
                    "name": "inline-block",
                    "description": "A block box, which itself is flowed as a single inline box, similar to a replaced element. The inside of an inline-block is formatted as a block box, and the box itself is formatted as an inline box."
                },
                {
                    "name": "inline-flex",
                    "description": "Inline-level flex container."
                },
                {
                    "name": "inline-flexbox",
                    "description": "Inline-level flex container. Standardized as 'inline-flex'"
                },
                {
                    "name": "inline-table",
                    "description": "Inline-level table wrapper box containing table box."
                },
                {
                    "name": "list-item",
                    "description": "One or more block boxes and one marker box."
                },
                {
                    "name": "-moz-box",
                    "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
                },
                {
                    "name": "-moz-deck"
                },
                {
                    "name": "-moz-grid"
                },
                {
                    "name": "-moz-grid-group"
                },
                {
                    "name": "-moz-grid-line"
                },
                {
                    "name": "-moz-groupbox"
                },
                {
                    "name": "-moz-inline-box",
                    "description": "Inline-level flex container. Standardized as 'inline-flex'"
                },
                {
                    "name": "-moz-inline-grid"
                },
                {
                    "name": "-moz-inline-stack"
                },
                {
                    "name": "-moz-marker"
                },
                {
                    "name": "-moz-popup"
                },
                {
                    "name": "-moz-stack"
                },
                {
                    "name": "-ms-flexbox",
                    "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
                },
                {
                    "name": "-ms-grid",
                    "description": "The element generates a principal grid container box, and establishes a grid formatting context."
                },
                {
                    "name": "-ms-inline-flexbox",
                    "description": "Inline-level flex container. Standardized as 'inline-flex'"
                },
                {
                    "name": "-ms-inline-grid",
                    "description": "Inline-level grid container."
                },
                {
                    "name": "none",
                    "description": "The element and its descendants generates no boxes."
                },
                {
                    "name": "ruby",
                    "description": "The element generates a principal ruby container box, and establishes a ruby formatting context."
                },
                {
                    "name": "ruby-base"
                },
                {
                    "name": "ruby-base-container"
                },
                {
                    "name": "ruby-text"
                },
                {
                    "name": "ruby-text-container"
                },
                {
                    "name": "run-in",
                    "description": "The element generates a run-in box. Run-in elements act like inlines or blocks, depending on the surrounding elements."
                },
                {
                    "name": "table",
                    "description": "The element generates a principal table wrapper box containing an additionally-generated table box, and establishes a table formatting context."
                },
                {
                    "name": "table-caption"
                },
                {
                    "name": "table-cell"
                },
                {
                    "name": "table-column"
                },
                {
                    "name": "table-column-group"
                },
                {
                    "name": "table-footer-group"
                },
                {
                    "name": "table-header-group"
                },
                {
                    "name": "table-row"
                },
                {
                    "name": "table-row-group"
                },
                {
                    "name": "-webkit-box",
                    "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
                },
                {
                    "name": "-webkit-flex",
                    "description": "The element lays out its contents using flow layout (block-and-inline layout)."
                },
                {
                    "name": "-webkit-inline-box",
                    "description": "Inline-level flex container. Standardized as 'inline-flex'"
                },
                {
                    "name": "-webkit-inline-flex",
                    "description": "Inline-level flex container."
                }
            ],
            "syntax": "[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/display"
                }
            ],
            "description": "In combination with 'float' and 'position', determines the type of box or boxes that are generated for an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "padding",
            "values": [],
            "syntax": "[ <length> | <percentage> ]{1,4}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding"
                }
            ],
            "description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "position",
            "values": [
                {
                    "name": "absolute",
                    "description": "The box's position (and possibly size) is specified with the 'top', 'right', 'bottom', and 'left' properties. These properties specify offsets with respect to the box's 'containing block'."
                },
                {
                    "name": "fixed",
                    "description": "The box's position is calculated according to the 'absolute' model, but in addition, the box is fixed with respect to some reference. As with the 'absolute' model, the box's margins do not collapse with any other margins."
                },
                {
                    "name": "-ms-page",
                    "description": "The box's position is calculated according to the 'absolute' model."
                },
                {
                    "name": "relative",
                    "description": "The box's position is calculated according to the normal flow (this is called the position in normal flow). Then the box is offset relative to its normal position."
                },
                {
                    "name": "static",
                    "description": "The box is a normal box, laid out according to the normal flow. The 'top', 'right', 'bottom', and 'left' properties do not apply."
                },
                {
                    "name": "sticky",
                    "description": "The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."
                },
                {
                    "name": "-webkit-sticky",
                    "description": "The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."
                }
            ],
            "syntax": "static | relative | absolute | sticky | fixed",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/position"
                }
            ],
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border",
            "syntax": "<line-width> || <line-style> || <color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border"
                }
            ],
            "description": "Shorthand property for setting border width, style, and color.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "margin",
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "[ <length> | <percentage> | auto ]{1,4}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin"
                }
            ],
            "description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "top",
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
                }
            ],
            "syntax": "<length> | <percentage> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/top"
                }
            ],
            "description": "Specifies how far an absolutely positioned box's top margin edge is offset below the top edge of the box's 'containing block'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "left",
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
                }
            ],
            "syntax": "<length> | <percentage> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/left"
                }
            ],
            "description": "Specifies how far an absolutely positioned box's left margin edge is offset to the right of the left edge of the box's 'containing block'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-top",
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "<length> | <percentage> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-top"
                }
            ],
            "description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "color",
            "syntax": "<color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/color"
                }
            ],
            "description": "Color of an element's text",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "font-size",
            "values": [
                {
                    "name": "large"
                },
                {
                    "name": "larger"
                },
                {
                    "name": "medium"
                },
                {
                    "name": "small"
                },
                {
                    "name": "smaller"
                },
                {
                    "name": "x-large"
                },
                {
                    "name": "x-small"
                },
                {
                    "name": "xx-large"
                },
                {
                    "name": "xx-small"
                }
            ],
            "syntax": "<absolute-size> | <relative-size> | <length-percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-size"
                }
            ],
            "description": "Indicates the desired height of glyphs from the font. For scalable fonts, the font-size is a scale factor applied to the EM unit of the font. (Note that certain glyphs may bleed outside their EM box.) For non-scalable fonts, the font-size is converted into absolute units and matched against the declared font-size of the font, using the same absolute coordinate space for both of the matched values.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "background-color",
            "syntax": "<color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-color"
                }
            ],
            "description": "Sets the background color of an element.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "text-align",
            "values": [
                {
                    "name": "center",
                    "description": "The inline contents are centered within the line box."
                },
                {
                    "name": "end",
                    "description": "The inline contents are aligned to the end edge of the line box."
                },
                {
                    "name": "justify",
                    "description": "The text is justified according to the method specified by the 'text-justify' property."
                },
                {
                    "name": "left",
                    "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
                },
                {
                    "name": "right",
                    "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
                },
                {
                    "name": "start",
                    "description": "The inline contents are aligned to the start edge of the line box."
                }
            ],
            "syntax": "start | end | left | right | center | justify | match-parent",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-align"
                }
            ],
            "description": "Describes how inline contents of a block are horizontally aligned if the contents do not completely fill the line box.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "opacity",
            "syntax": "<alpha-value>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/opacity"
                }
            ],
            "description": "Opacity of an element's text, where 1 is opaque and 0 is entirely transparent.",
            "restrictions": [
                "number(0-1)"
            ]
        },
        {
            "name": "background",
            "values": [
                {
                    "name": "fixed",
                    "description": "The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."
                },
                {
                    "name": "local",
                    "description": "The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."
                },
                {
                    "name": "none",
                    "description": "A value of 'none' counts as an image layer but draws nothing."
                },
                {
                    "name": "scroll",
                    "description": "The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"
                }
            ],
            "syntax": "[ <bg-layer> , ]* <final-bg-layer>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background"
                }
            ],
            "description": "Shorthand property for setting most background properties at the same place in the style sheet.",
            "restrictions": [
                "enum",
                "image",
                "color",
                "position",
                "length",
                "repeat",
                "percentage",
                "box"
            ]
        },
        {
            "name": "float",
            "values": [
                {
                    "name": "inline-end",
                    "description": "A keyword indicating that the element must float on the end side of its containing block. That is the right side with ltr scripts, and the left side with rtl scripts."
                },
                {
                    "name": "inline-start",
                    "description": "A keyword indicating that the element must float on the start side of its containing block. That is the left side with ltr scripts, and the right side with rtl scripts."
                },
                {
                    "name": "left",
                    "description": "The element generates a block box that is floated to the left. Content flows on the right side of the box, starting at the top (subject to the 'clear' property)."
                },
                {
                    "name": "none",
                    "description": "The box is not floated."
                },
                {
                    "name": "right",
                    "description": "Similar to 'left', except the box is floated to the right, and content flows on the left side of the box, starting at the top."
                }
            ],
            "syntax": "left | right | none | inline-start | inline-end",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/float"
                }
            ],
            "description": "Specifies how a box should be floated. It may be set for any element, but only applies to elements that generate boxes that are not absolutely positioned.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-weight",
            "values": [
                {
                    "name": "100",
                    "description": "Thin"
                },
                {
                    "name": "200",
                    "description": "Extra Light (Ultra Light)"
                },
                {
                    "name": "300",
                    "description": "Light"
                },
                {
                    "name": "400",
                    "description": "Normal"
                },
                {
                    "name": "500",
                    "description": "Medium"
                },
                {
                    "name": "600",
                    "description": "Semi Bold (Demi Bold)"
                },
                {
                    "name": "700",
                    "description": "Bold"
                },
                {
                    "name": "800",
                    "description": "Extra Bold (Ultra Bold)"
                },
                {
                    "name": "900",
                    "description": "Black (Heavy)"
                },
                {
                    "name": "bold",
                    "description": "Same as 700"
                },
                {
                    "name": "bolder",
                    "description": "Specifies the weight of the face bolder than the inherited value."
                },
                {
                    "name": "lighter",
                    "description": "Specifies the weight of the face lighter than the inherited value."
                },
                {
                    "name": "normal",
                    "description": "Same as 400"
                }
            ],
            "syntax": "<font-weight-absolute>{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-weight"
                }
            ],
            "description": "Specifies weight of glyphs in the font, their degree of blackness or stroke thickness.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "overflow",
            "values": [
                {
                    "name": "auto",
                    "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
                },
                {
                    "name": "hidden",
                    "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
                },
                {
                    "name": "-moz-hidden-unscrollable",
                    "description": "Same as the standardized 'clip', except doesn’t establish a block formatting context."
                },
                {
                    "name": "scroll",
                    "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
                },
                {
                    "name": "visible",
                    "description": "Content is not clipped, i.e., it may be rendered outside the content box."
                }
            ],
            "syntax": "[ visible | hidden | clip | scroll | auto ]{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/overflow"
                }
            ],
            "description": "Shorthand for setting 'overflow-x' and 'overflow-y'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "line-height",
            "values": [
                {
                    "name": "normal",
                    "description": "Tells user agents to set the computed value to a 'reasonable' value based on the font size of the element."
                }
            ],
            "syntax": "normal | <number> | <length> | <percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/line-height"
                }
            ],
            "description": "Determines the block-progression dimension of the text content area of an inline box.",
            "restrictions": [
                "number",
                "length",
                "percentage"
            ]
        },
        {
            "name": "font-family",
            "values": [
                {
                    "name": "-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif"
                },
                {
                    "name": "Arial, Helvetica, sans-serif"
                },
                {
                    "name": "Cambria, Cochin, Georgia, Times, 'Times New Roman', serif"
                },
                {
                    "name": "'Courier New', Courier, monospace"
                },
                {
                    "name": "cursive"
                },
                {
                    "name": "fantasy"
                },
                {
                    "name": "'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif"
                },
                {
                    "name": "Georgia, 'Times New Roman', Times, serif"
                },
                {
                    "name": "'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif"
                },
                {
                    "name": "Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif"
                },
                {
                    "name": "'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif"
                },
                {
                    "name": "monospace"
                },
                {
                    "name": "sans-serif"
                },
                {
                    "name": "'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"
                },
                {
                    "name": "serif"
                },
                {
                    "name": "'Times New Roman', Times, serif"
                },
                {
                    "name": "'Trebuchet MS', 'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Arial, sans-serif"
                },
                {
                    "name": "Verdana, Geneva, Tahoma, sans-serif"
                }
            ],
            "syntax": "<family-name>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-family"
                }
            ],
            "description": "Specifies a prioritized list of font family names or generic family names. A user agent iterates through the list of family names until it matches an available font that contains a glyph for the character to be rendered.",
            "restrictions": [
                "font"
            ]
        },
        {
            "name": "text-decoration",
            "values": [
                {
                    "name": "dashed",
                    "description": "Produces a dashed line style."
                },
                {
                    "name": "dotted",
                    "description": "Produces a dotted line."
                },
                {
                    "name": "double",
                    "description": "Produces a double line."
                },
                {
                    "name": "line-through",
                    "description": "Each line of text has a line through the middle."
                },
                {
                    "name": "none",
                    "description": "Produces no line."
                },
                {
                    "name": "overline",
                    "description": "Each line of text has a line above it."
                },
                {
                    "name": "solid",
                    "description": "Produces a solid line."
                },
                {
                    "name": "underline",
                    "description": "Each line of text is underlined."
                },
                {
                    "name": "wavy",
                    "description": "Produces a wavy line."
                }
            ],
            "syntax": "<'text-decoration-line'> || <'text-decoration-style'> || <'text-decoration-color'> || <'text-decoration-thickness'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration"
                }
            ],
            "description": "Decorations applied to font used for an element's text.",
            "restrictions": [
                "enum",
                "color"
            ]
        },
        {
            "name": "box-sizing",
            "values": [
                {
                    "name": "border-box",
                    "description": "The specified width and height (and respective min/max properties) on this element determine the border box of the element."
                },
                {
                    "name": "content-box",
                    "description": "Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."
                }
            ],
            "syntax": "content-box | border-box",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/box-sizing"
                }
            ],
            "description": "Specifies the behavior of the 'width' and 'height' properties.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "z-index",
            "values": [
                {
                    "name": "auto",
                    "description": "The stack level of the generated box in the current stacking context is 0. The box does not establish a new stacking context unless it is the root element."
                }
            ],
            "syntax": "auto | <integer>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/z-index"
                }
            ],
            "description": "For a positioned box, the 'z-index' property specifies the stack level of the box in the current stacking context and whether the box establishes a local stacking context.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "vertical-align",
            "values": [
                {
                    "name": "auto",
                    "description": "Align the dominant baseline of the parent box with the equivalent, or heuristically reconstructed, baseline of the element inline box."
                },
                {
                    "name": "baseline",
                    "description": "Align the 'alphabetic' baseline of the element with the 'alphabetic' baseline of the parent element."
                },
                {
                    "name": "bottom",
                    "description": "Align the after edge of the extended inline box with the after-edge of the line box."
                },
                {
                    "name": "middle",
                    "description": "Align the 'middle' baseline of the inline element with the middle baseline of the parent."
                },
                {
                    "name": "sub",
                    "description": "Lower the baseline of the box to the proper position for subscripts of the parent's box. (This value has no effect on the font size of the element's text.)"
                },
                {
                    "name": "super",
                    "description": "Raise the baseline of the box to the proper position for superscripts of the parent's box. (This value has no effect on the font size of the element's text.)"
                },
                {
                    "name": "text-bottom",
                    "description": "Align the bottom of the box with the after-edge of the parent element's font."
                },
                {
                    "name": "text-top",
                    "description": "Align the top of the box with the before-edge of the parent element's font."
                },
                {
                    "name": "top",
                    "description": "Align the before edge of the extended inline box with the before-edge of the line box."
                },
                {
                    "name": "-webkit-baseline-middle"
                }
            ],
            "syntax": "baseline | sub | super | text-top | text-bottom | middle | top | bottom | <percentage> | <length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/vertical-align"
                }
            ],
            "description": "Affects the vertical positioning of the inline boxes generated by an inline-level element inside a line box.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "border-radius",
            "syntax": "<length-percentage>{1,4} [ / <length-percentage>{1,4} ]?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-radius"
                }
            ],
            "description": "Defines the radii of the outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-left",
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "<length> | <percentage> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-left"
                }
            ],
            "description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "cursor",
            "values": [
                {
                    "name": "alias",
                    "description": "Indicates an alias of/shortcut to something is to be created. Often rendered as an arrow with a small curved arrow next to it."
                },
                {
                    "name": "all-scroll",
                    "description": "Indicates that the something can be scrolled in any direction. Often rendered as arrows pointing up, down, left, and right with a dot in the middle."
                },
                {
                    "name": "auto",
                    "description": "The UA determines the cursor to display based on the current context."
                },
                {
                    "name": "cell",
                    "description": "Indicates that a cell or set of cells may be selected. Often rendered as a thick plus-sign with a dot in the middle."
                },
                {
                    "name": "col-resize",
                    "description": "Indicates that the item/column can be resized horizontally. Often rendered as arrows pointing left and right with a vertical bar separating them."
                },
                {
                    "name": "context-menu",
                    "description": "A context menu is available for the object under the cursor. Often rendered as an arrow with a small menu-like graphic next to it."
                },
                {
                    "name": "copy",
                    "description": "Indicates something is to be copied. Often rendered as an arrow with a small plus sign next to it."
                },
                {
                    "name": "crosshair",
                    "description": "A simple crosshair (e.g., short line segments resembling a '+' sign). Often used to indicate a two dimensional bitmap selection mode."
                },
                {
                    "name": "default",
                    "description": "The platform-dependent default cursor. Often rendered as an arrow."
                },
                {
                    "name": "e-resize",
                    "description": "Indicates that east edge is to be moved."
                },
                {
                    "name": "ew-resize",
                    "description": "Indicates a bidirectional east-west resize cursor."
                },
                {
                    "name": "grab",
                    "description": "Indicates that something can be grabbed."
                },
                {
                    "name": "grabbing",
                    "description": "Indicates that something is being grabbed."
                },
                {
                    "name": "help",
                    "description": "Help is available for the object under the cursor. Often rendered as a question mark or a balloon."
                },
                {
                    "name": "move",
                    "description": "Indicates something is to be moved."
                },
                {
                    "name": "-moz-grab",
                    "description": "Indicates that something can be grabbed."
                },
                {
                    "name": "-moz-grabbing",
                    "description": "Indicates that something is being grabbed."
                },
                {
                    "name": "-moz-zoom-in",
                    "description": "Indicates that something can be zoomed (magnified) in."
                },
                {
                    "name": "-moz-zoom-out",
                    "description": "Indicates that something can be zoomed (magnified) out."
                },
                {
                    "name": "ne-resize",
                    "description": "Indicates that movement starts from north-east corner."
                },
                {
                    "name": "nesw-resize",
                    "description": "Indicates a bidirectional north-east/south-west cursor."
                },
                {
                    "name": "no-drop",
                    "description": "Indicates that the dragged item cannot be dropped at the current cursor location. Often rendered as a hand or pointer with a small circle with a line through it."
                },
                {
                    "name": "none",
                    "description": "No cursor is rendered for the element."
                },
                {
                    "name": "not-allowed",
                    "description": "Indicates that the requested action will not be carried out. Often rendered as a circle with a line through it."
                },
                {
                    "name": "n-resize",
                    "description": "Indicates that north edge is to be moved."
                },
                {
                    "name": "ns-resize",
                    "description": "Indicates a bidirectional north-south cursor."
                },
                {
                    "name": "nw-resize",
                    "description": "Indicates that movement starts from north-west corner."
                },
                {
                    "name": "nwse-resize",
                    "description": "Indicates a bidirectional north-west/south-east cursor."
                },
                {
                    "name": "pointer",
                    "description": "The cursor is a pointer that indicates a link."
                },
                {
                    "name": "progress",
                    "description": "A progress indicator. The program is performing some processing, but is different from 'wait' in that the user may still interact with the program. Often rendered as a spinning beach ball, or an arrow with a watch or hourglass."
                },
                {
                    "name": "row-resize",
                    "description": "Indicates that the item/row can be resized vertically. Often rendered as arrows pointing up and down with a horizontal bar separating them."
                },
                {
                    "name": "se-resize",
                    "description": "Indicates that movement starts from south-east corner."
                },
                {
                    "name": "s-resize",
                    "description": "Indicates that south edge is to be moved."
                },
                {
                    "name": "sw-resize",
                    "description": "Indicates that movement starts from south-west corner."
                },
                {
                    "name": "text",
                    "description": "Indicates text that may be selected. Often rendered as a vertical I-beam."
                },
                {
                    "name": "vertical-text",
                    "description": "Indicates vertical-text that may be selected. Often rendered as a horizontal I-beam."
                },
                {
                    "name": "wait",
                    "description": "Indicates that the program is busy and the user should wait. Often rendered as a watch or hourglass."
                },
                {
                    "name": "-webkit-grab",
                    "description": "Indicates that something can be grabbed."
                },
                {
                    "name": "-webkit-grabbing",
                    "description": "Indicates that something is being grabbed."
                },
                {
                    "name": "-webkit-zoom-in",
                    "description": "Indicates that something can be zoomed (magnified) in."
                },
                {
                    "name": "-webkit-zoom-out",
                    "description": "Indicates that something can be zoomed (magnified) out."
                },
                {
                    "name": "w-resize",
                    "description": "Indicates that west edge is to be moved."
                },
                {
                    "name": "zoom-in",
                    "description": "Indicates that something can be zoomed (magnified) in."
                },
                {
                    "name": "zoom-out",
                    "description": "Indicates that something can be zoomed (magnified) out."
                }
            ],
            "syntax": "[ [ <url> [ <x> <y> ]? , ]* [ auto | default | none | context-menu | help | pointer | progress | wait | cell | crosshair | text | vertical-text | alias | copy | move | no-drop | not-allowed | e-resize | n-resize | ne-resize | nw-resize | s-resize | se-resize | sw-resize | w-resize | ew-resize | ns-resize | nesw-resize | nwse-resize | col-resize | row-resize | all-scroll | zoom-in | zoom-out | grab | grabbing ] ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/cursor"
                }
            ],
            "description": "Allows control over cursor appearance in an element",
            "restrictions": [
                "url",
                "number",
                "enum"
            ]
        },
        {
            "name": "margin-bottom",
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "<length> | <percentage> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-bottom"
                }
            ],
            "description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "right",
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
                }
            ],
            "syntax": "<length> | <percentage> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/right"
                }
            ],
            "description": "Specifies how far an absolutely positioned box's right margin edge is offset to the left of the right edge of the box's 'containing block'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-right",
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "<length> | <percentage> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-right"
                }
            ],
            "description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-left",
            "syntax": "<length> | <percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-left"
                }
            ],
            "description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-top",
            "syntax": "<length> | <percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-top"
                }
            ],
            "description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "max-width",
            "values": [
                {
                    "name": "none",
                    "description": "No limit on the width of the box."
                },
                {
                    "name": "fit-content",
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "<viewport-length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/max-width"
                }
            ],
            "description": "Allows authors to constrain content width to a certain range.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "bottom",
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
                }
            ],
            "syntax": "<length> | <percentage> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/bottom"
                }
            ],
            "description": "Specifies how far an absolutely positioned box's bottom margin edge is offset above the bottom edge of the box's 'containing block'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "background-image",
            "values": [
                {
                    "name": "none",
                    "description": "Counts as an image layer but draws nothing."
                }
            ],
            "syntax": "<bg-image>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-image"
                }
            ],
            "description": "Sets the background image(s) of an element.",
            "restrictions": [
                "image",
                "enum"
            ]
        },
        {
            "name": "content",
            "values": [
                {
                    "name": "attr()",
                    "description": "The attr(n) function returns as a string the value of attribute n for the subject of the selector."
                },
                {
                    "name": "counter(name)",
                    "description": "Counters are denoted by identifiers (see the 'counter-increment' and 'counter-reset' properties)."
                },
                {
                    "name": "icon",
                    "description": "The (pseudo-)element is replaced in its entirety by the resource referenced by its 'icon' property, and treated as a replaced element."
                },
                {
                    "name": "none",
                    "description": "On elements, this inhibits the children of the element from being rendered as children of this element, as if the element was empty. On pseudo-elements it causes the pseudo-element to have no content."
                },
                {
                    "name": "normal",
                    "description": "See http://www.w3.org/TR/css3-content/#content for computation rules."
                },
                {
                    "name": "url()"
                }
            ],
            "syntax": "normal | none | [ <content-replacement> | <content-list> ] [/ <string> ]?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/content"
                }
            ],
            "description": "Determines which page-based occurrence of a given element is applied to a counter or string value.",
            "restrictions": [
                "string",
                "url"
            ]
        },
        {
            "name": "padding-right",
            "syntax": "<length> | <percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-right"
                }
            ],
            "description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "white-space",
            "values": [
                {
                    "name": "normal",
                    "description": "Sets 'white-space-collapsing' to 'collapse' and 'text-wrap' to 'normal'."
                },
                {
                    "name": "nowrap",
                    "description": "Sets 'white-space-collapsing' to 'collapse' and 'text-wrap' to 'none'."
                },
                {
                    "name": "pre",
                    "description": "Sets 'white-space-collapsing' to 'preserve' and 'text-wrap' to 'none'."
                },
                {
                    "name": "pre-line",
                    "description": "Sets 'white-space-collapsing' to 'preserve-breaks' and 'text-wrap' to 'normal'."
                },
                {
                    "name": "pre-wrap",
                    "description": "Sets 'white-space-collapsing' to 'preserve' and 'text-wrap' to 'normal'."
                }
            ],
            "syntax": "normal | pre | nowrap | pre-wrap | pre-line | break-spaces",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/white-space"
                }
            ],
            "description": "Shorthand property for the 'white-space-collapsing' and 'text-wrap' properties.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "padding-bottom",
            "syntax": "<length> | <percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-bottom"
                }
            ],
            "description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-bottom",
            "syntax": "<line-width> || <line-style> || <color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom"
                }
            ],
            "description": "Shorthand property for setting border width, style and color.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "box-shadow",
            "values": [
                {
                    "name": "inset",
                    "description": "Changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it)."
                },
                {
                    "name": "none",
                    "description": "No shadow."
                }
            ],
            "syntax": "none | <shadow>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/box-shadow"
                }
            ],
            "description": "Attaches one or more drop-shadows to the box. The property is a comma-separated list of shadows, each specified by 2-4 length values, an optional color, and an optional 'inset' keyword. Omitted lengths are 0; omitted colors are a user agent chosen color.",
            "restrictions": [
                "length",
                "color",
                "enum"
            ]
        },
        {
            "name": "transform",
            "values": [
                {
                    "name": "matrix()",
                    "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
                },
                {
                    "name": "matrix3d()",
                    "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
                },
                {
                    "name": "none"
                },
                {
                    "name": "perspective()",
                    "description": "Specifies a perspective projection matrix."
                },
                {
                    "name": "rotate()",
                    "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
                },
                {
                    "name": "rotate3d()",
                    "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
                },
                {
                    "name": "rotateX('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the X axis."
                },
                {
                    "name": "rotateY('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Y axis."
                },
                {
                    "name": "rotateZ('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Z axis."
                },
                {
                    "name": "scale()",
                    "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
                },
                {
                    "name": "scale3d()",
                    "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
                },
                {
                    "name": "scaleX()",
                    "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
                },
                {
                    "name": "scaleY()",
                    "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
                },
                {
                    "name": "scaleZ()",
                    "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
                },
                {
                    "name": "skew()",
                    "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
                },
                {
                    "name": "skewX()",
                    "description": "Specifies a skew transformation along the X axis by the given angle."
                },
                {
                    "name": "skewY()",
                    "description": "Specifies a skew transformation along the Y axis by the given angle."
                },
                {
                    "name": "translate()",
                    "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
                },
                {
                    "name": "translate3d()",
                    "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
                },
                {
                    "name": "translateX()",
                    "description": "Specifies a translation by the given amount in the X direction."
                },
                {
                    "name": "translateY()",
                    "description": "Specifies a translation by the given amount in the Y direction."
                },
                {
                    "name": "translateZ()",
                    "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
                }
            ],
            "syntax": "none | <transform-list>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transform"
                }
            ],
            "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "min-height",
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "fit-content",
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "<viewport-length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/min-height"
                }
            ],
            "description": "Allows authors to constrain content height to a certain range.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "visibility",
            "values": [
                {
                    "name": "collapse",
                    "description": "Table-specific. If used on elements other than rows, row groups, columns, or column groups, 'collapse' has the same meaning as 'hidden'."
                },
                {
                    "name": "hidden",
                    "description": "The generated box is invisible (fully transparent, nothing is drawn), but still affects layout."
                },
                {
                    "name": "visible",
                    "description": "The generated box is visible."
                }
            ],
            "syntax": "visible | hidden | collapse",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/visibility"
                }
            ],
            "description": "Specifies whether the boxes generated by an element are rendered. Invisible boxes still affect layout (set the ‘display’ property to ‘none’ to suppress box generation altogether).",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "background-position",
            "syntax": "<bg-position>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-position"
                }
            ],
            "description": "Specifies the initial position of the background image(s) (after any resizing) within their corresponding background positioning area.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-top",
            "syntax": "<line-width> || <line-style> || <color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-top"
                }
            ],
            "description": "Shorthand property for setting border width, style and color",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "min-width",
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "fit-content",
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "<viewport-length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/min-width"
                }
            ],
            "description": "Allows authors to constrain content width to a certain range.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "outline",
            "values": [
                {
                    "name": "auto",
                    "description": "Permits the user agent to render a custom outline style, typically the default platform style."
                },
                {
                    "name": "invert",
                    "description": "Performs a color inversion on the pixels on the screen."
                }
            ],
            "syntax": "[ <'outline-color'> || <'outline-style'> || <'outline-width'> ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/outline"
                }
            ],
            "description": "Shorthand property for 'outline-style', 'outline-width', and 'outline-color'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color",
                "enum"
            ]
        },
        {
            "name": "transition",
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "syntax": "<single-transition>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transition"
                }
            ],
            "description": "Shorthand property combines four of the transition properties into a single property.",
            "restrictions": [
                "time",
                "property",
                "timing-function",
                "enum"
            ]
        },
        {
            "name": "clear",
            "values": [
                {
                    "name": "both",
                    "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating and left-floating boxes that resulted from elements earlier in the source document."
                },
                {
                    "name": "left",
                    "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any left-floating boxes that resulted from elements earlier in the source document."
                },
                {
                    "name": "none",
                    "description": "No constraint on the box's position with respect to floats."
                },
                {
                    "name": "right",
                    "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating boxes that resulted from elements earlier in the source document."
                }
            ],
            "syntax": "none | left | right | both | inline-start | inline-end",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/clear"
                }
            ],
            "description": "Indicates which sides of an element's box(es) may not be adjacent to an earlier floating box. The 'clear' property does not consider floats inside the element itself or in other block formatting contexts.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-color",
            "values": [],
            "syntax": "<color>{1,4}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-color"
                }
            ],
            "description": "The color of the border around all four edges of an element.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "background-repeat",
            "values": [],
            "syntax": "<repeat-style>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-repeat"
                }
            ],
            "description": "Specifies how background images are tiled after they have been sized and positioned.",
            "restrictions": [
                "repeat"
            ]
        },
        {
            "name": "background-size",
            "values": [
                {
                    "name": "auto",
                    "description": "Resolved by using the image’s intrinsic ratio and the size of the other dimension, or failing that, using the image’s intrinsic size, or failing that, treating it as 100%."
                },
                {
                    "name": "contain",
                    "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."
                },
                {
                    "name": "cover",
                    "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."
                }
            ],
            "syntax": "<bg-size>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-size"
                }
            ],
            "description": "Specifies the size of the background images.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "text-transform",
            "values": [
                {
                    "name": "capitalize",
                    "description": "Puts the first typographic letter unit of each word in titlecase."
                },
                {
                    "name": "lowercase",
                    "description": "Puts all letters in lowercase."
                },
                {
                    "name": "none",
                    "description": "No effects."
                },
                {
                    "name": "uppercase",
                    "description": "Puts all letters in uppercase."
                }
            ],
            "syntax": "none | capitalize | uppercase | lowercase | full-width | full-size-kana",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-transform"
                }
            ],
            "description": "Controls capitalization effects of an element’s text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "max-height",
            "values": [
                {
                    "name": "none",
                    "description": "No limit on the height of the box."
                },
                {
                    "name": "fit-content",
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "<viewport-length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/max-height"
                }
            ],
            "description": "Allows authors to constrain content height to a certain range.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "list-style",
            "values": [
                {
                    "name": "armenian"
                },
                {
                    "name": "circle",
                    "description": "A hollow circle."
                },
                {
                    "name": "decimal"
                },
                {
                    "name": "decimal-leading-zero"
                },
                {
                    "name": "disc",
                    "description": "A filled circle."
                },
                {
                    "name": "georgian"
                },
                {
                    "name": "inside",
                    "description": "The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."
                },
                {
                    "name": "lower-alpha"
                },
                {
                    "name": "lower-greek"
                },
                {
                    "name": "lower-latin"
                },
                {
                    "name": "lower-roman"
                },
                {
                    "name": "none"
                },
                {
                    "name": "outside",
                    "description": "The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."
                },
                {
                    "name": "square",
                    "description": "A filled square."
                },
                {
                    "name": "symbols()",
                    "description": "Allows a counter style to be defined inline."
                },
                {
                    "name": "upper-alpha"
                },
                {
                    "name": "upper-latin"
                },
                {
                    "name": "upper-roman"
                },
                {
                    "name": "url()"
                }
            ],
            "syntax": "<'list-style-type'> || <'list-style-position'> || <'list-style-image'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/list-style"
                }
            ],
            "description": "Shorthand for setting 'list-style-type', 'list-style-position' and 'list-style-image'",
            "restrictions": [
                "image",
                "enum",
                "url"
            ]
        },
        {
            "name": "font-style",
            "values": [
                {
                    "name": "italic",
                    "description": "Selects a font that is labeled as an 'italic' face, or an 'oblique' face if one is not"
                },
                {
                    "name": "normal",
                    "description": "Selects a face that is classified as 'normal'."
                },
                {
                    "name": "oblique",
                    "description": "Selects a font that is labeled as an 'oblique' face, or an 'italic' face if one is not."
                }
            ],
            "syntax": "normal | italic | oblique <angle>{0,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-style"
                }
            ],
            "description": "Allows italic or oblique faces to be selected. Italic forms are generally cursive in nature while oblique faces are typically sloped versions of the regular face.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font",
            "values": [
                {
                    "name": "100",
                    "description": "Thin"
                },
                {
                    "name": "200",
                    "description": "Extra Light (Ultra Light)"
                },
                {
                    "name": "300",
                    "description": "Light"
                },
                {
                    "name": "400",
                    "description": "Normal"
                },
                {
                    "name": "500",
                    "description": "Medium"
                },
                {
                    "name": "600",
                    "description": "Semi Bold (Demi Bold)"
                },
                {
                    "name": "700",
                    "description": "Bold"
                },
                {
                    "name": "800",
                    "description": "Extra Bold (Ultra Bold)"
                },
                {
                    "name": "900",
                    "description": "Black (Heavy)"
                },
                {
                    "name": "bold",
                    "description": "Same as 700"
                },
                {
                    "name": "bolder",
                    "description": "Specifies the weight of the face bolder than the inherited value."
                },
                {
                    "name": "caption",
                    "description": "The font used for captioned controls (e.g., buttons, drop-downs, etc.)."
                },
                {
                    "name": "icon",
                    "description": "The font used to label icons."
                },
                {
                    "name": "italic",
                    "description": "Selects a font that is labeled 'italic', or, if that is not available, one labeled 'oblique'."
                },
                {
                    "name": "large"
                },
                {
                    "name": "larger"
                },
                {
                    "name": "lighter",
                    "description": "Specifies the weight of the face lighter than the inherited value."
                },
                {
                    "name": "medium"
                },
                {
                    "name": "menu",
                    "description": "The font used in menus (e.g., dropdown menus and menu lists)."
                },
                {
                    "name": "message-box",
                    "description": "The font used in dialog boxes."
                },
                {
                    "name": "normal",
                    "description": "Specifies a face that is not labeled as a small-caps font."
                },
                {
                    "name": "oblique",
                    "description": "Selects a font that is labeled 'oblique'."
                },
                {
                    "name": "small"
                },
                {
                    "name": "small-caps",
                    "description": "Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."
                },
                {
                    "name": "small-caption",
                    "description": "The font used for labeling small controls."
                },
                {
                    "name": "smaller"
                },
                {
                    "name": "status-bar",
                    "description": "The font used in window status bars."
                },
                {
                    "name": "x-large"
                },
                {
                    "name": "x-small"
                },
                {
                    "name": "xx-large"
                },
                {
                    "name": "xx-small"
                }
            ],
            "syntax": "[ [ <'font-style'> || <font-variant-css21> || <'font-weight'> || <'font-stretch'> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'> ] | caption | icon | menu | message-box | small-caption | status-bar",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font"
                }
            ],
            "description": "Shorthand property for setting 'font-style', 'font-variant', 'font-weight', 'font-size', 'line-height', and 'font-family', at the same place in the style sheet. The syntax of this property is based on a traditional typographical shorthand notation to set multiple properties related to fonts.",
            "restrictions": [
                "font"
            ]
        },
        {
            "name": "text-overflow",
            "values": [
                {
                    "name": "clip",
                    "description": "Clip inline content that overflows. Characters may be only partially rendered."
                },
                {
                    "name": "ellipsis",
                    "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
                }
            ],
            "syntax": "[ clip | ellipsis | <string> ]{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-overflow"
                }
            ],
            "description": "Text can overflow for example when it is prevented from wrapping.",
            "restrictions": [
                "enum",
                "string"
            ]
        },
        {
            "name": "border-left",
            "syntax": "<line-width> || <line-style> || <color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-left"
                }
            ],
            "description": "Shorthand property for setting border width, style and color",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-right",
            "syntax": "<line-width> || <line-style> || <color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-right"
                }
            ],
            "description": "Shorthand property for setting border width, style and color",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-width",
            "values": [],
            "syntax": "<line-width>{1,4}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-width"
                }
            ],
            "description": "Shorthand that sets the four 'border-*-width' properties. If it has four values, they set top, right, bottom and left in that order. If left is missing, it is the same as right; if bottom is missing, it is the same as top; if right is missing, it is the same as top.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "justify-content",
            "values": [
                {
                    "name": "center",
                    "description": "Flex items are packed toward the center of the line."
                },
                {
                    "name": "start",
                    "description": "The items are packed flush to each other toward the start edge of the alignment container in the main axis."
                },
                {
                    "name": "end",
                    "description": "The items are packed flush to each other toward the end edge of the alignment container in the main axis."
                },
                {
                    "name": "left",
                    "description": "The items are packed flush to each other toward the left edge of the alignment container in the main axis."
                },
                {
                    "name": "right",
                    "description": "The items are packed flush to each other toward the right edge of the alignment container in the main axis."
                },
                {
                    "name": "safe",
                    "description": "If the size of the item overflows the alignment container, the item is instead aligned as if the alignment mode were start."
                },
                {
                    "name": "unsafe",
                    "description": "Regardless of the relative sizes of the item and alignment container, the given alignment value is honored."
                },
                {
                    "name": "stretch",
                    "description": "If the combined size of the alignment subjects is less than the size of the alignment container, any auto-sized alignment subjects have their size increased equally (not proportionally), while still respecting the constraints imposed by max-height/max-width (or equivalent functionality), so that the combined size exactly fills the alignment container."
                },
                {
                    "name": "space-evenly",
                    "description": "The items are evenly distributed within the alignment container along the main axis."
                },
                {
                    "name": "flex-end",
                    "description": "Flex items are packed toward the end of the line."
                },
                {
                    "name": "flex-start",
                    "description": "Flex items are packed toward the start of the line."
                },
                {
                    "name": "space-around",
                    "description": "Flex items are evenly distributed in the line, with half-size spaces on either end."
                },
                {
                    "name": "space-between",
                    "description": "Flex items are evenly distributed in the line."
                },
                {
                    "name": "baseline",
                    "description": "Specifies participation in first-baseline alignment."
                },
                {
                    "name": "first baseline",
                    "description": "Specifies participation in first-baseline alignment."
                },
                {
                    "name": "last baseline",
                    "description": "Specifies participation in last-baseline alignment."
                }
            ],
            "syntax": "normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ]",
            "description": "Aligns flex items along the main axis of the current line of the flex container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "align-items",
            "values": [
                {
                    "name": "baseline",
                    "description": "If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
                },
                {
                    "name": "center",
                    "description": "The flex item’s margin box is centered in the cross axis within the line."
                },
                {
                    "name": "flex-end",
                    "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
                },
                {
                    "name": "flex-start",
                    "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                }
            ],
            "syntax": "normal | stretch | <baseline-position> | [ <overflow-position>? <self-position> ]",
            "description": "Aligns flex items along the cross axis of the current line of the flex container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "overflow-y",
            "values": [
                {
                    "name": "auto",
                    "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
                },
                {
                    "name": "hidden",
                    "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
                },
                {
                    "name": "scroll",
                    "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
                },
                {
                    "name": "visible",
                    "description": "Content is not clipped, i.e., it may be rendered outside the content box."
                }
            ],
            "syntax": "visible | hidden | clip | scroll | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/overflow-y"
                }
            ],
            "description": "Specifies the handling of overflow in the vertical direction.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "pointer-events",
            "values": [
                {
                    "name": "all",
                    "description": "The given element can be the target element for pointer events whenever the pointer is over either the interior or the perimeter of the element."
                },
                {
                    "name": "fill",
                    "description": "The given element can be the target element for pointer events whenever the pointer is over the interior of the element."
                },
                {
                    "name": "none",
                    "description": "The given element does not receive pointer events."
                },
                {
                    "name": "painted",
                    "description": "The given element can be the target element for pointer events when the pointer is over a \"painted\" area. "
                },
                {
                    "name": "stroke",
                    "description": "The given element can be the target element for pointer events whenever the pointer is over the perimeter of the element."
                },
                {
                    "name": "visible",
                    "description": "The given element can be the target element for pointer events when the ‘visibility’ property is set to visible and the pointer is over either the interior or the perimete of the element."
                },
                {
                    "name": "visibleFill",
                    "description": "The given element can be the target element for pointer events when the ‘visibility’ property is set to visible and when the pointer is over the interior of the element."
                },
                {
                    "name": "visiblePainted",
                    "description": "The given element can be the target element for pointer events when the ‘visibility’ property is set to visible and when the pointer is over a ‘painted’ area."
                },
                {
                    "name": "visibleStroke",
                    "description": "The given element can be the target element for pointer events when the ‘visibility’ property is set to visible and when the pointer is over the perimeter of the element."
                }
            ],
            "syntax": "auto | none | visiblePainted | visibleFill | visibleStroke | visible | painted | fill | stroke | all | inherit",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/pointer-events"
                }
            ],
            "description": "Specifies under what circumstances a given element can be the target element for a pointer event.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "letter-spacing",
            "values": [
                {
                    "name": "normal",
                    "description": "The spacing is the normal spacing for the current font. It is typically zero-length."
                }
            ],
            "syntax": "normal | <length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/letter-spacing"
                }
            ],
            "description": "Specifies the minimum, maximum, and optimal spacing between grapheme clusters.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "border-style",
            "values": [],
            "syntax": "<line-style>{1,4}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-style"
                }
            ],
            "description": "The style of the border around edges of an element.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "animation",
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "backwards",
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                },
                {
                    "name": "none",
                    "description": "No animation is performed"
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "syntax": "<single-animation>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation"
                }
            ],
            "description": "Shorthand property combines six of the animation properties into a single property.",
            "restrictions": [
                "time",
                "timing-function",
                "enum",
                "identifier",
                "number"
            ]
        },
        {
            "name": "overflow-x",
            "values": [
                {
                    "name": "auto",
                    "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
                },
                {
                    "name": "hidden",
                    "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
                },
                {
                    "name": "scroll",
                    "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
                },
                {
                    "name": "visible",
                    "description": "Content is not clipped, i.e., it may be rendered outside the content box."
                }
            ],
            "syntax": "visible | hidden | clip | scroll | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/overflow-x"
                }
            ],
            "description": "Specifies the handling of overflow in the horizontal direction.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "word-wrap",
            "values": [
                {
                    "name": "break-word",
                    "description": "An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."
                },
                {
                    "name": "normal",
                    "description": "Lines may break only at allowed break points."
                }
            ],
            "syntax": "normal | break-word",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/overflow-wrap"
                }
            ],
            "description": "Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-collapse",
            "values": [
                {
                    "name": "collapse",
                    "description": "Selects the collapsing borders model."
                },
                {
                    "name": "separate",
                    "description": "Selects the separated borders border model."
                }
            ],
            "syntax": "collapse | separate",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-collapse"
                }
            ],
            "description": "Selects a table's border model.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "flex-direction",
            "values": [
                {
                    "name": "column",
                    "description": "The flex container’s main axis has the same orientation as the block axis of the current writing mode."
                },
                {
                    "name": "column-reverse",
                    "description": "Same as 'column', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "row",
                    "description": "The flex container’s main axis has the same orientation as the inline axis of the current writing mode."
                },
                {
                    "name": "row-reverse",
                    "description": "Same as 'row', except the main-start and main-end directions are swapped."
                }
            ],
            "syntax": "row | row-reverse | column | column-reverse",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/flex-direction"
                }
            ],
            "description": "Specifies how flex items are placed in the flex container, by setting the direction of the flex container’s main axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "zoom",
            "browsers": [
                "E12",
                "S3.1",
                "C1",
                "IE5.5",
                "O15"
            ],
            "values": [
                {
                    "name": "normal"
                }
            ],
            "syntax": "auto | <number> | <percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/zoom"
                }
            ],
            "description": "Non-standard. Specifies the magnification scale of the object. See 'transform: scale()' for a standards-based alternative.",
            "restrictions": [
                "enum",
                "integer",
                "number",
                "percentage"
            ]
        },
        {
            "name": "flex",
            "values": [
                {
                    "name": "auto",
                    "description": "Retrieves the value of the main size property as the used 'flex-basis'."
                },
                {
                    "name": "content",
                    "description": "Indicates automatic sizing, based on the flex item’s content."
                },
                {
                    "name": "none",
                    "description": "Expands to '0 0 auto'."
                }
            ],
            "syntax": "none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/flex"
                }
            ],
            "description": "Specifies the components of a flexible length: the flex grow factor and flex shrink factor, and the flex basis.",
            "restrictions": [
                "length",
                "number",
                "percentage"
            ]
        },
        {
            "name": "text-shadow",
            "values": [
                {
                    "name": "none",
                    "description": "No shadow."
                }
            ],
            "syntax": "none | <shadow-t>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-shadow"
                }
            ],
            "description": "Enables shadow effects to be applied to the text of the element.",
            "restrictions": [
                "length",
                "color"
            ]
        },
        {
            "name": "list-style-type",
            "values": [
                {
                    "name": "armenian",
                    "description": "Traditional uppercase Armenian numbering."
                },
                {
                    "name": "circle",
                    "description": "A hollow circle."
                },
                {
                    "name": "decimal",
                    "description": "Western decimal numbers."
                },
                {
                    "name": "decimal-leading-zero",
                    "description": "Decimal numbers padded by initial zeros."
                },
                {
                    "name": "disc",
                    "description": "A filled circle."
                },
                {
                    "name": "georgian",
                    "description": "Traditional Georgian numbering."
                },
                {
                    "name": "lower-alpha",
                    "description": "Lowercase ASCII letters."
                },
                {
                    "name": "lower-greek",
                    "description": "Lowercase classical Greek."
                },
                {
                    "name": "lower-latin",
                    "description": "Lowercase ASCII letters."
                },
                {
                    "name": "lower-roman",
                    "description": "Lowercase ASCII Roman numerals."
                },
                {
                    "name": "none",
                    "description": "No marker"
                },
                {
                    "name": "square",
                    "description": "A filled square."
                },
                {
                    "name": "symbols()",
                    "description": "Allows a counter style to be defined inline."
                },
                {
                    "name": "upper-alpha",
                    "description": "Uppercase ASCII letters."
                },
                {
                    "name": "upper-latin",
                    "description": "Uppercase ASCII letters."
                },
                {
                    "name": "upper-roman",
                    "description": "Uppercase ASCII Roman numerals."
                }
            ],
            "syntax": "<counter-style> | <string> | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/list-style-type"
                }
            ],
            "description": "Used to construct the default contents of a list item’s marker",
            "restrictions": [
                "enum",
                "string"
            ]
        },
        {
            "name": "border-bottom-left-radius",
            "syntax": "<length-percentage>{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius"
                }
            ],
            "description": "Defines the radii of the bottom left outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "user-select",
            "values": [
                {
                    "name": "all",
                    "description": "The content of the element must be selected atomically"
                },
                {
                    "name": "auto"
                },
                {
                    "name": "contain",
                    "description": "UAs must not allow a selection which is started in this element to be extended outside of this element."
                },
                {
                    "name": "none",
                    "description": "The UA must not allow selections to be started in this element."
                },
                {
                    "name": "text",
                    "description": "The element imposes no constraint on the selection."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | text | none | contain | all",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/user-select"
                }
            ],
            "description": "Controls the appearance of selection.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "fill",
            "values": [
                {
                    "name": "url()",
                    "description": "A URL reference to a paint server element, which is an element that defines a paint server: ‘hatch’, ‘linearGradient’, ‘mesh’, ‘pattern’, ‘radialGradient’ and ‘solidcolor’."
                },
                {
                    "name": "none",
                    "description": "No paint is applied in this layer."
                }
            ],
            "description": "Paints the interior of the given graphical element.",
            "restrictions": [
                "color",
                "enum",
                "url"
            ]
        },
        {
            "name": "transform-origin",
            "syntax": "[ <length-percentage> | left | center | right | top | bottom ] | [ [ <length-percentage> | left | center | right ] && [ <length-percentage> | top | center | bottom ] ] <length>?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transform-origin"
                }
            ],
            "description": "Establishes the origin of transformation for an element.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-top-left-radius",
            "syntax": "<length-percentage>{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius"
                }
            ],
            "description": "Defines the radii of the top left outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "text-indent",
            "values": [],
            "syntax": "<length-percentage> && hanging? && each-line?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-indent"
                }
            ],
            "description": "Specifies the indentation applied to lines of inline content in a block. The indentation only affects the first line of inline content in the block unless the 'hanging' keyword is specified, in which case it affects all lines except the first.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "border-bottom-right-radius",
            "syntax": "<length-percentage>{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius"
                }
            ],
            "description": "Defines the radii of the bottom right outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "flex-wrap",
            "values": [
                {
                    "name": "nowrap",
                    "description": "The flex container is single-line."
                },
                {
                    "name": "wrap",
                    "description": "The flexbox is multi-line."
                },
                {
                    "name": "wrap-reverse",
                    "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
                }
            ],
            "syntax": "nowrap | wrap | wrap-reverse",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/flex-wrap"
                }
            ],
            "description": "Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-spacing",
            "syntax": "<length> <length>?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-spacing"
                }
            ],
            "description": "The lengths specify the distance that separates adjoining cell borders. If one length is specified, it gives both the horizontal and vertical spacing. If two are specified, the first gives the horizontal spacing and the second the vertical spacing. Lengths may not be negative.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "border-top-right-radius",
            "syntax": "<length-percentage>{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius"
                }
            ],
            "description": "Defines the radii of the top right outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "clip",
            "values": [
                {
                    "name": "auto",
                    "description": "The element does not clip."
                },
                {
                    "name": "rect()",
                    "description": "Specifies offsets from the edges of the border box."
                }
            ],
            "syntax": "<shape> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/clip"
                }
            ],
            "description": "Deprecated. Use the 'clip-path' property when support allows. Defines the visible portion of an element’s box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-top-color",
            "syntax": "<color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-color"
                }
            ],
            "description": "Sets the color of the top border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "word-break",
            "values": [
                {
                    "name": "break-all",
                    "description": "Lines may break between any two grapheme clusters for non-CJK scripts."
                },
                {
                    "name": "keep-all",
                    "description": "Block characters can no longer create implied break points."
                },
                {
                    "name": "normal",
                    "description": "Breaks non-CJK scripts according to their own rules."
                }
            ],
            "syntax": "normal | break-all | keep-all | break-word",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/word-break"
                }
            ],
            "description": "Specifies line break opportunities for non-CJK scripts.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-bottom-color",
            "syntax": "<'border-top-color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-color"
                }
            ],
            "description": "Sets the color of the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "flex-grow",
            "syntax": "<number>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/flex-grow"
                }
            ],
            "description": "Sets the flex grow factor. Negative numbers are invalid.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "direction",
            "values": [
                {
                    "name": "ltr",
                    "description": "Left-to-right direction."
                },
                {
                    "name": "rtl",
                    "description": "Right-to-left direction."
                }
            ],
            "syntax": "ltr | rtl",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/direction"
                }
            ],
            "description": "Specifies the inline base direction or directionality of any bidi paragraph, embedding, isolate, or override established by the box. Note: for HTML content use the 'dir' attribute and 'bdo' element rather than this property.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "align-self",
            "values": [
                {
                    "name": "auto",
                    "description": "Computes to the value of 'align-items' on the element’s parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."
                },
                {
                    "name": "baseline",
                    "description": "If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
                },
                {
                    "name": "center",
                    "description": "The flex item’s margin box is centered in the cross axis within the line."
                },
                {
                    "name": "flex-end",
                    "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
                },
                {
                    "name": "flex-start",
                    "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                }
            ],
            "syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? <self-position>",
            "description": "Allows the default alignment along the cross axis to be overridden for individual flex items.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "flex-shrink",
            "syntax": "<number>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/flex-shrink"
                }
            ],
            "description": "Sets the flex shrink factor. Negative numbers are invalid.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "text-rendering",
            "browsers": [
                "FF1",
                "S5",
                "C4",
                "O15"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "geometricPrecision",
                    "description": "Indicates that the user agent shall emphasize geometric precision over legibility and rendering speed."
                },
                {
                    "name": "optimizeLegibility",
                    "description": "Indicates that the user agent shall emphasize legibility over rendering speed and geometric precision."
                },
                {
                    "name": "optimizeSpeed",
                    "description": "Indicates that the user agent shall emphasize rendering speed over legibility and geometric precision."
                }
            ],
            "syntax": "auto | optimizeSpeed | optimizeLegibility | geometricPrecision",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-rendering"
                }
            ],
            "description": "The creator of SVG content might want to provide a hint to the implementation about what tradeoffs to make as it renders text. The ‘text-rendering’ property provides these hints.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "touch-action",
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent may determine any permitted touch behaviors for touches that begin on the element."
                },
                {
                    "name": "cross-slide-x"
                },
                {
                    "name": "cross-slide-y"
                },
                {
                    "name": "double-tap-zoom"
                },
                {
                    "name": "manipulation",
                    "description": "The user agent may consider touches that begin on the element only for the purposes of scrolling and continuous zooming."
                },
                {
                    "name": "none",
                    "description": "Touches that begin on the element must not trigger default touch behaviors."
                },
                {
                    "name": "pan-x",
                    "description": "The user agent may consider touches that begin on the element only for the purposes of horizontally scrolling the element’s nearest ancestor with horizontally scrollable content."
                },
                {
                    "name": "pan-y",
                    "description": "The user agent may consider touches that begin on the element only for the purposes of vertically scrolling the element’s nearest ancestor with vertically scrollable content."
                },
                {
                    "name": "pinch-zoom"
                }
            ],
            "syntax": "auto | none | [ [ pan-x | pan-left | pan-right ] || [ pan-y | pan-up | pan-down ] || pinch-zoom ] | manipulation",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/touch-action"
                }
            ],
            "description": "Determines whether touch input may trigger default behavior supplied by user agent.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "background-clip",
            "syntax": "<box>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-clip"
                }
            ],
            "description": "Determines the background painting area.",
            "restrictions": [
                "box"
            ]
        },
        {
            "name": "filter",
            "browsers": [
                "E12",
                "FF35",
                "S9.1",
                "C53",
                "O40"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No filter effects are applied."
                },
                {
                    "name": "blur()",
                    "description": "Applies a Gaussian blur to the input image."
                },
                {
                    "name": "brightness()",
                    "description": "Applies a linear multiplier to input image, making it appear more or less bright."
                },
                {
                    "name": "contrast()",
                    "description": "Adjusts the contrast of the input."
                },
                {
                    "name": "drop-shadow()",
                    "description": "Applies a drop shadow effect to the input image."
                },
                {
                    "name": "grayscale()",
                    "description": "Converts the input image to grayscale."
                },
                {
                    "name": "hue-rotate()",
                    "description": "Applies a hue rotation on the input image. "
                },
                {
                    "name": "invert()",
                    "description": "Inverts the samples in the input image."
                },
                {
                    "name": "opacity()",
                    "description": "Applies transparency to the samples in the input image."
                },
                {
                    "name": "saturate()",
                    "description": "Saturates the input image."
                },
                {
                    "name": "sepia()",
                    "description": "Converts the input image to sepia."
                },
                {
                    "name": "url()",
                    "browsers": [
                        "E12",
                        "FF35",
                        "S9.1",
                        "C53",
                        "O40"
                    ],
                    "description": "A filter reference to a <filter> element."
                }
            ],
            "syntax": "none | <filter-function-list>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/filter"
                }
            ],
            "description": "Processes an element’s rendering before it is displayed in the document, by applying one or more filter effects.",
            "restrictions": [
                "enum",
                "url"
            ]
        },
        {
            "name": "src",
            "values": [
                {
                    "name": "url()",
                    "description": "Reference font by URL"
                },
                {
                    "name": "format()",
                    "description": "Optional hint describing the format of the font resource."
                },
                {
                    "name": "local()",
                    "description": "Format-specific string that identifies a locally available copy of a given font."
                }
            ],
            "syntax": "[ <url> [ format( <string># ) ]? | local( <family-name> ) ]#",
            "description": "@font-face descriptor. Specifies the resource containing font data. It is required, whether the font is downloadable or locally installed.",
            "restrictions": [
                "enum",
                "url",
                "identifier"
            ]
        },
        {
            "name": "animation-timing-function",
            "syntax": "<timing-function>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation-timing-function"
                }
            ],
            "description": "Describes how the animation will progress over one cycle of its duration.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "border-right-color",
            "syntax": "<color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-right-color"
                }
            ],
            "description": "Sets the color of the right border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "font-variant",
            "values": [
                {
                    "name": "normal",
                    "description": "Specifies a face that is not labeled as a small-caps font."
                },
                {
                    "name": "small-caps",
                    "description": "Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."
                }
            ],
            "syntax": "normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> || stylistic(<feature-value-name>) || historical-forms || styleset(<feature-value-name>#) || character-variant(<feature-value-name>#) || swash(<feature-value-name>) || ornaments(<feature-value-name>) || annotation(<feature-value-name>) || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero || <east-asian-variant-values> || <east-asian-width-values> || ruby ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant"
                }
            ],
            "description": "Specifies variant representations of the font",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-left-color",
            "syntax": "<color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-left-color"
                }
            ],
            "description": "Sets the color of the left border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "animation-name",
            "values": [
                {
                    "name": "none",
                    "description": "No animation is performed"
                }
            ],
            "syntax": "[ none | <keyframes-name> ]#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation-name"
                }
            ],
            "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
            "restrictions": [
                "identifier",
                "enum"
            ]
        },
        {
            "name": "animation-duration",
            "syntax": "<time>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation-duration"
                }
            ],
            "description": "Defines the length of time that an animation takes to complete one cycle.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "will-change",
            "browsers": [
                "FF36",
                "S9.1",
                "C36",
                "O24"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Expresses no particular intent."
                },
                {
                    "name": "contents",
                    "description": "Indicates that the author expects to animate or change something about the element’s contents in the near future."
                },
                {
                    "name": "scroll-position",
                    "description": "Indicates that the author expects to animate or change the scroll position of the element in the near future."
                }
            ],
            "syntax": "auto | <animateable-feature>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/will-change"
                }
            ],
            "description": "Provides a rendering hint to the user agent, stating what kinds of changes the author expects to perform on the element.",
            "restrictions": [
                "enum",
                "identifier"
            ]
        },
        {
            "name": "stroke",
            "values": [
                {
                    "name": "url()",
                    "description": "A URL reference to a paint server element, which is an element that defines a paint server: ‘hatch’, ‘linearGradient’, ‘mesh’, ‘pattern’, ‘radialGradient’ and ‘solidcolor’."
                },
                {
                    "name": "none",
                    "description": "No paint is applied in this layer."
                }
            ],
            "description": "Paints along the outline of the given graphical element.",
            "restrictions": [
                "color",
                "enum",
                "url"
            ]
        },
        {
            "name": "transition-property",
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "syntax": "none | <single-transition-property>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transition-property"
                }
            ],
            "description": "Specifies the name of the CSS property to which the transition is applied.",
            "restrictions": [
                "property"
            ]
        },
        {
            "name": "table-layout",
            "values": [
                {
                    "name": "auto",
                    "description": "Use any automatic table layout algorithm."
                },
                {
                    "name": "fixed",
                    "description": "Use the fixed table layout algorithm."
                }
            ],
            "syntax": "auto | fixed",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/table-layout"
                }
            ],
            "description": "Controls the algorithm used to lay out the table cells, rows, and columns.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "transition-delay",
            "syntax": "<time>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transition-delay"
                }
            ],
            "description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "flex-basis",
            "values": [
                {
                    "name": "auto",
                    "description": "Retrieves the value of the main size property as the used 'flex-basis'."
                },
                {
                    "name": "content",
                    "description": "Indicates automatic sizing, based on the flex item’s content."
                }
            ],
            "syntax": "content | <'width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/flex-basis"
                }
            ],
            "description": "Sets the flex basis.",
            "restrictions": [
                "length",
                "number",
                "percentage"
            ]
        },
        {
            "name": "overflow-wrap",
            "values": [
                {
                    "name": "break-word",
                    "description": "An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."
                },
                {
                    "name": "normal",
                    "description": "Lines may break only at allowed break points."
                }
            ],
            "syntax": "normal | break-word | anywhere",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/overflow-wrap"
                }
            ],
            "description": "Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit within the line box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-top-width",
            "syntax": "<line-width>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-width"
                }
            ],
            "description": "Sets the thickness of the top border.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "outline-width",
            "syntax": "<line-width>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/outline-width"
                }
            ],
            "description": "Width of the outline.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "order",
            "syntax": "<integer>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/order"
                }
            ],
            "description": "Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "border-bottom-width",
            "syntax": "<line-width>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-width"
                }
            ],
            "description": "Sets the thickness of the bottom border.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "animation-fill-mode",
            "values": [
                {
                    "name": "backwards",
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "none",
                    "description": "There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."
                }
            ],
            "syntax": "<single-animation-fill-mode>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode"
                }
            ],
            "description": "Defines what values are applied by the animation outside the time it is executing.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "outline-style",
            "values": [
                {
                    "name": "auto",
                    "description": "Permits the user agent to render a custom outline style, typically the default platform style."
                }
            ],
            "syntax": "auto | <'border-style'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/outline-style"
                }
            ],
            "description": "Style of the outline.",
            "restrictions": [
                "line-style",
                "enum"
            ]
        },
        {
            "name": "object-fit",
            "browsers": [
                "E16",
                "FF36",
                "S10",
                "C31",
                "O19"
            ],
            "values": [
                {
                    "name": "contain",
                    "description": "The replaced content is sized to maintain its aspect ratio while fitting within the element’s content box: its concrete object size is resolved as a contain constraint against the element's used width and height."
                },
                {
                    "name": "cover",
                    "description": "The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element’s used width and height."
                },
                {
                    "name": "fill",
                    "description": "The replaced content is sized to fill the element’s content box: the object's concrete object size is the element's used width and height."
                },
                {
                    "name": "none",
                    "description": "The replaced content is not resized to fit inside the element's content box"
                },
                {
                    "name": "scale-down",
                    "description": "Size the content as if ‘none’ or ‘contain’ were specified, whichever would result in a smaller concrete object size."
                }
            ],
            "syntax": "fill | contain | cover | none | scale-down",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/object-fit"
                }
            ],
            "description": "Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "stroke-width",
            "description": "Specifies the width of the stroke on the current object.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "transition-duration",
            "syntax": "<time>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transition-duration"
                }
            ],
            "description": "Specifies how long the transition from the old value to the new value should take.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "animation-delay",
            "syntax": "<time>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation-delay"
                }
            ],
            "description": "Defines when the animation will start.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "outline-offset",
            "browsers": [
                "E15",
                "FF1.5",
                "S1.2",
                "C1",
                "O9.5"
            ],
            "syntax": "<length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/outline-offset"
                }
            ],
            "description": "Offset the outline and draw it beyond the border edge.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "stroke-dashoffset",
            "description": "Specifies the distance into the dash pattern to start the dash.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "backface-visibility",
            "values": [
                {
                    "name": "hidden",
                    "description": "Back side is hidden."
                },
                {
                    "name": "visible",
                    "description": "Back side is visible."
                }
            ],
            "syntax": "visible | hidden",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/backface-visibility"
                }
            ],
            "description": "Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-right-width",
            "syntax": "<line-width>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-right-width"
                }
            ],
            "description": "Sets the thickness of the right border.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "flex-flow",
            "values": [
                {
                    "name": "column",
                    "description": "The flex container’s main axis has the same orientation as the block axis of the current writing mode."
                },
                {
                    "name": "column-reverse",
                    "description": "Same as 'column', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "nowrap",
                    "description": "The flex container is single-line."
                },
                {
                    "name": "row",
                    "description": "The flex container’s main axis has the same orientation as the inline axis of the current writing mode."
                },
                {
                    "name": "row-reverse",
                    "description": "Same as 'row', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "wrap",
                    "description": "The flexbox is multi-line."
                },
                {
                    "name": "wrap-reverse",
                    "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
                }
            ],
            "syntax": "<'flex-direction'> || <'flex-wrap'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/flex-flow"
                }
            ],
            "description": "Specifies how flexbox items are placed in the flexbox.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "word-spacing",
            "values": [
                {
                    "name": "normal",
                    "description": "No additional spacing is applied. Computes to zero."
                }
            ],
            "syntax": "normal | <length-percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/word-spacing"
                }
            ],
            "description": "Specifies additional spacing between “words”.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "transition-timing-function",
            "syntax": "<timing-function>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transition-timing-function"
                }
            ],
            "description": "Describes how the intermediate values used during a transition will be calculated.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "resize",
            "browsers": [
                "FF4",
                "S3",
                "C1",
                "O12.1"
            ],
            "values": [
                {
                    "name": "both",
                    "description": "The UA presents a bidirectional resizing mechanism to allow the user to adjust both the height and the width of the element."
                },
                {
                    "name": "horizontal",
                    "description": "The UA presents a unidirectional horizontal resizing mechanism to allow the user to adjust only the width of the element."
                },
                {
                    "name": "none",
                    "description": "The UA does not present a resizing mechanism on the element, and the user is given no direct manipulation mechanism to resize the element."
                },
                {
                    "name": "vertical",
                    "description": "The UA presents a unidirectional vertical resizing mechanism to allow the user to adjust only the height of the element."
                }
            ],
            "syntax": "none | both | horizontal | vertical | block | inline",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/resize"
                }
            ],
            "description": "Specifies whether or not an element is resizable by the user, and if so, along which axis/axes.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "unicode-bidi",
            "values": [
                {
                    "name": "bidi-override",
                    "description": "Inside the element, reordering is strictly in sequence according to the 'direction' property; the implicit part of the bidirectional algorithm is ignored."
                },
                {
                    "name": "embed",
                    "description": "If the element is inline-level, this value opens an additional level of embedding with respect to the bidirectional algorithm. The direction of this embedding level is given by the 'direction' property."
                },
                {
                    "name": "isolate",
                    "description": "The contents of the element are considered to be inside a separate, independent paragraph."
                },
                {
                    "name": "isolate-override",
                    "description": "This combines the isolation behavior of 'isolate' with the directional override behavior of 'bidi-override'"
                },
                {
                    "name": "normal",
                    "description": "The element does not open an additional level of embedding with respect to the bidirectional algorithm. For inline-level elements, implicit reordering works across element boundaries."
                },
                {
                    "name": "plaintext",
                    "description": "For the purposes of the Unicode bidirectional algorithm, the base directionality of each bidi paragraph for which the element forms the containing block is determined not by the element's computed 'direction'."
                }
            ],
            "syntax": "normal | embed | isolate | bidi-override | isolate-override | plaintext",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/unicode-bidi"
                }
            ],
            "description": "The level of embedding with respect to the bidirectional algorithm.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "unicode-range",
            "values": [
                {
                    "name": "U+26",
                    "description": "Ampersand."
                },
                {
                    "name": "U+20-24F, U+2B0-2FF, U+370-4FF, U+1E00-1EFF, U+2000-20CF, U+2100-23FF, U+2500-26FF, U+E000-F8FF, U+FB00–FB4F",
                    "description": "WGL4 character set (Pan-European)."
                },
                {
                    "name": "U+20-17F, U+2B0-2FF, U+2000-206F, U+20A0-20CF, U+2100-21FF, U+2600-26FF",
                    "description": "The Multilingual European Subset No. 1. Latin. Covers ~44 languages."
                },
                {
                    "name": "U+20-2FF, U+370-4FF, U+1E00-20CF, U+2100-23FF, U+2500-26FF, U+FB00-FB4F, U+FFF0-FFFD",
                    "description": "The Multilingual European Subset No. 2. Latin, Greek, and Cyrillic. Covers ~128 language."
                },
                {
                    "name": "U+20-4FF, U+530-58F, U+10D0-10FF, U+1E00-23FF, U+2440-245F, U+2500-26FF, U+FB00-FB4F, U+FE20-FE2F, U+FFF0-FFFD",
                    "description": "The Multilingual European Subset No. 3. Covers all characters belonging to European scripts."
                },
                {
                    "name": "U+00-7F",
                    "description": "Basic Latin (ASCII)."
                },
                {
                    "name": "U+80-FF",
                    "description": "Latin-1 Supplement. Accented characters for Western European languages, common punctuation characters, multiplication and division signs."
                },
                {
                    "name": "U+100-17F",
                    "description": "Latin Extended-A. Accented characters for for Czech, Dutch, Polish, and Turkish."
                },
                {
                    "name": "U+180-24F",
                    "description": "Latin Extended-B. Croatian, Slovenian, Romanian, Non-European and historic latin, Khoisan, Pinyin, Livonian, Sinology."
                },
                {
                    "name": "U+1E00-1EFF",
                    "description": "Latin Extended Additional. Vietnamese, German captial sharp s, Medievalist, Latin general use."
                },
                {
                    "name": "U+250-2AF",
                    "description": "International Phonetic Alphabet Extensions."
                },
                {
                    "name": "U+370-3FF",
                    "description": "Greek and Coptic."
                },
                {
                    "name": "U+1F00-1FFF",
                    "description": "Greek Extended. Accented characters for polytonic Greek."
                },
                {
                    "name": "U+400-4FF",
                    "description": "Cyrillic."
                },
                {
                    "name": "U+500-52F",
                    "description": "Cyrillic Supplement. Extra letters for Komi, Khanty, Chukchi, Mordvin, Kurdish, Aleut, Chuvash, Abkhaz, Azerbaijani, and Orok."
                },
                {
                    "name": "U+00-52F, U+1E00-1FFF, U+2200–22FF",
                    "description": "Latin, Greek, Cyrillic, some punctuation and symbols."
                },
                {
                    "name": "U+530–58F",
                    "description": "Armenian."
                },
                {
                    "name": "U+590–5FF",
                    "description": "Hebrew."
                },
                {
                    "name": "U+600–6FF",
                    "description": "Arabic."
                },
                {
                    "name": "U+750–77F",
                    "description": "Arabic Supplement. Additional letters for African languages, Khowar, Torwali, Burushaski, and early Persian."
                },
                {
                    "name": "U+8A0–8FF",
                    "description": "Arabic Extended-A. Additional letters for African languages, European and Central Asian languages, Rohingya, Tamazight, Arwi, and Koranic annotation signs."
                },
                {
                    "name": "U+700–74F",
                    "description": "Syriac."
                },
                {
                    "name": "U+900–97F",
                    "description": "Devanagari."
                },
                {
                    "name": "U+980–9FF",
                    "description": "Bengali."
                },
                {
                    "name": "U+A00–A7F",
                    "description": "Gurmukhi."
                },
                {
                    "name": "U+A80–AFF",
                    "description": "Gujarati."
                },
                {
                    "name": "U+B00–B7F",
                    "description": "Oriya."
                },
                {
                    "name": "U+B80–BFF",
                    "description": "Tamil."
                },
                {
                    "name": "U+C00–C7F",
                    "description": "Telugu."
                },
                {
                    "name": "U+C80–CFF",
                    "description": "Kannada."
                },
                {
                    "name": "U+D00–D7F",
                    "description": "Malayalam."
                },
                {
                    "name": "U+D80–DFF",
                    "description": "Sinhala."
                },
                {
                    "name": "U+118A0–118FF",
                    "description": "Warang Citi."
                },
                {
                    "name": "U+E00–E7F",
                    "description": "Thai."
                },
                {
                    "name": "U+1A20–1AAF",
                    "description": "Tai Tham."
                },
                {
                    "name": "U+AA80–AADF",
                    "description": "Tai Viet."
                },
                {
                    "name": "U+E80–EFF",
                    "description": "Lao."
                },
                {
                    "name": "U+F00–FFF",
                    "description": "Tibetan."
                },
                {
                    "name": "U+1000–109F",
                    "description": "Myanmar (Burmese)."
                },
                {
                    "name": "U+10A0–10FF",
                    "description": "Georgian."
                },
                {
                    "name": "U+1200–137F",
                    "description": "Ethiopic."
                },
                {
                    "name": "U+1380–139F",
                    "description": "Ethiopic Supplement. Extra Syllables for Sebatbeit, and Tonal marks"
                },
                {
                    "name": "U+2D80–2DDF",
                    "description": "Ethiopic Extended. Extra Syllables for Me'en, Blin, and Sebatbeit."
                },
                {
                    "name": "U+AB00–AB2F",
                    "description": "Ethiopic Extended-A. Extra characters for Gamo-Gofa-Dawro, Basketo, and Gumuz."
                },
                {
                    "name": "U+1780–17FF",
                    "description": "Khmer."
                },
                {
                    "name": "U+1800–18AF",
                    "description": "Mongolian."
                },
                {
                    "name": "U+1B80–1BBF",
                    "description": "Sundanese."
                },
                {
                    "name": "U+1CC0–1CCF",
                    "description": "Sundanese Supplement. Punctuation."
                },
                {
                    "name": "U+4E00–9FD5",
                    "description": "CJK (Chinese, Japanese, Korean) Unified Ideographs. Most common ideographs for modern Chinese and Japanese."
                },
                {
                    "name": "U+3400–4DB5",
                    "description": "CJK Unified Ideographs Extension A. Rare ideographs."
                },
                {
                    "name": "U+2F00–2FDF",
                    "description": "Kangxi Radicals."
                },
                {
                    "name": "U+2E80–2EFF",
                    "description": "CJK Radicals Supplement. Alternative forms of Kangxi Radicals."
                },
                {
                    "name": "U+1100–11FF",
                    "description": "Hangul Jamo."
                },
                {
                    "name": "U+AC00–D7AF",
                    "description": "Hangul Syllables."
                },
                {
                    "name": "U+3040–309F",
                    "description": "Hiragana."
                },
                {
                    "name": "U+30A0–30FF",
                    "description": "Katakana."
                },
                {
                    "name": "U+A5, U+4E00-9FFF, U+30??, U+FF00-FF9F",
                    "description": "Japanese Kanji, Hiragana and Katakana characters plus Yen/Yuan symbol."
                },
                {
                    "name": "U+A4D0–A4FF",
                    "description": "Lisu."
                },
                {
                    "name": "U+A000–A48F",
                    "description": "Yi Syllables."
                },
                {
                    "name": "U+A490–A4CF",
                    "description": "Yi Radicals."
                },
                {
                    "name": "U+2000-206F",
                    "description": "General Punctuation."
                },
                {
                    "name": "U+3000–303F",
                    "description": "CJK Symbols and Punctuation."
                },
                {
                    "name": "U+2070–209F",
                    "description": "Superscripts and Subscripts."
                },
                {
                    "name": "U+20A0–20CF",
                    "description": "Currency Symbols."
                },
                {
                    "name": "U+2100–214F",
                    "description": "Letterlike Symbols."
                },
                {
                    "name": "U+2150–218F",
                    "description": "Number Forms."
                },
                {
                    "name": "U+2190–21FF",
                    "description": "Arrows."
                },
                {
                    "name": "U+2200–22FF",
                    "description": "Mathematical Operators."
                },
                {
                    "name": "U+2300–23FF",
                    "description": "Miscellaneous Technical."
                },
                {
                    "name": "U+E000-F8FF",
                    "description": "Private Use Area."
                },
                {
                    "name": "U+FB00–FB4F",
                    "description": "Alphabetic Presentation Forms. Ligatures for latin, Armenian, and Hebrew."
                },
                {
                    "name": "U+FB50–FDFF",
                    "description": "Arabic Presentation Forms-A. Contextual forms / ligatures for Persian, Urdu, Sindhi, Central Asian languages, etc, Arabic pedagogical symbols, word ligatures."
                },
                {
                    "name": "U+1F600–1F64F",
                    "description": "Emoji: Emoticons."
                },
                {
                    "name": "U+2600–26FF",
                    "description": "Emoji: Miscellaneous Symbols."
                },
                {
                    "name": "U+1F300–1F5FF",
                    "description": "Emoji: Miscellaneous Symbols and Pictographs."
                },
                {
                    "name": "U+1F900–1F9FF",
                    "description": "Emoji: Supplemental Symbols and Pictographs."
                },
                {
                    "name": "U+1F680–1F6FF",
                    "description": "Emoji: Transport and Map Symbols."
                }
            ],
            "syntax": "<unicode-range>#",
            "description": "@font-face descriptor. Defines the set of Unicode codepoints that may be supported by the font face for which it is declared.",
            "restrictions": [
                "unicode-range"
            ]
        },
        {
            "name": "stroke-dasharray",
            "values": [
                {
                    "name": "none",
                    "description": "Indicates that no dashing is used."
                }
            ],
            "description": "Controls the pattern of dashes and gaps used to stroke paths.",
            "restrictions": [
                "length",
                "percentage",
                "number",
                "enum"
            ]
        },
        {
            "name": "animation-iteration-count",
            "values": [
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                }
            ],
            "syntax": "<single-animation-iteration-count>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count"
                }
            ],
            "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
            "restrictions": [
                "number",
                "enum"
            ]
        },
        {
            "name": "image-rendering",
            "browsers": [
                "FF3.6",
                "S6",
                "C13",
                "O15"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The image should be scaled with an algorithm that maximizes the appearance of the image."
                },
                {
                    "name": "crisp-edges",
                    "description": "The image must be scaled with an algorithm that preserves contrast and edges in the image, and which does not smooth colors or introduce blur to the image in the process."
                },
                {
                    "name": "-moz-crisp-edges",
                    "browsers": [
                        "FF3.6",
                        "S6",
                        "C13",
                        "O15"
                    ]
                },
                {
                    "name": "optimizeQuality",
                    "description": "Deprecated."
                },
                {
                    "name": "optimizeSpeed",
                    "description": "Deprecated."
                },
                {
                    "name": "pixelated",
                    "description": "When scaling the image up, the 'nearest neighbor' or similar algorithm must be used, so that the image appears to be simply composed of very large pixels."
                }
            ],
            "syntax": "auto | crisp-edges | pixelated",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/image-rendering"
                }
            ],
            "description": "Provides a hint to the user-agent about what aspects of an image are most important to preserve when the image is scaled, to aid the user-agent in the choice of an appropriate scaling algorithm.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-left-width",
            "syntax": "<line-width>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-left-width"
                }
            ],
            "description": "Sets the thickness of the left border.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "align-content",
            "values": [
                {
                    "name": "center",
                    "description": "Lines are packed toward the center of the flex container."
                },
                {
                    "name": "flex-end",
                    "description": "Lines are packed toward the end of the flex container."
                },
                {
                    "name": "flex-start",
                    "description": "Lines are packed toward the start of the flex container."
                },
                {
                    "name": "space-around",
                    "description": "Lines are evenly distributed in the flex container, with half-size spaces on either end."
                },
                {
                    "name": "space-between",
                    "description": "Lines are evenly distributed in the flex container."
                },
                {
                    "name": "stretch",
                    "description": "Lines stretch to take up the remaining space."
                }
            ],
            "syntax": "normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position>",
            "description": "Aligns a flex container’s lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-bottom-style",
            "syntax": "<line-style>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-style"
                }
            ],
            "description": "Sets the style of the bottom border.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "perspective",
            "values": [
                {
                    "name": "none",
                    "description": "No perspective transform is applied."
                }
            ],
            "syntax": "none | <length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/perspective"
                }
            ],
            "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
            "restrictions": [
                "length",
                "enum"
            ]
        },
        {
            "name": "border-top-style",
            "syntax": "<line-style>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-style"
                }
            ],
            "description": "Sets the style of the top border.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "text-size-adjust",
            "status": "experimental",
            "syntax": "none | auto | <percentage>",
            "browsers": [
                "E12",
                "C54",
                "O41"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-size-adjust"
                }
            ],
            "description": "The text-size-adjust CSS property controls the text inflation algorithm used on some smartphones and tablets. Other browsers will ignore this property."
        },
        {
            "name": "transform-style",
            "browsers": [
                "E12",
                "FF16",
                "S9",
                "C36",
                "O15"
            ],
            "values": [
                {
                    "name": "flat",
                    "description": "All children of this element are rendered flattened into the 2D plane of the element."
                },
                {
                    "name": "preserve-3d",
                    "browsers": [
                        "E12",
                        "FF16",
                        "S9",
                        "C36",
                        "O15"
                    ],
                    "description": "Flattening is not performed, so children maintain their position in 3D space."
                }
            ],
            "syntax": "flat | preserve-3d",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transform-style"
                }
            ],
            "description": "Defines how nested elements are rendered in 3D space.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-template-columns",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "There is no explicit grid; any rows/columns will be implicitly generated."
                },
                {
                    "name": "min-content",
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "subgrid",
                    "description": "Indicates that the grid will align to its parent grid in that axis."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                },
                {
                    "name": "repeat()",
                    "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
                }
            ],
            "syntax": "none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-template-columns"
                }
            ],
            "description": "specifies, as a space-separated track list, the line names and track sizing functions of the grid.",
            "restrictions": [
                "identifier",
                "length",
                "percentage",
                "enum"
            ]
        },
        {
            "name": "list-style-position",
            "values": [
                {
                    "name": "inside",
                    "description": "The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."
                },
                {
                    "name": "outside",
                    "description": "The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."
                }
            ],
            "syntax": "inside | outside",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/list-style-position"
                }
            ],
            "description": "Specifies the position of the '::marker' pseudo-element's box in the list item.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "animation-direction",
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "syntax": "<single-animation-direction>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation-direction"
                }
            ],
            "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "animation-play-state",
            "values": [
                {
                    "name": "paused",
                    "description": "A running animation will be paused."
                },
                {
                    "name": "running",
                    "description": "Resume playback of a paused animation."
                }
            ],
            "syntax": "<single-animation-play-state>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/animation-play-state"
                }
            ],
            "description": "Defines whether the animation is running or paused.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "hyphens",
            "values": [
                {
                    "name": "auto",
                    "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
                },
                {
                    "name": "manual",
                    "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
                },
                {
                    "name": "none",
                    "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
                }
            ],
            "syntax": "none | manual | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/hyphens"
                }
            ],
            "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "quotes",
            "values": [
                {
                    "name": "none",
                    "description": "The 'open-quote' and 'close-quote' values of the 'content' property produce no quotations marks, as if they were 'no-open-quote' and 'no-close-quote' respectively."
                }
            ],
            "syntax": "none | auto | [ <string> <string> ]+",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/quotes"
                }
            ],
            "description": "Specifies quotation marks for any number of embedded quotations.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "background-origin",
            "syntax": "<box>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-origin"
                }
            ],
            "description": "For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",
            "restrictions": [
                "box"
            ]
        },
        {
            "name": "background-attachment",
            "values": [
                {
                    "name": "fixed",
                    "description": "The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."
                },
                {
                    "name": "local",
                    "description": "The background is fixed with regard to the element’s contents: if the element has a scrolling mechanism, the background scrolls with the element’s contents."
                },
                {
                    "name": "scroll",
                    "description": "The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element’s border.)"
                }
            ],
            "syntax": "<attachment>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-attachment"
                }
            ],
            "description": "Specifies whether the background images are fixed with regard to the viewport ('fixed') or scroll along with the element ('scroll') or its contents ('local').",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "background-position-x",
            "values": [
                {
                    "name": "center",
                    "description": "Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."
                },
                {
                    "name": "left",
                    "description": "Equivalent to '0%' for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset."
                },
                {
                    "name": "right",
                    "description": "Equivalent to '100%' for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset."
                }
            ],
            "status": "experimental",
            "syntax": "[ center | [ left | right | x-start | x-end ]? <length-percentage>? ]#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-position-x"
                }
            ],
            "description": "If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "background-position-y",
            "values": [
                {
                    "name": "bottom",
                    "description": "Equivalent to '100%' for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset."
                },
                {
                    "name": "center",
                    "description": "Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."
                },
                {
                    "name": "top",
                    "description": "Equivalent to '0%' for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."
                }
            ],
            "status": "experimental",
            "syntax": "[ center | [ top | bottom | y-start | y-end ]? <length-percentage>? ]#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-position-y"
                }
            ],
            "description": "If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "font-feature-settings",
            "values": [
                {
                    "name": "\"aalt\"",
                    "description": "Access All Alternates."
                },
                {
                    "name": "\"abvf\"",
                    "description": "Above-base Forms. Required in Khmer script."
                },
                {
                    "name": "\"abvm\"",
                    "description": "Above-base Mark Positioning. Required in Indic scripts."
                },
                {
                    "name": "\"abvs\"",
                    "description": "Above-base Substitutions. Required in Indic scripts."
                },
                {
                    "name": "\"afrc\"",
                    "description": "Alternative Fractions."
                },
                {
                    "name": "\"akhn\"",
                    "description": "Akhand. Required in most Indic scripts."
                },
                {
                    "name": "\"blwf\"",
                    "description": "Below-base Form. Required in a number of Indic scripts."
                },
                {
                    "name": "\"blwm\"",
                    "description": "Below-base Mark Positioning. Required in Indic scripts."
                },
                {
                    "name": "\"blws\"",
                    "description": "Below-base Substitutions. Required in Indic scripts."
                },
                {
                    "name": "\"calt\"",
                    "description": "Contextual Alternates."
                },
                {
                    "name": "\"case\"",
                    "description": "Case-Sensitive Forms. Applies only to European scripts; particularly prominent in Spanish-language setting."
                },
                {
                    "name": "\"ccmp\"",
                    "description": "Glyph Composition/Decomposition."
                },
                {
                    "name": "\"cfar\"",
                    "description": "Conjunct Form After Ro. Required in Khmer scripts."
                },
                {
                    "name": "\"cjct\"",
                    "description": "Conjunct Forms. Required in Indic scripts that show similarity to Devanagari."
                },
                {
                    "name": "\"clig\"",
                    "description": "Contextual Ligatures."
                },
                {
                    "name": "\"cpct\"",
                    "description": "Centered CJK Punctuation. Used primarily in Chinese fonts."
                },
                {
                    "name": "\"cpsp\"",
                    "description": "Capital Spacing. Should not be used in connecting scripts (e.g. most Arabic)."
                },
                {
                    "name": "\"cswh\"",
                    "description": "Contextual Swash."
                },
                {
                    "name": "\"curs\"",
                    "description": "Cursive Positioning. Can be used in any cursive script."
                },
                {
                    "name": "\"c2pc\"",
                    "description": "Petite Capitals From Capitals. Applies only to bicameral scripts."
                },
                {
                    "name": "\"c2sc\"",
                    "description": "Small Capitals From Capitals. Applies only to bicameral scripts."
                },
                {
                    "name": "\"dist\"",
                    "description": "Distances. Required in Indic scripts."
                },
                {
                    "name": "\"dlig\"",
                    "description": "Discretionary ligatures."
                },
                {
                    "name": "\"dnom\"",
                    "description": "Denominators."
                },
                {
                    "name": "\"dtls\"",
                    "description": "Dotless Forms. Applied to math formula layout."
                },
                {
                    "name": "\"expt\"",
                    "description": "Expert Forms. Applies only to Japanese."
                },
                {
                    "name": "\"falt\"",
                    "description": "Final Glyph on Line Alternates. Can be used in any cursive script."
                },
                {
                    "name": "\"fin2\"",
                    "description": "Terminal Form #2. Used only with the Syriac script."
                },
                {
                    "name": "\"fin3\"",
                    "description": "Terminal Form #3. Used only with the Syriac script."
                },
                {
                    "name": "\"fina\"",
                    "description": "Terminal Forms. Can be used in any alphabetic script."
                },
                {
                    "name": "\"flac\"",
                    "description": "Flattened ascent forms. Applied to math formula layout."
                },
                {
                    "name": "\"frac\"",
                    "description": "Fractions."
                },
                {
                    "name": "\"fwid\"",
                    "description": "Full Widths. Applies to any script which can use monospaced forms."
                },
                {
                    "name": "\"half\"",
                    "description": "Half Forms. Required in Indic scripts that show similarity to Devanagari."
                },
                {
                    "name": "\"haln\"",
                    "description": "Halant Forms. Required in Indic scripts."
                },
                {
                    "name": "\"halt\"",
                    "description": "Alternate Half Widths. Used only in CJKV fonts."
                },
                {
                    "name": "\"hist\"",
                    "description": "Historical Forms."
                },
                {
                    "name": "\"hkna\"",
                    "description": "Horizontal Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."
                },
                {
                    "name": "\"hlig\"",
                    "description": "Historical Ligatures."
                },
                {
                    "name": "\"hngl\"",
                    "description": "Hangul. Korean only."
                },
                {
                    "name": "\"hojo\"",
                    "description": "Hojo Kanji Forms (JIS X 0212-1990 Kanji Forms). Used only with Kanji script."
                },
                {
                    "name": "\"hwid\"",
                    "description": "Half Widths. Generally used only in CJKV fonts."
                },
                {
                    "name": "\"init\"",
                    "description": "Initial Forms. Can be used in any alphabetic script."
                },
                {
                    "name": "\"isol\"",
                    "description": "Isolated Forms. Can be used in any cursive script."
                },
                {
                    "name": "\"ital\"",
                    "description": "Italics. Applies mostly to Latin; note that many non-Latin fonts contain Latin as well."
                },
                {
                    "name": "\"jalt\"",
                    "description": "Justification Alternates. Can be used in any cursive script."
                },
                {
                    "name": "\"jp78\"",
                    "description": "JIS78 Forms. Applies only to Japanese."
                },
                {
                    "name": "\"jp83\"",
                    "description": "JIS83 Forms. Applies only to Japanese."
                },
                {
                    "name": "\"jp90\"",
                    "description": "JIS90 Forms. Applies only to Japanese."
                },
                {
                    "name": "\"jp04\"",
                    "description": "JIS2004 Forms. Applies only to Japanese."
                },
                {
                    "name": "\"kern\"",
                    "description": "Kerning."
                },
                {
                    "name": "\"lfbd\"",
                    "description": "Left Bounds."
                },
                {
                    "name": "\"liga\"",
                    "description": "Standard Ligatures."
                },
                {
                    "name": "\"ljmo\"",
                    "description": "Leading Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
                },
                {
                    "name": "\"lnum\"",
                    "description": "Lining Figures."
                },
                {
                    "name": "\"locl\"",
                    "description": "Localized Forms."
                },
                {
                    "name": "\"ltra\"",
                    "description": "Left-to-right glyph alternates."
                },
                {
                    "name": "\"ltrm\"",
                    "description": "Left-to-right mirrored forms."
                },
                {
                    "name": "\"mark\"",
                    "description": "Mark Positioning."
                },
                {
                    "name": "\"med2\"",
                    "description": "Medial Form #2. Used only with the Syriac script."
                },
                {
                    "name": "\"medi\"",
                    "description": "Medial Forms."
                },
                {
                    "name": "\"mgrk\"",
                    "description": "Mathematical Greek."
                },
                {
                    "name": "\"mkmk\"",
                    "description": "Mark to Mark Positioning."
                },
                {
                    "name": "\"nalt\"",
                    "description": "Alternate Annotation Forms."
                },
                {
                    "name": "\"nlck\"",
                    "description": "NLC Kanji Forms. Used only with Kanji script."
                },
                {
                    "name": "\"nukt\"",
                    "description": "Nukta Forms. Required in Indic scripts.."
                },
                {
                    "name": "\"numr\"",
                    "description": "Numerators."
                },
                {
                    "name": "\"onum\"",
                    "description": "Oldstyle Figures."
                },
                {
                    "name": "\"opbd\"",
                    "description": "Optical Bounds."
                },
                {
                    "name": "\"ordn\"",
                    "description": "Ordinals. Applies mostly to Latin script."
                },
                {
                    "name": "\"ornm\"",
                    "description": "Ornaments."
                },
                {
                    "name": "\"palt\"",
                    "description": "Proportional Alternate Widths. Used mostly in CJKV fonts."
                },
                {
                    "name": "\"pcap\"",
                    "description": "Petite Capitals."
                },
                {
                    "name": "\"pkna\"",
                    "description": "Proportional Kana. Generally used only in Japanese fonts."
                },
                {
                    "name": "\"pnum\"",
                    "description": "Proportional Figures."
                },
                {
                    "name": "\"pref\"",
                    "description": "Pre-base Forms. Required in Khmer and Myanmar (Burmese) scripts and southern Indic scripts that may display a pre-base form of Ra."
                },
                {
                    "name": "\"pres\"",
                    "description": "Pre-base Substitutions. Required in Indic scripts."
                },
                {
                    "name": "\"pstf\"",
                    "description": "Post-base Forms. Required in scripts of south and southeast Asia that have post-base forms for consonants eg: Gurmukhi, Malayalam, Khmer."
                },
                {
                    "name": "\"psts\"",
                    "description": "Post-base Substitutions."
                },
                {
                    "name": "\"pwid\"",
                    "description": "Proportional Widths."
                },
                {
                    "name": "\"qwid\"",
                    "description": "Quarter Widths. Generally used only in CJKV fonts."
                },
                {
                    "name": "\"rand\"",
                    "description": "Randomize."
                },
                {
                    "name": "\"rclt\"",
                    "description": "Required Contextual Alternates. May apply to any script, but is especially important for many styles of Arabic."
                },
                {
                    "name": "\"rlig\"",
                    "description": "Required Ligatures. Applies to Arabic and Syriac. May apply to some other scripts."
                },
                {
                    "name": "\"rkrf\"",
                    "description": "Rakar Forms. Required in Devanagari and Gujarati scripts."
                },
                {
                    "name": "\"rphf\"",
                    "description": "Reph Form. Required in Indic scripts. E.g. Devanagari, Kannada."
                },
                {
                    "name": "\"rtbd\"",
                    "description": "Right Bounds."
                },
                {
                    "name": "\"rtla\"",
                    "description": "Right-to-left alternates."
                },
                {
                    "name": "\"rtlm\"",
                    "description": "Right-to-left mirrored forms."
                },
                {
                    "name": "\"ruby\"",
                    "description": "Ruby Notation Forms. Applies only to Japanese."
                },
                {
                    "name": "\"salt\"",
                    "description": "Stylistic Alternates."
                },
                {
                    "name": "\"sinf\"",
                    "description": "Scientific Inferiors."
                },
                {
                    "name": "\"size\"",
                    "description": "Optical size."
                },
                {
                    "name": "\"smcp\"",
                    "description": "Small Capitals. Applies only to bicameral scripts."
                },
                {
                    "name": "\"smpl\"",
                    "description": "Simplified Forms. Applies only to Chinese and Japanese."
                },
                {
                    "name": "\"ssty\"",
                    "description": "Math script style alternates."
                },
                {
                    "name": "\"stch\"",
                    "description": "Stretching Glyph Decomposition."
                },
                {
                    "name": "\"subs\"",
                    "description": "Subscript."
                },
                {
                    "name": "\"sups\"",
                    "description": "Superscript."
                },
                {
                    "name": "\"swsh\"",
                    "description": "Swash. Does not apply to ideographic scripts."
                },
                {
                    "name": "\"titl\"",
                    "description": "Titling."
                },
                {
                    "name": "\"tjmo\"",
                    "description": "Trailing Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
                },
                {
                    "name": "\"tnam\"",
                    "description": "Traditional Name Forms. Applies only to Japanese."
                },
                {
                    "name": "\"tnum\"",
                    "description": "Tabular Figures."
                },
                {
                    "name": "\"trad\"",
                    "description": "Traditional Forms. Applies only to Chinese and Japanese."
                },
                {
                    "name": "\"twid\"",
                    "description": "Third Widths. Generally used only in CJKV fonts."
                },
                {
                    "name": "\"unic\"",
                    "description": "Unicase."
                },
                {
                    "name": "\"valt\"",
                    "description": "Alternate Vertical Metrics. Applies only to scripts with vertical writing modes."
                },
                {
                    "name": "\"vatu\"",
                    "description": "Vattu Variants. Used for Indic scripts. E.g. Devanagari."
                },
                {
                    "name": "\"vert\"",
                    "description": "Vertical Alternates. Applies only to scripts with vertical writing modes."
                },
                {
                    "name": "\"vhal\"",
                    "description": "Alternate Vertical Half Metrics. Used only in CJKV fonts."
                },
                {
                    "name": "\"vjmo\"",
                    "description": "Vowel Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
                },
                {
                    "name": "\"vkna\"",
                    "description": "Vertical Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."
                },
                {
                    "name": "\"vkrn\"",
                    "description": "Vertical Kerning."
                },
                {
                    "name": "\"vpal\"",
                    "description": "Proportional Alternate Vertical Metrics. Used mostly in CJKV fonts."
                },
                {
                    "name": "\"vrt2\"",
                    "description": "Vertical Alternates and Rotation. Applies only to scripts with vertical writing modes."
                },
                {
                    "name": "\"zero\"",
                    "description": "Slashed Zero."
                },
                {
                    "name": "normal",
                    "description": "No change in glyph substitution or positioning occurs."
                },
                {
                    "name": "off",
                    "description": "Disable feature."
                },
                {
                    "name": "on",
                    "description": "Enable feature."
                }
            ],
            "syntax": "normal | <feature-tag-value>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-feature-settings"
                }
            ],
            "description": "Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",
            "restrictions": [
                "string",
                "integer"
            ]
        },
        {
            "name": "border-left-style",
            "syntax": "<line-style>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-left-style"
                }
            ],
            "description": "Sets the style of the left border.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "font-stretch",
            "values": [
                {
                    "name": "condensed"
                },
                {
                    "name": "expanded"
                },
                {
                    "name": "extra-condensed"
                },
                {
                    "name": "extra-expanded"
                },
                {
                    "name": "narrower",
                    "description": "Indicates a narrower value relative to the width of the parent element."
                },
                {
                    "name": "normal"
                },
                {
                    "name": "semi-condensed"
                },
                {
                    "name": "semi-expanded"
                },
                {
                    "name": "ultra-condensed"
                },
                {
                    "name": "ultra-expanded"
                },
                {
                    "name": "wider",
                    "description": "Indicates a wider value relative to the width of the parent element."
                }
            ],
            "syntax": "<font-stretch-absolute>{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-stretch"
                }
            ],
            "description": "Selects a normal, condensed, or expanded face from a font family.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "outline-color",
            "values": [
                {
                    "name": "invert",
                    "description": "Performs a color inversion on the pixels on the screen."
                }
            ],
            "syntax": "<color> | invert",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/outline-color"
                }
            ],
            "description": "The color of the outline.",
            "restrictions": [
                "enum",
                "color"
            ]
        },
        {
            "name": "border-right-style",
            "syntax": "<line-style>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-right-style"
                }
            ],
            "description": "Sets the style of the right border.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "clip-path",
            "values": [
                {
                    "name": "none",
                    "description": "No clipping path gets created."
                },
                {
                    "name": "url()",
                    "description": "References a <clipPath> element to create a clipping path."
                }
            ],
            "syntax": "<clip-source> | [ <basic-shape> || <geometry-box> ] | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/clip-path"
                }
            ],
            "description": "Specifies a clipping path where everything inside the path is visible and everything outside is clipped out.",
            "restrictions": [
                "url",
                "shape",
                "geometry-box",
                "enum"
            ]
        },
        {
            "name": "list-style-image",
            "values": [
                {
                    "name": "none",
                    "description": "The default contents of the of the list item’s marker are given by 'list-style-type' instead."
                }
            ],
            "syntax": "<url> | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/list-style-image"
                }
            ],
            "description": "Sets the image that will be used as the list item marker. When the image is available, it will replace the marker set with the 'list-style-type' marker.",
            "restrictions": [
                "image"
            ]
        },
        {
            "name": "counter-increment",
            "values": [
                {
                    "name": "none",
                    "description": "This element does not alter the value of any counters."
                }
            ],
            "syntax": "[ <custom-ident> <integer>? ]+ | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/counter-increment"
                }
            ],
            "description": "Manipulate the value of existing counters.",
            "restrictions": [
                "identifier",
                "integer"
            ]
        },
        {
            "name": "counter-reset",
            "values": [
                {
                    "name": "none",
                    "description": "The counter is not modified."
                }
            ],
            "syntax": "[ <custom-ident> <integer>? ]+ | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/counter-reset"
                }
            ],
            "description": "Property accepts one or more names of counters (identifiers), each one optionally followed by an integer. The integer gives the value that the counter is set to on each occurrence of the element.",
            "restrictions": [
                "identifier",
                "integer"
            ]
        },
        {
            "name": "font-display",
            "status": "experimental",
            "syntax": "[ auto | block | swap | fallback | optional ]",
            "description": "The font-display descriptor determines how a font face is displayed based on whether and when it is downloaded and ready to use."
        },
        {
            "name": "border-image",
            "values": [
                {
                    "name": "auto",
                    "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
                },
                {
                    "name": "fill",
                    "description": "Causes the middle part of the border-image to be preserved."
                },
                {
                    "name": "none",
                    "description": "Use the border styles."
                },
                {
                    "name": "repeat",
                    "description": "The image is tiled (repeated) to fill the area."
                },
                {
                    "name": "round",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
                },
                {
                    "name": "space",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
                },
                {
                    "name": "stretch",
                    "description": "The image is stretched to fill the area."
                },
                {
                    "name": "url()"
                }
            ],
            "syntax": "<'border-image-source'> || <'border-image-slice'> [ / <'border-image-width'> | / <'border-image-width'>? / <'border-image-outset'> ]? || <'border-image-repeat'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-image"
                }
            ],
            "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "percentage",
                "number",
                "url",
                "enum"
            ]
        },
        {
            "name": "column-count",
            "values": [
                {
                    "name": "auto",
                    "description": "Determines the number of columns by the 'column-width' property and the element width."
                }
            ],
            "syntax": "<integer> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/column-count"
                }
            ],
            "description": "Describes the optimal number of columns into which the content of the element will be flowed.",
            "restrictions": [
                "integer",
                "enum"
            ]
        },
        {
            "name": "column-gap",
            "values": [
                {
                    "name": "normal",
                    "description": "User agent specific and typically equivalent to 1em."
                }
            ],
            "syntax": "normal | <length-percentage>",
            "description": "Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",
            "restrictions": [
                "length",
                "enum"
            ]
        },
        {
            "name": "text-decoration-color",
            "browsers": [
                "FF36",
                "S12.1",
                "C57",
                "O44"
            ],
            "syntax": "<color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration-color"
                }
            ],
            "description": "Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "all",
            "browsers": [
                "FF27",
                "S9.1",
                "C37",
                "O24"
            ],
            "values": [],
            "syntax": "initial | inherit | unset | revert",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/all"
                }
            ],
            "description": "Shorthand that resets all properties except 'direction' and 'unicode-bidi'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "object-position",
            "browsers": [
                "E16",
                "FF36",
                "S10",
                "C31",
                "O19"
            ],
            "syntax": "<position>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/object-position"
                }
            ],
            "description": "Determines the alignment of the replaced element inside its box.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "page-break-inside",
            "values": [
                {
                    "name": "auto",
                    "description": "Neither force nor forbid a page break inside the generated box."
                },
                {
                    "name": "avoid",
                    "description": "Avoid a page break inside the generated box."
                }
            ],
            "syntax": "auto | avoid",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/page-break-inside"
                }
            ],
            "description": "Defines rules for page breaks inside an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "stroke-linecap",
            "values": [
                {
                    "name": "butt",
                    "description": "Indicates that the stroke for each subpath does not extend beyond its two endpoints."
                },
                {
                    "name": "round",
                    "description": "Indicates that at each end of each subpath, the shape representing the stroke will be extended by a half circle with a radius equal to the stroke width."
                },
                {
                    "name": "square",
                    "description": "Indicates that at the end of each subpath, the shape representing the stroke will be extended by a rectangle with the same width as the stroke width and whose length is half of the stroke width."
                }
            ],
            "description": "Specifies the shape to be used at the end of open subpaths when they are stroked.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "size",
            "browsers": [
                "C",
                "O8"
            ],
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "empty-cells",
            "values": [
                {
                    "name": "hide",
                    "description": "No borders or backgrounds are drawn around/behind empty cells."
                },
                {
                    "name": "-moz-show-background"
                },
                {
                    "name": "show",
                    "description": "Borders and backgrounds are drawn around/behind empty cells (like normal cells)."
                }
            ],
            "syntax": "show | hide",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/empty-cells"
                }
            ],
            "description": "In the separated borders model, this property controls the rendering of borders and backgrounds around cells that have no visible content.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "page-break-after",
            "values": [
                {
                    "name": "always",
                    "description": "Always force a page break after the generated box."
                },
                {
                    "name": "auto",
                    "description": "Neither force nor forbid a page break after generated box."
                },
                {
                    "name": "avoid",
                    "description": "Avoid a page break after the generated box."
                },
                {
                    "name": "left",
                    "description": "Force one or two page breaks after the generated box so that the next page is formatted as a left page."
                },
                {
                    "name": "right",
                    "description": "Force one or two page breaks after the generated box so that the next page is formatted as a right page."
                }
            ],
            "syntax": "auto | always | avoid | left | right | recto | verso",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/page-break-after"
                }
            ],
            "description": "Defines rules for page breaks after an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "fill-opacity",
            "description": "Specifies the opacity of the painting operation used to paint the interior the current object.",
            "restrictions": [
                "number(0-1)"
            ]
        },
        {
            "name": "grid-gap",
            "browsers": [
                "FF52",
                "C57",
                "S10.1",
                "O44"
            ],
            "status": "obsolete",
            "syntax": "<'grid-row-gap'> <'grid-column-gap'>?",
            "description": "Shorthand that specifies the gutters between grid columns and grid rows in one declaration. Replaced by 'gap' property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "margin-block-end",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "<'margin-left'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-block-end"
                }
            ],
            "description": "Logical 'margin-bottom'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "contain",
            "browsers": [
                "FF69",
                "C52",
                "O40"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "Indicates that the property has no effect."
                },
                {
                    "name": "strict",
                    "description": "Turns on all forms of containment for the element."
                },
                {
                    "name": "content",
                    "description": "All containment rules except size are applied to the element."
                },
                {
                    "name": "size",
                    "description": "For properties that can have effects on more than just an element and its descendants, those effects don't escape the containing element."
                },
                {
                    "name": "layout",
                    "description": "Turns on layout containment for the element."
                },
                {
                    "name": "style",
                    "description": "Turns on style containment for the element."
                },
                {
                    "name": "paint",
                    "description": "Turns on paint containment for the element."
                }
            ],
            "status": "experimental",
            "syntax": "none | strict | content | [ size || layout || style || paint ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/contain"
                }
            ],
            "description": "Indicates that an element and its contents are, as much as possible, independent of the rest of the document tree.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "padding-inline-start",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'padding-left'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-inline-start"
                }
            ],
            "description": "Logical 'padding-left'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-inline-start",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "<'margin-left'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-inline-start"
                }
            ],
            "description": "Logical 'margin-left'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-inline-end",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "<'margin-left'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-inline-end"
                }
            ],
            "description": "Logical 'margin-right'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "grid-template-rows",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "There is no explicit grid; any rows/columns will be implicitly generated."
                },
                {
                    "name": "min-content",
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "subgrid",
                    "description": "Indicates that the grid will align to its parent grid in that axis."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                },
                {
                    "name": "repeat()",
                    "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
                }
            ],
            "syntax": "none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-template-rows"
                }
            ],
            "description": "specifies, as a space-separated track list, the line names and track sizing functions of the grid.",
            "restrictions": [
                "identifier",
                "length",
                "percentage",
                "string",
                "enum"
            ]
        },
        {
            "name": "padding-inline-end",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'padding-left'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-inline-end"
                }
            ],
            "description": "Logical 'padding-right'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "stroke-opacity",
            "description": "Specifies the opacity of the painting operation used to stroke the current object.",
            "restrictions": [
                "number(0-1)"
            ]
        },
        {
            "name": "orphans",
            "browsers": [
                "E12",
                "S1.3",
                "C25",
                "IE8",
                "O9.2"
            ],
            "syntax": "<integer>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/orphans"
                }
            ],
            "description": "Specifies the minimum number of line boxes in a block container that must be left in a fragment before a fragmentation break.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "shape-outside",
            "browsers": [
                "FF62",
                "S10.1",
                "C37",
                "O24"
            ],
            "values": [
                {
                    "name": "margin-box",
                    "description": "The background is painted within (clipped to) the margin box."
                },
                {
                    "name": "none",
                    "description": "The float area is unaffected."
                }
            ],
            "syntax": "none | <shape-box> || <basic-shape> | <image>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/shape-outside"
                }
            ],
            "description": "Specifies an orthogonal rotation to be applied to an image before it is laid out.",
            "restrictions": [
                "image",
                "box",
                "shape",
                "enum"
            ]
        },
        {
            "name": "caption-side",
            "values": [
                {
                    "name": "bottom",
                    "description": "Positions the caption box below the table box."
                },
                {
                    "name": "top",
                    "description": "Positions the caption box above the table box."
                }
            ],
            "syntax": "top | bottom | block-start | block-end | inline-start | inline-end",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/caption-side"
                }
            ],
            "description": "Specifies the position of the caption box with respect to the table box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "widows",
            "browsers": [
                "E12",
                "S1.3",
                "C25",
                "IE8",
                "O9.2"
            ],
            "syntax": "<integer>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/widows"
                }
            ],
            "description": "Specifies the minimum number of line boxes of a block container that must be left in a fragment after a break.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "grid-column",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line> [ / <grid-line> ]?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-column"
                }
            ],
            "description": "Shorthand for 'grid-column-start' and 'grid-column-end'.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "perspective-origin",
            "syntax": "<position>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/perspective-origin"
                }
            ],
            "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "column-width",
            "values": [
                {
                    "name": "auto",
                    "description": "The width depends on the values of other properties."
                }
            ],
            "syntax": "<length> | auto",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/column-width"
                }
            ],
            "description": "Describes the width of columns in multicol elements.",
            "restrictions": [
                "length",
                "enum"
            ]
        },
        {
            "name": "mix-blend-mode",
            "browsers": [
                "FF32",
                "S8",
                "C41",
                "O28"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "Default attribute which specifies no blending"
                },
                {
                    "name": "multiply",
                    "description": "The source color is multiplied by the destination color and replaces the destination."
                },
                {
                    "name": "screen",
                    "description": "Multiplies the complements of the backdrop and source color values, then complements the result."
                },
                {
                    "name": "overlay",
                    "description": "Multiplies or screens the colors, depending on the backdrop color value."
                },
                {
                    "name": "darken",
                    "description": "Selects the darker of the backdrop and source colors."
                },
                {
                    "name": "lighten",
                    "description": "Selects the lighter of the backdrop and source colors."
                },
                {
                    "name": "color-dodge",
                    "description": "Brightens the backdrop color to reflect the source color."
                },
                {
                    "name": "color-burn",
                    "description": "Darkens the backdrop color to reflect the source color."
                },
                {
                    "name": "hard-light",
                    "description": "Multiplies or screens the colors, depending on the source color value."
                },
                {
                    "name": "soft-light",
                    "description": "Darkens or lightens the colors, depending on the source color value."
                },
                {
                    "name": "difference",
                    "description": "Subtracts the darker of the two constituent colors from the lighter color.."
                },
                {
                    "name": "exclusion",
                    "description": "Produces an effect similar to that of the Difference mode but lower in contrast."
                },
                {
                    "name": "hue",
                    "browsers": [
                        "FF32",
                        "S8",
                        "C41",
                        "O28"
                    ],
                    "description": "Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."
                },
                {
                    "name": "saturation",
                    "browsers": [
                        "FF32",
                        "S8",
                        "C41",
                        "O28"
                    ],
                    "description": "Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."
                },
                {
                    "name": "color",
                    "browsers": [
                        "FF32",
                        "S8",
                        "C41",
                        "O28"
                    ],
                    "description": "Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."
                },
                {
                    "name": "luminosity",
                    "browsers": [
                        "FF32",
                        "S8",
                        "C41",
                        "O28"
                    ],
                    "description": "Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."
                }
            ],
            "syntax": "<blend-mode>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mix-blend-mode"
                }
            ],
            "description": "Defines the formula that must be used to mix the colors with the backdrop.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-auto-rows",
            "values": [
                {
                    "name": "min-content",
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                }
            ],
            "syntax": "<track-size>+",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-auto-rows"
                }
            ],
            "description": "Specifies the size of implicitly created rows.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "font-variant-ligatures",
            "browsers": [
                "FF34",
                "S9.1",
                "C34",
                "O21"
            ],
            "values": [
                {
                    "name": "additional-ligatures",
                    "description": "Enables display of additional ligatures."
                },
                {
                    "name": "common-ligatures",
                    "description": "Enables display of common ligatures."
                },
                {
                    "name": "contextual",
                    "browsers": [
                        "FF34",
                        "S9.1",
                        "C34",
                        "O21"
                    ],
                    "description": "Enables display of contextual alternates."
                },
                {
                    "name": "discretionary-ligatures",
                    "description": "Enables display of discretionary ligatures."
                },
                {
                    "name": "historical-ligatures",
                    "description": "Enables display of historical ligatures."
                },
                {
                    "name": "no-additional-ligatures",
                    "description": "Disables display of additional ligatures."
                },
                {
                    "name": "no-common-ligatures",
                    "description": "Disables display of common ligatures."
                },
                {
                    "name": "no-contextual",
                    "browsers": [
                        "FF34",
                        "S9.1",
                        "C34",
                        "O21"
                    ],
                    "description": "Disables display of contextual alternates."
                },
                {
                    "name": "no-discretionary-ligatures",
                    "description": "Disables display of discretionary ligatures."
                },
                {
                    "name": "no-historical-ligatures",
                    "description": "Disables display of historical ligatures."
                },
                {
                    "name": "none",
                    "browsers": [
                        "FF34",
                        "S9.1",
                        "C34",
                        "O21"
                    ],
                    "description": "Disables all ligatures."
                },
                {
                    "name": "normal",
                    "description": "Implies that the defaults set by the font are used."
                }
            ],
            "syntax": "normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-ligatures"
                }
            ],
            "description": "Specifies control over which ligatures are enabled or disabled. A value of ‘normal’ implies that the defaults set by the font are used.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scroll-behavior",
            "browsers": [
                "FF36",
                "C61",
                "O48"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Scrolls in an instant fashion."
                },
                {
                    "name": "smooth",
                    "description": "Scrolls in a smooth fashion using a user-agent-defined timing function and time period."
                }
            ],
            "syntax": "auto | smooth",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-behavior"
                }
            ],
            "description": "Specifies the scrolling behavior for a scrolling box, when scrolling happens due to navigation or CSSOM scrolling APIs.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-decoration-skip",
            "status": "experimental",
            "syntax": "none | [ objects || [ spaces | [ leading-spaces || trailing-spaces ] ] || edges || box-decoration ]",
            "browsers": [
                "S12.1",
                "C57",
                "O44"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip"
                }
            ],
            "description": "The text-decoration-skip CSS property specifies what parts of the element’s content any text decoration affecting the element must skip over. It controls all text decoration lines drawn by the element and also any text decoration lines drawn by its ancestors."
        },
        {
            "name": "columns",
            "values": [
                {
                    "name": "auto",
                    "description": "The width depends on the values of other properties."
                }
            ],
            "syntax": "<'column-width'> || <'column-count'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/columns"
                }
            ],
            "description": "A shorthand property which sets both 'column-width' and 'column-count'.",
            "restrictions": [
                "length",
                "integer",
                "enum"
            ]
        },
        {
            "name": "column-rule",
            "syntax": "<'column-rule-width'> || <'column-rule-style'> || <'column-rule-color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/column-rule"
                }
            ],
            "description": "Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "line-break",
            "values": [
                {
                    "name": "auto",
                    "description": "The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."
                },
                {
                    "name": "loose",
                    "description": "Breaks text using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."
                },
                {
                    "name": "normal",
                    "description": "Breaks text using the most common set of line-breaking rules."
                },
                {
                    "name": "strict",
                    "description": "Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."
                }
            ],
            "syntax": "auto | loose | normal | strict | anywhere",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/line-break"
                }
            ],
            "description": "Specifies what set of line breaking restrictions are in effect within the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-align-last",
            "browsers": [
                "E12",
                "FF49",
                "C47",
                "IE5.5",
                "O"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Content on the affected line is aligned per 'text-align' unless 'text-align' is set to 'justify', in which case it is 'start-aligned'."
                },
                {
                    "name": "center",
                    "description": "The inline contents are centered within the line box."
                },
                {
                    "name": "justify",
                    "description": "The text is justified according to the method specified by the 'text-justify' property."
                },
                {
                    "name": "left",
                    "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
                },
                {
                    "name": "right",
                    "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
                }
            ],
            "syntax": "auto | start | end | left | right | center | justify",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-align-last"
                }
            ],
            "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-image-width",
            "values": [
                {
                    "name": "auto",
                    "description": "The border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
                }
            ],
            "syntax": "[ <length-percentage> | <number> | auto ]{1,4}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-width"
                }
            ],
            "description": "The four values of 'border-image-width' specify offsets that are used to divide the border image area into nine parts. They represent inward distances from the top, right, bottom, and left sides of the area, respectively.",
            "restrictions": [
                "length",
                "percentage",
                "number"
            ]
        },
        {
            "name": "stroke-miterlimit",
            "description": "When two line segments meet at a sharp angle and miter joins have been specified for 'stroke-linejoin', it is possible for the miter to extend far beyond the thickness of the line stroking the path.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "border-image-repeat",
            "values": [
                {
                    "name": "repeat",
                    "description": "The image is tiled (repeated) to fill the area."
                },
                {
                    "name": "round",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
                },
                {
                    "name": "space",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
                },
                {
                    "name": "stretch",
                    "description": "The image is stretched to fill the area."
                }
            ],
            "syntax": "[ stretch | repeat | round | space ]{1,2}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-repeat"
                }
            ],
            "description": "Specifies how the images for the sides and the middle part of the border image are scaled and tiled. If the second keyword is absent, it is assumed to be the same as the first.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-column-gap",
            "browsers": [
                "FF52",
                "C57",
                "S10.1",
                "O44"
            ],
            "status": "obsolete",
            "syntax": "<length-percentage>",
            "description": "Specifies the gutters between grid columns. Replaced by 'column-gap' property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "border-image-slice",
            "values": [
                {
                    "name": "fill",
                    "description": "Causes the middle part of the border-image to be preserved."
                }
            ],
            "syntax": "<number-percentage>{1,4} && fill?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-slice"
                }
            ],
            "description": "Specifies inward offsets from the top, right, bottom, and left edges of the image, dividing it into nine regions: four corners, four edges and a middle.",
            "restrictions": [
                "number",
                "percentage"
            ]
        },
        {
            "name": "justify-self",
            "browsers": [
                "E16",
                "FF45",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "normal"
                },
                {
                    "name": "end"
                },
                {
                    "name": "start"
                },
                {
                    "name": "flex-end",
                    "description": "\"Flex items are packed toward the end of the line.\""
                },
                {
                    "name": "flex-start",
                    "description": "\"Flex items are packed toward the start of the line.\""
                },
                {
                    "name": "self-end",
                    "description": "The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."
                },
                {
                    "name": "self-start",
                    "description": "The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."
                },
                {
                    "name": "center",
                    "description": "The items are packed flush to each other toward the center of the of the alignment container."
                },
                {
                    "name": "left"
                },
                {
                    "name": "right"
                },
                {
                    "name": "baseline"
                },
                {
                    "name": "first baseline"
                },
                {
                    "name": "last baseline"
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                },
                {
                    "name": "save"
                },
                {
                    "name": "unsave"
                }
            ],
            "syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ]",
            "description": "Defines the way of justifying a box inside its container along the appropriate axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "fill-rule",
            "values": [
                {
                    "name": "evenodd",
                    "description": "Determines the ‘insideness’ of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."
                },
                {
                    "name": "nonzero",
                    "description": "Determines the ‘insideness’ of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."
                }
            ],
            "description": "Indicates the algorithm (or winding rule) which is to be used to determine what parts of the canvas are included inside the shape.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-image-outset",
            "syntax": "[ <length> | <number> ]{1,4}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-outset"
                }
            ],
            "description": "The values specify the amount by which the border image area extends beyond the border box on the top, right, bottom, and left sides respectively. If the fourth value is absent, it is the same as the second. If the third one is also absent, it is the same as the first. If the second one is also absent, it is the same as the first. Numbers represent multiples of the corresponding border-width.",
            "restrictions": [
                "length",
                "number"
            ]
        },
        {
            "name": "justify-items",
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "normal"
                },
                {
                    "name": "end"
                },
                {
                    "name": "start"
                },
                {
                    "name": "flex-end",
                    "description": "\"Flex items are packed toward the end of the line.\""
                },
                {
                    "name": "flex-start",
                    "description": "\"Flex items are packed toward the start of the line.\""
                },
                {
                    "name": "self-end",
                    "description": "The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."
                },
                {
                    "name": "self-start",
                    "description": "The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."
                },
                {
                    "name": "center",
                    "description": "The items are packed flush to each other toward the center of the of the alignment container."
                },
                {
                    "name": "left"
                },
                {
                    "name": "right"
                },
                {
                    "name": "baseline"
                },
                {
                    "name": "first baseline"
                },
                {
                    "name": "last baseline"
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                },
                {
                    "name": "save"
                },
                {
                    "name": "unsave"
                },
                {
                    "name": "legacy"
                }
            ],
            "syntax": "normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | legacy | legacy && [ left | right | center ]",
            "description": "Defines the default justify-self for all items of the box, giving them the default way of justifying each box along the appropriate axis",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "break-inside",
            "values": [
                {
                    "name": "auto",
                    "description": "Impose no additional breaking constraints within the box."
                },
                {
                    "name": "avoid",
                    "description": "Avoid breaks within the box."
                },
                {
                    "name": "avoid-column",
                    "description": "Avoid a column break within the box."
                },
                {
                    "name": "avoid-page",
                    "description": "Avoid a page break within the box."
                }
            ],
            "syntax": "auto | avoid | avoid-page | avoid-column | avoid-region",
            "description": "Describes the page/column/region break behavior inside the principal box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scroll-snap-type",
            "values": [
                {
                    "name": "none",
                    "description": "The visual viewport of this scroll container must ignore snap points, if any, when scrolled."
                },
                {
                    "name": "mandatory",
                    "description": "The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."
                },
                {
                    "name": "proximity",
                    "description": "The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."
                }
            ],
            "syntax": "none | [ x | y | block | inline | both ] [ mandatory | proximity ]?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type"
                }
            ],
            "description": "Defines how strictly snap points are enforced on the scroll container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-decoration-line",
            "browsers": [
                "FF36",
                "S12.1",
                "C57",
                "O"
            ],
            "values": [
                {
                    "name": "line-through",
                    "description": "Each line of text has a line through the middle."
                },
                {
                    "name": "none",
                    "description": "Neither produces nor inhibits text decoration."
                },
                {
                    "name": "overline",
                    "description": "Each line of text has a line above it."
                },
                {
                    "name": "underline",
                    "description": "Each line of text is underlined."
                }
            ],
            "syntax": "none | [ underline || overline || line-through || blink ] | spelling-error | grammar-error",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration-line"
                }
            ],
            "description": "Specifies what line decorations, if any, are added to the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scroll-snap-align",
            "syntax": "[ none | start | end | center ]{1,2}",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-snap-align"
                }
            ],
            "description": "The scroll-snap-align property specifies the box’s snap position as an alignment of its snap area (as the alignment subject) within its snap container’s snapport (as the alignment container). The two values specify the snapping alignment in the block axis and inline axis, respectively. If only one value is specified, the second value defaults to the same value."
        },
        {
            "name": "grid-row",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line> [ / <grid-line> ]?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-row"
                }
            ],
            "description": "Shorthand for 'grid-row-start' and 'grid-row-end'.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "caret-color",
            "browsers": [
                "FF53",
                "S11.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent selects an appropriate color for the caret. This is generally currentcolor, but the user agent may choose a different color to ensure good visibility and contrast with the surrounding content, taking into account the value of currentcolor, the background, shadows, and other factors."
                }
            ],
            "syntax": "auto | <color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/caret-color"
                }
            ],
            "description": "Controls the color of the text insertion indicator.",
            "restrictions": [
                "color",
                "enum"
            ]
        },
        {
            "name": "stroke-linejoin",
            "values": [
                {
                    "name": "bevel",
                    "description": "Indicates that a bevelled corner is to be used to join path segments."
                },
                {
                    "name": "miter",
                    "description": "Indicates that a sharp corner is to be used to join path segments."
                },
                {
                    "name": "round",
                    "description": "Indicates that a round corner is to be used to join path segments."
                }
            ],
            "description": "Specifies the shape to be used at the corners of paths or basic shapes when they are stroked.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-area",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line> [ / <grid-line> ]{0,3}",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-area"
                }
            ],
            "description": "Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement. Shorthand for 'grid-row-start', 'grid-column-start', 'grid-row-end', and 'grid-column-end'.",
            "restrictions": [
                "identifier",
                "integer"
            ]
        },
        {
            "name": "column-fill",
            "values": [
                {
                    "name": "auto",
                    "description": "Fills columns sequentially."
                },
                {
                    "name": "balance",
                    "description": "Balance content equally between columns, if possible."
                }
            ],
            "syntax": "auto | balance | balance-all",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/column-fill"
                }
            ],
            "description": "In continuous media, this property will only be consulted if the length of columns has been constrained. Otherwise, columns will automatically be balanced.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "tab-size",
            "browsers": [
                "FF4",
                "S6.1",
                "C21",
                "O15"
            ],
            "syntax": "<integer> | <length>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/tab-size"
                }
            ],
            "description": "Determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",
            "restrictions": [
                "integer",
                "length"
            ]
        },
        {
            "name": "overflow-anchor",
            "status": "experimental",
            "syntax": "auto | none",
            "browsers": [
                "FF66",
                "C56",
                "O43"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/overflow-anchor"
                }
            ],
            "description": "The overflow-anchor CSS property provides a way to opt out browser scroll anchoring behavior which adjusts scroll position to minimize content shifts."
        },
        {
            "name": "border-image-source",
            "values": [
                {
                    "name": "none",
                    "description": "Use the border styles."
                }
            ],
            "syntax": "none | <image>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-source"
                }
            ],
            "description": "Specifies an image to use instead of the border styles given by the 'border-style' properties and as an additional background layer for the element. If the value is 'none' or if the image cannot be displayed, the border styles will be used.",
            "restrictions": [
                "image"
            ]
        },
        {
            "name": "grid-template-areas",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The grid container doesn’t define any named grid areas."
                }
            ],
            "syntax": "none | <string>+",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-template-areas"
                }
            ],
            "description": "Specifies named grid areas, which are not associated with any particular grid item, but can be referenced from the grid-placement properties.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "font-kerning",
            "browsers": [
                "FF32",
                "S7",
                "C32",
                "O19"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Specifies that kerning is applied at the discretion of the user agent."
                },
                {
                    "name": "none",
                    "description": "Specifies that kerning is not applied."
                },
                {
                    "name": "normal",
                    "description": "Specifies that kerning is applied."
                }
            ],
            "syntax": "auto | normal | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-kerning"
                }
            ],
            "description": "Kerning is the contextual adjustment of inter-glyph spacing. This property controls metric kerning, kerning that utilizes adjustment data contained in the font.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "page-break-before",
            "values": [
                {
                    "name": "always",
                    "description": "Always force a page break before the generated box."
                },
                {
                    "name": "auto",
                    "description": "Neither force nor forbid a page break before the generated box."
                },
                {
                    "name": "avoid",
                    "description": "Avoid a page break before the generated box."
                },
                {
                    "name": "left",
                    "description": "Force one or two page breaks before the generated box so that the next page is formatted as a left page."
                },
                {
                    "name": "right",
                    "description": "Force one or two page breaks before the generated box so that the next page is formatted as a right page."
                }
            ],
            "syntax": "auto | always | avoid | left | right | recto | verso",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/page-break-before"
                }
            ],
            "description": "Defines rules for page breaks before an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-decoration-style",
            "browsers": [
                "FF36",
                "S12.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "dashed",
                    "description": "Produces a dashed line style."
                },
                {
                    "name": "dotted",
                    "description": "Produces a dotted line."
                },
                {
                    "name": "double",
                    "description": "Produces a double line."
                },
                {
                    "name": "none",
                    "description": "Produces no line."
                },
                {
                    "name": "solid",
                    "description": "Produces a solid line."
                },
                {
                    "name": "wavy",
                    "description": "Produces a wavy line."
                }
            ],
            "syntax": "solid | double | dotted | dashed | wavy",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration-style"
                }
            ],
            "description": "Specifies the line style for underline, line-through and overline text decoration.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-row-gap",
            "browsers": [
                "FF52",
                "C57",
                "S10.1",
                "O44"
            ],
            "status": "obsolete",
            "syntax": "<length-percentage>",
            "description": "Specifies the gutters between grid rows. Replaced by 'row-gap' property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "backdrop-filter",
            "status": "experimental",
            "syntax": "none | <filter-function-list>",
            "browsers": [
                "E17",
                "FF70",
                "S9",
                "C76",
                "O34"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/backdrop-filter"
                }
            ],
            "description": "The backdrop-filter CSS property lets you apply graphical effects such as blurring or color shifting to the area behind an element. Because it applies to everything behind the element, to see the effect you must make the element or its background at least partially transparent."
        },
        {
            "name": "grid-auto-flow",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "row",
                    "description": "The auto-placement algorithm places items by filling each row in turn, adding new rows as necessary."
                },
                {
                    "name": "column",
                    "description": "The auto-placement algorithm places items by filling each column in turn, adding new columns as necessary."
                },
                {
                    "name": "dense",
                    "description": "If specified, the auto-placement algorithm uses a “dense” packing algorithm, which attempts to fill in holes earlier in the grid if smaller items come up later."
                }
            ],
            "syntax": "[ row | column ] || dense",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-auto-flow"
                }
            ],
            "description": "Controls how the auto-placement algorithm works, specifying exactly how auto-placed items get flowed into the grid.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-column-start",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-column-start"
                }
            ],
            "description": "Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "column-rule-color",
            "syntax": "<color>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/column-rule-color"
                }
            ],
            "description": "Sets the color of the column rule",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "isolation",
            "browsers": [
                "FF36",
                "S8",
                "C41",
                "O30"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Elements are not isolated unless an operation is applied that causes the creation of a stacking context."
                },
                {
                    "name": "isolate",
                    "description": "In CSS will turn the element into a stacking context."
                }
            ],
            "syntax": "auto | isolate",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/isolation"
                }
            ],
            "description": "In CSS setting to 'isolate' will turn the element into a stacking context. In SVG, it defines whether an element is isolated or not.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "column-rule-style",
            "syntax": "<'border-style'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/column-rule-style"
                }
            ],
            "description": "Sets the style of the rule between columns of an element.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "stop-color",
            "description": "Indicates what color to use at that gradient stop.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "clip-rule",
            "browsers": [
                "E",
                "C5",
                "FF3",
                "IE10",
                "O9",
                "S6"
            ],
            "values": [
                {
                    "name": "evenodd",
                    "description": "Determines the ‘insideness’ of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."
                },
                {
                    "name": "nonzero",
                    "description": "Determines the ‘insideness’ of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."
                }
            ],
            "description": "Indicates the algorithm which is to be used to determine what parts of the canvas are included inside the shape.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "background-blend-mode",
            "browsers": [
                "FF30",
                "S8",
                "C35",
                "O22"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "Default attribute which specifies no blending"
                },
                {
                    "name": "multiply",
                    "description": "The source color is multiplied by the destination color and replaces the destination."
                },
                {
                    "name": "screen",
                    "description": "Multiplies the complements of the backdrop and source color values, then complements the result."
                },
                {
                    "name": "overlay",
                    "description": "Multiplies or screens the colors, depending on the backdrop color value."
                },
                {
                    "name": "darken",
                    "description": "Selects the darker of the backdrop and source colors."
                },
                {
                    "name": "lighten",
                    "description": "Selects the lighter of the backdrop and source colors."
                },
                {
                    "name": "color-dodge",
                    "description": "Brightens the backdrop color to reflect the source color."
                },
                {
                    "name": "color-burn",
                    "description": "Darkens the backdrop color to reflect the source color."
                },
                {
                    "name": "hard-light",
                    "description": "Multiplies or screens the colors, depending on the source color value."
                },
                {
                    "name": "soft-light",
                    "description": "Darkens or lightens the colors, depending on the source color value."
                },
                {
                    "name": "difference",
                    "description": "Subtracts the darker of the two constituent colors from the lighter color.."
                },
                {
                    "name": "exclusion",
                    "description": "Produces an effect similar to that of the Difference mode but lower in contrast."
                },
                {
                    "name": "hue",
                    "browsers": [
                        "FF30",
                        "S8",
                        "C35",
                        "O22"
                    ],
                    "description": "Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."
                },
                {
                    "name": "saturation",
                    "browsers": [
                        "FF30",
                        "S8",
                        "C35",
                        "O22"
                    ],
                    "description": "Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."
                },
                {
                    "name": "color",
                    "browsers": [
                        "FF30",
                        "S8",
                        "C35",
                        "O22"
                    ],
                    "description": "Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."
                },
                {
                    "name": "luminosity",
                    "browsers": [
                        "FF30",
                        "S8",
                        "C35",
                        "O22"
                    ],
                    "description": "Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."
                }
            ],
            "syntax": "<blend-mode>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/background-blend-mode"
                }
            ],
            "description": "Defines the blending mode of each background layer.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-numeric",
            "browsers": [
                "FF34",
                "S9.1",
                "C52",
                "O39"
            ],
            "values": [
                {
                    "name": "diagonal-fractions",
                    "description": "Enables display of lining diagonal fractions."
                },
                {
                    "name": "lining-nums",
                    "description": "Enables display of lining numerals."
                },
                {
                    "name": "normal",
                    "description": "None of the features are enabled."
                },
                {
                    "name": "oldstyle-nums",
                    "description": "Enables display of old-style numerals."
                },
                {
                    "name": "ordinal",
                    "description": "Enables display of letter forms used with ordinal numbers."
                },
                {
                    "name": "proportional-nums",
                    "description": "Enables display of proportional numerals."
                },
                {
                    "name": "slashed-zero",
                    "description": "Enables display of slashed zeros."
                },
                {
                    "name": "stacked-fractions",
                    "description": "Enables display of lining stacked fractions."
                },
                {
                    "name": "tabular-nums",
                    "description": "Enables display of tabular numerals."
                }
            ],
            "syntax": "normal | [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-numeric"
                }
            ],
            "description": "Specifies control over numerical forms.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-column-end",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-column-end"
                }
            ],
            "description": "Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "margin-block-start",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "syntax": "<'margin-left'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-block-start"
                }
            ],
            "description": "Logical 'margin-top'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "writing-mode",
            "values": [
                {
                    "name": "horizontal-tb",
                    "description": "Top-to-bottom block flow direction. The writing mode is horizontal."
                },
                {
                    "name": "sideways-lr",
                    "description": "Left-to-right block flow direction. The writing mode is vertical, while the typographic mode is horizontal."
                },
                {
                    "name": "sideways-rl",
                    "description": "Right-to-left block flow direction. The writing mode is vertical, while the typographic mode is horizontal."
                },
                {
                    "name": "vertical-lr",
                    "description": "Left-to-right block flow direction. The writing mode is vertical."
                },
                {
                    "name": "vertical-rl",
                    "description": "Right-to-left block flow direction. The writing mode is vertical."
                }
            ],
            "syntax": "horizontal-tb | vertical-rl | vertical-lr | sideways-rl | sideways-lr",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/writing-mode"
                }
            ],
            "description": "This is a shorthand property for both 'direction' and 'block-progression'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "shape-rendering",
            "values": [
                {
                    "name": "auto",
                    "description": "Suppresses aural rendering."
                },
                {
                    "name": "crispEdges",
                    "description": "Emphasize the contrast between clean edges of artwork over rendering speed and geometric precision."
                },
                {
                    "name": "geometricPrecision",
                    "description": "Emphasize geometric precision over speed and crisp edges."
                },
                {
                    "name": "optimizeSpeed",
                    "description": "Emphasize rendering speed over geometric precision and crisp edges."
                }
            ],
            "description": "Provides hints about what tradeoffs to make as it renders vector graphics elements such as <path> elements and basic shapes such as circles and rectangles.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-row-start",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-row-start"
                }
            ],
            "description": "Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "grid-auto-columns",
            "values": [
                {
                    "name": "min-content",
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                }
            ],
            "syntax": "<track-size>+",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-auto-columns"
                }
            ],
            "description": "Specifies the size of implicitly created columns.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "break-after",
            "values": [
                {
                    "name": "always",
                    "description": "Always force a page break before/after the generated box."
                },
                {
                    "name": "auto",
                    "description": "Neither force nor forbid a page/column break before/after the principal box."
                },
                {
                    "name": "avoid",
                    "description": "Avoid a break before/after the principal box."
                },
                {
                    "name": "avoid-column",
                    "description": "Avoid a column break before/after the principal box."
                },
                {
                    "name": "avoid-page",
                    "description": "Avoid a page break before/after the principal box."
                },
                {
                    "name": "column",
                    "description": "Always force a column break before/after the principal box."
                },
                {
                    "name": "left",
                    "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."
                },
                {
                    "name": "page",
                    "description": "Always force a page break before/after the principal box."
                },
                {
                    "name": "right",
                    "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."
                }
            ],
            "syntax": "auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",
            "description": "Describes the page/column/region break behavior after the generated box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-decoration-skip-ink",
            "status": "experimental",
            "syntax": "auto | none",
            "browsers": [
                "FF70",
                "C64",
                "O50"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip-ink"
                }
            ],
            "description": "The text-decoration-skip-ink CSS property specifies how overlines and underlines are drawn when they pass over glyph ascenders and descenders."
        },
        {
            "name": "grid-row-end",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-row-end"
                }
            ],
            "description": "Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "break-before",
            "values": [
                {
                    "name": "always",
                    "description": "Always force a page break before/after the generated box."
                },
                {
                    "name": "auto",
                    "description": "Neither force nor forbid a page/column break before/after the principal box."
                },
                {
                    "name": "avoid",
                    "description": "Avoid a break before/after the principal box."
                },
                {
                    "name": "avoid-column",
                    "description": "Avoid a column break before/after the principal box."
                },
                {
                    "name": "avoid-page",
                    "description": "Avoid a page break before/after the principal box."
                },
                {
                    "name": "column",
                    "description": "Always force a column break before/after the principal box."
                },
                {
                    "name": "left",
                    "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."
                },
                {
                    "name": "page",
                    "description": "Always force a page break before/after the principal box."
                },
                {
                    "name": "right",
                    "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."
                }
            ],
            "syntax": "auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",
            "description": "Describes the page/column/region break behavior before the generated box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-caps",
            "browsers": [
                "FF34",
                "C52",
                "O39"
            ],
            "values": [
                {
                    "name": "all-petite-caps",
                    "description": "Enables display of petite capitals for both upper and lowercase letters."
                },
                {
                    "name": "all-small-caps",
                    "description": "Enables display of small capitals for both upper and lowercase letters."
                },
                {
                    "name": "normal",
                    "description": "None of the features are enabled."
                },
                {
                    "name": "petite-caps",
                    "description": "Enables display of petite capitals."
                },
                {
                    "name": "small-caps",
                    "description": "Enables display of small capitals. Small-caps glyphs typically use the form of uppercase letters but are reduced to the size of lowercase letters."
                },
                {
                    "name": "titling-caps",
                    "description": "Enables display of titling capitals."
                },
                {
                    "name": "unicase",
                    "description": "Enables display of mixture of small capitals for uppercase letters with normal lowercase letters."
                }
            ],
            "syntax": "normal | small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-caps"
                }
            ],
            "description": "Specifies control over capitalized forms.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "stop-opacity",
            "description": "Defines the opacity of a given gradient stop.",
            "restrictions": [
                "number(0-1)"
            ]
        },
        {
            "name": "column-span",
            "values": [
                {
                    "name": "all",
                    "description": "The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."
                },
                {
                    "name": "none",
                    "description": "The element does not span multiple columns."
                }
            ],
            "syntax": "none | all",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/column-span"
                }
            ],
            "description": "Describes the page/column break behavior after the generated box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-anchor",
            "values": [
                {
                    "name": "end",
                    "description": "The rendered characters are aligned such that the end of the resulting rendered text is at the initial current text position."
                },
                {
                    "name": "middle",
                    "description": "The rendered characters are aligned such that the geometric middle of the resulting rendered text is at the initial current text position."
                },
                {
                    "name": "start",
                    "description": "The rendered characters are aligned such that the start of the resulting rendered text is at the initial current text position."
                }
            ],
            "description": "Used to align (start-, middle- or end-alignment) a string of text relative to a given point.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "column-rule-width",
            "syntax": "<'border-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/column-rule-width"
                }
            ],
            "description": "Sets the width of the rule between columns. Negative values are not allowed.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "mask",
            "syntax": "<mask-layer>#",
            "browsers": [
                "E12",
                "FF2",
                "S3.2",
                "C1",
                "O15"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mask"
                }
            ],
            "description": "The mask CSS property alters the visibility of an element by either partially or fully hiding it. This is accomplished by either masking or clipping the image at specific points."
        },
        {
            "name": "text-underline-position",
            "browsers": [
                "E12",
                "C33",
                "IE6",
                "O20"
            ],
            "values": [
                {
                    "name": "above"
                },
                {
                    "name": "auto",
                    "description": "The user agent may use any algorithm to determine the underline’s position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."
                },
                {
                    "name": "below",
                    "description": "The underline is aligned with the under edge of the element’s content box."
                }
            ],
            "syntax": "auto | [ under || [ left | right ] ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-underline-position"
                }
            ],
            "description": "Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements. This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "mask-type",
            "browsers": [
                "FF35",
                "S6.1",
                "C24",
                "O15"
            ],
            "values": [
                {
                    "name": "alpha",
                    "description": "Indicates that the alpha values of the mask should be used."
                },
                {
                    "name": "luminance",
                    "description": "Indicates that the luminance values of the mask should be used."
                }
            ],
            "syntax": "luminance | alpha",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mask-type"
                }
            ],
            "description": "Defines whether the content of the <mask> element is treated as as luminance mask or alpha mask.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-east-asian",
            "browsers": [
                "FF34",
                "C63",
                "O50"
            ],
            "values": [
                {
                    "name": "full-width",
                    "description": "Enables rendering of full-width variants."
                },
                {
                    "name": "jis04",
                    "description": "Enables rendering of JIS04 forms."
                },
                {
                    "name": "jis78",
                    "description": "Enables rendering of JIS78 forms."
                },
                {
                    "name": "jis83",
                    "description": "Enables rendering of JIS83 forms."
                },
                {
                    "name": "jis90",
                    "description": "Enables rendering of JIS90 forms."
                },
                {
                    "name": "normal",
                    "description": "None of the features are enabled."
                },
                {
                    "name": "proportional-width",
                    "description": "Enables rendering of proportionally-spaced variants."
                },
                {
                    "name": "ruby",
                    "description": "Enables display of ruby variant glyphs."
                },
                {
                    "name": "simplified",
                    "description": "Enables rendering of simplified forms."
                },
                {
                    "name": "traditional",
                    "description": "Enables rendering of traditional forms."
                }
            ],
            "syntax": "normal | [ <east-asian-variant-values> || <east-asian-width-values> || ruby ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-east-asian"
                }
            ],
            "description": "Allows control of glyph substitute and positioning in East Asian text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-inline-end-width",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-end-width"
                }
            ],
            "description": "Logical 'border-right-width'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-inline-start-width",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-start-width"
                }
            ],
            "description": "Logical 'border-left-width'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "text-orientation",
            "browsers": [
                "FF41",
                "S5.1",
                "C48",
                "O15"
            ],
            "values": [
                {
                    "name": "sideways",
                    "browsers": [
                        "FF41",
                        "S5.1",
                        "C48",
                        "O15"
                    ],
                    "description": "This value is equivalent to 'sideways-right' in 'vertical-rl' writing mode and equivalent to 'sideways-left' in 'vertical-lr' writing mode."
                },
                {
                    "name": "sideways-right",
                    "browsers": [
                        "FF41",
                        "S5.1",
                        "C48",
                        "O15"
                    ],
                    "description": "In vertical writing modes, this causes text to be set as if in a horizontal layout, but rotated 90° clockwise."
                },
                {
                    "name": "upright",
                    "description": "In vertical writing modes, characters from horizontal-only scripts are rendered upright, i.e. in their standard horizontal orientation."
                }
            ],
            "syntax": "mixed | upright | sideways",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-orientation"
                }
            ],
            "description": "Specifies the orientation of text within a line.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "shape-margin",
            "browsers": [
                "FF62",
                "S10.1",
                "C37",
                "O24"
            ],
            "syntax": "<length-percentage>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/shape-margin"
                }
            ],
            "description": "Adds a margin to a 'shape-outside'. This defines a new shape that is the smallest contour that includes all the points that are the 'shape-margin' distance outward in the perpendicular direction from a point on the underlying shape.",
            "restrictions": [
                "url",
                "length",
                "percentage"
            ]
        },
        {
            "name": "shape-image-threshold",
            "browsers": [
                "FF62",
                "S10.1",
                "C37",
                "O24"
            ],
            "syntax": "<alpha-value>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/shape-image-threshold"
                }
            ],
            "description": "Defines the alpha channel threshold used to extract the shape using an image. A value of 0.5 means that the shape will enclose all the pixels that are more than 50% opaque.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "min-inline-size",
            "browsers": [
                "FF41",
                "S12.1",
                "C57",
                "O44"
            ],
            "syntax": "<'min-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/min-inline-size"
                }
            ],
            "description": "Logical 'min-height'. Mapping depends on the element’s 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "inline-size",
            "browsers": [
                "FF41",
                "S12.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Depends on the values of other properties."
                }
            ],
            "syntax": "<'width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/inline-size"
                }
            ],
            "description": "Logical 'height'. Mapping depends on the element’s 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "text-combine-upright",
            "syntax": "none | all | [ digits <integer>? ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-combine-upright"
                }
            ],
            "description": "The text-combine-upright CSS property specifies the combination of multiple characters into the space of a single character. If the combined text is wider than 1em, the user agent must fit the contents within 1em. The resulting composition is treated as a single upright glyph for layout and decoration. This property only has an effect in vertical writing modes.\n\nThis is used to produce an effect that is known as tate-chū-yoko (縦中横) in Japanese, or as 直書橫向 in Chinese."
        },
        {
            "name": "block-size",
            "browsers": [
                "FF41",
                "S12.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Depends on the values of other properties."
                }
            ],
            "syntax": "<'width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/block-size"
                }
            ],
            "description": "Logical 'width'. Mapping depends on the element’s 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "min-block-size",
            "browsers": [
                "FF41",
                "S12.1",
                "C57",
                "O44"
            ],
            "syntax": "<'min-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/min-block-size"
                }
            ],
            "description": "Logical 'min-width'. Mapping depends on the element’s 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-block-start",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'padding-left'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-block-start"
                }
            ],
            "description": "Logical 'padding-top'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-block-end",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'padding-left'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-block-end"
                }
            ],
            "description": "Logical 'padding-bottom'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-inline-start-color",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-start-color"
                }
            ],
            "description": "Logical 'border-left-color'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-inline-end-color",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-end-color"
                }
            ],
            "description": "Logical 'border-right-color'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-inline-end-style",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-style'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-end-style"
                }
            ],
            "description": "Logical 'border-right-style'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-inline-start-style",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-style'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-start-style"
                }
            ],
            "description": "Logical 'border-left-style'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-block-end-style",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-style'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-end-style"
                }
            ],
            "description": "Logical 'border-bottom-style'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-block-end-color",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-end-color"
                }
            ],
            "description": "Logical 'border-bottom-color'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-block-start-style",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-style'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-start-style"
                }
            ],
            "description": "Logical 'border-top-style'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-block-start-color",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-start-color"
                }
            ],
            "description": "Logical 'border-top-color'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-block-start-width",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-start-width"
                }
            ],
            "description": "Logical 'border-top-width'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-block-end-width",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-end-width"
                }
            ],
            "description": "Logical 'border-bottom-width'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "row-gap",
            "syntax": "normal | <length-percentage>",
            "browsers": [
                "E16",
                "FF63",
                "S10.1",
                "C66",
                "O53"
            ],
            "description": "The row-gap CSS property specifies the gutter between grid rows."
        },
        {
            "name": "grid-template",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "Sets all three properties to their initial values."
                },
                {
                    "name": "min-content",
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "subgrid",
                    "description": "Sets 'grid-template-rows' and 'grid-template-columns' to 'subgrid', and 'grid-template-areas' to its initial value."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                },
                {
                    "name": "repeat()",
                    "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
                }
            ],
            "syntax": "none | [ <'grid-template-rows'> / <'grid-template-columns'> ] | [ <line-names>? <string> <track-size>? <line-names>? ]+ [ / <explicit-track-list> ]?",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid-template"
                }
            ],
            "description": "Shorthand for setting grid-template-columns, grid-template-rows, and grid-template-areas in a single declaration.",
            "restrictions": [
                "identifier",
                "length",
                "percentage",
                "string",
                "enum"
            ]
        },
        {
            "name": "color-interpolation-filters",
            "browsers": [
                "E",
                "C5",
                "FF3",
                "IE10",
                "O9",
                "S6"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Color operations are not required to occur in a particular color space."
                },
                {
                    "name": "linearRGB",
                    "description": "Color operations should occur in the linearized RGB color space."
                },
                {
                    "name": "sRGB",
                    "description": "Color operations should occur in the sRGB color space."
                }
            ],
            "description": "Specifies the color space for imaging operations performed via filter effects.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "paint-order",
            "browsers": [
                "E17",
                "FF60",
                "S8",
                "C35",
                "O22"
            ],
            "values": [
                {
                    "name": "fill"
                },
                {
                    "name": "markers"
                },
                {
                    "name": "normal",
                    "description": "The element is painted with the standard order of painting operations: the 'fill' is painted first, then its 'stroke' and finally its markers."
                },
                {
                    "name": "stroke"
                }
            ],
            "status": "experimental",
            "syntax": "normal | [ fill || stroke || markers ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/paint-order"
                }
            ],
            "description": "Controls the order that the three paint operations that shapes and text are rendered with: their fill, their stroke and any markers they might have.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "flood-color",
            "browsers": [
                "E",
                "C5",
                "FF3",
                "IE10",
                "O9",
                "S6"
            ],
            "description": "Indicates what color to use to flood the current filter primitive subregion.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "flood-opacity",
            "browsers": [
                "E",
                "C5",
                "FF3",
                "IE10",
                "O9",
                "S6"
            ],
            "description": "Indicates what opacity to use to flood the current filter primitive subregion.",
            "restrictions": [
                "number(0-1)",
                "percentage"
            ]
        },
        {
            "name": "scroll-snap-stop",
            "syntax": "normal | always",
            "browsers": [
                "C75",
                "O62"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-snap-stop"
                }
            ],
            "description": "The scroll-snap-stop CSS property defines whether the scroll container is allowed to \"pass over\" possible snap positions."
        },
        {
            "name": "lighting-color",
            "browsers": [
                "E",
                "C5",
                "FF3",
                "IE10",
                "O9",
                "S6"
            ],
            "description": "Defines the color of the light source for filter primitives 'feDiffuseLighting' and 'feSpecularLighting'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scroll-padding-left",
            "syntax": "auto | <length-percentage>",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-left"
                }
            ],
            "description": "The scroll-padding-left property defines offsets for the left of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."
        },
        {
            "name": "marker-end",
            "values": [
                {
                    "name": "none",
                    "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
                },
                {
                    "name": "url()",
                    "description": "Indicates that the <marker> element referenced will be used."
                }
            ],
            "description": "Specifies the marker that will be drawn at the last vertices of the given markable element.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "marker-start",
            "values": [
                {
                    "name": "none",
                    "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
                },
                {
                    "name": "url()",
                    "description": "Indicates that the <marker> element referenced will be used."
                }
            ],
            "description": "Specifies the marker that will be drawn at the first vertices of the given markable element.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "marker-mid",
            "values": [
                {
                    "name": "none",
                    "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
                },
                {
                    "name": "url()",
                    "description": "Indicates that the <marker> element referenced will be used."
                }
            ],
            "description": "Specifies the marker that will be drawn at all vertices except the first and last.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "offset-distance",
            "status": "experimental",
            "syntax": "<length-percentage>",
            "browsers": [
                "FF69",
                "C55",
                "O42"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/offset-distance"
                }
            ],
            "description": "The offset-distance CSS property specifies a position along an offset-path."
        },
        {
            "name": "place-content",
            "syntax": "<'align-content'> <'justify-content'>?",
            "browsers": [
                "FF53",
                "S9",
                "C59",
                "O"
            ],
            "description": "The place-content CSS shorthand property sets both the align-content and justify-content properties."
        },
        {
            "name": "font-variation-settings",
            "syntax": "normal | [ <string> <number> ]#",
            "browsers": [
                "E17",
                "FF62",
                "S11",
                "C62",
                "O49"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-variation-settings"
                }
            ],
            "description": "The font-variation-settings CSS property provides low-level control over OpenType or TrueType font variations, by specifying the four letter axis names of the features you want to vary, along with their variation values."
        },
        {
            "name": "offset-path",
            "status": "experimental",
            "syntax": "none | ray( [ <angle> && <size>? && contain? ] ) | <path()> | <url> | [ <basic-shape> || <geometry-box> ]",
            "browsers": [
                "FF63",
                "C55",
                "O45"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/offset-path"
                }
            ],
            "description": "The offset-path CSS property specifies the offset path where the element gets positioned. The exact element’s position on the offset path is determined by the offset-distance property. An offset path is either a specified path with one or multiple sub-paths or the geometry of a not-styled basic shape. Each shape or path must define an initial position for the computed value of \"0\" for offset-distance and an initial direction which specifies the rotation of the object to the initial position.\n\nIn this specification, a direction (or rotation) of 0 degrees is equivalent to the direction of the positive x-axis in the object’s local coordinate system. In other words, a rotation of 0 degree points to the right side of the UA if the object and its ancestors have no transformation applied."
        },
        {
            "name": "offset-rotate",
            "status": "experimental",
            "syntax": "[ auto | reverse ] || <angle>",
            "browsers": [
                "FF69",
                "C56",
                "O43"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/offset-rotate"
                }
            ],
            "description": "The offset-rotate CSS property defines the direction of the element while positioning along the offset path."
        },
        {
            "name": "max-inline-size",
            "browsers": [
                "FF41",
                "S10.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No limit on the height of the box."
                }
            ],
            "status": "experimental",
            "syntax": "<'max-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/max-inline-size"
                }
            ],
            "description": "Logical 'max-height'. Mapping depends on the element’s 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "max-block-size",
            "browsers": [
                "FF41",
                "S12.1",
                "C57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No limit on the width of the box."
                }
            ],
            "status": "experimental",
            "syntax": "<'max-width'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/max-block-size"
                }
            ],
            "description": "Logical 'max-width'. Mapping depends on the element’s 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "scroll-padding",
            "syntax": "[ auto | <length-percentage> ]{1,4}",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding"
                }
            ],
            "description": "The scroll-padding property is a shorthand property which sets all of the scroll-padding longhands, assigning values much like the padding property does for the padding-* longhands."
        },
        {
            "name": "transform-box",
            "syntax": "border-box | fill-box | view-box",
            "browsers": [
                "FF55",
                "S11",
                "C64",
                "O51"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/transform-box"
                }
            ],
            "description": "The transform-box CSS property defines the layout box to which the transform and transform-origin properties relate."
        },
        {
            "name": "scroll-padding-top",
            "syntax": "auto | <length-percentage>",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-top"
                }
            ],
            "description": "The scroll-padding-top property defines offsets for the top of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."
        },
        {
            "name": "gap",
            "syntax": "<'row-gap'> <'column-gap'>?",
            "browsers": [
                "E16",
                "FF63",
                "S10.1",
                "C66",
                "O53"
            ],
            "description": "The gap CSS property is a shorthand property for row-gap and column-gap specifying the gutters between grid rows and columns."
        },
        {
            "name": "scroll-padding-right",
            "syntax": "auto | <length-percentage>",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-right"
                }
            ],
            "description": "The scroll-padding-right property defines offsets for the right of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."
        },
        {
            "name": "marker",
            "values": [
                {
                    "name": "none",
                    "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
                },
                {
                    "name": "url()",
                    "description": "Indicates that the <marker> element referenced will be used."
                }
            ],
            "description": "Specifies the marker symbol that shall be used for all points on the sets the value for all vertices on the given ‘path’ element or basic shape.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "scroll-padding-bottom",
            "syntax": "auto | <length-percentage>",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-bottom"
                }
            ],
            "description": "The scroll-padding-bottom property defines offsets for the bottom of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."
        },
        {
            "name": "scroll-padding-inline-start",
            "syntax": "auto | <length-percentage>",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-start"
                }
            ],
            "description": "The scroll-padding-inline-start property defines offsets for the start edge in the inline dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."
        },
        {
            "name": "scroll-padding-block-start",
            "syntax": "auto | <length-percentage>",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-start"
                }
            ],
            "description": "The scroll-padding-block-start property defines offsets for the start edge in the block dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."
        },
        {
            "name": "scroll-padding-inline-end",
            "syntax": "auto | <length-percentage>",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-end"
                }
            ],
            "description": "The scroll-padding-inline-end property defines offsets for the end edge in the inline dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."
        },
        {
            "name": "scroll-padding-block-end",
            "syntax": "auto | <length-percentage>",
            "browsers": [
                "FF68",
                "S11",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-end"
                }
            ],
            "description": "The scroll-padding-block-end property defines offsets for the end edge in the block dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."
        },
        {
            "name": "place-self",
            "syntax": "<'align-self'> <'justify-self'>?",
            "browsers": [
                "FF45",
                "C59",
                "O46"
            ],
            "description": "The place-self CSS property is a shorthand property sets both the align-self and justify-self properties. The first value is the align-self property value, the second the justify-self one. If the second value is not present, the first value is also used for it."
        },
        {
            "name": "grid",
            "browsers": [
                "E16",
                "FF52",
                "S10.1",
                "C57",
                "O44"
            ],
            "syntax": "<'grid-template'> | <'grid-template-rows'> / [ auto-flow && dense? ] <'grid-auto-columns'>? | [ auto-flow && dense? ] <'grid-auto-rows'>? / <'grid-template-columns'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/grid"
                }
            ],
            "description": "The grid CSS property is a shorthand property that sets all of the explicit grid properties ('grid-template-rows', 'grid-template-columns', and 'grid-template-areas'), and all the implicit grid properties ('grid-auto-rows', 'grid-auto-columns', and 'grid-auto-flow'), in a single declaration.",
            "restrictions": [
                "identifier",
                "length",
                "percentage",
                "string",
                "enum"
            ]
        },
        {
            "name": "place-items",
            "syntax": "<'align-items'> <'justify-items'>?",
            "browsers": [
                "FF45",
                "S11",
                "C59",
                "O46"
            ],
            "description": "The CSS place-items shorthand property sets both the align-items and justify-items properties. The first value is the align-items property value, the second the justify-items one. If the second value is not present, the first value is also used for it."
        },
        {
            "name": "font-optical-sizing",
            "syntax": "auto | none",
            "browsers": [
                "E17",
                "FF62",
                "S11",
                "C79"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-optical-sizing"
                }
            ],
            "description": "The font-optical-sizing CSS property allows developers to control whether browsers render text with slightly differing visual representations to optimize viewing at different sizes, or not. This only works for fonts that have an optical size variation axis."
        },
        {
            "name": "border-block-start",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-width'> || <'border-top-style'> || <'color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-start"
                }
            ],
            "description": "Logical 'border-top'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-block-end",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-width'> || <'border-top-style'> || <'color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-end"
                }
            ],
            "description": "Logical 'border-bottom'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-inline-start",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-width'> || <'border-top-style'> || <'color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-start"
                }
            ],
            "description": "Logical 'border-left'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "offset",
            "status": "experimental",
            "syntax": "[ <'offset-position'>? [ <'offset-path'> [ <'offset-distance'> || <'offset-rotate'> ]? ]? ]! [ / <'offset-anchor'> ]?",
            "browsers": [
                "FF71",
                "C55",
                "O42"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/offset"
                }
            ],
            "description": "The offset CSS property is a shorthand property for animating an element along a defined path."
        },
        {
            "name": "border-inline-end",
            "browsers": [
                "FF41",
                "S12.1",
                "C69",
                "O56"
            ],
            "syntax": "<'border-top-width'> || <'border-top-style'> || <'color'>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-end"
                }
            ],
            "description": "Logical 'border-right'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "scroll-padding-block",
            "syntax": "[ auto | <length-percentage> ]{1,2}",
            "browsers": [
                "FF68",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block"
                }
            ],
            "description": "The scroll-padding-block property is a shorthand property which sets the scroll-padding longhands for the block dimension."
        },
        {
            "name": "scroll-padding-inline",
            "syntax": "[ auto | <length-percentage> ]{1,2}",
            "browsers": [
                "FF68",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline"
                }
            ],
            "description": "The scroll-padding-inline property is a shorthand property which sets the scroll-padding longhands for the inline dimension."
        },
        {
            "name": "motion",
            "browsers": [
                "C46",
                "O33"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No motion path gets created."
                },
                {
                    "name": "path()",
                    "description": "Defines an SVG path as a string, with optional 'fill-rule' as the first argument."
                },
                {
                    "name": "auto",
                    "description": "Indicates that the object is rotated by the angle of the direction of the motion path."
                },
                {
                    "name": "reverse",
                    "description": "Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."
                }
            ],
            "description": "Shorthand property for setting 'motion-path', 'motion-offset' and 'motion-rotation'.",
            "restrictions": [
                "url",
                "length",
                "percentage",
                "angle",
                "shape",
                "geometry-box",
                "enum"
            ]
        },
        {
            "name": "margin-inline",
            "syntax": "<'margin-left'>{1,2}",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-inline"
                }
            ],
            "description": "The margin-inline CSS property defines the logical inline start and end margins of an element, which maps to physical margins depending on the element's writing mode, directionality, and text orientation."
        },
        {
            "name": "padding-block",
            "syntax": "<'padding-left'>{1,2}",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-block"
                }
            ],
            "description": "The padding-block CSS property defines the logical block start and end padding of an element, which maps to physical padding properties depending on the element's writing mode, directionality, and text orientation."
        },
        {
            "name": "padding-inline",
            "syntax": "<'padding-left'>{1,2}",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/padding-inline"
                }
            ],
            "description": "The padding-inline CSS property defines the logical inline start and end padding of an element, which maps to physical padding properties depending on the element's writing mode, directionality, and text orientation."
        },
        {
            "name": "font-size-adjust",
            "browsers": [
                "FF40",
                "C54",
                "O41"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "Do not preserve the font’s x-height."
                }
            ],
            "syntax": "none | <number>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-size-adjust"
                }
            ],
            "description": "Preserves the readability of text when font fallback occurs by adjusting the font-size so that the x-height is the same regardless of the font used.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "motion-path",
            "browsers": [
                "C46",
                "O33"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No motion path gets created."
                },
                {
                    "name": "path()",
                    "description": "Defines an SVG path as a string, with optional 'fill-rule' as the first argument."
                }
            ],
            "description": "Specifies the motion path the element gets positioned at.",
            "restrictions": [
                "url",
                "shape",
                "geometry-box",
                "enum"
            ]
        },
        {
            "name": "text-justify",
            "browsers": [
                "E12",
                "FF55",
                "C32",
                "IE11",
                "O19"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."
                },
                {
                    "name": "distribute",
                    "description": "Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."
                },
                {
                    "name": "distribute-all-lines"
                },
                {
                    "name": "inter-cluster",
                    "description": "Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."
                },
                {
                    "name": "inter-ideograph",
                    "description": "Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."
                },
                {
                    "name": "inter-word",
                    "description": "Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."
                },
                {
                    "name": "kashida",
                    "description": "Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."
                },
                {
                    "name": "newspaper"
                }
            ],
            "syntax": "auto | inter-character | inter-word | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/text-justify"
                }
            ],
            "description": "Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "motion-offset",
            "browsers": [
                "C46",
                "O33"
            ],
            "description": "A distance that describes the position along the specified motion path.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "inset-block-start",
            "syntax": "<'top'>",
            "browsers": [
                "FF63",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/inset-block-start"
                }
            ],
            "description": "The inset-block-start CSS property defines the logical block start offset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "inset",
            "syntax": "<'top'>{1,4}",
            "browsers": [
                "FF66"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/inset"
                }
            ],
            "description": "The inset CSS property defines the logical block and inline start and end offsets of an element, which map to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "inset-inline-start",
            "syntax": "<'top'>",
            "browsers": [
                "FF63",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/inset-inline-start"
                }
            ],
            "description": "The inset-inline-start CSS property defines the logical inline start inset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "inset-inline-end",
            "syntax": "<'top'>",
            "browsers": [
                "FF63",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/inset-inline-end"
                }
            ],
            "description": "The inset-inline-end CSS property defines the logical inline end inset of an element, which maps to a physical inset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "scale",
            "syntax": "none | <number>{1,3}",
            "browsers": [
                "FF60"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scale"
                }
            ],
            "description": "The scale CSS property allows you to specify scale transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."
        },
        {
            "name": "translate",
            "syntax": "none | <length-percentage> [ <length-percentage> <length>? ]?",
            "browsers": [
                "FF60"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/translate"
                }
            ],
            "description": "The translate CSS property allows you to specify translation transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."
        },
        {
            "name": "rotate",
            "syntax": "none | <angle> | [ x | y | z | <number>{3} ] && <angle>",
            "browsers": [
                "FF60"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/rotate"
                }
            ],
            "description": "The rotate CSS property allows you to specify rotation transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."
        },
        {
            "name": "offset-anchor",
            "status": "experimental",
            "syntax": "auto | <position>",
            "browsers": [
                "FF70",
                "C79"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/offset-anchor"
                }
            ],
            "description": "Defines an anchor point of the box positioned along the path. The anchor point specifies the point of the box which is to be considered as the point that is moved along the path."
        },
        {
            "name": "offset-position",
            "status": "experimental",
            "syntax": "auto | <position>",
            "description": "Specifies the initial position of the offset path. If position is specified with static, offset-position would be ignored."
        },
        {
            "name": "margin-block",
            "syntax": "<'margin-left'>{1,2}",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/margin-block"
                }
            ],
            "description": "The margin-block CSS property defines the logical block start and end margins of an element, which maps to physical margins depending on the element's writing mode, directionality, and text orientation."
        },
        {
            "name": "user-zoom",
            "syntax": "zoom | fixed",
            "description": "The user-zoom CSS descriptor controls whether or not the user can change the zoom factor of a document defined by @viewport."
        },
        {
            "name": "min-zoom",
            "syntax": "auto | <number> | <percentage>",
            "description": "The min-zoom CSS descriptor sets the minimum zoom factor of a document defined by the @viewport at-rule. The browser will not zoom out any further than this, whether automatically or at the user's request.\n\nA zoom factor of 1.0 or 100% corresponds to no zooming. Larger values are zoomed in. Smaller values are zoomed out."
        },
        {
            "name": "inset-block-end",
            "syntax": "<'top'>",
            "browsers": [
                "FF63",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/inset-block-end"
                }
            ],
            "description": "The inset-block-end CSS property defines the logical block end offset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "enable-background",
            "values": [
                {
                    "name": "accumulate",
                    "description": "If the ancestor container element has a property of new, then all graphics elements within the current container are rendered both on the parent's background image and onto the target."
                },
                {
                    "name": "new",
                    "description": "Create a new background image canvas. All children of the current container element can access the background, and they will be rendered onto both the parent's background image canvas in addition to the target device."
                }
            ],
            "description": "Deprecated. Use 'isolation' property instead when support allows. Specifies how the accumulation of the background image is managed.",
            "restrictions": [
                "integer",
                "length",
                "percentage",
                "enum"
            ]
        },
        {
            "name": "glyph-orientation-horizontal",
            "description": "Controls glyph orientation when the inline-progression-direction is horizontal.",
            "restrictions": [
                "angle",
                "number"
            ]
        },
        {
            "name": "glyph-orientation-vertical",
            "values": [
                {
                    "name": "auto",
                    "description": "Sets the orientation based on the fullwidth or non-fullwidth characters and the most common orientation."
                }
            ],
            "description": "Controls glyph orientation when the inline-progression-direction is vertical.",
            "restrictions": [
                "angle",
                "number",
                "enum"
            ]
        },
        {
            "name": "kerning",
            "values": [
                {
                    "name": "auto",
                    "description": "Indicates that the user agent should adjust inter-glyph spacing based on kerning tables that are included in the font that will be used."
                }
            ],
            "description": "Indicates whether the user agent should adjust inter-glyph spacing based on kerning tables that are included in the relevant font or instead disable auto-kerning and set inter-character spacing to a specific length.",
            "restrictions": [
                "length",
                "enum"
            ]
        },
        {
            "name": "image-orientation",
            "browsers": [
                "FF26"
            ],
            "values": [
                {
                    "name": "flip",
                    "description": "After rotating by the precededing angle, the image is flipped horizontally. Defaults to 0deg if the angle is ommitted."
                },
                {
                    "name": "from-image",
                    "description": "If the image has an orientation specified in its metadata, such as EXIF, this value computes to the angle that the metadata specifies is necessary to correctly orient the image."
                }
            ],
            "syntax": "from-image | <angle> | [ <angle>? flip ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/image-orientation"
                }
            ],
            "description": "Specifies an orthogonal rotation to be applied to an image before it is laid out.",
            "restrictions": [
                "angle"
            ]
        },
        {
            "name": "image-resolution",
            "status": "experimental",
            "syntax": "[ from-image || <resolution> ] && snap?",
            "description": "The image-resolution property specifies the intrinsic resolution of all raster images used in or on the element. It affects both content images (e.g. replaced elements and generated content) and decorative images (such as background-image). The intrinsic resolution of an image is used to determine the image’s intrinsic dimensions."
        },
        {
            "name": "max-zoom",
            "syntax": "auto | <number> | <percentage>",
            "description": "The max-zoom CSS descriptor sets the maximum zoom factor of a document defined by the @viewport at-rule. The browser will not zoom in any further than this, whether automatically or at the user's request.\n\nA zoom factor of 1.0 or 100% corresponds to no zooming. Larger values are zoomed in. Smaller values are zoomed out."
        },
        {
            "name": "orientation",
            "syntax": "auto | portrait | landscape",
            "description": "The orientation CSS @media media feature can be used to apply styles based on the orientation of the viewport (or the page box, for paged media)."
        },
        {
            "name": "motion-rotation",
            "browsers": [
                "C46",
                "O33"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Indicates that the object is rotated by the angle of the direction of the motion path."
                },
                {
                    "name": "reverse",
                    "description": "Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."
                }
            ],
            "description": "Defines the direction of the element while positioning along the motion path.",
            "restrictions": [
                "angle"
            ]
        },
        {
            "name": "scroll-snap-points-x",
            "browsers": [
                "FF39",
                "S9"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No snap points are defined by this scroll container."
                },
                {
                    "name": "repeat()",
                    "description": "Defines an interval at which snap points are defined, starting from the container’s relevant start edge."
                }
            ],
            "status": "obsolete",
            "syntax": "none | repeat( <length-percentage> )",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-snap-points-x"
                }
            ],
            "description": "Defines the positioning of snap points along the x axis of the scroll container it is applied to.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scroll-snap-points-y",
            "browsers": [
                "FF39",
                "S9"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No snap points are defined by this scroll container."
                },
                {
                    "name": "repeat()",
                    "description": "Defines an interval at which snap points are defined, starting from the container’s relevant start edge."
                }
            ],
            "status": "obsolete",
            "syntax": "none | repeat( <length-percentage> )",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-snap-points-y"
                }
            ],
            "description": "Defines the positioning of snap points along the y axis of the scroll container it is applied to.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scroll-snap-coordinate",
            "browsers": [
                "FF39"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "Specifies that this element does not contribute a snap point."
                }
            ],
            "status": "obsolete",
            "syntax": "none | <position>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-snap-coordinate"
                }
            ],
            "description": "Defines the x and y coordinate within the element which will align with the nearest ancestor scroll container’s snap-destination for the respective axis.",
            "restrictions": [
                "position",
                "length",
                "percentage",
                "enum"
            ]
        },
        {
            "name": "scroll-snap-destination",
            "browsers": [
                "FF39"
            ],
            "status": "obsolete",
            "syntax": "<position>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-snap-destination"
                }
            ],
            "description": "Define the x and y coordinate within the scroll container’s visual viewport which element snap points will align with.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-block-color",
            "syntax": "<'border-top-color'>{1,2}",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-color"
                }
            ],
            "description": "The border-block-color CSS property defines the color of the logical block borders of an element, which maps to a physical border color depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-color and border-bottom-color, or border-right-color and border-left-color property depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "border-block-style",
            "syntax": "<'border-top-style'>",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-style"
                }
            ],
            "description": "The border-block-style CSS property defines the style of the logical block borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-style and border-bottom-style, or border-left-style and border-right-style properties depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "border-block-width",
            "syntax": "<'border-top-width'>",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-width"
                }
            ],
            "description": "The border-block-width CSS property defines the width of the logical block borders of an element, which maps to a physical border width depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-width and border-bottom-width, or border-left-width, and border-right-width property depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "border-inline-color",
            "syntax": "<'border-top-color'>{1,2}",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-color"
                }
            ],
            "description": "The border-inline-color CSS property defines the color of the logical inline borders of an element, which maps to a physical border color depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-color and border-bottom-color, or border-right-color and border-left-color property depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "border-inline-style",
            "syntax": "<'border-top-style'>",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-style"
                }
            ],
            "description": "The border-inline-style CSS property defines the style of the logical inline borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-style and border-bottom-style, or border-left-style and border-right-style properties depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "border-inline-width",
            "syntax": "<'border-top-width'>",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-width"
                }
            ],
            "description": "The border-inline-width CSS property defines the width of the logical inline borders of an element, which maps to a physical border width depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-width and border-bottom-width, or border-left-width, and border-right-width property depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "border-block",
            "syntax": "<'border-top-width'> || <'border-top-style'> || <'color'>",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-block"
                }
            ],
            "description": "The border-block CSS property is a shorthand property for setting the individual logical block border property values in a single place in the style sheet."
        },
        {
            "name": "border-inline",
            "syntax": "<'border-top-width'> || <'border-top-style'> || <'color'>",
            "browsers": [
                "FF66",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline"
                }
            ],
            "description": "The border-inline CSS property is a shorthand property for setting the individual logical inline border property values in a single place in the style sheet."
        },
        {
            "name": "inset-block",
            "syntax": "<'top'>{1,2}",
            "browsers": [
                "FF63",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/inset-block"
                }
            ],
            "description": "The inset-block CSS property defines the logical block start and end offsets of an element, which maps to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "inset-inline",
            "syntax": "<'top'>{1,2}",
            "browsers": [
                "FF63",
                "C69",
                "O56"
            ],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/inset-inline"
                }
            ],
            "description": "The inset-inline CSS property defines the logical block start and end offsets of an element, which maps to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."
        },
        {
            "name": "additive-symbols",
            "browsers": [
                "FF33"
            ],
            "syntax": "[ <integer> && <symbol> ]#",
            "description": "@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor. Needs to be specified if the counter system is 'additive'.",
            "restrictions": [
                "integer",
                "string",
                "image",
                "identifier"
            ]
        },
        {
            "name": "alt",
            "browsers": [
                "S9"
            ],
            "values": [],
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/alt"
                }
            ],
            "description": "Provides alternative text for assistive technology to replace the generated content of a ::before or ::after element.",
            "restrictions": [
                "string",
                "enum"
            ]
        },
        {
            "name": "behavior",
            "browsers": [
                "IE6"
            ],
            "description": "IE only. Used to extend behaviors of the browser.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "box-decoration-break",
            "browsers": [
                "FF32",
                "S6.1",
                "C22",
                "O15"
            ],
            "values": [
                {
                    "name": "clone",
                    "description": "Each box is independently wrapped with the border and padding."
                },
                {
                    "name": "slice",
                    "description": "The effect is as though the element were rendered with no breaks present, and then sliced by the breaks afterward."
                }
            ],
            "syntax": "slice | clone",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/box-decoration-break"
                }
            ],
            "description": "Specifies whether individual boxes are treated as broken pieces of one continuous box, or whether each box is individually wrapped with the border and padding.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "fallback",
            "browsers": [
                "FF33"
            ],
            "syntax": "<counter-style-name>",
            "description": "@counter-style descriptor. Specifies a fallback counter style to be used when the current counter style can’t create a representation for a given counter value.",
            "restrictions": [
                "identifier"
            ]
        },
        {
            "name": "font-language-override",
            "browsers": [
                "FF34"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "Implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering."
                }
            ],
            "syntax": "normal | <string>",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-language-override"
                }
            ],
            "description": "The value of 'normal' implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "font-synthesis",
            "browsers": [
                "FF34",
                "S9"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "Disallow all synthetic faces."
                },
                {
                    "name": "style",
                    "description": "Allow synthetic italic faces."
                },
                {
                    "name": "weight",
                    "description": "Allow synthetic bold faces."
                }
            ],
            "syntax": "none | [ weight || style ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-synthesis"
                }
            ],
            "description": "Controls whether user agents are allowed to synthesize bold or oblique font faces when a font family lacks bold or italic faces.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-alternates",
            "browsers": [
                "FF34"
            ],
            "values": [
                {
                    "name": "annotation()",
                    "description": "Enables display of alternate annotation forms."
                },
                {
                    "name": "character-variant()",
                    "description": "Enables display of specific character variants."
                },
                {
                    "name": "historical-forms",
                    "description": "Enables display of historical forms."
                },
                {
                    "name": "normal",
                    "description": "None of the features are enabled."
                },
                {
                    "name": "ornaments()",
                    "description": "Enables replacement of default glyphs with ornaments, if provided in the font."
                },
                {
                    "name": "styleset()",
                    "description": "Enables display with stylistic sets."
                },
                {
                    "name": "stylistic()",
                    "description": "Enables display of stylistic alternates."
                },
                {
                    "name": "swash()",
                    "description": "Enables display of swash glyphs."
                }
            ],
            "syntax": "normal | [ stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) ]",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-alternates"
                }
            ],
            "description": "For any given character, fonts can provide a variety of alternate glyphs in addition to the default glyph for that character. This property provides control over the selection of these alternate glyphs.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-position",
            "browsers": [
                "FF34"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "None of the features are enabled."
                },
                {
                    "name": "sub",
                    "description": "Enables display of subscript variants (OpenType feature: subs)."
                },
                {
                    "name": "super",
                    "description": "Enables display of superscript variants (OpenType feature: sups)."
                }
            ],
            "syntax": "normal | sub | super",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-position"
                }
            ],
            "description": "Specifies the vertical position",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "ime-mode",
            "browsers": [
                "E12",
                "FF3",
                "IE5"
            ],
            "values": [
                {
                    "name": "active",
                    "description": "The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."
                },
                {
                    "name": "auto",
                    "description": "No change is made to the current input method editor state. This is the default."
                },
                {
                    "name": "disabled",
                    "description": "The input method editor is disabled and may not be activated by the user."
                },
                {
                    "name": "inactive",
                    "description": "The input method editor is initially inactive, but the user may activate it if they wish."
                },
                {
                    "name": "normal",
                    "description": "The IME state should be normal; this value can be used in a user style sheet to override the page setting."
                }
            ],
            "status": "obsolete",
            "syntax": "auto | normal | active | inactive | disabled",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/ime-mode"
                }
            ],
            "description": "Controls the state of the input method editor for text fields.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "mask-image",
            "browsers": [
                "E16",
                "FF53",
                "S4",
                "C1",
                "O15"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "Counts as a transparent black image layer."
                },
                {
                    "name": "url()",
                    "description": "Reference to a <mask element or to a CSS image."
                }
            ],
            "syntax": "<mask-reference>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mask-image"
                }
            ],
            "description": "Sets the mask layer image of an element.",
            "restrictions": [
                "url",
                "image",
                "enum"
            ]
        },
        {
            "name": "mask-mode",
            "browsers": [
                "FF53"
            ],
            "values": [
                {
                    "name": "alpha",
                    "description": "Alpha values of the mask layer image should be used as the mask values."
                },
                {
                    "name": "auto",
                    "description": "Use alpha values if 'mask-image' is an image, luminance if a <mask> element or a CSS image."
                },
                {
                    "name": "luminance",
                    "description": "Luminance values of the mask layer image should be used as the mask values."
                }
            ],
            "syntax": "<masking-mode>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mask-mode"
                }
            ],
            "description": "Indicates whether the mask layer image is treated as luminance mask or alpha mask.",
            "restrictions": [
                "url",
                "image",
                "enum"
            ]
        },
        {
            "name": "mask-origin",
            "browsers": [
                "FF53",
                "S4",
                "C1",
                "O15"
            ],
            "syntax": "<geometry-box>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mask-origin"
                }
            ],
            "description": "Specifies the mask positioning area.",
            "restrictions": [
                "geometry-box",
                "enum"
            ]
        },
        {
            "name": "mask-position",
            "browsers": [
                "E18",
                "FF53",
                "S3.2",
                "C1",
                "O15"
            ],
            "syntax": "<position>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mask-position"
                }
            ],
            "description": "Specifies how mask layer images are positioned.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "mask-repeat",
            "browsers": [
                "E18",
                "FF53",
                "S3.2",
                "C1",
                "O15"
            ],
            "syntax": "<repeat-style>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mask-repeat"
                }
            ],
            "description": "Specifies how mask layer images are tiled after they have been sized and positioned.",
            "restrictions": [
                "repeat"
            ]
        },
        {
            "name": "mask-size",
            "browsers": [
                "E18",
                "FF53",
                "S4",
                "C4",
                "O15"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Resolved by using the image’s intrinsic ratio and the size of the other dimension, or failing that, using the image’s intrinsic size, or failing that, treating it as 100%."
                },
                {
                    "name": "contain",
                    "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."
                },
                {
                    "name": "cover",
                    "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."
                }
            ],
            "syntax": "<bg-size>#",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/mask-size"
                }
            ],
            "description": "Specifies the size of the mask layer images.",
            "restrictions": [
                "length",
                "percentage",
                "enum"
            ]
        },
        {
            "name": "-moz-animation",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "backwards",
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                },
                {
                    "name": "none",
                    "description": "No animation is performed"
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "description": "Shorthand property combines six of the animation properties into a single property.",
            "restrictions": [
                "time",
                "enum",
                "timing-function",
                "identifier",
                "number"
            ]
        },
        {
            "name": "-moz-animation-delay",
            "browsers": [
                "FF9"
            ],
            "description": "Defines when the animation will start.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-moz-animation-direction",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-animation-duration",
            "browsers": [
                "FF9"
            ],
            "description": "Defines the length of time that an animation takes to complete one cycle.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-moz-animation-iteration-count",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                }
            ],
            "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
            "restrictions": [
                "number",
                "enum"
            ]
        },
        {
            "name": "-moz-animation-name",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No animation is performed"
                }
            ],
            "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
            "restrictions": [
                "identifier",
                "enum"
            ]
        },
        {
            "name": "-moz-animation-play-state",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "paused",
                    "description": "A running animation will be paused."
                },
                {
                    "name": "running",
                    "description": "Resume playback of a paused animation."
                }
            ],
            "description": "Defines whether the animation is running or paused.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-animation-timing-function",
            "browsers": [
                "FF9"
            ],
            "description": "Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "-moz-appearance",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "button"
                },
                {
                    "name": "button-arrow-down"
                },
                {
                    "name": "button-arrow-next"
                },
                {
                    "name": "button-arrow-previous"
                },
                {
                    "name": "button-arrow-up"
                },
                {
                    "name": "button-bevel"
                },
                {
                    "name": "checkbox"
                },
                {
                    "name": "checkbox-container"
                },
                {
                    "name": "checkbox-label"
                },
                {
                    "name": "dialog"
                },
                {
                    "name": "groupbox"
                },
                {
                    "name": "listbox"
                },
                {
                    "name": "menuarrow"
                },
                {
                    "name": "menuimage"
                },
                {
                    "name": "menuitem"
                },
                {
                    "name": "menuitemtext"
                },
                {
                    "name": "menulist"
                },
                {
                    "name": "menulist-button"
                },
                {
                    "name": "menulist-text"
                },
                {
                    "name": "menulist-textfield"
                },
                {
                    "name": "menupopup"
                },
                {
                    "name": "menuradio"
                },
                {
                    "name": "menuseparator"
                },
                {
                    "name": "-moz-mac-unified-toolbar"
                },
                {
                    "name": "-moz-win-borderless-glass"
                },
                {
                    "name": "-moz-win-browsertabbar-toolbox"
                },
                {
                    "name": "-moz-win-communications-toolbox"
                },
                {
                    "name": "-moz-win-glass"
                },
                {
                    "name": "-moz-win-media-toolbox"
                },
                {
                    "name": "none"
                },
                {
                    "name": "progressbar"
                },
                {
                    "name": "progresschunk"
                },
                {
                    "name": "radio"
                },
                {
                    "name": "radio-container"
                },
                {
                    "name": "radio-label"
                },
                {
                    "name": "radiomenuitem"
                },
                {
                    "name": "resizer"
                },
                {
                    "name": "resizerpanel"
                },
                {
                    "name": "scrollbarbutton-down"
                },
                {
                    "name": "scrollbarbutton-left"
                },
                {
                    "name": "scrollbarbutton-right"
                },
                {
                    "name": "scrollbarbutton-up"
                },
                {
                    "name": "scrollbar-small"
                },
                {
                    "name": "scrollbartrack-horizontal"
                },
                {
                    "name": "scrollbartrack-vertical"
                },
                {
                    "name": "separator"
                },
                {
                    "name": "spinner"
                },
                {
                    "name": "spinner-downbutton"
                },
                {
                    "name": "spinner-textfield"
                },
                {
                    "name": "spinner-upbutton"
                },
                {
                    "name": "statusbar"
                },
                {
                    "name": "statusbarpanel"
                },
                {
                    "name": "tab"
                },
                {
                    "name": "tabpanels"
                },
                {
                    "name": "tab-scroll-arrow-back"
                },
                {
                    "name": "tab-scroll-arrow-forward"
                },
                {
                    "name": "textfield"
                },
                {
                    "name": "textfield-multiline"
                },
                {
                    "name": "toolbar"
                },
                {
                    "name": "toolbox"
                },
                {
                    "name": "tooltip"
                },
                {
                    "name": "treeheadercell"
                },
                {
                    "name": "treeheadersortarrow"
                },
                {
                    "name": "treeitem"
                },
                {
                    "name": "treetwistyopen"
                },
                {
                    "name": "treeview"
                },
                {
                    "name": "treewisty"
                },
                {
                    "name": "window"
                }
            ],
            "status": "nonstandard",
            "syntax": "none | button | button-arrow-down | button-arrow-next | button-arrow-previous | button-arrow-up | button-bevel | button-focus | caret | checkbox | checkbox-container | checkbox-label | checkmenuitem | dualbutton | groupbox | listbox | listitem | menuarrow | menubar | menucheckbox | menuimage | menuitem | menuitemtext | menulist | menulist-button | menulist-text | menulist-textfield | menupopup | menuradio | menuseparator | meterbar | meterchunk | progressbar | progressbar-vertical | progresschunk | progresschunk-vertical | radio | radio-container | radio-label | radiomenuitem | range | range-thumb | resizer | resizerpanel | scale-horizontal | scalethumbend | scalethumb-horizontal | scalethumbstart | scalethumbtick | scalethumb-vertical | scale-vertical | scrollbarbutton-down | scrollbarbutton-left | scrollbarbutton-right | scrollbarbutton-up | scrollbarthumb-horizontal | scrollbarthumb-vertical | scrollbartrack-horizontal | scrollbartrack-vertical | searchfield | separator | sheet | spinner | spinner-downbutton | spinner-textfield | spinner-upbutton | splitter | statusbar | statusbarpanel | tab | tabpanel | tabpanels | tab-scroll-arrow-back | tab-scroll-arrow-forward | textfield | textfield-multiline | toolbar | toolbarbutton | toolbarbutton-dropdown | toolbargripper | toolbox | tooltip | treeheader | treeheadercell | treeheadersortarrow | treeitem | treeline | treetwisty | treetwistyopen | treeview | -moz-mac-unified-toolbar | -moz-win-borderless-glass | -moz-win-browsertabbar-toolbox | -moz-win-communicationstext | -moz-win-communications-toolbox | -moz-win-exclude-glass | -moz-win-glass | -moz-win-mediatext | -moz-win-media-toolbox | -moz-window-button-box | -moz-window-button-box-maximized | -moz-window-button-close | -moz-window-button-maximize | -moz-window-button-minimize | -moz-window-button-restore | -moz-window-frame-bottom | -moz-window-frame-left | -moz-window-frame-right | -moz-window-titlebar | -moz-window-titlebar-maximized",
            "description": "Used in Gecko (Firefox) to display an element using a platform-native styling based on the operating system's theme.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-backface-visibility",
            "browsers": [
                "FF10"
            ],
            "values": [
                {
                    "name": "hidden"
                },
                {
                    "name": "visible"
                }
            ],
            "description": "Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-background-clip",
            "browsers": [
                "FF1-3.6"
            ],
            "values": [
                {
                    "name": "padding"
                }
            ],
            "description": "Determines the background painting area.",
            "restrictions": [
                "box",
                "enum"
            ]
        },
        {
            "name": "-moz-background-inline-policy",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "bounding-box"
                },
                {
                    "name": "continuous"
                },
                {
                    "name": "each-box"
                }
            ],
            "description": "In Gecko-based applications like Firefox, the -moz-background-inline-policy CSS property specifies how the background image of an inline element is determined when the content of the inline element wraps onto multiple lines. The choice of position has significant effects on repetition.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-background-origin",
            "browsers": [
                "FF1"
            ],
            "description": "For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",
            "restrictions": [
                "box"
            ]
        },
        {
            "name": "-moz-border-bottom-colors",
            "browsers": [
                "FF1"
            ],
            "status": "nonstandard",
            "syntax": "<color>+ | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/-moz-border-bottom-colors"
                }
            ],
            "description": "Sets a list of colors for the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-border-image",
            "browsers": [
                "FF3.6"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
                },
                {
                    "name": "fill",
                    "description": "Causes the middle part of the border-image to be preserved."
                },
                {
                    "name": "none"
                },
                {
                    "name": "repeat",
                    "description": "The image is tiled (repeated) to fill the area."
                },
                {
                    "name": "round",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
                },
                {
                    "name": "space",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
                },
                {
                    "name": "stretch",
                    "description": "The image is stretched to fill the area."
                },
                {
                    "name": "url()"
                }
            ],
            "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "percentage",
                "number",
                "url",
                "enum"
            ]
        },
        {
            "name": "-moz-border-left-colors",
            "browsers": [
                "FF1"
            ],
            "status": "nonstandard",
            "syntax": "<color>+ | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/-moz-border-left-colors"
                }
            ],
            "description": "Sets a list of colors for the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-border-right-colors",
            "browsers": [
                "FF1"
            ],
            "status": "nonstandard",
            "syntax": "<color>+ | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/-moz-border-right-colors"
                }
            ],
            "description": "Sets a list of colors for the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-border-top-colors",
            "browsers": [
                "FF1"
            ],
            "status": "nonstandard",
            "syntax": "<color>+ | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/-moz-border-top-colors"
                }
            ],
            "description": "Ske Firefox, -moz-border-bottom-colors sets a list of colors for the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-box-align",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "baseline",
                    "description": "If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."
                },
                {
                    "name": "center",
                    "description": "Any extra space is divided evenly, with half placed above the child and the other half placed after the child."
                },
                {
                    "name": "end",
                    "description": "For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."
                },
                {
                    "name": "start",
                    "description": "For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."
                },
                {
                    "name": "stretch",
                    "description": "The height of each child is adjusted to that of the containing block."
                }
            ],
            "description": "Specifies how a XUL box aligns its contents across (perpendicular to) the direction of its layout. The effect of this is only visible if there is extra space in the box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-box-direction",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."
                },
                {
                    "name": "reverse",
                    "description": "A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."
                }
            ],
            "description": "Specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-box-flex",
            "browsers": [
                "FF1"
            ],
            "description": "Specifies how a box grows to fill the box that contains it, in the direction of the containing box's layout.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "-moz-box-flexgroup",
            "browsers": [
                "FF1"
            ],
            "description": "Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-moz-box-ordinal-group",
            "browsers": [
                "FF1"
            ],
            "description": "Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-moz-box-orient",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "block-axis",
                    "description": "Elements are oriented along the box's axis."
                },
                {
                    "name": "horizontal",
                    "description": "The box displays its children from left to right in a horizontal line."
                },
                {
                    "name": "inline-axis",
                    "description": "Elements are oriented vertically."
                },
                {
                    "name": "vertical",
                    "description": "The box displays its children from stacked from top to bottom vertically."
                }
            ],
            "description": "In Mozilla applications, -moz-box-orient specifies whether a box lays out its contents horizontally or vertically.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-box-pack",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."
                },
                {
                    "name": "end",
                    "description": "For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."
                },
                {
                    "name": "justify",
                    "description": "The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."
                },
                {
                    "name": "start",
                    "description": "For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."
                }
            ],
            "description": "Specifies how a box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-box-sizing",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "border-box",
                    "description": "The specified width and height (and respective min/max properties) on this element determine the border box of the element."
                },
                {
                    "name": "content-box",
                    "description": "Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."
                },
                {
                    "name": "padding-box",
                    "description": "The specified width and height (and respective min/max properties) on this element determine the padding box of the element."
                }
            ],
            "description": "Box Model addition in CSS3.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-column-count",
            "browsers": [
                "FF3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Determines the number of columns by the 'column-width' property and the element width."
                }
            ],
            "description": "Describes the optimal number of columns into which the content of the element will be flowed.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-moz-column-gap",
            "browsers": [
                "FF3.5"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "User agent specific and typically equivalent to 1em."
                }
            ],
            "description": "Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-moz-column-rule",
            "browsers": [
                "FF3.5"
            ],
            "description": "Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "-moz-column-rule-color",
            "browsers": [
                "FF3.5"
            ],
            "description": "Sets the color of the column rule",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-column-rule-style",
            "browsers": [
                "FF3.5"
            ],
            "description": "Sets the style of the rule between columns of an element.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "-moz-column-rule-width",
            "browsers": [
                "FF3.5"
            ],
            "description": "Sets the width of the rule between columns. Negative values are not allowed.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "-moz-columns",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The width depends on the values of other properties."
                }
            ],
            "description": "A shorthand property which sets both 'column-width' and 'column-count'.",
            "restrictions": [
                "length",
                "integer"
            ]
        },
        {
            "name": "-moz-column-width",
            "browsers": [
                "FF3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The width depends on the values of other properties."
                }
            ],
            "description": "This property describes the width of columns in multicol elements.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-moz-font-feature-settings",
            "browsers": [
                "FF4"
            ],
            "values": [
                {
                    "name": "\"c2cs\""
                },
                {
                    "name": "\"dlig\""
                },
                {
                    "name": "\"kern\""
                },
                {
                    "name": "\"liga\""
                },
                {
                    "name": "\"lnum\""
                },
                {
                    "name": "\"onum\""
                },
                {
                    "name": "\"smcp\""
                },
                {
                    "name": "\"swsh\""
                },
                {
                    "name": "\"tnum\""
                },
                {
                    "name": "normal",
                    "description": "No change in glyph substitution or positioning occurs."
                },
                {
                    "name": "off",
                    "browsers": [
                        "FF4"
                    ]
                },
                {
                    "name": "on",
                    "browsers": [
                        "FF4"
                    ]
                }
            ],
            "description": "Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",
            "restrictions": [
                "string",
                "integer"
            ]
        },
        {
            "name": "-moz-hyphens",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
                },
                {
                    "name": "manual",
                    "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
                },
                {
                    "name": "none",
                    "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
                }
            ],
            "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-perspective",
            "browsers": [
                "FF10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No perspective transform is applied."
                }
            ],
            "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-moz-perspective-origin",
            "browsers": [
                "FF10"
            ],
            "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "-moz-text-align-last",
            "browsers": [
                "FF12"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "center",
                    "description": "The inline contents are centered within the line box."
                },
                {
                    "name": "justify",
                    "description": "The text is justified according to the method specified by the 'text-justify' property."
                },
                {
                    "name": "left",
                    "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
                },
                {
                    "name": "right",
                    "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
                }
            ],
            "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-text-decoration-color",
            "browsers": [
                "FF6"
            ],
            "description": "Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-text-decoration-line",
            "browsers": [
                "FF6"
            ],
            "values": [
                {
                    "name": "line-through",
                    "description": "Each line of text has a line through the middle."
                },
                {
                    "name": "none",
                    "description": "Neither produces nor inhibits text decoration."
                },
                {
                    "name": "overline",
                    "description": "Each line of text has a line above it."
                },
                {
                    "name": "underline",
                    "description": "Each line of text is underlined."
                }
            ],
            "description": "Specifies what line decorations, if any, are added to the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-text-decoration-style",
            "browsers": [
                "FF6"
            ],
            "values": [
                {
                    "name": "dashed",
                    "description": "Produces a dashed line style."
                },
                {
                    "name": "dotted",
                    "description": "Produces a dotted line."
                },
                {
                    "name": "double",
                    "description": "Produces a double line."
                },
                {
                    "name": "none",
                    "description": "Produces no line."
                },
                {
                    "name": "solid",
                    "description": "Produces a solid line."
                },
                {
                    "name": "wavy",
                    "description": "Produces a wavy line."
                }
            ],
            "description": "Specifies the line style for underline, line-through and overline text decoration.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-text-size-adjust",
            "browsers": [
                "FF"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Renderers must use the default size adjustment when displaying on a small device."
                },
                {
                    "name": "none",
                    "description": "Renderers must not do size adjustment when displaying on a small device."
                }
            ],
            "description": "Specifies a size adjustment for displaying text content in mobile browsers.",
            "restrictions": [
                "enum",
                "percentage"
            ]
        },
        {
            "name": "-moz-transform",
            "browsers": [
                "FF3.5"
            ],
            "values": [
                {
                    "name": "matrix()",
                    "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
                },
                {
                    "name": "matrix3d()",
                    "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
                },
                {
                    "name": "none"
                },
                {
                    "name": "perspective",
                    "description": "Specifies a perspective projection matrix."
                },
                {
                    "name": "rotate()",
                    "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
                },
                {
                    "name": "rotate3d()",
                    "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
                },
                {
                    "name": "rotateX('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the X axis."
                },
                {
                    "name": "rotateY('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Y axis."
                },
                {
                    "name": "rotateZ('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Z axis."
                },
                {
                    "name": "scale()",
                    "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
                },
                {
                    "name": "scale3d()",
                    "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
                },
                {
                    "name": "scaleX()",
                    "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
                },
                {
                    "name": "scaleY()",
                    "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
                },
                {
                    "name": "scaleZ()",
                    "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
                },
                {
                    "name": "skew()",
                    "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
                },
                {
                    "name": "skewX()",
                    "description": "Specifies a skew transformation along the X axis by the given angle."
                },
                {
                    "name": "skewY()",
                    "description": "Specifies a skew transformation along the Y axis by the given angle."
                },
                {
                    "name": "translate()",
                    "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
                },
                {
                    "name": "translate3d()",
                    "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
                },
                {
                    "name": "translateX()",
                    "description": "Specifies a translation by the given amount in the X direction."
                },
                {
                    "name": "translateY()",
                    "description": "Specifies a translation by the given amount in the Y direction."
                },
                {
                    "name": "translateZ()",
                    "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
                }
            ],
            "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-transform-origin",
            "browsers": [
                "FF3.5"
            ],
            "description": "Establishes the origin of transformation for an element.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-moz-transition",
            "browsers": [
                "FF4"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "description": "Shorthand property combines four of the transition properties into a single property.",
            "restrictions": [
                "time",
                "property",
                "timing-function",
                "enum"
            ]
        },
        {
            "name": "-moz-transition-delay",
            "browsers": [
                "FF4"
            ],
            "description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-moz-transition-duration",
            "browsers": [
                "FF4"
            ],
            "description": "Specifies how long the transition from the old value to the new value should take.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-moz-transition-property",
            "browsers": [
                "FF4"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "description": "Specifies the name of the CSS property to which the transition is applied.",
            "restrictions": [
                "property"
            ]
        },
        {
            "name": "-moz-transition-timing-function",
            "browsers": [
                "FF4"
            ],
            "description": "Describes how the intermediate values used during a transition will be calculated.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "-moz-user-focus",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "ignore"
                },
                {
                    "name": "normal"
                }
            ],
            "status": "nonstandard",
            "syntax": "ignore | normal | select-after | select-before | select-menu | select-same | select-all | none",
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/-moz-user-focus"
                }
            ],
            "description": "Used to indicate whether the element can have focus."
        },
        {
            "name": "-moz-user-select",
            "browsers": [
                "FF1.5"
            ],
            "values": [
                {
                    "name": "all"
                },
                {
                    "name": "element"
                },
                {
                    "name": "elements"
                },
                {
                    "name": "-moz-all"
                },
                {
                    "name": "-moz-none"
                },
                {
                    "name": "none"
                },
                {
                    "name": "text"
                },
                {
                    "name": "toggle"
                }
            ],
            "description": "Controls the appearance of selection.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-accelerator",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "false",
                    "description": "The element does not contain an accelerator key sequence."
                },
                {
                    "name": "true",
                    "description": "The element contains an accelerator key sequence."
                }
            ],
            "status": "nonstandard",
            "syntax": "false | true",
            "description": "IE only. Has the ability to turn off its system underlines for accelerator keys until the ALT key is pressed",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-behavior",
            "browsers": [
                "IE8"
            ],
            "description": "IE only. Used to extend behaviors of the browser",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "-ms-block-progression",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "bt",
                    "description": "Bottom-to-top block flow. Layout is horizontal."
                },
                {
                    "name": "lr",
                    "description": "Left-to-right direction. The flow orientation is vertical."
                },
                {
                    "name": "rl",
                    "description": "Right-to-left direction. The flow orientation is vertical."
                },
                {
                    "name": "tb",
                    "description": "Top-to-bottom direction. The flow orientation is horizontal."
                }
            ],
            "status": "nonstandard",
            "syntax": "tb | rl | bt | lr",
            "description": "Sets the block-progression value and the flow orientation",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-content-zoom-chaining",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "chained",
                    "description": "The nearest zoomable parent element begins zooming when the user hits a zoom limit during a manipulation. No bounce effect is shown."
                },
                {
                    "name": "none",
                    "description": "A bounce effect is shown when the user hits a zoom limit during a manipulation."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | chained",
            "description": "Specifies the zoom behavior that occurs when a user hits the zoom limit during a manipulation."
        },
        {
            "name": "-ms-content-zooming",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The element is not zoomable."
                },
                {
                    "name": "zoom",
                    "description": "The element is zoomable."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | zoom",
            "description": "Specifies whether zooming is enabled.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-content-zoom-limit",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>",
            "description": "Shorthand property for the -ms-content-zoom-limit-min and -ms-content-zoom-limit-max properties.",
            "restrictions": [
                "percentage"
            ]
        },
        {
            "name": "-ms-content-zoom-limit-max",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<percentage>",
            "description": "Specifies the maximum zoom factor.",
            "restrictions": [
                "percentage"
            ]
        },
        {
            "name": "-ms-content-zoom-limit-min",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<percentage>",
            "description": "Specifies the minimum zoom factor.",
            "restrictions": [
                "percentage"
            ]
        },
        {
            "name": "-ms-content-zoom-snap",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "mandatory",
                    "description": "Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."
                },
                {
                    "name": "none",
                    "description": "Indicates that zooming is unaffected by any defined snap-points."
                },
                {
                    "name": "proximity",
                    "description": "Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop \"close enough\" to a snap-point."
                },
                {
                    "name": "snapInterval(100%, 100%)",
                    "description": "Specifies where the snap-points will be placed."
                },
                {
                    "name": "snapList()",
                    "description": "Specifies the position of individual snap-points as a comma-separated list of zoom factors."
                }
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-content-zoom-snap-type'> || <'-ms-content-zoom-snap-points'>",
            "description": "Shorthand property for the -ms-content-zoom-snap-type and -ms-content-zoom-snap-points properties."
        },
        {
            "name": "-ms-content-zoom-snap-points",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "snapInterval(100%, 100%)",
                    "description": "Specifies where the snap-points will be placed."
                },
                {
                    "name": "snapList()",
                    "description": "Specifies the position of individual snap-points as a comma-separated list of zoom factors."
                }
            ],
            "status": "nonstandard",
            "syntax": "snapInterval( <percentage>, <percentage> ) | snapList( <percentage># )",
            "description": "Defines where zoom snap-points are located."
        },
        {
            "name": "-ms-content-zoom-snap-type",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "mandatory",
                    "description": "Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."
                },
                {
                    "name": "none",
                    "description": "Indicates that zooming is unaffected by any defined snap-points."
                },
                {
                    "name": "proximity",
                    "description": "Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop \"close enough\" to a snap-point."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | proximity | mandatory",
            "description": "Specifies how zooming is affected by defined snap-points.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-filter",
            "browsers": [
                "IE8-9"
            ],
            "status": "nonstandard",
            "syntax": "<string>",
            "description": "IE only. Used to produce visual effects.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "-ms-flex",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Retrieves the value of the main size property as the used 'flex-basis'."
                },
                {
                    "name": "none",
                    "description": "Expands to '0 0 auto'."
                }
            ],
            "description": "specifies the parameters of a flexible length: the positive and negative flexibility, and the preferred size.",
            "restrictions": [
                "length",
                "number",
                "percentage"
            ]
        },
        {
            "name": "-ms-flex-align",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "baseline",
                    "description": "If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
                },
                {
                    "name": "center",
                    "description": "The flex item’s margin box is centered in the cross axis within the line."
                },
                {
                    "name": "end",
                    "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
                },
                {
                    "name": "start",
                    "description": "The cross-start margin edge of the flexbox item is placed flush with the cross-start edge of the line."
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flexbox item is anything other than 'auto', this value is identical to 'start'."
                }
            ],
            "description": "Aligns flex items along the cross axis of the current line of the flex container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-direction",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "column",
                    "description": "The flex container’s main axis has the same orientation as the block axis of the current writing mode."
                },
                {
                    "name": "column-reverse",
                    "description": "Same as 'column', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "row",
                    "description": "The flex container’s main axis has the same orientation as the inline axis of the current writing mode."
                },
                {
                    "name": "row-reverse",
                    "description": "Same as 'row', except the main-start and main-end directions are swapped."
                }
            ],
            "description": "Specifies how flex items are placed in the flex container, by setting the direction of the flex container’s main axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-flow",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "column",
                    "description": "The flex container’s main axis has the same orientation as the block axis of the current writing mode."
                },
                {
                    "name": "column-reverse",
                    "description": "Same as 'column', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "nowrap",
                    "description": "The flex container is single-line."
                },
                {
                    "name": "row",
                    "description": "The flex container’s main axis has the same orientation as the inline axis of the current writing mode."
                },
                {
                    "name": "wrap",
                    "description": "The flexbox is multi-line."
                },
                {
                    "name": "wrap-reverse",
                    "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
                }
            ],
            "description": "Specifies how flexbox items are placed in the flexbox.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-item-align",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Computes to the value of 'align-items' on the element’s parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."
                },
                {
                    "name": "baseline",
                    "description": "If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
                },
                {
                    "name": "center",
                    "description": "The flex item’s margin box is centered in the cross axis within the line."
                },
                {
                    "name": "end",
                    "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
                },
                {
                    "name": "start",
                    "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                }
            ],
            "description": "Allows the default alignment along the cross axis to be overridden for individual flex items.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-line-pack",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Lines are packed toward the center of the flex container."
                },
                {
                    "name": "distribute",
                    "description": "Lines are evenly distributed in the flex container, with half-size spaces on either end."
                },
                {
                    "name": "end",
                    "description": "Lines are packed toward the end of the flex container."
                },
                {
                    "name": "justify",
                    "description": "Lines are evenly distributed in the flex container."
                },
                {
                    "name": "start",
                    "description": "Lines are packed toward the start of the flex container."
                },
                {
                    "name": "stretch",
                    "description": "Lines stretch to take up the remaining space."
                }
            ],
            "description": "Aligns a flex container’s lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-order",
            "browsers": [
                "IE10"
            ],
            "description": "Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-flex-pack",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Flex items are packed toward the center of the line."
                },
                {
                    "name": "distribute",
                    "description": "Flex items are evenly distributed in the line, with half-size spaces on either end."
                },
                {
                    "name": "end",
                    "description": "Flex items are packed toward the end of the line."
                },
                {
                    "name": "justify",
                    "description": "Flex items are evenly distributed in the line."
                },
                {
                    "name": "start",
                    "description": "Flex items are packed toward the start of the line."
                }
            ],
            "description": "Aligns flex items along the main axis of the current line of the flex container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-wrap",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "nowrap",
                    "description": "The flex container is single-line."
                },
                {
                    "name": "wrap",
                    "description": "The flexbox is multi-line."
                },
                {
                    "name": "wrap-reverse",
                    "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
                }
            ],
            "description": "Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flow-from",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The block container is not a CSS Region."
                }
            ],
            "status": "nonstandard",
            "syntax": "[ none | <custom-ident> ]#",
            "description": "Makes a block container a region and associates it with a named flow.",
            "restrictions": [
                "identifier"
            ]
        },
        {
            "name": "-ms-flow-into",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The element is not moved to a named flow and normal CSS processing takes place."
                }
            ],
            "status": "nonstandard",
            "syntax": "[ none | <custom-ident> ]#",
            "description": "Places an element or its contents into a named flow.",
            "restrictions": [
                "identifier"
            ]
        },
        {
            "name": "-ms-grid-column",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "end"
                },
                {
                    "name": "start"
                }
            ],
            "description": "Used to place grid items and explicitly defined grid cells in the Grid.",
            "restrictions": [
                "integer",
                "string",
                "enum"
            ]
        },
        {
            "name": "-ms-grid-column-align",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Places the center of the Grid Item's margin box at the center of the Grid Item's column."
                },
                {
                    "name": "end",
                    "description": "Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's column."
                },
                {
                    "name": "start",
                    "description": "Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's column."
                },
                {
                    "name": "stretch",
                    "description": "Ensures that the Grid Item's margin box is equal to the size of the Grid Item's column."
                }
            ],
            "description": "Aligns the columns in a grid.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-grid-columns",
            "browsers": [
                "E",
                "IE10"
            ],
            "description": "Lays out the columns of the grid."
        },
        {
            "name": "-ms-grid-column-span",
            "browsers": [
                "E",
                "IE10"
            ],
            "description": "Specifies the number of columns to span.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-grid-layer",
            "browsers": [
                "E",
                "IE10"
            ],
            "description": "Grid-layer is similar in concept to z-index, but avoids overloading the meaning of the z-index property, which is applicable only to positioned elements.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-grid-row",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "end"
                },
                {
                    "name": "start"
                }
            ],
            "description": "grid-row is used to place grid items and explicitly defined grid cells in the Grid.",
            "restrictions": [
                "integer",
                "string",
                "enum"
            ]
        },
        {
            "name": "-ms-grid-row-align",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Places the center of the Grid Item's margin box at the center of the Grid Item's row."
                },
                {
                    "name": "end",
                    "description": "Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's row."
                },
                {
                    "name": "start",
                    "description": "Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's row."
                },
                {
                    "name": "stretch",
                    "description": "Ensures that the Grid Item's margin box is equal to the size of the Grid Item's row."
                }
            ],
            "description": "Aligns the rows in a grid.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-grid-rows",
            "browsers": [
                "E",
                "IE10"
            ],
            "description": "Lays out the columns of the grid."
        },
        {
            "name": "-ms-grid-row-span",
            "browsers": [
                "E",
                "IE10"
            ],
            "description": "Specifies the number of rows to span.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-high-contrast-adjust",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Properties will be adjusted as applicable."
                },
                {
                    "name": "none",
                    "description": "No adjustments will be applied."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | none",
            "description": "Specifies if properties should be adjusted in high contrast mode.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-hyphenate-limit-chars",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent chooses a value that adapts to the current layout."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | <integer>{1,3}",
            "description": "Specifies the minimum number of characters in a hyphenated word.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-hyphenate-limit-lines",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "no-limit",
                    "description": "There is no limit."
                }
            ],
            "status": "nonstandard",
            "syntax": "no-limit | <integer>",
            "description": "Indicates the maximum number of successive hyphenated lines in an element.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-hyphenate-limit-zone",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<percentage> | <length>",
            "description": "Specifies the maximum amount of unfilled space (before justification) that may be left in the line box before hyphenation is triggered to pull part of a word from the next line back up into the current line.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "-ms-hyphens",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
                },
                {
                    "name": "manual",
                    "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
                },
                {
                    "name": "none",
                    "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
                }
            ],
            "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-ime-mode",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "active",
                    "description": "The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."
                },
                {
                    "name": "auto",
                    "description": "No change is made to the current input method editor state. This is the default."
                },
                {
                    "name": "disabled",
                    "description": "The input method editor is disabled and may not be activated by the user."
                },
                {
                    "name": "inactive",
                    "description": "The input method editor is initially inactive, but the user may activate it if they wish."
                },
                {
                    "name": "normal",
                    "description": "The IME state should be normal; this value can be used in a user style sheet to override the page setting."
                }
            ],
            "description": "Controls the state of the input method editor for text fields.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-interpolation-mode",
            "browsers": [
                "IE7"
            ],
            "values": [
                {
                    "name": "bicubic"
                },
                {
                    "name": "nearest-neighbor"
                }
            ],
            "description": "Gets or sets the interpolation (resampling) method used to stretch images.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-layout-grid",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "char",
                    "description": "Any of the range of character values available to the -ms-layout-grid-char property."
                },
                {
                    "name": "line",
                    "description": "Any of the range of line values available to the -ms-layout-grid-line property."
                },
                {
                    "name": "mode",
                    "description": "Any of the range of mode values available to the -ms-layout-grid-mode property."
                },
                {
                    "name": "type",
                    "description": "Any of the range of type values available to the -ms-layout-grid-type property."
                }
            ],
            "description": "Sets or retrieves the composite document grid properties that specify the layout of text characters."
        },
        {
            "name": "-ms-layout-grid-char",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Largest character in the font of the element is used to set the character grid."
                },
                {
                    "name": "none",
                    "description": "Default. No character grid is set."
                }
            ],
            "description": "Sets or retrieves the size of the character grid used for rendering the text content of an element.",
            "restrictions": [
                "enum",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-layout-grid-line",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Largest character in the font of the element is used to set the character grid."
                },
                {
                    "name": "none",
                    "description": "Default. No grid line is set."
                }
            ],
            "description": "Sets or retrieves the gridline value used for rendering the text content of an element.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-layout-grid-mode",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "both",
                    "description": "Default. Both the char and line grid modes are enabled. This setting is necessary to fully enable the layout grid on an element."
                },
                {
                    "name": "char",
                    "description": "Only a character grid is used. This is recommended for use with block-level elements, such as a blockquote, where the line grid is intended to be disabled."
                },
                {
                    "name": "line",
                    "description": "Only a line grid is used. This is recommended for use with inline elements, such as a span, to disable the horizontal grid on runs of text that act as a single entity in the grid layout."
                },
                {
                    "name": "none",
                    "description": "No grid is used."
                }
            ],
            "description": "Gets or sets whether the text layout grid uses two dimensions.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-layout-grid-type",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "fixed",
                    "description": "Grid used for monospaced layout. All noncursive characters are treated as equal; every character is centered within a single grid space by default."
                },
                {
                    "name": "loose",
                    "description": "Default. Grid used for Japanese and Korean characters."
                },
                {
                    "name": "strict",
                    "description": "Grid used for Chinese, as well as Japanese (Genko) and Korean characters. Only the ideographs, kanas, and wide characters are snapped to the grid."
                }
            ],
            "description": "Sets or retrieves the type of grid used for rendering the text content of an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-line-break",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."
                },
                {
                    "name": "keep-all",
                    "description": "Sequences of CJK characters can no longer break on implied break points. This option should only be used where the presence of word separator characters still creates line-breaking opportunities, as in Korean."
                },
                {
                    "name": "newspaper",
                    "description": "Breaks CJK scripts using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."
                },
                {
                    "name": "normal",
                    "description": "Breaks CJK scripts using a normal set of line-breaking rules."
                },
                {
                    "name": "strict",
                    "description": "Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."
                }
            ],
            "description": "Specifies what set of line breaking restrictions are in effect within the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-overflow-style",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "No preference, UA should use the first scrolling method in the list that it supports."
                },
                {
                    "name": "-ms-autohiding-scrollbar",
                    "description": "Indicates the element displays auto-hiding scrollbars during mouse interactions and panning indicators during touch and keyboard interactions."
                },
                {
                    "name": "none",
                    "description": "Indicates the element does not display scrollbars or panning indicators, even when its content overflows."
                },
                {
                    "name": "scrollbar",
                    "description": "Scrollbars are typically narrow strips inserted on one or two edges of an element and which often have arrows to click on and a \"thumb\" to drag up and down (or left and right) to move the contents of the element."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | none | scrollbar | -ms-autohiding-scrollbar",
            "description": "Specify whether content is clipped when it overflows the element's content area.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-perspective",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No perspective transform is applied."
                }
            ],
            "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-perspective-origin",
            "browsers": [
                "IE10"
            ],
            "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "-ms-perspective-origin-x",
            "browsers": [
                "IE10"
            ],
            "description": "Establishes the origin for the perspective property. It effectively sets the X  position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "-ms-perspective-origin-y",
            "browsers": [
                "IE10"
            ],
            "description": "Establishes the origin for the perspective property. It effectively sets the Y position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "-ms-progress-appearance",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "bar"
                },
                {
                    "name": "ring"
                }
            ],
            "description": "Gets or sets a value that specifies whether a progress control displays as a bar or a ring.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scrollbar-3dlight-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-arrow-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "description": "Determines the color of the arrow elements of a scroll arrow.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-base-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "description": "Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-darkshadow-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "description": "Determines the color of the gutter of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-face-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "description": "Determines the color of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-highlight-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-shadow-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "description": "Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-track-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "description": "Determines the color of the track element of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scroll-chaining",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "chained"
                },
                {
                    "name": "none"
                }
            ],
            "status": "nonstandard",
            "syntax": "chained | none",
            "description": "Gets or sets a value that indicates the scrolling behavior that occurs when a user hits the content boundary during a manipulation.",
            "restrictions": [
                "enum",
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>",
            "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-limit-x-min, -ms-scroll-limit-y-min, -ms-scroll-limit-x-max, and -ms-scroll-limit-y-max properties.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit-x-max",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | <length>",
            "description": "Gets or sets a value that specifies the maximum value for the scrollLeft property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit-x-min",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<length>",
            "description": "Gets or sets a value that specifies the minimum value for the scrollLeft property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit-y-max",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | <length>",
            "description": "Gets or sets a value that specifies the maximum value for the scrollTop property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit-y-min",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<length>",
            "description": "Gets or sets a value that specifies the minimum value for the scrollTop property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-rails",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none"
                },
                {
                    "name": "railed"
                }
            ],
            "status": "nonstandard",
            "syntax": "none | railed",
            "description": "Gets or sets a value that indicates whether or not small motions perpendicular to the primary axis of motion will result in either changes to both the scrollTop and scrollLeft properties or a change to the primary axis (for instance, either the scrollTop or scrollLeft properties will change, but not both).",
            "restrictions": [
                "enum",
                "length"
            ]
        },
        {
            "name": "-ms-scroll-snap-points-x",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "snapInterval(100%, 100%)"
                },
                {
                    "name": "snapList()"
                }
            ],
            "status": "nonstandard",
            "syntax": "snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",
            "description": "Gets or sets a value that defines where snap-points will be located along the x-axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-snap-points-y",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "snapInterval(100%, 100%)"
                },
                {
                    "name": "snapList()"
                }
            ],
            "status": "nonstandard",
            "syntax": "snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",
            "description": "Gets or sets a value that defines where snap-points will be located along the y-axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-snap-type",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The visual viewport of this scroll container must ignore snap points, if any, when scrolled."
                },
                {
                    "name": "mandatory",
                    "description": "The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."
                },
                {
                    "name": "proximity",
                    "description": "The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | proximity | mandatory",
            "description": "Gets or sets a value that defines what type of snap-point should be used for the current element. There are two type of snap-points, with the primary difference being whether or not the user is guaranteed to always stop on a snap-point.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-snap-x",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "mandatory"
                },
                {
                    "name": "none"
                },
                {
                    "name": "proximity"
                },
                {
                    "name": "snapInterval(100%, 100%)"
                },
                {
                    "name": "snapList()"
                }
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>",
            "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-x properties.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-snap-y",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "mandatory"
                },
                {
                    "name": "none"
                },
                {
                    "name": "proximity"
                },
                {
                    "name": "snapInterval(100%, 100%)"
                },
                {
                    "name": "snapList()"
                }
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>",
            "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-y properties.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-translation",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none"
                },
                {
                    "name": "vertical-to-horizontal"
                }
            ],
            "status": "nonstandard",
            "syntax": "none | vertical-to-horizontal",
            "description": "Gets or sets a value that specifies whether vertical-to-horizontal scroll wheel translation occurs on the specified element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-align-last",
            "browsers": [
                "E",
                "IE8"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "center",
                    "description": "The inline contents are centered within the line box."
                },
                {
                    "name": "justify",
                    "description": "The text is justified according to the method specified by the 'text-justify' property."
                },
                {
                    "name": "left",
                    "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
                },
                {
                    "name": "right",
                    "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
                }
            ],
            "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-autospace",
            "browsers": [
                "E",
                "IE8"
            ],
            "values": [
                {
                    "name": "ideograph-alpha",
                    "description": "Creates 1/4em extra spacing between runs of ideographic letters and non-ideographic letters, such as Latin-based, Cyrillic, Greek, Arabic or Hebrew."
                },
                {
                    "name": "ideograph-numeric",
                    "description": "Creates 1/4em extra spacing between runs of ideographic letters and numeric glyphs."
                },
                {
                    "name": "ideograph-parenthesis",
                    "description": "Creates extra spacing between normal (non wide) parenthesis and ideographs."
                },
                {
                    "name": "ideograph-space",
                    "description": "Extends the width of the space character while surrounded by ideographs."
                },
                {
                    "name": "none",
                    "description": "No extra space is created."
                },
                {
                    "name": "punctuation",
                    "description": "Creates extra non-breaking spacing around punctuation as required by language-specific typographic conventions."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | ideograph-alpha | ideograph-numeric | ideograph-parenthesis | ideograph-space",
            "description": "Determines whether or not a full-width punctuation mark character should be trimmed if it appears at the beginning of a line, so that its 'ink' lines up with the first glyph in the line above and below.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-combine-horizontal",
            "browsers": [
                "E",
                "IE11"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Attempt to typeset horizontally all consecutive characters within the box such that they take up the space of a single character within the vertical line box."
                },
                {
                    "name": "digits",
                    "description": "Attempt to typeset horizontally each maximal sequence of consecutive ASCII digits (U+0030–U+0039) that has as many or fewer characters than the specified integer such that it takes up the space of a single character within the vertical line box."
                },
                {
                    "name": "none",
                    "description": "No special processing."
                }
            ],
            "description": "This property specifies the combination of multiple characters into the space of a single character.",
            "restrictions": [
                "enum",
                "integer"
            ]
        },
        {
            "name": "-ms-text-justify",
            "browsers": [
                "E",
                "IE8"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."
                },
                {
                    "name": "distribute",
                    "description": "Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."
                },
                {
                    "name": "inter-cluster",
                    "description": "Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."
                },
                {
                    "name": "inter-ideograph",
                    "description": "Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."
                },
                {
                    "name": "inter-word",
                    "description": "Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."
                },
                {
                    "name": "kashida",
                    "description": "Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."
                }
            ],
            "description": "Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-kashida-space",
            "browsers": [
                "E",
                "IE10"
            ],
            "description": "Sets or retrieves the ratio of kashida expansion to white space expansion when justifying lines of text in the object.",
            "restrictions": [
                "percentage"
            ]
        },
        {
            "name": "-ms-text-overflow",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "clip",
                    "description": "Clip inline content that overflows. Characters may be only partially rendered."
                },
                {
                    "name": "ellipsis",
                    "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
                }
            ],
            "description": "Text can overflow for example when it is prevented from wrapping",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-size-adjust",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Renderers must use the default size adjustment when displaying on a small device."
                },
                {
                    "name": "none",
                    "description": "Renderers must not do size adjustment when displaying on a small device."
                }
            ],
            "description": "Specifies a size adjustment for displaying text content in mobile browsers.",
            "restrictions": [
                "enum",
                "percentage"
            ]
        },
        {
            "name": "-ms-text-underline-position",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "alphabetic",
                    "description": "The underline is aligned with the alphabetic baseline. In this case the underline is likely to cross some descenders."
                },
                {
                    "name": "auto",
                    "description": "The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."
                },
                {
                    "name": "over",
                    "description": "The underline is aligned with the 'top' (right in vertical writing) edge of the element's em-box. In this mode, an overline also switches sides."
                },
                {
                    "name": "under",
                    "description": "The underline is aligned with the 'bottom' (left in vertical writing) edge of the element's em-box. In this case the underline usually does not cross the descenders. This is sometimes called 'accounting' underline."
                }
            ],
            "description": "Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements.This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-touch-action",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The element is a passive element, with several exceptions."
                },
                {
                    "name": "double-tap-zoom",
                    "description": "The element will zoom on double-tap."
                },
                {
                    "name": "manipulation",
                    "description": "The element is a manipulation-causing element."
                },
                {
                    "name": "none",
                    "description": "The element is a manipulation-blocking element."
                },
                {
                    "name": "pan-x",
                    "description": "The element permits touch-driven panning on the horizontal axis. The touch pan is performed on the nearest ancestor with horizontally scrollable content."
                },
                {
                    "name": "pan-y",
                    "description": "The element permits touch-driven panning on the vertical axis. The touch pan is performed on the nearest ancestor with vertically scrollable content."
                },
                {
                    "name": "pinch-zoom",
                    "description": "The element permits pinch-zooming. The pinch-zoom is performed on the nearest ancestor with zoomable content."
                }
            ],
            "description": "Gets or sets a value that indicates whether and how a given region can be manipulated by the user.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-touch-select",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "grippers",
                    "description": "Grippers are always on."
                },
                {
                    "name": "none",
                    "description": "Grippers are always off."
                }
            ],
            "status": "nonstandard",
            "syntax": "grippers | none",
            "description": "Gets or sets a value that toggles the 'gripper' visual elements that enable touch text selection.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-transform",
            "browsers": [
                "IE9-9"
            ],
            "values": [
                {
                    "name": "matrix()",
                    "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
                },
                {
                    "name": "matrix3d()",
                    "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
                },
                {
                    "name": "none"
                },
                {
                    "name": "rotate()",
                    "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
                },
                {
                    "name": "rotate3d()",
                    "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
                },
                {
                    "name": "rotateX('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the X axis."
                },
                {
                    "name": "rotateY('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Y axis."
                },
                {
                    "name": "rotateZ('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Z axis."
                },
                {
                    "name": "scale()",
                    "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
                },
                {
                    "name": "scale3d()",
                    "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
                },
                {
                    "name": "scaleX()",
                    "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
                },
                {
                    "name": "scaleY()",
                    "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
                },
                {
                    "name": "scaleZ()",
                    "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
                },
                {
                    "name": "skew()",
                    "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
                },
                {
                    "name": "skewX()",
                    "description": "Specifies a skew transformation along the X axis by the given angle."
                },
                {
                    "name": "skewY()",
                    "description": "Specifies a skew transformation along the Y axis by the given angle."
                },
                {
                    "name": "translate()",
                    "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
                },
                {
                    "name": "translate3d()",
                    "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
                },
                {
                    "name": "translateX()",
                    "description": "Specifies a translation by the given amount in the X direction."
                },
                {
                    "name": "translateY()",
                    "description": "Specifies a translation by the given amount in the Y direction."
                },
                {
                    "name": "translateZ()",
                    "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
                }
            ],
            "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-transform-origin",
            "browsers": [
                "IE9-9"
            ],
            "description": "Establishes the origin of transformation for an element.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-transform-origin-x",
            "browsers": [
                "IE10"
            ],
            "description": "The x coordinate of the origin for transforms applied to an element with respect to its border box.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-transform-origin-y",
            "browsers": [
                "IE10"
            ],
            "description": "The y coordinate of the origin for transforms applied to an element with respect to its border box.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-transform-origin-z",
            "browsers": [
                "IE10"
            ],
            "description": "The z coordinate of the origin for transforms applied to an element with respect to its border box.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-user-select",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "element"
                },
                {
                    "name": "none"
                },
                {
                    "name": "text"
                }
            ],
            "status": "nonstandard",
            "syntax": "none | element | text",
            "description": "Controls the appearance of selection.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-word-break",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "break-all",
                    "description": "Lines may break between any two grapheme clusters for non-CJK scripts."
                },
                {
                    "name": "keep-all",
                    "description": "Block characters can no longer create implied break points."
                },
                {
                    "name": "normal",
                    "description": "Breaks non-CJK scripts according to their own rules."
                }
            ],
            "description": "Specifies line break opportunities for non-CJK scripts.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-word-wrap",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "break-word",
                    "description": "An unbreakable 'word' may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."
                },
                {
                    "name": "normal",
                    "description": "Lines may break only at allowed break points."
                }
            ],
            "description": "Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-wrap-flow",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For floats an exclusion is created, for all other elements an exclusion is not created."
                },
                {
                    "name": "both",
                    "description": "Inline flow content can flow on all sides of the exclusion."
                },
                {
                    "name": "clear",
                    "description": "Inline flow content can only wrap on top and bottom of the exclusion and must leave the areas to the start and end edges of the exclusion box empty."
                },
                {
                    "name": "end",
                    "description": "Inline flow content can wrap on the end side of the exclusion area but must leave the area to the start edge of the exclusion area empty."
                },
                {
                    "name": "maximum",
                    "description": "Inline flow content can wrap on the side of the exclusion with the largest available space for the given line, and must leave the other side of the exclusion empty."
                },
                {
                    "name": "minimum",
                    "description": "Inline flow content can flow around the edge of the exclusion with the smallest available space within the flow content’s containing block, and must leave the other edge of the exclusion empty."
                },
                {
                    "name": "start",
                    "description": "Inline flow content can wrap on the start edge of the exclusion area but must leave the area to end edge of the exclusion area empty."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | both | start | end | maximum | clear",
            "description": "An element becomes an exclusion when its 'wrap-flow' property has a computed value other than 'auto'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-wrap-margin",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<length>",
            "description": "Gets or sets a value that is used to offset the inner wrap shape from other shapes.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-wrap-through",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The exclusion element does not inherit its parent node's wrapping context. Its descendants are only subject to exclusion shapes defined inside the element."
                },
                {
                    "name": "wrap",
                    "description": "The exclusion element inherits its parent node's wrapping context. Its descendant inline content wraps around exclusions defined outside the element."
                }
            ],
            "status": "nonstandard",
            "syntax": "wrap | none",
            "description": "Specifies if an element inherits its parent wrapping context. In other words if it is subject to the exclusions defined outside the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-writing-mode",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "bt-lr"
                },
                {
                    "name": "bt-rl"
                },
                {
                    "name": "lr-bt"
                },
                {
                    "name": "lr-tb"
                },
                {
                    "name": "rl-bt"
                },
                {
                    "name": "rl-tb"
                },
                {
                    "name": "tb-lr"
                },
                {
                    "name": "tb-rl"
                }
            ],
            "description": "Shorthand property for both 'direction' and 'block-progression'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-zoom",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "normal"
                }
            ],
            "description": "Sets or retrieves the magnification scale of the object.",
            "restrictions": [
                "enum",
                "integer",
                "number",
                "percentage"
            ]
        },
        {
            "name": "-ms-zoom-animation",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "default"
                },
                {
                    "name": "none"
                }
            ],
            "description": "Gets or sets a value that indicates whether an animation is used when zooming.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "nav-down",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
                },
                {
                    "name": "current",
                    "description": "Indicates that the user agent should target the frame that the element is in."
                },
                {
                    "name": "root",
                    "description": "Indicates that the user agent should target the full window."
                }
            ],
            "description": "Provides an way to control directional focus navigation.",
            "restrictions": [
                "enum",
                "identifier",
                "string"
            ]
        },
        {
            "name": "nav-index",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The element's sequential navigation order is assigned automatically by the user agent."
                }
            ],
            "description": "Provides an input-method-neutral way of specifying the sequential navigation order (also known as 'tabbing order').",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "nav-left",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
                },
                {
                    "name": "current",
                    "description": "Indicates that the user agent should target the frame that the element is in."
                },
                {
                    "name": "root",
                    "description": "Indicates that the user agent should target the full window."
                }
            ],
            "description": "Provides an way to control directional focus navigation.",
            "restrictions": [
                "enum",
                "identifier",
                "string"
            ]
        },
        {
            "name": "nav-right",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
                },
                {
                    "name": "current",
                    "description": "Indicates that the user agent should target the frame that the element is in."
                },
                {
                    "name": "root",
                    "description": "Indicates that the user agent should target the full window."
                }
            ],
            "description": "Provides an way to control directional focus navigation.",
            "restrictions": [
                "enum",
                "identifier",
                "string"
            ]
        },
        {
            "name": "nav-up",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
                },
                {
                    "name": "current",
                    "description": "Indicates that the user agent should target the frame that the element is in."
                },
                {
                    "name": "root",
                    "description": "Indicates that the user agent should target the full window."
                }
            ],
            "description": "Provides an way to control directional focus navigation.",
            "restrictions": [
                "enum",
                "identifier",
                "string"
            ]
        },
        {
            "name": "negative",
            "browsers": [
                "FF33"
            ],
            "syntax": "<symbol> <symbol>?",
            "description": "@counter-style descriptor. Defines how to alter the representation when the counter value is negative.",
            "restrictions": [
                "image",
                "identifier",
                "string"
            ]
        },
        {
            "name": "-o-animation",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "backwards",
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                },
                {
                    "name": "none",
                    "description": "No animation is performed"
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "description": "Shorthand property combines six of the animation properties into a single property.",
            "restrictions": [
                "time",
                "enum",
                "timing-function",
                "identifier",
                "number"
            ]
        },
        {
            "name": "-o-animation-delay",
            "browsers": [
                "O12"
            ],
            "description": "Defines when the animation will start.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-o-animation-direction",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-animation-duration",
            "browsers": [
                "O12"
            ],
            "description": "Defines the length of time that an animation takes to complete one cycle.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-o-animation-fill-mode",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "backwards",
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "none",
                    "description": "There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."
                }
            ],
            "description": "Defines what values are applied by the animation outside the time it is executing.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-animation-iteration-count",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                }
            ],
            "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
            "restrictions": [
                "number",
                "enum"
            ]
        },
        {
            "name": "-o-animation-name",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No animation is performed"
                }
            ],
            "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
            "restrictions": [
                "identifier",
                "enum"
            ]
        },
        {
            "name": "-o-animation-play-state",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "paused",
                    "description": "A running animation will be paused."
                },
                {
                    "name": "running",
                    "description": "Resume playback of a paused animation."
                }
            ],
            "description": "Defines whether the animation is running or paused.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-animation-timing-function",
            "browsers": [
                "O12"
            ],
            "description": "Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "-o-border-image",
            "browsers": [
                "O11.6"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
                },
                {
                    "name": "fill",
                    "description": "Causes the middle part of the border-image to be preserved."
                },
                {
                    "name": "none"
                },
                {
                    "name": "repeat",
                    "description": "The image is tiled (repeated) to fill the area."
                },
                {
                    "name": "round",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
                },
                {
                    "name": "space",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
                },
                {
                    "name": "stretch",
                    "description": "The image is stretched to fill the area."
                }
            ],
            "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "percentage",
                "number",
                "image",
                "enum"
            ]
        },
        {
            "name": "-o-object-fit",
            "browsers": [
                "O10.6"
            ],
            "values": [
                {
                    "name": "contain",
                    "description": "The replaced content is sized to maintain its aspect ratio while fitting within the element’s content box: its concrete object size is resolved as a contain constraint against the element's used width and height."
                },
                {
                    "name": "cover",
                    "description": "The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element’s used width and height."
                },
                {
                    "name": "fill",
                    "description": "The replaced content is sized to fill the element’s content box: the object's concrete object size is the element's used width and height."
                },
                {
                    "name": "none",
                    "description": "The replaced content is not resized to fit inside the element's content box"
                },
                {
                    "name": "scale-down",
                    "description": "Size the content as if ‘none’ or ‘contain’ were specified, whichever would result in a smaller concrete object size."
                }
            ],
            "description": "Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-object-position",
            "browsers": [
                "O10.6"
            ],
            "description": "Determines the alignment of the replaced element inside its box.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-o-table-baseline",
            "browsers": [
                "O9.6"
            ],
            "description": "Determines which row of a inline-table should be used as baseline of inline-table.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-o-tab-size",
            "browsers": [
                "O10.6"
            ],
            "description": "This property determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",
            "restrictions": [
                "integer",
                "length"
            ]
        },
        {
            "name": "-o-text-overflow",
            "browsers": [
                "O10"
            ],
            "values": [
                {
                    "name": "clip",
                    "description": "Clip inline content that overflows. Characters may be only partially rendered."
                },
                {
                    "name": "ellipsis",
                    "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
                }
            ],
            "description": "Text can overflow for example when it is prevented from wrapping",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-transform",
            "browsers": [
                "O10.5"
            ],
            "values": [
                {
                    "name": "matrix()",
                    "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
                },
                {
                    "name": "matrix3d()",
                    "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
                },
                {
                    "name": "none"
                },
                {
                    "name": "rotate()",
                    "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
                },
                {
                    "name": "rotate3d()",
                    "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
                },
                {
                    "name": "rotateX('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the X axis."
                },
                {
                    "name": "rotateY('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Y axis."
                },
                {
                    "name": "rotateZ('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Z axis."
                },
                {
                    "name": "scale()",
                    "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
                },
                {
                    "name": "scale3d()",
                    "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
                },
                {
                    "name": "scaleX()",
                    "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
                },
                {
                    "name": "scaleY()",
                    "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
                },
                {
                    "name": "scaleZ()",
                    "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
                },
                {
                    "name": "skew()",
                    "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
                },
                {
                    "name": "skewX()",
                    "description": "Specifies a skew transformation along the X axis by the given angle."
                },
                {
                    "name": "skewY()",
                    "description": "Specifies a skew transformation along the Y axis by the given angle."
                },
                {
                    "name": "translate()",
                    "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
                },
                {
                    "name": "translate3d()",
                    "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
                },
                {
                    "name": "translateX()",
                    "description": "Specifies a translation by the given amount in the X direction."
                },
                {
                    "name": "translateY()",
                    "description": "Specifies a translation by the given amount in the Y direction."
                },
                {
                    "name": "translateZ()",
                    "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
                }
            ],
            "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-transform-origin",
            "browsers": [
                "O10.5"
            ],
            "description": "Establishes the origin of transformation for an element.",
            "restrictions": [
                "positon",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-o-transition",
            "browsers": [
                "O11.5"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "description": "Shorthand property combines four of the transition properties into a single property.",
            "restrictions": [
                "time",
                "property",
                "timing-function",
                "enum"
            ]
        },
        {
            "name": "-o-transition-delay",
            "browsers": [
                "O11.5"
            ],
            "description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-o-transition-duration",
            "browsers": [
                "O11.5"
            ],
            "description": "Specifies how long the transition from the old value to the new value should take.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-o-transition-property",
            "browsers": [
                "O11.5"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "description": "Specifies the name of the CSS property to which the transition is applied.",
            "restrictions": [
                "property"
            ]
        },
        {
            "name": "-o-transition-timing-function",
            "browsers": [
                "O11.5"
            ],
            "description": "Describes how the intermediate values used during a transition will be calculated.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "offset-block-end",
            "browsers": [
                "FF41"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
                }
            ],
            "description": "Logical 'bottom'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "offset-block-start",
            "browsers": [
                "FF41"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
                }
            ],
            "description": "Logical 'top'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "offset-inline-end",
            "browsers": [
                "FF41"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
                }
            ],
            "description": "Logical 'right'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "offset-inline-start",
            "browsers": [
                "FF41"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
                }
            ],
            "description": "Logical 'left'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "len