# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['_boot',
 '_onewire',
 '_uasyncio',
 'apa102',
 'array',
 'binascii',
 'btree',
 'collections',
 'dht',
 'ds18x20',
 'errno',
 'esp',
 'flashbdev',
 'framebuf',
 'gc',
 'hashlib',
 'heapq',
 'inisetup',
 'io',
 'json',
 'lwip',
 'machine',
 'math',
 'micropython',
 'neopixel',
 'network',
 'ntptime',
 'onewire',
 'os',
 'port_diag',
 'random',
 're',
 'select',
 'socket',
 'ssd1306',
 'ssl',
 'struct',
 'sys',
 'time',
 'uarray',
 '__init__',
 'core',
 'event',
 'funcs',
 'lock',
 'stream',
 'ubinascii',
 'ucollections',
 'ucryptolib',
 'uctypes',
 'uerrno',
 'uhashlib',
 'uheapq',
 'uio',
 'ujson',
 'robust',
 'simple',
 'uos',
 'upip',
 'upip_utarfile',
 'urandom',
 'ure',
 'urequest',
 'urequests',
 'uselect',
 'usocket',
 'ussl',
 'ustruct',
 'usys',
 'utime',
 'utimeq',
 'uwebsocket',
 'uzlib',
 'webrepl',
 'webrepl_setup',
 'websocket',
 'websocket_helper',
 'zlib']
install_requires = \
['micropython-stdlib-stubs>=0.9.0']

setup_kwargs = {
    'name': 'micropython-esp8266-stubs',
    'version': '1.17.post3',
    'description': 'MicroPython stubs',
    'long_description': '# micropython-esp8266-stubs\n\n\nThis is a stub-only package for MicroPython.\nIt is intended to be installed in a projects virtual environment to allow static type checkers and intellisense features to be used while writing Micropython code.\n\nThe version of this package is alligned the the version of the MicroPython firmware.\n - Major, Minor and Patch levels are alligned to the same version as the firmware.  \n - The post release level is used to publish new releases of the stubs.\n\nFor `Micropython 1.17` the stubs are published as `1.17.post1` ... `1.17.post2`  \nfor `Micropython 1.18` the stubs are published as `1.18.post1` ... `1.18.post2`  \n\nTo install the latest stubs:  \n`pip install -I  micropython-<port>-stubs` where port is the port of the MicroPython firmware.\n\nTo install the stubs for an older version, such as MicroPython 1.17:  \n`pip install micropython-stm32-stubs==1.17.*` which will install the last post release of the stubs for MicroPython 1.17.\n\n\nAs the creation of the stubs, and merging of the different types is still going though improvements, the stub packages are marked as Beta.\nTo upgrade stubs to the latest stubs for a specific version use `pip install micropython-stm32-stubs==1.17.* --upgrade`\n\nIf you have suggestions or find any issues with the stubs, please report them in the [MicroPython-stubs Discussions](https://github.com/Josverl/micropython-stubs/discussions)\n\nFor an overview of  Micropython Stubs please see: https://micropython-stubs.readthedocs.io/en/main/ \n * List of all stubs : https://micropython-stubs.readthedocs.io/en/main/firmware_grp.html\n\nIncluded stubs:\n* Merged stubs from `stubs/micropython-v1_17-esp8266-merged`\n* Frozen stubs from `stubs/micropython-v1_17-frozen/esp8266/GENERIC`\n* Core Stubs from `stubs/cpython_core-pycopy`\n\n\norigin | Family | Port | Board | Version\n-------|--------|------|-------|--------\nFirmware | micropython | esp8266 | ESP module with ESP8266 | v1.17 \nDocumentation | micropython | - | - | v1.17 \nCore | micropython | esp8266 | - | v1.17 \n',
    'author': 'josverl',
    'author_email': 'josverl@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/josverl/micropython-stubs#micropython-stubs',
    'py_modules': modules,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
