/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.metrics.TimeStampFormatter$;
import wvlet.airframe.metrics.TimeWindow$;
import wvlet.airframe.metrics.TimeWindowBuilder;
import wvlet.airframe.metrics.TimeWindowUnit;
import wvlet.airframe.metrics.TimeWindowUnit$Day$;
import wvlet.airframe.metrics.TimeWindowUnit$Hour$;
import wvlet.airframe.metrics.TimeWindowUnit$Minute$;
import wvlet.airframe.metrics.TimeWindowUnit$Month$;
import wvlet.airframe.metrics.TimeWindowUnit$Quarter$;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.TimeWindowUnit$Week$;
import wvlet.airframe.metrics.TimeWindowUnit$Year$;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001\u0002\u001b6\u0001rB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t'\u0002\u0011\t\u0012)A\u0005\u0017\"AA\u000b\u0001BK\u0002\u0013\u0005!\n\u0003\u0005V\u0001\tE\t\u0015!\u0003L\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015\t\u0007\u0001\"\u0003^\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00159\u0007\u0001\"\u0001d\u0011\u0015A\u0007\u0001\"\u0001d\u0011\u0015I\u0007\u0001\"\u0001d\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u00159\b\u0001\"\u0001y\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\n\u0001\t\u0003\t)\u0003C\u0004\u0002*\u0001!\t!!\n\t\u000f\u0005-\u0002\u0001\"\u0001\u0002&!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013Bq!a\u0012\u0001\t\u0003\ti\u0005\u0003\u0004\u0002X\u0001!\ta\u0019\u0005\u0007\u00033\u0002A\u0011A2\t\r\u0005m\u0003\u0001\"\u0001d\u0011\u0019\ti\u0006\u0001C\u0001G\"1\u0011q\f\u0001\u0005\u0002\rDa!!\u0019\u0001\t\u0003\u0019\u0007BBA2\u0001\u0011\u00051\rC\u0004\u0002f\u0001!\t!a\u001a\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0004\"CA>\u0001E\u0005I\u0011AA?\u0011%\t\u0019\nAI\u0001\n\u0003\ti\bC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003[\u0003\u0011\u0011!C\u0001\u0003_C\u0011\"a/\u0001\u0003\u0003%\t%!0\t\u0013\u0005-\u0007!!A\u0005\u0002\u00055\u0007\"CAi\u0001\u0005\u0005I\u0011IAj\u0011%\t)\u000eAA\u0001\n\u0003\n9nB\u0004\u0002\\VB\t!!8\u0007\rQ*\u0004\u0012AAp\u0011\u001916\u0006\"\u0001\u0002n\"9\u0011q^\u0016\u0005\u0002\u0005E\bbBAxW\u0011\u0005\u0011Q \u0005\b\u0005\u0007YC\u0011\u0001B\u0003\u0011\u001d\u00119a\u000bC\u0001\u0005\u000bA\u0011B!\u0003,\u0003\u0003%\tIa\u0003\t\u0013\tE1&!A\u0005\u0002\nM\u0001\"\u0003B\u0013W\u0005\u0005I\u0011\u0002B\u0014\u0005)!\u0016.\\3XS:$wn\u001e\u0006\u0003m]\nq!\\3ue&\u001c7O\u0003\u00029s\u0005A\u0011-\u001b:ge\u0006lWMC\u0001;\u0003\u00159h\u000f\\3u\u0007\u0001\u0019B\u0001A\u001fD\rB\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1\u0011I\\=SK\u001a\u0004\"A\u0010#\n\u0005\u0015{$a\u0002)s_\u0012,8\r\u001e\t\u0003}\u001dK!\u0001S \u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000bM$\u0018M\u001d;\u0016\u0003-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\tQLW.\u001a\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJA\u0007[_:,G\rR1uKRKW.Z\u0001\u0007gR\f'\u000f\u001e\u0011\u0002\u0007\u0015tG-\u0001\u0003f]\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0002Y5n\u0003\"!\u0017\u0001\u000e\u0003UBQ!S\u0003A\u0002-CQ\u0001V\u0003A\u0002-\u000ba\"\u001b8ti\u0006tGo\u00144Ti\u0006\u0014H/F\u0001_!\tau,\u0003\u0002a\u001b\n9\u0011J\\:uC:$\u0018\u0001D5ogR\fg\u000e^(g\u000b:$\u0017!D:uCJ$XK\\5y)&lW-F\u0001e!\tqT-\u0003\u0002g\u007f\t!Aj\u001c8h\u0003-)g\u000eZ+oSb$\u0016.\\3\u0002!M$\u0018M\u001d;Fa>\u001c\u0007.T5mY&\u001c\u0018AD3oI\u0016\u0003xn\u00195NS2d\u0017n]\u0001\ti>\u001cFO]5oOR\tA\u000e\u0005\u0002ni:\u0011aN\u001d\t\u0003_~j\u0011\u0001\u001d\u0006\u0003cn\na\u0001\u0010:p_Rt\u0014BA:@\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M|\u0014A\u0003;p'R\u0014\u0018N\\4BiR\u0011A.\u001f\u0005\u0006u6\u0001\ra_\u0001\u0005u>tW\r\u0005\u0002My&\u0011Q0\u0014\u0002\u000b5>tWm\u00144gg\u0016$\u0018!C:qY&$\u0018J\u001c;p)\u0011\t\t!a\u0005\u0011\u000b\u0005\r\u0011Q\u0002-\u000f\t\u0005\u0015\u0011\u0011\u0002\b\u0004_\u0006\u001d\u0011\"\u0001!\n\u0007\u0005-q(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0011\u0011\u0003\u0002\u0004'\u0016\f(bAA\u0006\u007f!9\u0011Q\u0003\bA\u0002\u0005]\u0011\u0001B;oSR\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;i\u0015\u0001\u0003;f[B|'/\u00197\n\t\u0005\u0005\u00121\u0004\u0002\u000b\u0007\"\u0014xN\\8V]&$\u0018AD:qY&$\u0018J\u001c;p\u0011>,(o]\u000b\u0003\u0003\u0003\tQb\u001d9mSRLe\u000e^8ECf\u001c\u0018aD:qY&$\u0018J\u001c;p\u001b>tG\u000f[:\u0002\u001dM\u0004H.\u001b;J]R|w+Z3lg\u000691\u000f\u001d7ji\u0006#H\u0003BA\u0001\u0003cAa!a\r\u0014\u0001\u0004Y\u0015\u0001\u00023bi\u0016\fA\u0001\u001d7vgR)\u0001,!\u000f\u0002>!1\u00111\b\u000bA\u0002\u0011\f\u0011A\u001c\u0005\b\u0003+!\u0002\u0019AA\f\u0003\u0015i\u0017N\\;t)\u0015A\u00161IA#\u0011\u0019\tY$\u0006a\u0001I\"9\u0011QC\u000bA\u0002\u0005]\u0011a\u00025po6\u000bg.\u001f\u000b\u0004I\u0006-\u0003bBA\u000b-\u0001\u0007\u0011q\u0003\u000b\u0004I\u0006=\u0003bBA\u000b/\u0001\u0007\u0011\u0011\u000b\t\u00043\u0006M\u0013bAA+k\tqA+[7f/&tGm\\<V]&$\u0018AC:fG>tG\rR5gM\u0006QQ.\u001b8vi\u0016$\u0015N\u001a4\u0002\u0011!|WO\u001d#jM\u001a\f\u0001\u0002Z1uK\u0012KgMZ\u0001\to\u0016,7\u000eR5gM\u0006IQn\u001c8uQ\u0012KgMZ\u0001\ts\u0016\f'\u000fR5gM\u0006q\u0011N\u001c;feN,7\r^:XSRDG\u0003BA5\u0003_\u00022APA6\u0013\r\tig\u0010\u0002\b\u0005>|G.Z1o\u0011\u0019\t\th\ba\u00011\u0006)q\u000e\u001e5fe\u0006!1m\u001c9z)\u0015A\u0016qOA=\u0011\u001dI\u0005\u0005%AA\u0002-Cq\u0001\u0016\u0011\u0011\u0002\u0003\u00071*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}$fA&\u0002\u0002.\u0012\u00111\u0011\t\u0005\u0003\u000b\u000by)\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003%)hn\u00195fG.,GMC\u0002\u0002\u000e~\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t*a\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\n\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\tyjT\u0001\u0005Y\u0006tw-C\u0002v\u0003;\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a*\u0011\u0007y\nI+C\u0002\u0002,~\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!-\u00028B\u0019a(a-\n\u0007\u0005UvHA\u0002B]fD\u0011\"!/&\u0003\u0003\u0005\r!a*\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\f\u0005\u0004\u0002B\u0006\u001d\u0017\u0011W\u0007\u0003\u0003\u0007T1!!2@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0013\f\u0019M\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA5\u0003\u001fD\u0011\"!/(\u0003\u0003\u0005\r!!-\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a*\u0002\r\u0015\fX/\u00197t)\u0011\tI'!7\t\u0013\u0005e\u0016&!AA\u0002\u0005E\u0016A\u0003+j[\u0016<\u0016N\u001c3poB\u0011\u0011lK\n\u0005Wu\n\t\u000f\u0005\u0003\u0002d\u0006%XBAAs\u0015\r\t9/O\u0001\u0004Y><\u0017\u0002BAv\u0003K\u0014!\u0002T8h'V\u0004\bo\u001c:u)\t\ti.\u0001\u0007xSRDG+[7f5>tW\r\u0006\u0003\u0002t\u0006e\bcA-\u0002v&\u0019\u0011q_\u001b\u0003#QKW.Z,j]\u0012|wOQ;jY\u0012,'\u000f\u0003\u0004\u0002|6\u0002\r\u0001\\\u0001\tu>tWMT1nKR!\u00111_A\u0000\u0011\u0019\u0011\tA\fa\u0001w\u00061!p\u001c8f\u0013\u0012\fqa^5uQV#6)\u0006\u0002\u0002t\u0006\u0011r/\u001b;i'f\u001cH/Z7US6,'l\u001c8f\u0003\u0015\t\u0007\u000f\u001d7z)\u0015A&Q\u0002B\b\u0011\u0015I\u0015\u00071\u0001L\u0011\u0015!\u0016\u00071\u0001L\u0003\u001d)h.\u00199qYf$BA!\u0006\u0003\"A)aHa\u0006\u0003\u001c%\u0019!\u0011D \u0003\r=\u0003H/[8o!\u0015q$QD&L\u0013\r\u0011yb\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t\r\"'!AA\u0002a\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t%\u0002\u0003BAN\u0005WIAA!\f\u0002\u001e\n1qJ\u00196fGR\u0004")
public class TimeWindow
implements Product,
scala.Serializable {
    private final ZonedDateTime start;
    private final ZonedDateTime end;

    public static Option<Tuple2<ZonedDateTime, ZonedDateTime>> unapply(TimeWindow timeWindow) {
        return TimeWindow$.MODULE$.unapply(timeWindow);
    }

    public static TimeWindow apply(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2) {
        return TimeWindow$.MODULE$.apply(zonedDateTime, zonedDateTime2);
    }

    public static TimeWindowBuilder withSystemTimeZone() {
        return TimeWindow$.MODULE$.withSystemTimeZone();
    }

    public static TimeWindowBuilder withUTC() {
        return TimeWindow$.MODULE$.withUTC();
    }

    public static TimeWindowBuilder withTimeZone(ZoneOffset zoneOffset) {
        return TimeWindow$.MODULE$.withTimeZone(zoneOffset);
    }

    public static TimeWindowBuilder withTimeZone(String string) {
        return TimeWindow$.MODULE$.withTimeZone(string);
    }

    public ZonedDateTime start() {
        return this.start;
    }

    public ZonedDateTime end() {
        return this.end;
    }

    private Instant instantOfStart() {
        return this.start().toInstant();
    }

    private Instant instantOfEnd() {
        return this.end().toInstant();
    }

    public long startUnixTime() {
        return this.start().toEpochSecond();
    }

    public long endUnixTime() {
        return this.end().toEpochSecond();
    }

    public long startEpochMillis() {
        return this.instantOfStart().toEpochMilli();
    }

    public long endEpochMillis() {
        return this.instantOfEnd().toEpochMilli();
    }

    public String toString() {
        String s2 = TimeStampFormatter$.MODULE$.formatTimestamp(this.start());
        String e = TimeStampFormatter$.MODULE$.formatTimestamp(this.end());
        return new StringBuilder(3).append("[").append(s2).append(",").append(e).append(")").toString();
    }

    public String toStringAt(ZoneOffset zone) {
        String s2 = TimeStampFormatter$.MODULE$.formatTimestamp(this.startEpochMillis(), zone);
        String e = TimeStampFormatter$.MODULE$.formatTimestamp(this.endEpochMillis(), zone);
        return new StringBuilder(3).append("[").append(s2).append(",").append(e).append(")").toString();
    }

    private Seq<TimeWindow> splitInto(ChronoUnit unit) {
        Builder b = Seq$.MODULE$.newBuilder();
        ZonedDateTime cursor = this.start();
        while (cursor.compareTo(this.end()) < 0) {
            ZonedDateTime zonedDateTime;
            ChronoUnit chronoUnit = unit;
            boolean bl = ChronoUnit.DAYS.equals(chronoUnit) ? true : (ChronoUnit.HOURS.equals(chronoUnit) ? true : ChronoUnit.MINUTES.equals(chronoUnit));
            if (bl) {
                zonedDateTime = cursor.plus(1L, unit).truncatedTo(unit);
            } else if (ChronoUnit.WEEKS.equals(chronoUnit)) {
                zonedDateTime = cursor.plus(1L, unit).with(DayOfWeek.MONDAY);
            } else if (ChronoUnit.MONTHS.equals(chronoUnit)) {
                zonedDateTime = cursor.plus(1L, unit).withDayOfMonth(1);
            } else if (ChronoUnit.YEARS.equals(chronoUnit)) {
                zonedDateTime = cursor.plus(1L, unit).withDayOfYear(1);
            } else {
                throw new IllegalStateException(new StringBuilder(30).append("Invalid split unit ").append(unit).append(" for range ").append(this.toString()).toString());
            }
            ZonedDateTime e = zonedDateTime;
            Builder builder = e.compareTo(this.end()) <= 0 ? b.$plus$eq((Object)new TimeWindow(cursor, e)) : b.$plus$eq((Object)new TimeWindow(cursor, this.end()));
            cursor = e;
        }
        return (Seq)b.result();
    }

    public Seq<TimeWindow> splitIntoHours() {
        return this.splitInto(ChronoUnit.HOURS);
    }

    public Seq<TimeWindow> splitIntoDays() {
        return this.splitInto(ChronoUnit.DAYS);
    }

    public Seq<TimeWindow> splitIntoMonths() {
        return this.splitInto(ChronoUnit.MONTHS);
    }

    public Seq<TimeWindow> splitIntoWeeks() {
        return this.splitInto(ChronoUnit.WEEKS);
    }

    public Seq<TimeWindow> splitAt(ZonedDateTime date) {
        return date.compareTo(this.start()) <= 0 || date.compareTo(this.end()) > 0 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeWindow[]{this})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeWindow[]{new TimeWindow(this.start(), date), new TimeWindow(date, this.end())}));
    }

    public TimeWindow plus(long n, ChronoUnit unit) {
        return new TimeWindow(this.start().plus(n, unit), this.end().plus(n, unit));
    }

    public TimeWindow minus(long n, ChronoUnit unit) {
        return this.plus(-n, unit);
    }

    public long howMany(ChronoUnit unit) {
        return unit.between(this.start(), this.end());
    }

    public long howMany(TimeWindowUnit unit) {
        long l;
        TimeWindowUnit timeWindowUnit = unit;
        if (TimeWindowUnit$Year$.MODULE$.equals(timeWindowUnit)) {
            l = this.howMany(ChronoUnit.YEARS);
        } else if (TimeWindowUnit$Quarter$.MODULE$.equals(timeWindowUnit)) {
            ZonedDateTime startTruncated = unit.truncate(this.start());
            ZonedDateTime endTruncated = unit.truncate(this.end());
            int yearDiff = endTruncated.getYear() - startTruncated.getYear();
            l = (endTruncated.getMonthValue() + yearDiff * 12 - startTruncated.getMonthValue()) / 3;
        } else if (TimeWindowUnit$Month$.MODULE$.equals(timeWindowUnit)) {
            l = this.monthDiff();
        } else if (TimeWindowUnit$Week$.MODULE$.equals(timeWindowUnit)) {
            l = this.weekDiff();
        } else if (TimeWindowUnit$Day$.MODULE$.equals(timeWindowUnit)) {
            l = this.dateDiff();
        } else if (TimeWindowUnit$Hour$.MODULE$.equals(timeWindowUnit)) {
            l = this.hourDiff();
        } else if (TimeWindowUnit$Minute$.MODULE$.equals(timeWindowUnit)) {
            l = this.minuteDiff();
        } else if (TimeWindowUnit$Second$.MODULE$.equals(timeWindowUnit)) {
            l = this.secondDiff();
        } else {
            throw new MatchError((Object)timeWindowUnit);
        }
        return l;
    }

    public long secondDiff() {
        return this.howMany(ChronoUnit.SECONDS);
    }

    public long minuteDiff() {
        return this.howMany(ChronoUnit.MINUTES);
    }

    public long hourDiff() {
        return this.howMany(ChronoUnit.HOURS);
    }

    public long dateDiff() {
        return this.howMany(ChronoUnit.DAYS);
    }

    public long weekDiff() {
        return this.howMany(ChronoUnit.WEEKS);
    }

    public long monthDiff() {
        return this.howMany(ChronoUnit.MONTHS);
    }

    public long yearDiff() {
        return this.howMany(ChronoUnit.YEARS);
    }

    public boolean intersectsWith(TimeWindow other) {
        return this.start().compareTo(other.end()) < 0 && this.end().compareTo(other.start()) > 0;
    }

    public TimeWindow copy(ZonedDateTime start, ZonedDateTime end) {
        return new TimeWindow(start, end);
    }

    public ZonedDateTime copy$default$1() {
        return this.start();
    }

    public ZonedDateTime copy$default$2() {
        return this.end();
    }

    public String productPrefix() {
        return "TimeWindow";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        ZonedDateTime zonedDateTime;
        int n = x$1;
        switch (n) {
            case 0: {
                zonedDateTime = this.start();
                break;
            }
            case 1: {
                zonedDateTime = this.end();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return zonedDateTime;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeWindow;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeWindow timeWindow = (TimeWindow)x$1;
        ZonedDateTime zonedDateTime = this.start();
        ZonedDateTime zonedDateTime2 = timeWindow.start();
        if (zonedDateTime == null) {
            if (zonedDateTime2 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime).equals(zonedDateTime2)) return false;
        ZonedDateTime zonedDateTime3 = this.end();
        ZonedDateTime zonedDateTime4 = timeWindow.end();
        if (zonedDateTime3 == null) {
            if (zonedDateTime4 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime3).equals(zonedDateTime4)) return false;
        if (!timeWindow.canEqual(this)) return false;
        return true;
    }

    public TimeWindow(ZonedDateTime start, ZonedDateTime end) {
        this.start = start;
        this.end = end;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(start.compareTo(end) <= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("invalid range: ").append(TimeStampFormatter$.MODULE$.formatTimestamp(this.start())).append(" > ").append(TimeStampFormatter$.MODULE$.formatTimestamp(this.end())).toString());
    }
}

