/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import wvlet.airframe.control.ResultClass;
import wvlet.airframe.control.ResultClass$;
import wvlet.airframe.control.ResultClass$Succeeded$;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.HttpStatus$BadRequest_400$;
import wvlet.airframe.http.HttpStatus$ClientClosedRequest_499$;
import wvlet.airframe.http.HttpStatus$Gone_410$;
import wvlet.airframe.http.HttpStatus$ServiceUnavailable_503$;
import wvlet.airframe.http.HttpStatus$TooManyRequests_429$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClientException$
implements LogSupport {
    public static HttpClientException$ MODULE$;
    private final Set<String> finagleRetryableExceptionClasses;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HttpClientException$();
    }

    private Logger logger$lzycompute() {
        HttpClientException$ httpClientException$ = this;
        synchronized (httpClientException$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private <Resp> HttpClientException requestFailure(Resp response, HttpResponseAdapter<Resp> adapter) {
        HttpStatus status = adapter.statusOf(response);
        String content = adapter.contentStringOf(response);
        return content == null || content.isEmpty() ? new HttpClientException(adapter.wrap(response), status) : new HttpClientException(adapter.wrap(response), status, new StringBuilder(16).append("Request failed: ").append(content).toString());
    }

    public <Resp> ResultClass classifyHttpResponse(Resp response, HttpResponseAdapter<Resp> adapter) {
        ResultClass resultClass;
        HttpStatus status = adapter.statusOf(response);
        HttpStatus httpStatus = status;
        if (httpStatus.isSuccessful()) {
            resultClass = ResultClass$Succeeded$.MODULE$;
        } else if (httpStatus.isServerError()) {
            ResultClass.Failed f = ResultClass$.MODULE$.retryableFailure(this.requestFailure(response, adapter));
            HttpStatus httpStatus2 = status;
            HttpStatus$ServiceUnavailable_503$ httpStatus$ServiceUnavailable_503$ = HttpStatus$ServiceUnavailable_503$.MODULE$;
            resultClass = !(httpStatus2 != null ? !httpStatus2.equals(httpStatus$ServiceUnavailable_503$) : httpStatus$ServiceUnavailable_503$ != null) ? f.withExtraWaitFactor(0.5, f.withExtraWaitFactor$default$2()) : f;
        } else if (httpStatus.isClientError()) {
            HttpStatus httpStatus3 = httpStatus;
            ResultClass.Failed failed = HttpStatus$BadRequest_400$.MODULE$.equals(httpStatus3) && this.isRetryable400ErrorMessage(adapter.contentStringOf(response)) ? ResultClass$.MODULE$.retryableFailure(this.requestFailure(response, adapter)) : (HttpStatus$Gone_410$.MODULE$.equals(httpStatus3) ? ResultClass$.MODULE$.retryableFailure(this.requestFailure(response, adapter)) : (HttpStatus$TooManyRequests_429$.MODULE$.equals(httpStatus3) ? ResultClass$.MODULE$.retryableFailure(this.requestFailure(response, adapter)) : (HttpStatus$ClientClosedRequest_499$.MODULE$.equals(httpStatus3) ? ResultClass$.MODULE$.retryableFailure(this.requestFailure(response, adapter)) : ResultClass$.MODULE$.nonRetryableFailure(this.requestFailure(response, adapter)))));
            resultClass = failed;
        } else {
            resultClass = ResultClass$.MODULE$.nonRetryableFailure(this.requestFailure(response, adapter));
        }
        return resultClass;
    }

    private boolean isRetryable400ErrorMessage(String m3) {
        Seq retriable400ErrorMessage = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Regex[]{new StringOps(Predef$.MODULE$.augmentString("Idle connections will be closed")).r()}));
        return retriable400ErrorMessage.find((Function1 & Serializable & scala.Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)HttpClientException$.$anonfun$isRetryable400ErrorMessage$1(m3, pattern))).isDefined();
    }

    public ResultClass.Failed classifyHttpClientException(Throwable e) {
        return (ResultClass.Failed)this.ioExceptionClassifier().orElse(this.executionFailureClassifier()).applyOrElse((Object)e, this.nonRetryable());
    }

    public PartialFunction<Throwable, ResultClass.Failed> ioExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IOException) {
                    IOException iOException = (IOException)A1;
                    object = HttpClientException$.MODULE$.classifyExecutionFailure(iOException);
                } else if (A1 instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)A1;
                    object = HttpClientException$.MODULE$.classifyExecutionFailure(invocationTargetException);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IOException ? true : throwable instanceof InvocationTargetException;
                return bl;
            }
        };
    }

    public ResultClass.Failed classifyExecutionFailure(Throwable ex) {
        return (ResultClass.Failed)this.executionFailureClassifier().applyOrElse((Object)ex, this.nonRetryable());
    }

    public PartialFunction<Throwable, ResultClass.Failed> executionFailureClassifier() {
        return this.timeoutExceptionClassifier().orElse(this.connectionExceptionClassifier()).orElse(this.sslExceptionClassifier()).orElse(this.invocationTargetExceptionClassifier());
    }

    public PartialFunction<Throwable, ResultClass.Failed> timeoutExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)A1;
                    object = ResultClass$.MODULE$.retryableFailure(timeoutException);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof TimeoutException;
                return bl;
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> connectionExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)A1;
                    object = ResultClass$.MODULE$.retryableFailure(interruptedException);
                    return (B1)object;
                }
                if (A1 instanceof ProtocolException) {
                    ProtocolException protocolException = (ProtocolException)A1;
                    object = ResultClass$.MODULE$.retryableFailure(protocolException);
                    return (B1)object;
                }
                if (A1 instanceof ConnectException) {
                    ConnectException connectException = (ConnectException)A1;
                    object = ResultClass$.MODULE$.retryableFailure(connectException);
                    return (B1)object;
                }
                if (A1 instanceof EOFException) {
                    EOFException eOFException = (EOFException)A1;
                    object = ResultClass$.MODULE$.retryableFailure(eOFException);
                    return (B1)object;
                }
                if (A1 instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)A1;
                    object = ResultClass$.MODULE$.retryableFailure(timeoutException);
                    return (B1)object;
                }
                if (A1 instanceof ClosedChannelException) {
                    ClosedChannelException closedChannelException = (ClosedChannelException)A1;
                    object = ResultClass$.MODULE$.retryableFailure(closedChannelException);
                    return (B1)object;
                }
                if (A1 instanceof SocketException) {
                    SocketException socketException = (SocketException)A1;
                    SocketException socketException2 = socketException;
                    ResultClass.Failed failed = socketException2 instanceof BindException ? ResultClass$.MODULE$.retryableFailure(socketException) : (socketException2 instanceof ConnectException ? ResultClass$.MODULE$.retryableFailure(socketException) : (socketException2 instanceof NoRouteToHostException ? ResultClass$.MODULE$.retryableFailure(socketException) : (socketException2 instanceof PortUnreachableException ? ResultClass$.MODULE$.retryableFailure(socketException) : ResultClass$.MODULE$.nonRetryableFailure(socketException))));
                    object = failed;
                    return (B1)object;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    if (HttpClientException$.MODULE$.finagleRetryableExceptionClasses().contains((Object)A12.getClass().getName())) {
                        object = ResultClass$.MODULE$.retryableFailure(A12);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof InterruptedException) {
                    return true;
                }
                if (throwable instanceof ProtocolException) {
                    return true;
                }
                if (throwable instanceof ConnectException) {
                    return true;
                }
                if (throwable instanceof EOFException) {
                    return true;
                }
                if (throwable instanceof TimeoutException) {
                    return true;
                }
                if (throwable instanceof ClosedChannelException) {
                    return true;
                }
                if (throwable instanceof SocketException) {
                    return true;
                }
                if (throwable == null) return false;
                Throwable throwable2 = throwable;
                if (!HttpClientException$.MODULE$.finagleRetryableExceptionClasses().contains((Object)throwable2.getClass().getName())) return false;
                return true;
            }
        };
    }

    public Set<String> finagleRetryableExceptionClasses() {
        return this.finagleRetryableExceptionClasses;
    }

    public PartialFunction<Throwable, ResultClass.Failed> sslExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SSLException) {
                    SSLException sSLException = (SSLException)A1;
                    SSLException sSLException2 = sSLException;
                    ResultClass.Failed failed = sSLException2 instanceof SSLHandshakeException ? ResultClass$.MODULE$.nonRetryableFailure(sSLException) : (sSLException2 instanceof SSLKeyException ? ResultClass$.MODULE$.nonRetryableFailure(sSLException) : (sSLException2 instanceof SSLPeerUnverifiedException ? ResultClass$.MODULE$.nonRetryableFailure(sSLException) : ResultClass$.MODULE$.retryableFailure(sSLException)));
                    object = failed;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof SSLException;
                return bl;
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> invocationTargetExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                ExecutionException executionException;
                A1 A1 = x1;
                if (A1 instanceof ExecutionException && (executionException = (ExecutionException)A1).getCause() != null) {
                    object = HttpClientException$.MODULE$.classifyExecutionFailure(executionException.getCause());
                } else if (A1 instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)A1;
                    object = HttpClientException$.MODULE$.classifyExecutionFailure(invocationTargetException.getTargetException());
                } else {
                    object = A1.getCause() != null ? HttpClientException$.MODULE$.classifyExecutionFailure(A1.getCause()) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                ExecutionException executionException;
                Throwable throwable = x1;
                boolean bl = throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null ? true : (throwable instanceof InvocationTargetException ? true : throwable.getCause() != null);
                return bl;
            }
        };
    }

    public Function1<Throwable, ResultClass.Failed> nonRetryable() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            ResultClass.Failed failed = ResultClass$.MODULE$.nonRetryableFailure(throwable);
            return failed;
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$isRetryable400ErrorMessage$1(String m$1, Regex pattern) {
        return pattern.findFirstIn((CharSequence)m$1).isDefined();
    }

    private HttpClientException$() {
        MODULE$ = this;
        LoggingMethods.$init$(this);
        LazyLogger.$init$(this);
        this.finagleRetryableExceptionClasses = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com.twitter.finagle.ChannelClosedException", "com.twitter.finagle.ReadTimedOutException", "com.twitter.finagle.WriteTimedOutException"}));
    }
}

