/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallContextCache;
import com.kenai.jffi.Function;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import jnr.ffi.CallingConvention;
import jnr.ffi.LibraryOption;
import jnr.ffi.NativeType;
import jnr.ffi.Runtime;
import jnr.ffi.Type;
import jnr.ffi.annotations.IgnoreError;
import jnr.ffi.annotations.SaveError;
import jnr.ffi.annotations.StdCall;
import jnr.ffi.mapper.DefaultSignatureType;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.FromNativeType;
import jnr.ffi.mapper.MethodParameterContext;
import jnr.ffi.mapper.MethodResultContext;
import jnr.ffi.mapper.SignatureTypeMapper;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.mapper.ToNativeType;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.ConverterMetaData;
import jnr.ffi.provider.jffi.MethodGenerator;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SigType;
import jnr.ffi.provider.jffi.Types;
import jnr.ffi.util.Annotations;

final class InvokerUtil {
    static final Map<NativeType, com.kenai.jffi.Type> jffiTypes;

    InvokerUtil() {
    }

    public static boolean requiresErrno(Method method) {
        boolean saveError = true;
        for (Annotation a : method.getAnnotations()) {
            if (a instanceof IgnoreError) {
                saveError = false;
                continue;
            }
            if (!(a instanceof SaveError)) continue;
            saveError = true;
        }
        return saveError;
    }

    public static com.kenai.jffi.CallingConvention getCallingConvention(Map<LibraryOption, ?> libraryOptions) {
        Object convention = libraryOptions.get((Object)LibraryOption.CallingConvention);
        if (convention instanceof com.kenai.jffi.CallingConvention) {
            return (com.kenai.jffi.CallingConvention)((Object)convention);
        }
        if (convention instanceof CallingConvention) {
            switch ((CallingConvention)((Object)convention)) {
                case DEFAULT: {
                    return com.kenai.jffi.CallingConvention.DEFAULT;
                }
                case STDCALL: {
                    return com.kenai.jffi.CallingConvention.STDCALL;
                }
            }
        } else if (convention != null) {
            throw new IllegalArgumentException("unknown calling convention: " + convention);
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }

    public static boolean hasAnnotation(Collection<Annotation> annotations, Class<? extends Annotation> annotationClass) {
        for (Annotation a : annotations) {
            if (!annotationClass.isInstance(a)) continue;
            return true;
        }
        return false;
    }

    static com.kenai.jffi.Type jffiType(NativeType jnrType) {
        com.kenai.jffi.Type jffiType = jffiTypes.get((Object)jnrType);
        if (jffiType != null) {
            return jffiType;
        }
        throw new IllegalArgumentException("unsupported parameter type: " + (Object)((Object)jnrType));
    }

    static NativeType nativeType(Type jnrType) {
        return jnrType.getNativeType();
    }

    static Collection<Annotation> getAnnotations(FromNativeType fromNativeType) {
        return fromNativeType != null ? ConverterMetaData.getAnnotations(fromNativeType.getFromNativeConverter()) : Annotations.EMPTY_ANNOTATIONS;
    }

    static Collection<Annotation> getAnnotations(ToNativeType toNativeType) {
        return toNativeType != null ? ConverterMetaData.getAnnotations(toNativeType.getToNativeConverter()) : Annotations.EMPTY_ANNOTATIONS;
    }

    static ResultType getResultType(Runtime runtime, Class type, Collection<Annotation> annotations, FromNativeConverter fromNativeConverter, FromNativeContext fromNativeContext) {
        Collection<Annotation> converterAnnotations = ConverterMetaData.getAnnotations(fromNativeConverter);
        Collection<Annotation> allAnnotations = Annotations.mergeAnnotations(annotations, converterAnnotations);
        NativeType nativeType = InvokerUtil.getMethodResultNativeType(runtime, fromNativeConverter != null ? fromNativeConverter.nativeType() : type, allAnnotations);
        boolean useContext = fromNativeConverter != null && !InvokerUtil.hasAnnotation(converterAnnotations, FromNativeConverter.NoContext.class);
        return new ResultType(type, nativeType, allAnnotations, fromNativeConverter, useContext ? fromNativeContext : null);
    }

    static ResultType getResultType(Runtime runtime, Class type, Collection<Annotation> annotations, FromNativeType fromNativeType, FromNativeContext fromNativeContext) {
        Collection<Annotation> converterAnnotations = InvokerUtil.getAnnotations(fromNativeType);
        Collection<Annotation> allAnnotations = Annotations.mergeAnnotations(annotations, converterAnnotations);
        FromNativeConverter fromNativeConverter = fromNativeType != null ? fromNativeType.getFromNativeConverter() : null;
        NativeType nativeType = InvokerUtil.getMethodResultNativeType(runtime, fromNativeConverter != null ? fromNativeConverter.nativeType() : type, allAnnotations);
        boolean useContext = fromNativeConverter != null && !InvokerUtil.hasAnnotation(converterAnnotations, FromNativeConverter.NoContext.class);
        return new ResultType(type, nativeType, allAnnotations, fromNativeConverter, useContext ? fromNativeContext : null);
    }

    private static ParameterType getParameterType(Runtime runtime, Class type, Collection<Annotation> annotations, ToNativeConverter toNativeConverter, ToNativeContext toNativeContext) {
        NativeType nativeType = InvokerUtil.getMethodParameterNativeType(runtime, toNativeConverter != null ? toNativeConverter.nativeType() : type, annotations);
        return new ParameterType(type, nativeType, annotations, toNativeConverter, toNativeContext);
    }

    private static ParameterType getParameterType(Runtime runtime, Class type, Collection<Annotation> annotations, ToNativeType toNativeType, ToNativeContext toNativeContext) {
        ToNativeConverter toNativeConverter = toNativeType != null ? toNativeType.getToNativeConverter() : null;
        NativeType nativeType = InvokerUtil.getMethodParameterNativeType(runtime, toNativeConverter != null ? toNativeConverter.nativeType() : type, annotations);
        return new ParameterType(type, nativeType, annotations, toNativeConverter, toNativeContext);
    }

    static ParameterType[] getParameterTypes(Runtime runtime, SignatureTypeMapper typeMapper, Method m3) {
        Class<?>[] javaParameterTypes = m3.getParameterTypes();
        Annotation[][] parameterAnnotations = m3.getParameterAnnotations();
        ParameterType[] parameterTypes = new ParameterType[javaParameterTypes.length];
        for (int pidx = 0; pidx < javaParameterTypes.length; ++pidx) {
            Collection<Annotation> annotations = Annotations.sortedAnnotationCollection(parameterAnnotations[pidx]);
            MethodParameterContext toNativeContext = new MethodParameterContext(runtime, m3, pidx, annotations);
            DefaultSignatureType signatureType = DefaultSignatureType.create(javaParameterTypes[pidx], toNativeContext);
            ToNativeType toNativeType = typeMapper.getToNativeType(signatureType, toNativeContext);
            ToNativeConverter toNativeConverter = toNativeType != null ? toNativeType.getToNativeConverter() : null;
            Collection<Annotation> converterAnnotations = ConverterMetaData.getAnnotations(toNativeConverter);
            Collection<Annotation> allAnnotations = Annotations.mergeAnnotations(annotations, converterAnnotations);
            boolean contextRequired = toNativeConverter != null && !InvokerUtil.hasAnnotation(converterAnnotations, ToNativeConverter.NoContext.class);
            parameterTypes[pidx] = InvokerUtil.getParameterType(runtime, javaParameterTypes[pidx], allAnnotations, toNativeConverter, (ToNativeContext)(contextRequired ? toNativeContext : null));
        }
        return parameterTypes;
    }

    static CallContext getCallContext(SigType resultType, SigType[] parameterTypes, com.kenai.jffi.CallingConvention convention, boolean requiresErrno) {
        com.kenai.jffi.Type[] nativeParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            nativeParamTypes[i] = InvokerUtil.jffiType(parameterTypes[i].nativeType);
        }
        return CallContextCache.getInstance().getCallContext(InvokerUtil.jffiType(resultType.nativeType), nativeParamTypes, convention, requiresErrno);
    }

    public static com.kenai.jffi.CallingConvention getNativeCallingConvention(Method m3) {
        if (m3.isAnnotationPresent(StdCall.class) || m3.getDeclaringClass().isAnnotationPresent(StdCall.class)) {
            return com.kenai.jffi.CallingConvention.STDCALL;
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }

    static NativeType getMethodParameterNativeType(Runtime runtime, Class parameterClass, Collection<Annotation> annotations) {
        return Types.getType(runtime, parameterClass, annotations).getNativeType();
    }

    static NativeType getMethodResultNativeType(Runtime runtime, Class resultClass, Collection<Annotation> annotations) {
        return Types.getType(runtime, resultClass, annotations).getNativeType();
    }

    static void generateFunctionInvocation(NativeRuntime runtime, AsmBuilder builder, Method m3, long functionAddress, com.kenai.jffi.CallingConvention callingConvention, boolean saveErrno, SignatureTypeMapper typeMapper, MethodGenerator[] generators) {
        MethodResultContext resultContext = new MethodResultContext(runtime, m3);
        DefaultSignatureType signatureType = DefaultSignatureType.create(m3.getReturnType(), resultContext);
        ResultType resultType = InvokerUtil.getResultType((Runtime)runtime, m3.getReturnType(), resultContext.getAnnotations(), typeMapper.getFromNativeType(signatureType, resultContext), (FromNativeContext)resultContext);
        ParameterType[] parameterTypes = InvokerUtil.getParameterTypes(runtime, typeMapper, m3);
        Function function = InvokerUtil.getFunction(functionAddress, resultType, parameterTypes, saveErrno, callingConvention);
        for (MethodGenerator g2 : generators) {
            if (!g2.isSupported(resultType, parameterTypes, callingConvention)) continue;
            g2.generate(builder, m3.getName(), function, resultType, parameterTypes, !saveErrno);
            break;
        }
    }

    private static Function getFunction(long address, ResultType resultType, ParameterType[] parameterTypes, boolean requiresErrno, com.kenai.jffi.CallingConvention convention) {
        return new Function(address, InvokerUtil.getCallContext(resultType, parameterTypes, convention, requiresErrno));
    }

    static {
        EnumMap<NativeType, com.kenai.jffi.Type> m3 = new EnumMap<NativeType, com.kenai.jffi.Type>(NativeType.class);
        m3.put(NativeType.VOID, com.kenai.jffi.Type.VOID);
        m3.put(NativeType.SCHAR, com.kenai.jffi.Type.SCHAR);
        m3.put(NativeType.UCHAR, com.kenai.jffi.Type.UCHAR);
        m3.put(NativeType.SSHORT, com.kenai.jffi.Type.SSHORT);
        m3.put(NativeType.USHORT, com.kenai.jffi.Type.USHORT);
        m3.put(NativeType.SINT, com.kenai.jffi.Type.SINT);
        m3.put(NativeType.UINT, com.kenai.jffi.Type.UINT);
        m3.put(NativeType.SLONG, com.kenai.jffi.Type.SLONG);
        m3.put(NativeType.ULONG, com.kenai.jffi.Type.ULONG);
        m3.put(NativeType.SLONGLONG, com.kenai.jffi.Type.SLONG_LONG);
        m3.put(NativeType.ULONGLONG, com.kenai.jffi.Type.ULONG_LONG);
        m3.put(NativeType.FLOAT, com.kenai.jffi.Type.FLOAT);
        m3.put(NativeType.DOUBLE, com.kenai.jffi.Type.DOUBLE);
        m3.put(NativeType.ADDRESS, com.kenai.jffi.Type.POINTER);
        jffiTypes = Collections.unmodifiableMap(m3);
    }
}

