/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.okhttp3.internal.huc;

import io.prestosql.jdbc.$internal.okhttp3.Handshake;
import io.prestosql.jdbc.$internal.okhttp3.OkHttpClient;
import io.prestosql.jdbc.$internal.okhttp3.internal.URLFilter;
import io.prestosql.jdbc.$internal.okhttp3.internal.huc.DelegatingHttpsURLConnection;
import io.prestosql.jdbc.$internal.okhttp3.internal.huc.OkHttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class OkHttpsURLConnection
extends DelegatingHttpsURLConnection {
    private final OkHttpURLConnection delegate;

    public OkHttpsURLConnection(URL url, OkHttpClient client) {
        this(new OkHttpURLConnection(url, client));
    }

    public OkHttpsURLConnection(URL url, OkHttpClient client, URLFilter filter) {
        this(new OkHttpURLConnection(url, client, filter));
    }

    public OkHttpsURLConnection(OkHttpURLConnection delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    protected Handshake handshake() {
        if (this.delegate.call == null) {
            throw new IllegalStateException("Connection has not yet been established");
        }
        return this.delegate.handshake;
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.delegate.client = this.delegate.client.newBuilder().hostnameVerifier(hostnameVerifier).build();
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.delegate.client.hostnameVerifier();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.delegate.client = this.delegate.client.newBuilder().sslSocketFactory(sslSocketFactory).build();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.delegate.client.sslSocketFactory();
    }
}

