/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.writer;

import com.treasuredata.partition.mpc.Column;
import com.treasuredata.partition.mpc.ColumnSet;
import com.treasuredata.partition.mpc.CompressionType;
import com.treasuredata.partition.mpc.MPCFile;
import com.treasuredata.partition.mpc.MessagePackerFactory;
import com.treasuredata.partition.mpc.Packable;
import com.treasuredata.partition.mpc.SimpleBlockData;
import com.treasuredata.partition.mpc.buffer.BufferUtil;
import com.treasuredata.partition.mpc.writer.BlockBuilder;
import com.treasuredata.partition.mpc.writer.TempFileAllocator;
import com.treasuredata.partition.mpc.writer.sparse.SparseTableBuilder;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import org.msgpack.value.Value;

public class MPCFileWriter
implements Closeable {
    private Packable headerMetadata;
    private TempFileAllocator tempFileAllocator;
    private CompressionType compType;
    private MessagePackerFactory packerFactory;
    private ColumnSet columnSet;
    private SparseTableBuilder sparseRows;
    private long recordCount;
    private File[] blocks;
    private byte[] header;
    private long totalSize;
    private Comparator<Column> columnComparator;

    public MPCFileWriter(File file) throws IOException {
        this(CompressionType.GZIP, file);
    }

    public MPCFileWriter(TempFileAllocator tempFileAllocator) throws IOException {
        this(CompressionType.GZIP, tempFileAllocator);
    }

    public MPCFileWriter(CompressionType compressionType, File file) throws IOException {
        this(compressionType, new TempFileAllocator(file));
    }

    public MPCFileWriter(CompressionType compressionType, TempFileAllocator tempFileAllocator) throws IOException {
        this(compressionType, tempFileAllocator, new Column.FileSizeComparator());
    }

    public MPCFileWriter(CompressionType compressionType, TempFileAllocator tempFileAllocator, Comparator<Column> comparator) throws IOException {
        this.compType = Preconditions.checkNotNull(compressionType, "compType is null");
        this.tempFileAllocator = Preconditions.checkNotNull(tempFileAllocator, "tempFileAllocator is null");
        this.columnComparator = Preconditions.checkNotNull(comparator, "columnComparator is null");
        this.packerFactory = new MessagePackerFactory(compressionType);
        this.columnSet = this.createColumnSet();
        this.sparseRows = this.createSparseTableBuilder();
        this.recordCount = 0L;
    }

    protected SparseTableBuilder createSparseTableBuilder() throws IOException {
        return new SparseTableBuilder(this.createTempFile("sparse-vector-"));
    }

    protected ColumnSet createColumnSet() {
        return new ColumnSet();
    }

    public void setMetadata(Packable packable) {
        this.headerMetadata = packable;
    }

    private BlockBuilder openBlockBuilder(File file) throws IOException {
        return new BlockBuilder(this.packerFactory.openFile(file));
    }

    public void add(Value value) throws IOException {
        Value[] valueArray = value.asMapValue().getKeyValueArray();
        ArrayList<Column> arrayList = new ArrayList<Column>(valueArray.length / 2);
        ArrayList<Column> arrayList2 = new ArrayList<Column>(valueArray.length / 2);
        for (int i = 0; i < valueArray.length; i += 2) {
            Value object = valueArray[i];
            Value value2 = valueArray[i + 1];
            Column column = this.columnSet.get(object);
            if (value2.isNilValue() || arrayList.contains(column)) continue;
            arrayList.add(column);
            if (column.builderIsSet()) {
                column.getBuilder().add(this.recordCount, value2);
            } else {
                this.sparseRows.add(this.recordCount, column.getIndex(), value2);
                arrayList2.add(column);
            }
            column.incrementCounter();
        }
        ++this.recordCount;
        for (Column column : arrayList2) {
            if (column.getCounter() <= 100L || !((double)column.getCounter() / (double)this.recordCount > 0.3)) continue;
            this.extractToDenseBlock(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractToDenseBlock(Column column) throws IOException {
        if (this.sparseRows == null) {
            throw new IllegalStateException("ColumnarFileBuilder already finish()ed or close()ed");
        }
        File file = this.createTempFile("column-block-");
        try {
            BlockBuilder blockBuilder = this.openBlockBuilder(file);
            column.setBuilder(file, blockBuilder);
            file = null;
            this.sparseRows.extract(column.getIndex(), new SparseToDenseCallback(blockBuilder));
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public void finish() throws IOException {
        for (Column column : this.columnSet) {
            if (!column.builderIsSet()) continue;
            column.getBuilder().fillNil(this.recordCount);
            column.getBuilder().close();
        }
        for (Column column : this.columnSet) {
            if (column.builderIsSet()) continue;
            this.extractToDenseBlock(column);
            column.getBuilder().fillNil(this.recordCount);
            column.getBuilder().close();
        }
        this.sparseRows.close();
        this.sparseRows = null;
        Column[] columnArray = this.columnSet.toArray();
        Arrays.sort(columnArray, this.columnComparator);
        this.blocks = new File[columnArray.length + 1];
        this.blocks[0] = this.buildColumnNameBlock(columnArray);
        int n = 0;
        for (Column column : columnArray) {
            this.blocks[n + 1] = column.getFile();
            ++n;
        }
        this.totalSize = 0L;
        long[] lArray = new long[this.blocks.length];
        for (int i = 0; i < this.blocks.length; ++i) {
            long l;
            lArray[i] = l = this.blocks[i].length();
            this.totalSize += l;
        }
        SimpleBlockData simpleBlockData = new SimpleBlockData(this.compType);
        this.header = MPCFile.writeHeader(MPCFile.BLOCK_MAGIC, simpleBlockData, this.headerMetadata, 0, lArray);
        this.totalSize += (long)this.header.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File buildColumnNameBlock(Column[] columnArray) throws IOException {
        File file = this.createTempFile("column-block-");
        try (BlockBuilder blockBuilder = this.openBlockBuilder(file);){
            int n = 0;
            for (Column column : columnArray) {
                blockBuilder.add(n, column.getName());
                ++n;
            }
        }
        return file;
    }

    public long getFileSize() {
        if (this.header == null) {
            throw new IllegalStateException("finish() must be called before getFileSize()");
        }
        return this.totalSize;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public long getEstimatedFileSize() {
        if (this.header != null) {
            return this.getFileSize();
        }
        long l = 0L;
        for (Column column : this.columnSet) {
            if (!column.builderIsSet()) continue;
            l += column.getFile().length();
        }
        return l + 16L;
    }

    public void writeTo(WritableByteChannel writableByteChannel) throws IOException {
        if (this.header == null) {
            throw new IllegalStateException("finish() must be called before writeTo()");
        }
        writableByteChannel.write(ByteBuffer.wrap(this.header));
        for (File file : this.blocks) {
            BufferUtil.transferFile(file, writableByteChannel);
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.header == null) {
            throw new IllegalStateException("finish() must be called before openInputStream()");
        }
        return new SequenceInputStream(new InputStreamEnumeration());
    }

    public byte[] getHeader() {
        if (this.header == null) {
            return null;
        }
        return Arrays.copyOf(this.header, this.header.length);
    }

    public File[] getBlocks() {
        if (this.blocks == null) {
            return null;
        }
        return Arrays.copyOf(this.blocks, this.blocks.length);
    }

    @Override
    public void close() throws IOException {
        for (Column column : this.columnSet) {
            if (!column.builderIsSet()) continue;
            column.getBuilder().close();
            column.getFile().delete();
        }
        if (this.blocks != null && this.blocks[0] != null) {
            this.blocks[0].delete();
        }
        if (this.sparseRows != null) {
            this.sparseRows.close();
            this.sparseRows = null;
        }
    }

    private File createTempFile(String string) throws IOException {
        File file = this.tempFileAllocator.allocate(string, ".tmp");
        return file;
    }

    private class InputStreamEnumeration
    implements Enumeration<InputStream> {
        private int index = 0;

        private InputStreamEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < MPCFileWriter.this.blocks.length + 1;
        }

        @Override
        public InputStream nextElement() {
            InputStream inputStream;
            try {
                inputStream = this.index == 0 ? new ByteArrayInputStream(MPCFileWriter.this.header) : Files.newInputStream(MPCFileWriter.this.blocks[this.index - 1].toPath(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            ++this.index;
            return inputStream;
        }
    }

    private static class SparseToDenseCallback
    implements SparseTableBuilder.ExtractCallback {
        private BlockBuilder builder;

        public SparseToDenseCallback(BlockBuilder blockBuilder) {
            this.builder = blockBuilder;
        }

        @Override
        public void call(long l, Value value) throws IOException {
            this.builder.add(l, value);
        }
    }
}

