/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.input;

import com.treasuredata.partition.mpc.reader.LimitedReadableByteChannel;
import com.treasuredata.partition.mpc.reader.input.InputFile;
import com.treasuredata.partition.mpc.reader.input.StorageObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class StorageObjectInputFile
implements InputFile {
    private final StorageObject object;
    private final long size;

    public StorageObjectInputFile(StorageObject storageObject) throws IOException {
        this.object = storageObject;
        this.size = storageObject.size();
    }

    @Override
    public ReadableByteChannel openChannel(long l, long l2) throws IOException {
        InputStream inputStream = this.object.getInputStream(l, l2);
        return new LimitedReadableByteChannel(Channels.newChannel(inputStream), l2);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        if (this.object != null) {
            this.object.close();
        }
    }

    public int hashCode() {
        return this.object.hashCode();
    }
}

