/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.AbstractColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;
import org.msgpack.value.Variable;

public class StringColumnReader
extends AbstractColumnReader {
    private final StringHolder holder = new StringHolder();

    public StringColumnReader(MessageUnpacker messageUnpacker) {
        super(messageUnpacker);
    }

    @Override
    protected StringHolder current() {
        return this.holder;
    }

    @Override
    public byte[] getByteArray() throws IOException {
        return this.holder.getOrElseUpdate().toByteArray();
    }

    @Override
    public MessageBuffer getMemoryReference() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    @Override
    public Value getValue() throws IOException {
        if (this.isNull()) {
            return ValueFactory.newNil();
        }
        return ValueFactory.newString(this.getByteArray());
    }

    private class StringHolder
    extends ColumnValueHolder {
        private MessageBuffer value;
        private Variable anyVal = new Variable();

        private StringHolder() {
        }

        @Override
        protected boolean update() throws IOException {
            if (!this.isRead) {
                MessageFormat messageFormat = StringColumnReader.this.unpacker.getNextFormat();
                ValueType valueType = messageFormat.getValueType();
                switch (valueType) {
                    case STRING: 
                    case BINARY: {
                        int n = StringColumnReader.this.unpacker.unpackRawStringHeader();
                        this.value = StringColumnReader.this.unpacker.readPayloadAsReference(n);
                        break;
                    }
                    case NIL: {
                        this.isValid = false;
                        StringColumnReader.this.unpacker.skipValue();
                        break;
                    }
                    case ARRAY: 
                    case MAP: {
                        StringColumnReader.this.unpacker.unpackValue(this.anyVal);
                        String string = this.anyVal.toJson();
                        this.value = MessageBuffer.wrap(string.getBytes(MessagePack.UTF8));
                        break;
                    }
                    case FLOAT: {
                        String string = "";
                        switch (messageFormat) {
                            case FLOAT32: {
                                string = Float.toString(StringColumnReader.this.unpacker.unpackFloat());
                                break;
                            }
                            case FLOAT64: {
                                string = Double.toString(StringColumnReader.this.unpacker.unpackDouble());
                            }
                        }
                        this.value = MessageBuffer.wrap(string.getBytes(MessagePack.UTF8));
                        break;
                    }
                    default: {
                        StringColumnReader.this.unpacker.unpackValue(this.anyVal);
                        this.value = MessageBuffer.wrap(this.anyVal.toString().getBytes(MessagePack.UTF8));
                    }
                }
                this.isRead = true;
            }
            return this.isValid;
        }

        public MessageBuffer getOrElseUpdate() throws IOException {
            this.update();
            return this.value;
        }
    }
}

