/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.ArrayColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.BooleanColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.BytesColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueType;
import com.treasuredata.partition.mpc.reader.columnar.DoubleColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.LongColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.MapColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.NullColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.StringColumnReader;
import java.util.List;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.Preconditions;
import org.msgpack.value.ValueType;

public class MPCColumnReader {
    protected MPCColumnReader() {
    }

    public static ColumnReader createColumnReader(MessageUnpacker messageUnpacker, ValueType valueType, boolean bl) {
        return MPCColumnReader.createColumnReader(messageUnpacker, new ColumnValueType(valueType), bl);
    }

    public static ColumnReader createColumnReader(MessageUnpacker messageUnpacker, ColumnValueType columnValueType, boolean bl) {
        ColumnReader columnReader = null;
        List<ColumnValueType> list = columnValueType.getParameterTypes();
        switch (columnValueType.getValueType()) {
            case BOOLEAN: {
                columnReader = new BooleanColumnReader(messageUnpacker);
                break;
            }
            case INTEGER: {
                columnReader = new LongColumnReader(messageUnpacker);
                break;
            }
            case FLOAT: {
                columnReader = new DoubleColumnReader(messageUnpacker);
                break;
            }
            case STRING: {
                columnReader = new StringColumnReader(messageUnpacker);
                break;
            }
            case BINARY: {
                columnReader = new BytesColumnReader(messageUnpacker);
                break;
            }
            case ARRAY: {
                Preconditions.checkArgument(list.size() == 1, "ArrayType must specify one parameterType");
                columnReader = new ArrayColumnReader(messageUnpacker, list.get(0));
                break;
            }
            case MAP: {
                Preconditions.checkArgument(list.size() == 2, "MapType must specify two parameterTypes");
                columnReader = new MapColumnReader(messageUnpacker, list.get(0), list.get(1));
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot create a column reader for %s type", new Object[]{columnValueType.getValueType()}));
            }
        }
        if (bl) {
            columnReader = new NullColumnReader(columnReader);
        }
        return columnReader;
    }
}

