/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.ColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueType;
import com.treasuredata.partition.mpc.reader.columnar.TypeConversionException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.msgpack.value.ValueType;

public abstract class ColumnValueHolder {
    protected boolean isRead = false;
    protected boolean isValid = true;
    protected TypeConversionException conversionError = null;

    public boolean isEmpty() {
        return !this.isRead;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected abstract boolean update() throws IOException;

    private TypeConversionException getErrorReporter(ValueType valueType) {
        if (this.conversionError == null) {
            this.conversionError = new TypeConversionException(valueType);
        }
        return this.conversionError;
    }

    protected void reportConversionError(ValueType valueType, ValueType valueType2) {
        this.getErrorReporter(valueType).reportInvalidType(valueType2);
        this.isValid = false;
    }

    protected void reportOverflow(ValueType valueType) {
        this.getErrorReporter(valueType).reportOverflow();
        this.isValid = false;
    }

    public void reset() {
        this.isRead = false;
        this.isValid = true;
    }

    public void close() {
        if (this.conversionError != null) {
            // empty if block
        }
    }

    protected static Object readItem(ColumnReader columnReader, ColumnValueType columnValueType) throws IOException {
        Object object = null;
        if (!columnReader.isNull()) {
            switch (columnValueType.getValueType()) {
                case INTEGER: {
                    object = columnReader.getLong();
                    break;
                }
                case FLOAT: {
                    object = columnReader.getDouble();
                    break;
                }
                case STRING: {
                    object = new String(columnReader.getByteArray(), StandardCharsets.UTF_8);
                    break;
                }
                case BOOLEAN: {
                    object = columnReader.getBoolean();
                    break;
                }
                case BINARY: {
                    object = columnReader.getByteArray();
                    break;
                }
                case ARRAY: {
                    object = columnReader.getList();
                    break;
                }
                case MAP: {
                    object = columnReader.getMap();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(columnValueType.getValueType().name());
                }
            }
        }
        columnReader.advance();
        return object;
    }
}

