/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader;

import com.treasuredata.partition.mpc.MPCFile;
import com.treasuredata.partition.mpc.reader.EagerMPCFileReader;
import com.treasuredata.partition.mpc.reader.LazyMPCFileReader;
import com.treasuredata.partition.mpc.reader.input.InputFile;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.msgpack.core.MessagePackException;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public abstract class MPCFileReader
implements AutoCloseable {
    protected final InputFile input;
    protected final MPCFile.Header header;
    protected final ArrayList<MPCFile.ColumnInfo> columns;
    protected Value[] kvs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MPCFileReader(InputFile inputFile) throws IOException, MessagePackException {
        this.input = inputFile;
        try (ReadableByteChannel readableByteChannel = inputFile.openChannel(0L, inputFile.size());){
            MPCFile.HeaderAndColumnInfo headerAndColumnInfo = MPCFile.readHeaderAndColumnInfo(readableByteChannel, inputFile.size());
            this.header = headerAndColumnInfo.getHeader();
            this.columns = headerAndColumnInfo.getColumnList();
        }
        this.kvs = new Value[this.columns.size() * 2];
        IntStream.range(0, this.columns.size()).forEach(n -> {
            this.kvs[n * 2] = ValueFactory.newString(this.columns.get(n).getName());
        });
    }

    public static MPCFileReader getEagerMPCFileReader(InputFile inputFile) throws MessagePackException, IOException {
        return new EagerMPCFileReader(inputFile);
    }

    public static MPCFileReader getLazyMPCFileReader(InputFile inputFile) throws MessagePackException, IOException {
        return new LazyMPCFileReader(inputFile);
    }

    public static MPCFileReader getLazyMPCFileReader(InputFile inputFile, List<String> list) throws MessagePackException, IOException {
        return new LazyMPCFileReader(inputFile, list);
    }

    public long getFileSize() {
        return this.input.size();
    }

    public List<MPCFile.ColumnInfo> getColumns() {
        return this.columns;
    }

    public ReadableByteChannel bypassInitAndOpenRawBlockReader(long l, long l2) throws IOException, MessagePackException {
        return this.input.openChannel(l, l2);
    }

    public abstract Value next() throws IOException, MessagePackException;

    public List<byte[]> getColumnNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.columns.stream().forEach(columnInfo -> builder.add((Object)columnInfo.getName()));
        return builder.build();
    }

    @Override
    public void close() throws Exception, MessagePackException {
        if (this.input != null) {
            this.input.close();
        }
    }
}

