/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class LimitedReadableByteChannel
implements ReadableByteChannel {
    protected ReadableByteChannel channel;
    protected long limit;

    public LimitedReadableByteChannel(ReadableByteChannel readableByteChannel, long l) {
        this.channel = readableByteChannel;
        this.limit = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (this.limit <= 0L) {
            return -1;
        }
        if ((long)byteBuffer.remaining() > this.limit) {
            int n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + (int)this.limit);
            try {
                n = this.channel.read(byteBuffer);
            }
            finally {
                byteBuffer.limit(n2);
            }
        } else {
            n = this.channel.read(byteBuffer);
        }
        if (n > 0) {
            this.limit -= (long)n;
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

