/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.merge;

import com.treasuredata.partition.mpc.Column;
import com.treasuredata.partition.mpc.merge.ColumnNamesComparator;
import com.treasuredata.partition.mpc.merge.SplitMPCFileColumnsPacker;
import com.treasuredata.partition.mpc.merge.TimeIndexMPCFileWriter;
import com.treasuredata.partition.mpc.writer.TempFileAllocator;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

public class MPCFileSplitter
implements Closeable {
    private final Supplier<TimeIndexMPCFileWriter> writerFactory = () -> {
        try {
            return new TimeIndexMPCFileWriter(ImmutableList.of(), tempFileAllocator, (Comparator<Column>)new ColumnNamesComparator(list));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    };
    private final SplitMPCFileColumnsPacker columnsPacker;

    public MPCFileSplitter(TempFileAllocator tempFileAllocator, List<String> list) {
        this.columnsPacker = new SplitMPCFileColumnsPacker(tempFileAllocator);
    }

    public void write(File file, long l, long l2, long l3, long l4) {
        if (l2 < l3) {
            return;
        }
        int n = Math.toIntExact(Math.max(l2 / l3, l / l4)) + 1;
        long l5 = l / (long)n + 1L;
        long[] lArray = new long[n];
        long l6 = l;
        for (int i = 0; i < n; ++i) {
            lArray[i] = Math.min(l6, l5);
            l6 -= l5;
        }
        try {
            this.columnsPacker.extract(this.writerFactory, file, lArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public List<TimeIndexMPCFileWriter> finish() throws IOException {
        return this.columnsPacker.finish();
    }

    @Override
    public void close() throws IOException {
        this.columnsPacker.close();
    }
}

