/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.filter.gzip;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.filter.FilterSink;
import com.treasuredata.partition.mpc.filter.OutputFilter;
import com.treasuredata.partition.mpc.filter.gzip.ZStream;
import com.treasuredata.partition.mpc.filter.gzip.Zlib;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NativeGzipOutputFilter
implements OutputFilter {
    protected FilterSink sink;
    private ZStream zstream = new ZStream();
    private Zlib zlib;
    private boolean initialized;

    public NativeGzipOutputFilter() {
        NativeGzipOutputFilter nativeGzipOutputFilter = this;
        this.zlib = nativeGzipOutputFilter.zstream.getZlib();
    }

    @Override
    public void setSink(FilterSink filterSink) {
        this.sink = filterSink;
    }

    @Override
    public void offer(Buffer buffer) throws IOException {
        this.write(buffer.getByteBuffer());
        buffer.release();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2 = this.sink.getCurrentBuffer();
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            if (byteBuffer2.remaining() < 512) {
                this.sink.forward();
                byteBuffer2 = this.sink.getCurrentBuffer();
            }
            n += this.process(byteBuffer, byteBuffer2);
        }
        return n;
    }

    @Override
    public void complete() throws IOException {
        if (!this.initialized) {
            return;
        }
        ByteBuffer byteBuffer = this.sink.getCurrentBuffer();
        while (true) {
            if (byteBuffer.remaining() < 512) {
                this.sink.forward();
                byteBuffer = this.sink.getCurrentBuffer();
            }
            int n = byteBuffer.remaining();
            n = this.zstream.set_out(byteBuffer, n);
            int n2 = this.zlib.deflate(this.zstream.getPointer(), 4);
            int n3 = (int)((long)n - this.zstream.avail_out.get());
            byteBuffer.position(byteBuffer.position() + n3);
            if (n2 == 1) break;
            this.zstream.checkError(n2);
        }
        this.sink.complete();
    }

    private int process(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        int n;
        if (!this.initialized) {
            NativeGzipOutputFilter nativeGzipOutputFilter = this;
            n = this.zlib.deflateInit2_(this.zstream.getPointer(), -1, 8, 31, 9, 0, nativeGzipOutputFilter.zstream.getZlibVersion(), this.zstream.getSize());
            this.zstream.checkError(n);
            this.initialized = true;
        }
        n = byteBuffer.remaining();
        n = this.zstream.set_in(byteBuffer, n);
        int n2 = byteBuffer2.remaining();
        n2 = this.zstream.set_out(byteBuffer2, n2);
        int n3 = this.zlib.deflate(this.zstream.getPointer(), 0);
        this.zstream.checkError(n3);
        int n4 = (int)((long)n2 - this.zstream.avail_out.get());
        int n5 = (int)((long)n - this.zstream.avail_in.get());
        byteBuffer2.position(byteBuffer2.position() + n4);
        byteBuffer.position(byteBuffer.position() + n5);
        return n5;
    }

    @Override
    public void reset() throws IOException {
        if (this.initialized) {
            int n = this.zlib.deflateReset(this.zstream.getPointer());
            this.zstream.checkError(n);
        }
        if (this.sink != null) {
            this.sink.close();
            this.sink = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.initialized) {
            int n = this.zlib.deflateEnd(this.zstream.getPointer());
            this.zstream.checkError(n);
            this.initialized = false;
        }
        if (this.sink != null) {
            this.sink.close();
            this.sink = null;
        }
    }
}

