/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.filter.gzip;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.IoBufferAllocator;
import com.treasuredata.partition.mpc.filter.FilterSource;
import com.treasuredata.partition.mpc.filter.InputFilter;
import com.treasuredata.partition.mpc.filter.gzip.ZStream;
import com.treasuredata.partition.mpc.filter.gzip.Zlib;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NativeGzipInputFilter
implements InputFilter {
    protected FilterSource source;
    private ZStream zstream = new ZStream();
    private Zlib zlib;
    private boolean initialized;
    private IoBufferAllocator bufferAllocator;
    private Buffer inBuffer;
    private boolean streamEnd;

    public NativeGzipInputFilter(IoBufferAllocator ioBufferAllocator) {
        NativeGzipInputFilter nativeGzipInputFilter = this;
        this.zlib = nativeGzipInputFilter.zstream.getZlib();
        this.bufferAllocator = ioBufferAllocator;
    }

    @Override
    public void setSource(FilterSource filterSource) {
        this.source = filterSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer next() throws IOException {
        Buffer buffer = this.bufferAllocator.allocateIoBuffer();
        try {
            Object object;
            int n = 0;
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            do {
                int n2;
                if (this.streamEnd) {
                    object = null;
                    return object;
                }
                if (this.inBuffer == null) {
                    this.inBuffer = this.source.next();
                    if (this.inBuffer == null) {
                        object = null;
                        return object;
                    }
                }
                if (!((java.nio.Buffer)(object = this.inBuffer.getByteBuffer())).hasRemaining()) {
                    this.inBuffer.release();
                    this.inBuffer = null;
                    continue;
                }
                int n3 = ((java.nio.Buffer)object).remaining();
                n3 = this.zstream.set_in((ByteBuffer)object, n3);
                int n4 = byteBuffer.remaining();
                n4 = this.zstream.set_out(byteBuffer, n4);
                if (!this.initialized) {
                    NativeGzipInputFilter nativeGzipInputFilter = this;
                    n2 = this.zlib.inflateInit2_(this.zstream.getPointer(), 47, nativeGzipInputFilter.zstream.getZlibVersion(), this.zstream.getSize());
                    this.zstream.checkError(n2);
                    this.initialized = true;
                }
                if ((n2 = this.zlib.inflate(this.zstream.getPointer(), 1)) == 1) {
                    this.streamEnd = true;
                } else if (n2 == 0) {
                    this.streamEnd = false;
                } else {
                    this.zstream.checkError(n2);
                }
                int n5 = (int)((long)n3 - this.zstream.avail_in.get());
                ((ByteBuffer)object).position(((java.nio.Buffer)object).position() + n5);
                if (!((java.nio.Buffer)object).hasRemaining()) {
                    this.inBuffer.release();
                    this.inBuffer = null;
                }
                n = (int)((long)n4 - this.zstream.avail_out.get());
            } while (n <= 0);
            byteBuffer.limit(n);
            object = buffer;
            buffer = null;
            Object object2 = object;
            return object2;
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.initialized) {
            int n = this.zlib.inflateReset(this.zstream.getPointer());
            this.zstream.checkError(n);
        }
        if (this.inBuffer != null) {
            this.inBuffer.release();
            this.inBuffer = null;
        }
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.initialized) {
            int n = this.zlib.inflateEnd(this.zstream.getPointer());
            this.zstream.checkError(n);
            this.initialized = false;
        }
        if (this.inBuffer != null) {
            this.inBuffer.release();
            this.inBuffer = null;
        }
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }
}

