/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.filter;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.IoBufferAllocator;
import com.treasuredata.partition.mpc.filter.FilterSink;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class WritableByteChannelFilterSink
implements FilterSink,
Closeable {
    private WritableByteChannel channel;
    private IoBufferAllocator bufferAllocator;
    private Buffer current;

    public WritableByteChannelFilterSink(WritableByteChannel writableByteChannel, IoBufferAllocator ioBufferAllocator) {
        this.channel = writableByteChannel;
        this.bufferAllocator = ioBufferAllocator;
    }

    @Override
    public ByteBuffer getCurrentBuffer() throws IOException {
        if (this.current == null) {
            this.current = this.bufferAllocator.allocateIoBuffer();
        }
        return this.current.getByteBuffer();
    }

    @Override
    public void forward() throws IOException {
        this.flushCurrentBuffer();
    }

    @Override
    public void complete() throws IOException {
        this.flushCurrentBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCurrentBuffer() throws IOException {
        if (this.current == null) {
            return;
        }
        ByteBuffer byteBuffer = this.current.getByteBuffer();
        int n = byteBuffer.position();
        if (n == 0) {
            return;
        }
        int n2 = byteBuffer.limit();
        byteBuffer.limit(n);
        byteBuffer.position(0);
        try {
            this.channel.write(byteBuffer);
            byteBuffer = null;
        }
        finally {
            if (byteBuffer != null) {
                byteBuffer.position(byteBuffer.limit());
                byteBuffer.limit(n2);
            }
        }
        this.current.release();
        this.current = null;
    }

    @Override
    public void close() throws IOException {
        if (this.current != null) {
            this.current.release();
            this.current = null;
        }
        this.channel.close();
    }
}

