/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.filter;

import com.treasuredata.partition.mpc.buffer.IoBufferAllocator;
import com.treasuredata.partition.mpc.filter.OutputFilter;
import com.treasuredata.partition.mpc.filter.WritableByteChannelFilterSink;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class FilteredWritableByteChannel
implements WritableByteChannel {
    protected WritableByteChannel out;
    private OutputFilter filter;
    private WritableByteChannelFilterSink sink;
    private IoBufferAllocator bufferAllocator;
    private boolean completeOnClose;

    public FilteredWritableByteChannel(WritableByteChannel writableByteChannel, OutputFilter outputFilter, IoBufferAllocator ioBufferAllocator) {
        this.out = writableByteChannel;
        this.filter = outputFilter;
        this.bufferAllocator = ioBufferAllocator;
        this.sink = new WritableByteChannelFilterSink(writableByteChannel, ioBufferAllocator);
        this.completeOnClose = true;
        outputFilter.setSink(this.sink);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.filter.write(byteBuffer);
    }

    public void complete() throws IOException {
        this.filter.complete();
    }

    @Override
    public boolean isOpen() {
        return this.out.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.completeOnClose) {
            this.filter.complete();
        }
        this.filter.close();
    }
}

